// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceGetOrganizationServicePrincipalReader is a Reader for the ServicePrincipalsServiceGetOrganizationServicePrincipal structure.
type ServicePrincipalsServiceGetOrganizationServicePrincipalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceGetOrganizationServicePrincipalOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceGetOrganizationServicePrincipalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceGetOrganizationServicePrincipalOK creates a ServicePrincipalsServiceGetOrganizationServicePrincipalOK with default headers values
func NewServicePrincipalsServiceGetOrganizationServicePrincipalOK() *ServicePrincipalsServiceGetOrganizationServicePrincipalOK {
	return &ServicePrincipalsServiceGetOrganizationServicePrincipalOK{}
}

/*
ServicePrincipalsServiceGetOrganizationServicePrincipalOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceGetOrganizationServicePrincipalOK struct {
	Payload *models.HashicorpCloudIamGetOrganizationServicePrincipalResponse
}

// IsSuccess returns true when this service principals service get organization service principal o k response has a 2xx status code
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service get organization service principal o k response has a 3xx status code
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service get organization service principal o k response has a 4xx status code
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service get organization service principal o k response has a 5xx status code
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service get organization service principal o k response a status code equal to that given
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service get organization service principal o k response
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/service-principals/{principal_id}][%d] servicePrincipalsServiceGetOrganizationServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/service-principals/{principal_id}][%d] servicePrincipalsServiceGetOrganizationServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) GetPayload() *models.HashicorpCloudIamGetOrganizationServicePrincipalResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamGetOrganizationServicePrincipalResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceGetOrganizationServicePrincipalDefault creates a ServicePrincipalsServiceGetOrganizationServicePrincipalDefault with default headers values
func NewServicePrincipalsServiceGetOrganizationServicePrincipalDefault(code int) *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault {
	return &ServicePrincipalsServiceGetOrganizationServicePrincipalDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceGetOrganizationServicePrincipalDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceGetOrganizationServicePrincipalDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service get organization service principal default response has a 2xx status code
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service get organization service principal default response has a 3xx status code
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service get organization service principal default response has a 4xx status code
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service get organization service principal default response has a 5xx status code
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service get organization service principal default response a status code equal to that given
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service get organization service principal default response
func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/service-principals/{principal_id}][%d] ServicePrincipalsService_GetOrganizationServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/service-principals/{principal_id}][%d] ServicePrincipalsService_GetOrganizationServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceGetOrganizationServicePrincipalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
