// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceListChannelsReader is a Reader for the PackerServiceListChannels structure.
type PackerServiceListChannelsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceListChannelsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceListChannelsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceListChannelsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceListChannelsOK creates a PackerServiceListChannelsOK with default headers values
func NewPackerServiceListChannelsOK() *PackerServiceListChannelsOK {
	return &PackerServiceListChannelsOK{}
}

/*
PackerServiceListChannelsOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceListChannelsOK struct {
	Payload *models.HashicorpCloudPacker20230101ListChannelsResponse
}

// IsSuccess returns true when this packer service list channels o k response has a 2xx status code
func (o *PackerServiceListChannelsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service list channels o k response has a 3xx status code
func (o *PackerServiceListChannelsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service list channels o k response has a 4xx status code
func (o *PackerServiceListChannelsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service list channels o k response has a 5xx status code
func (o *PackerServiceListChannelsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service list channels o k response a status code equal to that given
func (o *PackerServiceListChannelsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service list channels o k response
func (o *PackerServiceListChannelsOK) Code() int {
	return 200
}

func (o *PackerServiceListChannelsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels][%d] packerServiceListChannelsOK %s", 200, payload)
}

func (o *PackerServiceListChannelsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels][%d] packerServiceListChannelsOK %s", 200, payload)
}

func (o *PackerServiceListChannelsOK) GetPayload() *models.HashicorpCloudPacker20230101ListChannelsResponse {
	return o.Payload
}

func (o *PackerServiceListChannelsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101ListChannelsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceListChannelsDefault creates a PackerServiceListChannelsDefault with default headers values
func NewPackerServiceListChannelsDefault(code int) *PackerServiceListChannelsDefault {
	return &PackerServiceListChannelsDefault{
		_statusCode: code,
	}
}

/*
PackerServiceListChannelsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceListChannelsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service list channels default response has a 2xx status code
func (o *PackerServiceListChannelsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service list channels default response has a 3xx status code
func (o *PackerServiceListChannelsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service list channels default response has a 4xx status code
func (o *PackerServiceListChannelsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service list channels default response has a 5xx status code
func (o *PackerServiceListChannelsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service list channels default response a status code equal to that given
func (o *PackerServiceListChannelsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service list channels default response
func (o *PackerServiceListChannelsDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceListChannelsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels][%d] PackerService_ListChannels default %s", o._statusCode, payload)
}

func (o *PackerServiceListChannelsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels][%d] PackerService_ListChannels default %s", o._statusCode, payload)
}

func (o *PackerServiceListChannelsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceListChannelsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
