// Code generated by go-swagger; DO NOT EDIT.

package vault_link_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRotateLinkedClusterCredentialsParams creates a new RotateLinkedClusterCredentialsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRotateLinkedClusterCredentialsParams() *RotateLinkedClusterCredentialsParams {
	return &RotateLinkedClusterCredentialsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRotateLinkedClusterCredentialsParamsWithTimeout creates a new RotateLinkedClusterCredentialsParams object
// with the ability to set a timeout on a request.
func NewRotateLinkedClusterCredentialsParamsWithTimeout(timeout time.Duration) *RotateLinkedClusterCredentialsParams {
	return &RotateLinkedClusterCredentialsParams{
		timeout: timeout,
	}
}

// NewRotateLinkedClusterCredentialsParamsWithContext creates a new RotateLinkedClusterCredentialsParams object
// with the ability to set a context for a request.
func NewRotateLinkedClusterCredentialsParamsWithContext(ctx context.Context) *RotateLinkedClusterCredentialsParams {
	return &RotateLinkedClusterCredentialsParams{
		Context: ctx,
	}
}

// NewRotateLinkedClusterCredentialsParamsWithHTTPClient creates a new RotateLinkedClusterCredentialsParams object
// with the ability to set a custom HTTPClient for a request.
func NewRotateLinkedClusterCredentialsParamsWithHTTPClient(client *http.Client) *RotateLinkedClusterCredentialsParams {
	return &RotateLinkedClusterCredentialsParams{
		HTTPClient: client,
	}
}

/*
RotateLinkedClusterCredentialsParams contains all the parameters to send to the API endpoint

	for the rotate linked cluster credentials operation.

	Typically these are written to a http.Request.
*/
type RotateLinkedClusterCredentialsParams struct {

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the rotate linked cluster credentials params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RotateLinkedClusterCredentialsParams) WithDefaults() *RotateLinkedClusterCredentialsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the rotate linked cluster credentials params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RotateLinkedClusterCredentialsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) WithTimeout(timeout time.Duration) *RotateLinkedClusterCredentialsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) WithContext(ctx context.Context) *RotateLinkedClusterCredentialsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) WithHTTPClient(client *http.Client) *RotateLinkedClusterCredentialsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) WithClusterID(clusterID string) *RotateLinkedClusterCredentialsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) WithLocationOrganizationID(locationOrganizationID string) *RotateLinkedClusterCredentialsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) WithLocationProjectID(locationProjectID string) *RotateLinkedClusterCredentialsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) WithLocationRegionProvider(locationRegionProvider *string) *RotateLinkedClusterCredentialsParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) WithLocationRegionRegion(locationRegionRegion *string) *RotateLinkedClusterCredentialsParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the rotate linked cluster credentials params
func (o *RotateLinkedClusterCredentialsParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *RotateLinkedClusterCredentialsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
