// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// OpenAppSecretVersionReader is a Reader for the OpenAppSecretVersion structure.
type OpenAppSecretVersionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *OpenAppSecretVersionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewOpenAppSecretVersionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewOpenAppSecretVersionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewOpenAppSecretVersionOK creates a OpenAppSecretVersionOK with default headers values
func NewOpenAppSecretVersionOK() *OpenAppSecretVersionOK {
	return &OpenAppSecretVersionOK{}
}

/*
OpenAppSecretVersionOK describes a response with status code 200, with default header values.

A successful response.
*/
type OpenAppSecretVersionOK struct {
	Payload *models.Secrets20230613OpenAppSecretVersionResponse
}

// IsSuccess returns true when this open app secret version o k response has a 2xx status code
func (o *OpenAppSecretVersionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this open app secret version o k response has a 3xx status code
func (o *OpenAppSecretVersionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this open app secret version o k response has a 4xx status code
func (o *OpenAppSecretVersionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this open app secret version o k response has a 5xx status code
func (o *OpenAppSecretVersionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this open app secret version o k response a status code equal to that given
func (o *OpenAppSecretVersionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the open app secret version o k response
func (o *OpenAppSecretVersionOK) Code() int {
	return 200
}

func (o *OpenAppSecretVersionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/open/{secret_name}/versions/{version}][%d] openAppSecretVersionOK %s", 200, payload)
}

func (o *OpenAppSecretVersionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/open/{secret_name}/versions/{version}][%d] openAppSecretVersionOK %s", 200, payload)
}

func (o *OpenAppSecretVersionOK) GetPayload() *models.Secrets20230613OpenAppSecretVersionResponse {
	return o.Payload
}

func (o *OpenAppSecretVersionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613OpenAppSecretVersionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewOpenAppSecretVersionDefault creates a OpenAppSecretVersionDefault with default headers values
func NewOpenAppSecretVersionDefault(code int) *OpenAppSecretVersionDefault {
	return &OpenAppSecretVersionDefault{
		_statusCode: code,
	}
}

/*
OpenAppSecretVersionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type OpenAppSecretVersionDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this open app secret version default response has a 2xx status code
func (o *OpenAppSecretVersionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this open app secret version default response has a 3xx status code
func (o *OpenAppSecretVersionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this open app secret version default response has a 4xx status code
func (o *OpenAppSecretVersionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this open app secret version default response has a 5xx status code
func (o *OpenAppSecretVersionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this open app secret version default response a status code equal to that given
func (o *OpenAppSecretVersionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the open app secret version default response
func (o *OpenAppSecretVersionDefault) Code() int {
	return o._statusCode
}

func (o *OpenAppSecretVersionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/open/{secret_name}/versions/{version}][%d] OpenAppSecretVersion default %s", o._statusCode, payload)
}

func (o *OpenAppSecretVersionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/open/{secret_name}/versions/{version}][%d] OpenAppSecretVersion default %s", o._statusCode, payload)
}

func (o *OpenAppSecretVersionDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *OpenAppSecretVersionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
