// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewBulkCreateAppKVSecretsParams creates a new BulkCreateAppKVSecretsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBulkCreateAppKVSecretsParams() *BulkCreateAppKVSecretsParams {
	return &BulkCreateAppKVSecretsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBulkCreateAppKVSecretsParamsWithTimeout creates a new BulkCreateAppKVSecretsParams object
// with the ability to set a timeout on a request.
func NewBulkCreateAppKVSecretsParamsWithTimeout(timeout time.Duration) *BulkCreateAppKVSecretsParams {
	return &BulkCreateAppKVSecretsParams{
		timeout: timeout,
	}
}

// NewBulkCreateAppKVSecretsParamsWithContext creates a new BulkCreateAppKVSecretsParams object
// with the ability to set a context for a request.
func NewBulkCreateAppKVSecretsParamsWithContext(ctx context.Context) *BulkCreateAppKVSecretsParams {
	return &BulkCreateAppKVSecretsParams{
		Context: ctx,
	}
}

// NewBulkCreateAppKVSecretsParamsWithHTTPClient creates a new BulkCreateAppKVSecretsParams object
// with the ability to set a custom HTTPClient for a request.
func NewBulkCreateAppKVSecretsParamsWithHTTPClient(client *http.Client) *BulkCreateAppKVSecretsParams {
	return &BulkCreateAppKVSecretsParams{
		HTTPClient: client,
	}
}

/*
BulkCreateAppKVSecretsParams contains all the parameters to send to the API endpoint

	for the bulk create app k v secrets operation.

	Typically these are written to a http.Request.
*/
type BulkCreateAppKVSecretsParams struct {

	// AppName.
	AppName string

	// Body.
	Body *models.SecretServiceBulkCreateAppKVSecretsBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the bulk create app k v secrets params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BulkCreateAppKVSecretsParams) WithDefaults() *BulkCreateAppKVSecretsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the bulk create app k v secrets params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BulkCreateAppKVSecretsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) WithTimeout(timeout time.Duration) *BulkCreateAppKVSecretsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) WithContext(ctx context.Context) *BulkCreateAppKVSecretsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) WithHTTPClient(client *http.Client) *BulkCreateAppKVSecretsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) WithAppName(appName string) *BulkCreateAppKVSecretsParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithBody adds the body to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) WithBody(body *models.SecretServiceBulkCreateAppKVSecretsBody) *BulkCreateAppKVSecretsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) SetBody(body *models.SecretServiceBulkCreateAppKVSecretsBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) WithOrganizationID(organizationID string) *BulkCreateAppKVSecretsParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) WithProjectID(projectID string) *BulkCreateAppKVSecretsParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the bulk create app k v secrets params
func (o *BulkCreateAppKVSecretsParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *BulkCreateAppKVSecretsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
