// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudWaypointWaypointServiceUpdateVariableBody hashicorp cloud waypoint waypoint service update variable body
//
// swagger:model hashicorp.cloud.waypoint.WaypointService.UpdateVariableBody
type HashicorpCloudWaypointWaypointServiceUpdateVariableBody struct {

	// namespace
	Namespace *HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace `json:"namespace,omitempty"`

	// The reference to the variable to update
	Ref *HashicorpCloudWaypointRefVariable `json:"ref,omitempty"`

	// Optional, will be used for PATCH requests. This includes what fields to
	// update in the request.
	UpdateMask string `json:"update_mask,omitempty"`

	// The variables fields to update
	Variable *HashicorpCloudWaypointVariable `json:"variable,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update variable body
func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNamespace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRef(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariable(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) validateNamespace(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespace) { // not required
		return nil
	}

	if m.Namespace != nil {
		if err := m.Namespace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) validateRef(formats strfmt.Registry) error {
	if swag.IsZero(m.Ref) { // not required
		return nil
	}

	if m.Ref != nil {
		if err := m.Ref.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ref")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ref")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) validateVariable(formats strfmt.Registry) error {
	if swag.IsZero(m.Variable) { // not required
		return nil
	}

	if m.Variable != nil {
		if err := m.Variable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("variable")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("variable")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service update variable body based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNamespace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRef(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) contextValidateNamespace(ctx context.Context, formats strfmt.Registry) error {

	if m.Namespace != nil {

		if swag.IsZero(m.Namespace) { // not required
			return nil
		}

		if err := m.Namespace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) contextValidateRef(ctx context.Context, formats strfmt.Registry) error {

	if m.Ref != nil {

		if swag.IsZero(m.Ref) { // not required
			return nil
		}

		if err := m.Ref.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ref")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ref")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) contextValidateVariable(ctx context.Context, formats strfmt.Registry) error {

	if m.Variable != nil {

		if swag.IsZero(m.Variable) { // not required
			return nil
		}

		if err := m.Variable.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("variable")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("variable")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBody) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateVariableBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace The namespace to update the variable in
//
// swagger:model HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace
type HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace struct {

	// When used via an API request, this is populated and used to populate id.
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update variable body namespace
func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service update variable body namespace based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateVariableBodyNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
