// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Billing20201105CardDetails CardDetails contains credit/debit card details.
//
// swagger:model billing_20201105CardDetails
type Billing20201105CardDetails struct {

	// brand of the card.
	Brand *CardDetailsBrand `json:"brand,omitempty"`

	// exp_month is the two-digit month part of the card's expiration date.
	ExpMonth int32 `json:"exp_month,omitempty"`

	// exp_year is the four-digit year part of the card's expiration date.
	ExpYear int32 `json:"exp_year,omitempty"`

	// last4 is the last four digits of the card's PAN (long number).
	Last4 string `json:"last4,omitempty"`
}

// Validate validates this billing 20201105 card details
func (m *Billing20201105CardDetails) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBrand(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105CardDetails) validateBrand(formats strfmt.Registry) error {
	if swag.IsZero(m.Brand) { // not required
		return nil
	}

	if m.Brand != nil {
		if err := m.Brand.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("brand")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("brand")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this billing 20201105 card details based on the context it is used
func (m *Billing20201105CardDetails) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBrand(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105CardDetails) contextValidateBrand(ctx context.Context, formats strfmt.Registry) error {

	if m.Brand != nil {

		if swag.IsZero(m.Brand) { // not required
			return nil
		}

		if err := m.Brand.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("brand")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("brand")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105CardDetails) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105CardDetails) UnmarshalBinary(b []byte) error {
	var res Billing20201105CardDetails
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
