// Code generated by go-swagger; DO NOT EDIT.

package auth_config_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAuthConfigServiceCreateAuthConnectionParams creates a new AuthConfigServiceCreateAuthConnectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAuthConfigServiceCreateAuthConnectionParams() *AuthConfigServiceCreateAuthConnectionParams {
	return &AuthConfigServiceCreateAuthConnectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAuthConfigServiceCreateAuthConnectionParamsWithTimeout creates a new AuthConfigServiceCreateAuthConnectionParams object
// with the ability to set a timeout on a request.
func NewAuthConfigServiceCreateAuthConnectionParamsWithTimeout(timeout time.Duration) *AuthConfigServiceCreateAuthConnectionParams {
	return &AuthConfigServiceCreateAuthConnectionParams{
		timeout: timeout,
	}
}

// NewAuthConfigServiceCreateAuthConnectionParamsWithContext creates a new AuthConfigServiceCreateAuthConnectionParams object
// with the ability to set a context for a request.
func NewAuthConfigServiceCreateAuthConnectionParamsWithContext(ctx context.Context) *AuthConfigServiceCreateAuthConnectionParams {
	return &AuthConfigServiceCreateAuthConnectionParams{
		Context: ctx,
	}
}

// NewAuthConfigServiceCreateAuthConnectionParamsWithHTTPClient creates a new AuthConfigServiceCreateAuthConnectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewAuthConfigServiceCreateAuthConnectionParamsWithHTTPClient(client *http.Client) *AuthConfigServiceCreateAuthConnectionParams {
	return &AuthConfigServiceCreateAuthConnectionParams{
		HTTPClient: client,
	}
}

/*
AuthConfigServiceCreateAuthConnectionParams contains all the parameters to send to the API endpoint

	for the auth config service create auth connection operation.

	Typically these are written to a http.Request.
*/
type AuthConfigServiceCreateAuthConnectionParams struct {

	// Body.
	Body AuthConfigServiceCreateAuthConnectionBody

	/* OrganizationID.

	   organization_id is the organization that will own the authentication connection.
	*/
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the auth config service create auth connection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AuthConfigServiceCreateAuthConnectionParams) WithDefaults() *AuthConfigServiceCreateAuthConnectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the auth config service create auth connection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AuthConfigServiceCreateAuthConnectionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) WithTimeout(timeout time.Duration) *AuthConfigServiceCreateAuthConnectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) WithContext(ctx context.Context) *AuthConfigServiceCreateAuthConnectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) WithHTTPClient(client *http.Client) *AuthConfigServiceCreateAuthConnectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) WithBody(body AuthConfigServiceCreateAuthConnectionBody) *AuthConfigServiceCreateAuthConnectionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) SetBody(body AuthConfigServiceCreateAuthConnectionBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) WithOrganizationID(organizationID string) *AuthConfigServiceCreateAuthConnectionParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the auth config service create auth connection params
func (o *AuthConfigServiceCreateAuthConnectionParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *AuthConfigServiceCreateAuthConnectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
