// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyReader is a Reader for the ServicePrincipalsServiceCreateOrganizationServicePrincipalKey structure.
type ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK creates a ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK with default headers values
func NewServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK() *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK {
	return &ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK{}
}

/*
ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK struct {
	Payload *models.HashicorpCloudIamCreateOrganizationServicePrincipalKeyResponse
}

// IsSuccess returns true when this service principals service create organization service principal key o k response has a 2xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service create organization service principal key o k response has a 3xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service create organization service principal key o k response has a 4xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service create organization service principal key o k response has a 5xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service create organization service principal key o k response a status code equal to that given
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service create organization service principal key o k response
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/service-principal-keys][%d] servicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/service-principal-keys][%d] servicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) GetPayload() *models.HashicorpCloudIamCreateOrganizationServicePrincipalKeyResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCreateOrganizationServicePrincipalKeyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault creates a ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault with default headers values
func NewServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault(code int) *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault {
	return &ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service create organization service principal key default response has a 2xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service create organization service principal key default response has a 3xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service create organization service principal key default response has a 4xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service create organization service principal key default response has a 5xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service create organization service principal key default response a status code equal to that given
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service create organization service principal key default response
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/service-principal-keys][%d] ServicePrincipalsService_CreateOrganizationServicePrincipalKey default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/service-principal-keys][%d] ServicePrincipalsService_CreateOrganizationServicePrincipalKey default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyBody CreateOrganizationServicePrincipalKeyRequest is the request message used when creating a
// service principal key for a principal on organization level.
swagger:model ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyBody
*/
type ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyBody struct {

	// principal_id is the ID of the service principal for which the new service
	// principal key should be created.
	PrincipalID string `json:"principal_id,omitempty"`
}

// Validate validates this service principals service create organization service principal key body
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this service principals service create organization service principal key body based on context it is used
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyBody) UnmarshalBinary(b []byte) error {
	var res ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
