// Code generated by go-swagger; DO NOT EDIT.

package data_source_registration_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// OnboardDataSourceReader is a Reader for the OnboardDataSource structure.
type OnboardDataSourceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *OnboardDataSourceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewOnboardDataSourceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewOnboardDataSourceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewOnboardDataSourceOK creates a OnboardDataSourceOK with default headers values
func NewOnboardDataSourceOK() *OnboardDataSourceOK {
	return &OnboardDataSourceOK{}
}

/*
OnboardDataSourceOK describes a response with status code 200, with default header values.

A successful response.
*/
type OnboardDataSourceOK struct {
	Payload *models.VaultRadar20230501OnboardDataSourceResponse
}

// IsSuccess returns true when this onboard data source o k response has a 2xx status code
func (o *OnboardDataSourceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this onboard data source o k response has a 3xx status code
func (o *OnboardDataSourceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this onboard data source o k response has a 4xx status code
func (o *OnboardDataSourceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this onboard data source o k response has a 5xx status code
func (o *OnboardDataSourceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this onboard data source o k response a status code equal to that given
func (o *OnboardDataSourceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the onboard data source o k response
func (o *OnboardDataSourceOK) Code() int {
	return 200
}

func (o *OnboardDataSourceOK) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/onboard][%d] onboardDataSourceOK  %+v", 200, o.Payload)
}

func (o *OnboardDataSourceOK) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/onboard][%d] onboardDataSourceOK  %+v", 200, o.Payload)
}

func (o *OnboardDataSourceOK) GetPayload() *models.VaultRadar20230501OnboardDataSourceResponse {
	return o.Payload
}

func (o *OnboardDataSourceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VaultRadar20230501OnboardDataSourceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewOnboardDataSourceDefault creates a OnboardDataSourceDefault with default headers values
func NewOnboardDataSourceDefault(code int) *OnboardDataSourceDefault {
	return &OnboardDataSourceDefault{
		_statusCode: code,
	}
}

/*
OnboardDataSourceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type OnboardDataSourceDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this onboard data source default response has a 2xx status code
func (o *OnboardDataSourceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this onboard data source default response has a 3xx status code
func (o *OnboardDataSourceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this onboard data source default response has a 4xx status code
func (o *OnboardDataSourceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this onboard data source default response has a 5xx status code
func (o *OnboardDataSourceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this onboard data source default response a status code equal to that given
func (o *OnboardDataSourceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the onboard data source default response
func (o *OnboardDataSourceDefault) Code() int {
	return o._statusCode
}

func (o *OnboardDataSourceDefault) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/onboard][%d] OnboardDataSource default  %+v", o._statusCode, o.Payload)
}

func (o *OnboardDataSourceDefault) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/onboard][%d] OnboardDataSource default  %+v", o._statusCode, o.Payload)
}

func (o *OnboardDataSourceDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *OnboardDataSourceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
OnboardDataSourceBody onboard data source body
swagger:model OnboardDataSourceBody
*/
type OnboardDataSourceBody struct {

	// connection url
	ConnectionURL string `json:"connection_url,omitempty"`

	// location
	Location *OnboardDataSourceParamsBodyLocation `json:"location,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// token
	Token string `json:"token,omitempty"`

	// type
	Type string `json:"type,omitempty"`
}

// Validate validates this onboard data source body
func (o *OnboardDataSourceBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *OnboardDataSourceBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this onboard data source body based on the context it is used
func (o *OnboardDataSourceBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *OnboardDataSourceBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *OnboardDataSourceBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *OnboardDataSourceBody) UnmarshalBinary(b []byte) error {
	var res OnboardDataSourceBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
OnboardDataSourceParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model OnboardDataSourceParamsBodyLocation
*/
type OnboardDataSourceParamsBodyLocation struct {

	// organization_id is the id of the organization.
	OrganizationID string `json:"organization_id,omitempty"`

	// region
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this onboard data source params body location
func (o *OnboardDataSourceParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *OnboardDataSourceParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this onboard data source params body location based on the context it is used
func (o *OnboardDataSourceParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *OnboardDataSourceParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *OnboardDataSourceParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *OnboardDataSourceParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res OnboardDataSourceParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
