// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetCurrentMilestoneParams creates a new GetCurrentMilestoneParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetCurrentMilestoneParams() *GetCurrentMilestoneParams {
	return &GetCurrentMilestoneParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetCurrentMilestoneParamsWithTimeout creates a new GetCurrentMilestoneParams object
// with the ability to set a timeout on a request.
func NewGetCurrentMilestoneParamsWithTimeout(timeout time.Duration) *GetCurrentMilestoneParams {
	return &GetCurrentMilestoneParams{
		timeout: timeout,
	}
}

// NewGetCurrentMilestoneParamsWithContext creates a new GetCurrentMilestoneParams object
// with the ability to set a context for a request.
func NewGetCurrentMilestoneParamsWithContext(ctx context.Context) *GetCurrentMilestoneParams {
	return &GetCurrentMilestoneParams{
		Context: ctx,
	}
}

// NewGetCurrentMilestoneParamsWithHTTPClient creates a new GetCurrentMilestoneParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetCurrentMilestoneParamsWithHTTPClient(client *http.Client) *GetCurrentMilestoneParams {
	return &GetCurrentMilestoneParams{
		HTTPClient: client,
	}
}

/*
GetCurrentMilestoneParams contains all the parameters to send to the API endpoint

	for the get current milestone operation.

	Typically these are written to a http.Request.
*/
type GetCurrentMilestoneParams struct {

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get current milestone params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCurrentMilestoneParams) WithDefaults() *GetCurrentMilestoneParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get current milestone params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCurrentMilestoneParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get current milestone params
func (o *GetCurrentMilestoneParams) WithTimeout(timeout time.Duration) *GetCurrentMilestoneParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get current milestone params
func (o *GetCurrentMilestoneParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get current milestone params
func (o *GetCurrentMilestoneParams) WithContext(ctx context.Context) *GetCurrentMilestoneParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get current milestone params
func (o *GetCurrentMilestoneParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get current milestone params
func (o *GetCurrentMilestoneParams) WithHTTPClient(client *http.Client) *GetCurrentMilestoneParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get current milestone params
func (o *GetCurrentMilestoneParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the get current milestone params
func (o *GetCurrentMilestoneParams) WithClusterID(clusterID string) *GetCurrentMilestoneParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the get current milestone params
func (o *GetCurrentMilestoneParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the get current milestone params
func (o *GetCurrentMilestoneParams) WithLocationOrganizationID(locationOrganizationID string) *GetCurrentMilestoneParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get current milestone params
func (o *GetCurrentMilestoneParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get current milestone params
func (o *GetCurrentMilestoneParams) WithLocationProjectID(locationProjectID string) *GetCurrentMilestoneParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get current milestone params
func (o *GetCurrentMilestoneParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get current milestone params
func (o *GetCurrentMilestoneParams) WithLocationRegionProvider(locationRegionProvider *string) *GetCurrentMilestoneParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get current milestone params
func (o *GetCurrentMilestoneParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get current milestone params
func (o *GetCurrentMilestoneParams) WithLocationRegionRegion(locationRegionRegion *string) *GetCurrentMilestoneParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get current milestone params
func (o *GetCurrentMilestoneParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetCurrentMilestoneParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
