// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/integrations/v1alpha/task_config.proto

package integrations

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Various policies for executing the next set of tasks.
type TaskConfig_NextTasksExecutionPolicy int32

const (
	// Default.
	TaskConfig_NEXT_TASKS_EXECUTION_POLICY_UNSPECIFIED TaskConfig_NextTasksExecutionPolicy = 0
	// Execute all the tasks that satisfy their associated condition.
	TaskConfig_RUN_ALL_MATCH TaskConfig_NextTasksExecutionPolicy = 1
	// Execute the first task that satisfies the associated condition.
	TaskConfig_RUN_FIRST_MATCH TaskConfig_NextTasksExecutionPolicy = 2
)

// Enum value maps for TaskConfig_NextTasksExecutionPolicy.
var (
	TaskConfig_NextTasksExecutionPolicy_name = map[int32]string{
		0: "NEXT_TASKS_EXECUTION_POLICY_UNSPECIFIED",
		1: "RUN_ALL_MATCH",
		2: "RUN_FIRST_MATCH",
	}
	TaskConfig_NextTasksExecutionPolicy_value = map[string]int32{
		"NEXT_TASKS_EXECUTION_POLICY_UNSPECIFIED": 0,
		"RUN_ALL_MATCH":   1,
		"RUN_FIRST_MATCH": 2,
	}
)

func (x TaskConfig_NextTasksExecutionPolicy) Enum() *TaskConfig_NextTasksExecutionPolicy {
	p := new(TaskConfig_NextTasksExecutionPolicy)
	*p = x
	return p
}

func (x TaskConfig_NextTasksExecutionPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskConfig_NextTasksExecutionPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes[0].Descriptor()
}

func (TaskConfig_NextTasksExecutionPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes[0]
}

func (x TaskConfig_NextTasksExecutionPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskConfig_NextTasksExecutionPolicy.Descriptor instead.
func (TaskConfig_NextTasksExecutionPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP(), []int{0, 0}
}

// Various policies to trigger the execution of this task.
type TaskConfig_TaskExecutionStrategy int32

const (
	// Default. If the strategy is not set explicitly, it will default to
	// `WHEN_ALL_SUCCEED`.
	TaskConfig_TASK_EXECUTION_STRATEGY_UNSPECIFIED TaskConfig_TaskExecutionStrategy = 0
	// Wait until all of its previous tasks finished execution, then verify at
	// least one of the edge conditions is met, and execute if possible. This
	// should be considered as WHEN_ALL_TASKS_SUCCEED.
	TaskConfig_WHEN_ALL_SUCCEED TaskConfig_TaskExecutionStrategy = 1
	// Start execution as long as any of its previous tasks finished execution
	// and the corresponding edge condition is met (since we will execute if
	// only that succeeding edge condition is met).
	TaskConfig_WHEN_ANY_SUCCEED TaskConfig_TaskExecutionStrategy = 2
	// Wait until all of its previous tasks finished execution, then verify
	// the all edge conditions are met and execute if possible.
	TaskConfig_WHEN_ALL_TASKS_AND_CONDITIONS_SUCCEED TaskConfig_TaskExecutionStrategy = 3
)

// Enum value maps for TaskConfig_TaskExecutionStrategy.
var (
	TaskConfig_TaskExecutionStrategy_name = map[int32]string{
		0: "TASK_EXECUTION_STRATEGY_UNSPECIFIED",
		1: "WHEN_ALL_SUCCEED",
		2: "WHEN_ANY_SUCCEED",
		3: "WHEN_ALL_TASKS_AND_CONDITIONS_SUCCEED",
	}
	TaskConfig_TaskExecutionStrategy_value = map[string]int32{
		"TASK_EXECUTION_STRATEGY_UNSPECIFIED":   0,
		"WHEN_ALL_SUCCEED":                      1,
		"WHEN_ANY_SUCCEED":                      2,
		"WHEN_ALL_TASKS_AND_CONDITIONS_SUCCEED": 3,
	}
)

func (x TaskConfig_TaskExecutionStrategy) Enum() *TaskConfig_TaskExecutionStrategy {
	p := new(TaskConfig_TaskExecutionStrategy)
	*p = x
	return p
}

func (x TaskConfig_TaskExecutionStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskConfig_TaskExecutionStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes[1].Descriptor()
}

func (TaskConfig_TaskExecutionStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes[1]
}

func (x TaskConfig_TaskExecutionStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskConfig_TaskExecutionStrategy.Descriptor instead.
func (TaskConfig_TaskExecutionStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP(), []int{0, 1}
}

// The state of execution.
type SuccessPolicy_FinalState int32

const (
	// UNSPECIFIED.
	SuccessPolicy_FINAL_STATE_UNSPECIFIED SuccessPolicy_FinalState = 0
	// The default behavior, where successful tasks will be marked as SUCCEEDED.
	SuccessPolicy_SUCCEEDED SuccessPolicy_FinalState = 1
	// Sets the state to SUSPENDED after executing.  This is required for
	// SuspensionTask; event execution will continue once the user calls
	// ResolveSuspensions with the event_execution_info_id and the task number.
	SuccessPolicy_SUSPENDED SuccessPolicy_FinalState = 2
)

// Enum value maps for SuccessPolicy_FinalState.
var (
	SuccessPolicy_FinalState_name = map[int32]string{
		0: "FINAL_STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "SUSPENDED",
	}
	SuccessPolicy_FinalState_value = map[string]int32{
		"FINAL_STATE_UNSPECIFIED": 0,
		"SUCCEEDED":               1,
		"SUSPENDED":               2,
	}
)

func (x SuccessPolicy_FinalState) Enum() *SuccessPolicy_FinalState {
	p := new(SuccessPolicy_FinalState)
	*p = x
	return p
}

func (x SuccessPolicy_FinalState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SuccessPolicy_FinalState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes[2].Descriptor()
}

func (SuccessPolicy_FinalState) Type() protoreflect.EnumType {
	return &file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes[2]
}

func (x SuccessPolicy_FinalState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SuccessPolicy_FinalState.Descriptor instead.
func (SuccessPolicy_FinalState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP(), []int{1, 0}
}

// The behavior when the taks failed.
type FailurePolicy_RetryStrategy int32

const (
	// UNSPECIFIED.
	FailurePolicy_RETRY_STRATEGY_UNSPECIFIED FailurePolicy_RetryStrategy = 0
	// Ignores the failure of this task. The rest of the integration will be
	// executed Assuming this task succeeded.
	FailurePolicy_IGNORE FailurePolicy_RetryStrategy = 1
	// Causes a permanent failure of the task. However, if the last task(s)
	// of event was successfully completed despite the failure of this task,
	// it has no impact on the integration.
	FailurePolicy_NONE FailurePolicy_RetryStrategy = 2
	// Causes a permanent failure of the event. It is different from NONE
	// because this will mark the event as FAILED by shutting down the
	// event execution.
	FailurePolicy_FATAL FailurePolicy_RetryStrategy = 3
	// The task will be retried from the failed task onwards after a fixed
	// delay. A max-retry count is required to be specified with this
	// strategy. A jitter is added to each exponential interval so that
	// concurrently failing tasks of the same type do not end up retrying
	// after the exact same exponential interval. max_retries and
	// interval_in_seconds must be specified.
	FailurePolicy_FIXED_INTERVAL FailurePolicy_RetryStrategy = 4
	// The task will be retried from the failed task onwards after a fixed
	// delay that linearly increases with each retry attempt. A jitter is
	// added to each exponential interval so that concurrently failing tasks
	// of the same type do not end up retrying after the exact same
	// exponential interval. A max-retry count is required to be specified
	// with this strategy. max_retries and interval_in_seconds must be
	// specified.
	FailurePolicy_LINEAR_BACKOFF FailurePolicy_RetryStrategy = 5
	// The task will be retried after an exponentially increasing period of
	// time with each failure. A jitter is added to each exponential interval
	// so that concurrently failing tasks of the same type do not end up
	// retrying after the exact same exponential interval. A max-retry count
	// is required to be specified with this strategy. `max_retries` and
	// `interval_in_seconds` must be specified.
	FailurePolicy_EXPONENTIAL_BACKOFF FailurePolicy_RetryStrategy = 6
	// The entire integration will be restarted with the initial parameters that
	// were set when the event was fired. A max-retry count is required to be
	// specified with this strategy. `max_retries` and `interval_in_seconds`
	// must be specified.
	FailurePolicy_RESTART_INTEGRATION_WITH_BACKOFF FailurePolicy_RetryStrategy = 7
)

// Enum value maps for FailurePolicy_RetryStrategy.
var (
	FailurePolicy_RetryStrategy_name = map[int32]string{
		0: "RETRY_STRATEGY_UNSPECIFIED",
		1: "IGNORE",
		2: "NONE",
		3: "FATAL",
		4: "FIXED_INTERVAL",
		5: "LINEAR_BACKOFF",
		6: "EXPONENTIAL_BACKOFF",
		7: "RESTART_INTEGRATION_WITH_BACKOFF",
	}
	FailurePolicy_RetryStrategy_value = map[string]int32{
		"RETRY_STRATEGY_UNSPECIFIED":       0,
		"IGNORE":                           1,
		"NONE":                             2,
		"FATAL":                            3,
		"FIXED_INTERVAL":                   4,
		"LINEAR_BACKOFF":                   5,
		"EXPONENTIAL_BACKOFF":              6,
		"RESTART_INTEGRATION_WITH_BACKOFF": 7,
	}
)

func (x FailurePolicy_RetryStrategy) Enum() *FailurePolicy_RetryStrategy {
	p := new(FailurePolicy_RetryStrategy)
	*p = x
	return p
}

func (x FailurePolicy_RetryStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FailurePolicy_RetryStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes[3].Descriptor()
}

func (FailurePolicy_RetryStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes[3]
}

func (x FailurePolicy_RetryStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FailurePolicy_RetryStrategy.Descriptor instead.
func (FailurePolicy_RetryStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP(), []int{2, 0}
}

// The task configuration details. This is not the implementation of Task.
// There might be multiple TaskConfigs for the same Task.
// (-- Next available id: 12 --)
type TaskConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name for the task.
	Task string `protobuf:"bytes,1,opt,name=task,proto3" json:"task,omitempty"`
	// Required. The identifier of this task within its parent event config,
	// specified by the client. This should be unique among all the tasks belong
	// to the same event config. We use this field as the identifier to
	// find next tasks (via field `next_tasks.task_id`).
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Optional. The customized parameters the user can pass to this task.
	Parameters map[string]*EventParameter `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Determines the number of times the
	// task will be retried on failure and with what retry strategy.
	// This is applicable for asynchronous calls to Eventbus alone (Post To
	// Queue, Schedule etc.).
	FailurePolicy *FailurePolicy `protobuf:"bytes,4,opt,name=failure_policy,json=failurePolicy,proto3" json:"failure_policy,omitempty"`
	// Optional. Determines the number of times the
	// task will be retried on failure and with what retry strategy.
	// This is applicable for synchronous calls to Eventbus alone (Post).
	SynchronousCallFailurePolicy *FailurePolicy `protobuf:"bytes,5,opt,name=synchronous_call_failure_policy,json=synchronousCallFailurePolicy,proto3" json:"synchronous_call_failure_policy,omitempty"`
	// Optional. The set of tasks that are next in line to be executed as per the
	// execution graph defined for the parent event, specified by
	// `event_config_id`. Each of these next tasks are executed
	// only if the condition associated with them evaluates to true.
	NextTasks []*NextTask `protobuf:"bytes,6,rep,name=next_tasks,json=nextTasks,proto3" json:"next_tasks,omitempty"`
	// Optional. The policy dictating the execution of the next set of tasks for the current
	// task.
	NextTasksExecutionPolicy TaskConfig_NextTasksExecutionPolicy `protobuf:"varint,7,opt,name=next_tasks_execution_policy,json=nextTasksExecutionPolicy,proto3,enum=google.cloud.integrations.v1alpha.TaskConfig_NextTasksExecutionPolicy" json:"next_tasks_execution_policy,omitempty"`
	// Optional. The policy dictating the execution strategy of this task.
	TaskExecutionStrategy TaskConfig_TaskExecutionStrategy `protobuf:"varint,8,opt,name=task_execution_strategy,json=taskExecutionStrategy,proto3,enum=google.cloud.integrations.v1alpha.TaskConfig_TaskExecutionStrategy" json:"task_execution_strategy,omitempty"`
	// Optional. User-provided label that is attached to this TaskConfig in the UI.
	DisplayName string `protobuf:"bytes,9,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Determines what action to take upon successful task completion.
	SuccessPolicy *SuccessPolicy `protobuf:"bytes,10,opt,name=success_policy,json=successPolicy,proto3" json:"success_policy,omitempty"`
	// Optional. If set, overrides the option configured in the Task implementation class.
	JsonValidationOption JsonValidationOption `protobuf:"varint,11,opt,name=json_validation_option,json=jsonValidationOption,proto3,enum=google.cloud.integrations.v1alpha.JsonValidationOption" json:"json_validation_option,omitempty"`
}

func (x *TaskConfig) Reset() {
	*x = TaskConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskConfig) ProtoMessage() {}

func (x *TaskConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskConfig.ProtoReflect.Descriptor instead.
func (*TaskConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP(), []int{0}
}

func (x *TaskConfig) GetTask() string {
	if x != nil {
		return x.Task
	}
	return ""
}

func (x *TaskConfig) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *TaskConfig) GetParameters() map[string]*EventParameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *TaskConfig) GetFailurePolicy() *FailurePolicy {
	if x != nil {
		return x.FailurePolicy
	}
	return nil
}

func (x *TaskConfig) GetSynchronousCallFailurePolicy() *FailurePolicy {
	if x != nil {
		return x.SynchronousCallFailurePolicy
	}
	return nil
}

func (x *TaskConfig) GetNextTasks() []*NextTask {
	if x != nil {
		return x.NextTasks
	}
	return nil
}

func (x *TaskConfig) GetNextTasksExecutionPolicy() TaskConfig_NextTasksExecutionPolicy {
	if x != nil {
		return x.NextTasksExecutionPolicy
	}
	return TaskConfig_NEXT_TASKS_EXECUTION_POLICY_UNSPECIFIED
}

func (x *TaskConfig) GetTaskExecutionStrategy() TaskConfig_TaskExecutionStrategy {
	if x != nil {
		return x.TaskExecutionStrategy
	}
	return TaskConfig_TASK_EXECUTION_STRATEGY_UNSPECIFIED
}

func (x *TaskConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *TaskConfig) GetSuccessPolicy() *SuccessPolicy {
	if x != nil {
		return x.SuccessPolicy
	}
	return nil
}

func (x *TaskConfig) GetJsonValidationOption() JsonValidationOption {
	if x != nil {
		return x.JsonValidationOption
	}
	return JsonValidationOption_JSON_VALIDATION_OPTION_UNSPECIFIED
}

// Policy that dictates the behavior for the task after it completes
// successfully.
type SuccessPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// State to which the execution snapshot status will be set if the task
	// succeeds.
	FinalState SuccessPolicy_FinalState `protobuf:"varint,1,opt,name=final_state,json=finalState,proto3,enum=google.cloud.integrations.v1alpha.SuccessPolicy_FinalState" json:"final_state,omitempty"`
}

func (x *SuccessPolicy) Reset() {
	*x = SuccessPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuccessPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuccessPolicy) ProtoMessage() {}

func (x *SuccessPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuccessPolicy.ProtoReflect.Descriptor instead.
func (*SuccessPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP(), []int{1}
}

func (x *SuccessPolicy) GetFinalState() SuccessPolicy_FinalState {
	if x != nil {
		return x.FinalState
	}
	return SuccessPolicy_FINAL_STATE_UNSPECIFIED
}

// Policy that defines the task retry logic and failure type. If no
// FailurePolicy is defined for a task, all its dependent tasks will not be
// executed (i.e, a `retry_strategy` of NONE will be applied).
type FailurePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines what happens to the task upon failure.
	RetryStrategy FailurePolicy_RetryStrategy `protobuf:"varint,1,opt,name=retry_strategy,json=retryStrategy,proto3,enum=google.cloud.integrations.v1alpha.FailurePolicy_RetryStrategy" json:"retry_strategy,omitempty"`
	// Required if retry_strategy is FIXED_INTERVAL or
	// LINEAR/EXPONENTIAL_BACKOFF/RESTART_INTEGRATION_WITH_BACKOFF. Defines the
	// number of times the task will be retried if failed.
	MaxRetries int32 `protobuf:"varint,2,opt,name=max_retries,json=maxRetries,proto3" json:"max_retries,omitempty"`
	// Required if retry_strategy is FIXED_INTERVAL or
	// LINEAR/EXPONENTIAL_BACKOFF/RESTART_INTEGRATION_WITH_BACKOFF. Defines the
	// initial interval in seconds for backoff.
	IntervalTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=interval_time,json=intervalTime,proto3" json:"interval_time,omitempty"`
}

func (x *FailurePolicy) Reset() {
	*x = FailurePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailurePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailurePolicy) ProtoMessage() {}

func (x *FailurePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailurePolicy.ProtoReflect.Descriptor instead.
func (*FailurePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP(), []int{2}
}

func (x *FailurePolicy) GetRetryStrategy() FailurePolicy_RetryStrategy {
	if x != nil {
		return x.RetryStrategy
	}
	return FailurePolicy_RETRY_STRATEGY_UNSPECIFIED
}

func (x *FailurePolicy) GetMaxRetries() int32 {
	if x != nil {
		return x.MaxRetries
	}
	return 0
}

func (x *FailurePolicy) GetIntervalTime() *timestamppb.Timestamp {
	if x != nil {
		return x.IntervalTime
	}
	return nil
}

// The task that is next in line to be executed, if the
// condition specified evaluated to true.
type NextTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the next task.
	TaskConfigId string `protobuf:"bytes,1,opt,name=task_config_id,json=taskConfigId,proto3" json:"task_config_id,omitempty"`
	// Task number of the next task.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Standard filter expression for this task to become an eligible next task.
	Condition string `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// User-provided label that is attached to this edge in the UI.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *NextTask) Reset() {
	*x = NextTask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NextTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextTask) ProtoMessage() {}

func (x *NextTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextTask.ProtoReflect.Descriptor instead.
func (*NextTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP(), []int{3}
}

func (x *NextTask) GetTaskConfigId() string {
	if x != nil {
		return x.TaskConfigId
	}
	return ""
}

func (x *NextTask) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *NextTask) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *NextTask) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_integrations_v1alpha_task_config_proto protoreflect.FileDescriptor

var file_google_cloud_integrations_v1alpha_task_config_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdb, 0x0a, 0x0a,
	0x0a, 0x54, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x74,
	0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x74, 0x61, 0x73, 0x6b, 0x12, 0x1c, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b,
	0x49, 0x64, 0x12, 0x62, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x5c, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x7c, 0x0a, 0x1f, 0x73, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e,
	0x6f, 0x75, 0x73, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x73, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x6f, 0x75,
	0x73, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x4f, 0x0a, 0x0a, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4e, 0x65, 0x78, 0x74, 0x54,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6e, 0x65, 0x78, 0x74, 0x54, 0x61,
	0x73, 0x6b, 0x73, 0x12, 0x8a, 0x01, 0x0a, 0x1b, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x61, 0x73,
	0x6b, 0x73, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x65, 0x78, 0x74, 0x54, 0x61, 0x73,
	0x6b, 0x73, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x6e, 0x65, 0x78, 0x74, 0x54, 0x61, 0x73, 0x6b,
	0x73, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x80, 0x01, 0x0a, 0x17, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x74, 0x61,
	0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x0e, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x72, 0x0a, 0x16, 0x6a, 0x73, 0x6f,
	0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4a, 0x73,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x6a, 0x73, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x70, 0x0a,
	0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x6f, 0x0a, 0x18, 0x4e, 0x65, 0x78, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2b, 0x0a, 0x27, 0x4e,
	0x45, 0x58, 0x54, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x53, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x55, 0x4e, 0x5f,
	0x41, 0x4c, 0x4c, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x52,
	0x55, 0x4e, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x02,
	0x22, 0x97, 0x01, 0x0a, 0x15, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x27, 0x0a, 0x23, 0x54, 0x41,
	0x53, 0x4b, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52,
	0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x57, 0x48, 0x45, 0x4e, 0x5f, 0x41, 0x4c, 0x4c, 0x5f,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x57, 0x48, 0x45,
	0x4e, 0x5f, 0x41, 0x4e, 0x59, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x29, 0x0a, 0x25, 0x57, 0x48, 0x45, 0x4e, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x54, 0x41, 0x53, 0x4b,
	0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x53,
	0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x10, 0x03, 0x22, 0xb6, 0x01, 0x0a, 0x0d, 0x53,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5c, 0x0a, 0x0b,
	0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a,
	0x66, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x47, 0x0a, 0x0a, 0x46, 0x69,
	0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x46, 0x49, 0x4e, 0x41,
	0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45,
	0x44, 0x10, 0x02, 0x22, 0x92, 0x03, 0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x65, 0x0a, 0x0e, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x52, 0x65, 0x74, 0x72, 0x79, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x0d, 0x72,
	0x65, 0x74, 0x72, 0x79, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x1f, 0x0a, 0x0b,
	0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3f, 0x0a,
	0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb7,
	0x01, 0x0a, 0x0d, 0x52, 0x65, 0x74, 0x72, 0x79, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x54, 0x52, 0x59, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45,
	0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x10,
	0x03, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x49, 0x58, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x56, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x5f,
	0x42, 0x41, 0x43, 0x4b, 0x4f, 0x46, 0x46, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x58, 0x50,
	0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x4f, 0x46, 0x46,
	0x10, 0x06, 0x12, 0x24, 0x0a, 0x20, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x49, 0x4e,
	0x54, 0x45, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x42,
	0x41, 0x43, 0x4b, 0x4f, 0x46, 0x46, 0x10, 0x07, 0x22, 0x8a, 0x01, 0x0a, 0x08, 0x4e, 0x65, 0x78,
	0x74, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74,
	0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x74,
	0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61,
	0x73, 0x6b, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x89, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42,
	0x0f, 0x54, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x4d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x3b, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_integrations_v1alpha_task_config_proto_rawDescOnce sync.Once
	file_google_cloud_integrations_v1alpha_task_config_proto_rawDescData = file_google_cloud_integrations_v1alpha_task_config_proto_rawDesc
)

func file_google_cloud_integrations_v1alpha_task_config_proto_rawDescGZIP() []byte {
	file_google_cloud_integrations_v1alpha_task_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_integrations_v1alpha_task_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_integrations_v1alpha_task_config_proto_rawDescData)
	})
	return file_google_cloud_integrations_v1alpha_task_config_proto_rawDescData
}

var file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_integrations_v1alpha_task_config_proto_goTypes = []interface{}{
	(TaskConfig_NextTasksExecutionPolicy)(0), // 0: google.cloud.integrations.v1alpha.TaskConfig.NextTasksExecutionPolicy
	(TaskConfig_TaskExecutionStrategy)(0),    // 1: google.cloud.integrations.v1alpha.TaskConfig.TaskExecutionStrategy
	(SuccessPolicy_FinalState)(0),            // 2: google.cloud.integrations.v1alpha.SuccessPolicy.FinalState
	(FailurePolicy_RetryStrategy)(0),         // 3: google.cloud.integrations.v1alpha.FailurePolicy.RetryStrategy
	(*TaskConfig)(nil),                       // 4: google.cloud.integrations.v1alpha.TaskConfig
	(*SuccessPolicy)(nil),                    // 5: google.cloud.integrations.v1alpha.SuccessPolicy
	(*FailurePolicy)(nil),                    // 6: google.cloud.integrations.v1alpha.FailurePolicy
	(*NextTask)(nil),                         // 7: google.cloud.integrations.v1alpha.NextTask
	nil,                                      // 8: google.cloud.integrations.v1alpha.TaskConfig.ParametersEntry
	(JsonValidationOption)(0),                // 9: google.cloud.integrations.v1alpha.JsonValidationOption
	(*timestamppb.Timestamp)(nil),            // 10: google.protobuf.Timestamp
	(*EventParameter)(nil),                   // 11: google.cloud.integrations.v1alpha.EventParameter
}
var file_google_cloud_integrations_v1alpha_task_config_proto_depIdxs = []int32{
	8,  // 0: google.cloud.integrations.v1alpha.TaskConfig.parameters:type_name -> google.cloud.integrations.v1alpha.TaskConfig.ParametersEntry
	6,  // 1: google.cloud.integrations.v1alpha.TaskConfig.failure_policy:type_name -> google.cloud.integrations.v1alpha.FailurePolicy
	6,  // 2: google.cloud.integrations.v1alpha.TaskConfig.synchronous_call_failure_policy:type_name -> google.cloud.integrations.v1alpha.FailurePolicy
	7,  // 3: google.cloud.integrations.v1alpha.TaskConfig.next_tasks:type_name -> google.cloud.integrations.v1alpha.NextTask
	0,  // 4: google.cloud.integrations.v1alpha.TaskConfig.next_tasks_execution_policy:type_name -> google.cloud.integrations.v1alpha.TaskConfig.NextTasksExecutionPolicy
	1,  // 5: google.cloud.integrations.v1alpha.TaskConfig.task_execution_strategy:type_name -> google.cloud.integrations.v1alpha.TaskConfig.TaskExecutionStrategy
	5,  // 6: google.cloud.integrations.v1alpha.TaskConfig.success_policy:type_name -> google.cloud.integrations.v1alpha.SuccessPolicy
	9,  // 7: google.cloud.integrations.v1alpha.TaskConfig.json_validation_option:type_name -> google.cloud.integrations.v1alpha.JsonValidationOption
	2,  // 8: google.cloud.integrations.v1alpha.SuccessPolicy.final_state:type_name -> google.cloud.integrations.v1alpha.SuccessPolicy.FinalState
	3,  // 9: google.cloud.integrations.v1alpha.FailurePolicy.retry_strategy:type_name -> google.cloud.integrations.v1alpha.FailurePolicy.RetryStrategy
	10, // 10: google.cloud.integrations.v1alpha.FailurePolicy.interval_time:type_name -> google.protobuf.Timestamp
	11, // 11: google.cloud.integrations.v1alpha.TaskConfig.ParametersEntry.value:type_name -> google.cloud.integrations.v1alpha.EventParameter
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_integrations_v1alpha_task_config_proto_init() }
func file_google_cloud_integrations_v1alpha_task_config_proto_init() {
	if File_google_cloud_integrations_v1alpha_task_config_proto != nil {
		return
	}
	file_google_cloud_integrations_v1alpha_event_parameter_proto_init()
	file_google_cloud_integrations_v1alpha_json_validation_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuccessPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailurePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NextTask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_integrations_v1alpha_task_config_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_integrations_v1alpha_task_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_integrations_v1alpha_task_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_integrations_v1alpha_task_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_integrations_v1alpha_task_config_proto_msgTypes,
	}.Build()
	File_google_cloud_integrations_v1alpha_task_config_proto = out.File
	file_google_cloud_integrations_v1alpha_task_config_proto_rawDesc = nil
	file_google_cloud_integrations_v1alpha_task_config_proto_goTypes = nil
	file_google_cloud_integrations_v1alpha_task_config_proto_depIdxs = nil
}
