# 打字速記法

配方： ℞ **stenotype**

[Rime](https://rime.im) 打字速記法輸入方案

由《ABC 簡易速記》所記述的字母式中文速記改編

## 用法

本方案的字母表與對應的拼音（加尖括號）：

    b  <b>          B  <bi>
    p  <p>          P  <pi>
    m  <m>          M  <mi>
    f  <f>          F  <fei>
    d  <d>          D  <di>
    t  <t>          T  <ti>
    n  <n>          N  <ni>
    l  <l>          L  <li>
    g  <g>          G  <gu>
    k  <k>          K  <ku>
    h  <h>          H  <hu>
    j  <j>          J  <ju>
    q  <q>          Q  <qu>
    x  <x>          X  <xu>
    z  <z, zh>      Z  <zu, zhu>
    c  <c, ch>      C  <cu, chu>
    s  <s, sh>      S  <su, shu>
    r  <r, er>      R  <ru>
    .  <i>
    :  <u>
    "  <ü>
    '  <a>          `  <ia>         ~  <ua>
    ,  <o, uo>
    e  <e, ei>      <  <ie>         >  <üe>
    v  <uei>
    i  <ai>
    @  <uai>
    o  <ao, iao>
    u  <ou, iou>
    a  <an>         y  <ian>        w  <uan>        $  <üan>
    -  <en, -n>     =  <in>         U  <uen>        V  <ün>
    A  <ang>        Y  <iang>       W  <uang>
    E  <eng>        I  <ing>        O  <ong, iong>

拼寫規則：

介音 `<i, u, ü>` 可選擇與聲母或韻母結合爲一個速記字母，以簡短、省力爲原則。

優先與聲母結合如

    j' = <jia>
    Ki = <kuai>
    Po = <piao>
    LA = <liang>
    M- = <min>
    je = <jie>

優先與韻母結合如

    pI = <ping>
    g, = <guo>

兩可，如

    La = ly = <lian>
    Ha = hw = <huan>
    He = hv = <hui>

隔音符號：

用 `_` 消除音節切分歧義。
拼合後不符合簡短原則的，視爲兩個音節，無須隔音。如 `.a`, `z:`

標點：

速記不重標點。本方案改用 `;` 鍵輸入「，」「。」「：」「；」等。

## 安裝

本方案依賴於

  - [朙月拼音](https://github.com/rime/rime-luna-pinyin) ℞ **`luna-pinyin`**

[東風破](https://github.com/rime/plum) 安裝口令： `bash rime-install stenotype`

授權條款：見 [LICENSE](LICENSE)
