// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Package seccomp provides a way to install a syscall filter for a Linux
// process. It uses the seccomp (secure computing) BPF filters.
package seccomp

// Run "go generate" from Linux to build the generated content.
//go:generate sh -c "go tool cgo -godefs defs_constants_linux.go > zconstants.go"
//go:generate sh -c "perl -p -i -e 's/DO NOT EDIT$/DO NOT EDIT./' zconstants.go"
//go:generate sh -c "perl -p -i -e 's|// Created by |// Code generated by |' zconstants.go"
