// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opActivateOrganizationsAccess = "ActivateOrganizationsAccess"

// ActivateOrganizationsAccessRequest generates a "aws/request.Request" representing the
// client's request for the ActivateOrganizationsAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateOrganizationsAccess for more information on using the ActivateOrganizationsAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ActivateOrganizationsAccessRequest method.
//	req, resp := client.ActivateOrganizationsAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateOrganizationsAccess
func (c *CloudFormation) ActivateOrganizationsAccessRequest(input *ActivateOrganizationsAccessInput) (req *request.Request, output *ActivateOrganizationsAccessOutput) {
	op := &request.Operation{
		Name:       opActivateOrganizationsAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateOrganizationsAccessInput{}
	}

	output = &ActivateOrganizationsAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ActivateOrganizationsAccess API operation for AWS CloudFormation.
//
// Activate trusted access with Organizations. With trusted access between StackSets
// and Organizations activated, the management account has permissions to create
// and manage StackSets for your organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ActivateOrganizationsAccess for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
//   - ErrCodeOperationNotFoundException "OperationNotFoundException"
//     The specified ID refers to an operation that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateOrganizationsAccess
func (c *CloudFormation) ActivateOrganizationsAccess(input *ActivateOrganizationsAccessInput) (*ActivateOrganizationsAccessOutput, error) {
	req, out := c.ActivateOrganizationsAccessRequest(input)
	return out, req.Send()
}

// ActivateOrganizationsAccessWithContext is the same as ActivateOrganizationsAccess with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateOrganizationsAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ActivateOrganizationsAccessWithContext(ctx aws.Context, input *ActivateOrganizationsAccessInput, opts ...request.Option) (*ActivateOrganizationsAccessOutput, error) {
	req, out := c.ActivateOrganizationsAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opActivateType = "ActivateType"

// ActivateTypeRequest generates a "aws/request.Request" representing the
// client's request for the ActivateType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateType for more information on using the ActivateType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ActivateTypeRequest method.
//	req, resp := client.ActivateTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateType
func (c *CloudFormation) ActivateTypeRequest(input *ActivateTypeInput) (req *request.Request, output *ActivateTypeOutput) {
	op := &request.Operation{
		Name:       opActivateType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateTypeInput{}
	}

	output = &ActivateTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ActivateType API operation for AWS CloudFormation.
//
// Activates a public third-party extension, making it available for use in
// stack templates. For more information, see Using public extensions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html)
// in the CloudFormation User Guide.
//
// Once you have activated a public third-party extension in your account and
// Region, use SetTypeConfiguration (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html)
// to specify configuration properties for the extension. For more information,
// see Configuring extensions at the account level (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private.html#registry-set-configuration)
// in the CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ActivateType for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
//   - ErrCodeTypeNotFoundException "TypeNotFoundException"
//     The specified extension doesn't exist in the CloudFormation registry.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateType
func (c *CloudFormation) ActivateType(input *ActivateTypeInput) (*ActivateTypeOutput, error) {
	req, out := c.ActivateTypeRequest(input)
	return out, req.Send()
}

// ActivateTypeWithContext is the same as ActivateType with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ActivateTypeWithContext(ctx aws.Context, input *ActivateTypeInput, opts ...request.Option) (*ActivateTypeOutput, error) {
	req, out := c.ActivateTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDescribeTypeConfigurations = "BatchDescribeTypeConfigurations"

// BatchDescribeTypeConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDescribeTypeConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDescribeTypeConfigurations for more information on using the BatchDescribeTypeConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDescribeTypeConfigurationsRequest method.
//	req, resp := client.BatchDescribeTypeConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/BatchDescribeTypeConfigurations
func (c *CloudFormation) BatchDescribeTypeConfigurationsRequest(input *BatchDescribeTypeConfigurationsInput) (req *request.Request, output *BatchDescribeTypeConfigurationsOutput) {
	op := &request.Operation{
		Name:       opBatchDescribeTypeConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDescribeTypeConfigurationsInput{}
	}

	output = &BatchDescribeTypeConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDescribeTypeConfigurations API operation for AWS CloudFormation.
//
// Returns configuration data for the specified CloudFormation extensions, from
// the CloudFormation registry for the account and Region.
//
// For more information, see Configuring extensions at the account level (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private.html#registry-set-configuration)
// in the CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation BatchDescribeTypeConfigurations for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeTypeConfigurationNotFoundException "TypeConfigurationNotFoundException"
//     The specified extension configuration can't be found.
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/BatchDescribeTypeConfigurations
func (c *CloudFormation) BatchDescribeTypeConfigurations(input *BatchDescribeTypeConfigurationsInput) (*BatchDescribeTypeConfigurationsOutput, error) {
	req, out := c.BatchDescribeTypeConfigurationsRequest(input)
	return out, req.Send()
}

// BatchDescribeTypeConfigurationsWithContext is the same as BatchDescribeTypeConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDescribeTypeConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) BatchDescribeTypeConfigurationsWithContext(ctx aws.Context, input *BatchDescribeTypeConfigurationsInput, opts ...request.Option) (*BatchDescribeTypeConfigurationsOutput, error) {
	req, out := c.BatchDescribeTypeConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelUpdateStack = "CancelUpdateStack"

// CancelUpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the CancelUpdateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelUpdateStack for more information on using the CancelUpdateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelUpdateStackRequest method.
//	req, resp := client.CancelUpdateStackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack
func (c *CloudFormation) CancelUpdateStackRequest(input *CancelUpdateStackInput) (req *request.Request, output *CancelUpdateStackOutput) {
	op := &request.Operation{
		Name:       opCancelUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelUpdateStackInput{}
	}

	output = &CancelUpdateStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelUpdateStack API operation for AWS CloudFormation.
//
// Cancels an update on the specified stack. If the call completes successfully,
// the stack rolls back the update and reverts to the previous stack configuration.
//
// You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CancelUpdateStack for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//     A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack
func (c *CloudFormation) CancelUpdateStack(input *CancelUpdateStackInput) (*CancelUpdateStackOutput, error) {
	req, out := c.CancelUpdateStackRequest(input)
	return out, req.Send()
}

// CancelUpdateStackWithContext is the same as CancelUpdateStack with the addition of
// the ability to pass a context and additional request options.
//
// See CancelUpdateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CancelUpdateStackWithContext(ctx aws.Context, input *CancelUpdateStackInput, opts ...request.Option) (*CancelUpdateStackOutput, error) {
	req, out := c.CancelUpdateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opContinueUpdateRollback = "ContinueUpdateRollback"

// ContinueUpdateRollbackRequest generates a "aws/request.Request" representing the
// client's request for the ContinueUpdateRollback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ContinueUpdateRollback for more information on using the ContinueUpdateRollback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ContinueUpdateRollbackRequest method.
//	req, resp := client.ContinueUpdateRollbackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback
func (c *CloudFormation) ContinueUpdateRollbackRequest(input *ContinueUpdateRollbackInput) (req *request.Request, output *ContinueUpdateRollbackOutput) {
	op := &request.Operation{
		Name:       opContinueUpdateRollback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ContinueUpdateRollbackInput{}
	}

	output = &ContinueUpdateRollbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ContinueUpdateRollback API operation for AWS CloudFormation.
//
// For a specified stack that's in the UPDATE_ROLLBACK_FAILED state, continues
// rolling it back to the UPDATE_ROLLBACK_COMPLETE state. Depending on the cause
// of the failure, you can manually fix the error (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
// and continue the rollback. By continuing the rollback, you can return your
// stack to a working state (the UPDATE_ROLLBACK_COMPLETE state), and then try
// to update the stack again.
//
// A stack goes into the UPDATE_ROLLBACK_FAILED state when CloudFormation can't
// roll back all changes after a failed stack update. For example, you might
// have a stack that's rolling back to an old database instance that was deleted
// outside of CloudFormation. Because CloudFormation doesn't know the database
// was deleted, it assumes that the database instance still exists and attempts
// to roll back to it, causing the update rollback to fail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ContinueUpdateRollback for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//     A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback
func (c *CloudFormation) ContinueUpdateRollback(input *ContinueUpdateRollbackInput) (*ContinueUpdateRollbackOutput, error) {
	req, out := c.ContinueUpdateRollbackRequest(input)
	return out, req.Send()
}

// ContinueUpdateRollbackWithContext is the same as ContinueUpdateRollback with the addition of
// the ability to pass a context and additional request options.
//
// See ContinueUpdateRollback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ContinueUpdateRollbackWithContext(ctx aws.Context, input *ContinueUpdateRollbackInput, opts ...request.Option) (*ContinueUpdateRollbackOutput, error) {
	req, out := c.ContinueUpdateRollbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChangeSet = "CreateChangeSet"

// CreateChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChangeSet for more information on using the CreateChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChangeSetRequest method.
//	req, resp := client.CreateChangeSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet
func (c *CloudFormation) CreateChangeSetRequest(input *CreateChangeSetInput) (req *request.Request, output *CreateChangeSetOutput) {
	op := &request.Operation{
		Name:       opCreateChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateChangeSetInput{}
	}

	output = &CreateChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChangeSet API operation for AWS CloudFormation.
//
// Creates a list of changes that will be applied to a stack so that you can
// review the changes before executing them. You can create a change set for
// a stack that doesn't exist or an existing stack. If you create a change set
// for a stack that doesn't exist, the change set shows all of the resources
// that CloudFormation will create. If you create a change set for an existing
// stack, CloudFormation compares the stack's information with the information
// that you submit in the change set and lists the differences. Use change sets
// to understand which resources CloudFormation will create or change, and how
// it will change resources in an existing stack, before you create or update
// a stack.
//
// To create a change set for a stack that doesn't exist, for the ChangeSetType
// parameter, specify CREATE. To create a change set for an existing stack,
// specify UPDATE for the ChangeSetType parameter. To create a change set for
// an import operation, specify IMPORT for the ChangeSetType parameter. After
// the CreateChangeSet call successfully completes, CloudFormation starts creating
// the change set. To check the status of the change set or to review it, use
// the DescribeChangeSet action.
//
// When you are satisfied with the changes the change set will make, execute
// the change set by using the ExecuteChangeSet action. CloudFormation doesn't
// make changes until you execute the change set.
//
// To create a change set for the entire stack hierarchy, set IncludeNestedStacks
// to True.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateChangeSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeAlreadyExistsException "AlreadyExistsException"
//     The resource with the name requested already exists.
//
//   - ErrCodeInsufficientCapabilitiesException "InsufficientCapabilitiesException"
//     The template contains resources with capabilities that weren't specified
//     in the Capabilities parameter.
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The quota for the resource has already been reached.
//
//     For information about resource and stack limitations, see CloudFormation
//     quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//     in the CloudFormation User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet
func (c *CloudFormation) CreateChangeSet(input *CreateChangeSetInput) (*CreateChangeSetOutput, error) {
	req, out := c.CreateChangeSetRequest(input)
	return out, req.Send()
}

// CreateChangeSetWithContext is the same as CreateChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateChangeSetWithContext(ctx aws.Context, input *CreateChangeSetInput, opts ...request.Option) (*CreateChangeSetOutput, error) {
	req, out := c.CreateChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGeneratedTemplate = "CreateGeneratedTemplate"

// CreateGeneratedTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateGeneratedTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGeneratedTemplate for more information on using the CreateGeneratedTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGeneratedTemplateRequest method.
//	req, resp := client.CreateGeneratedTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateGeneratedTemplate
func (c *CloudFormation) CreateGeneratedTemplateRequest(input *CreateGeneratedTemplateInput) (req *request.Request, output *CreateGeneratedTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateGeneratedTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGeneratedTemplateInput{}
	}

	output = &CreateGeneratedTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGeneratedTemplate API operation for AWS CloudFormation.
//
// Creates a template from existing resources that are not already managed with
// CloudFormation. You can check the status of the template generation using
// the DescribeGeneratedTemplate API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateGeneratedTemplate for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeAlreadyExistsException "AlreadyExistsException"
//     The resource with the name requested already exists.
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The quota for the resource has already been reached.
//
//     For information about resource and stack limitations, see CloudFormation
//     quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//     in the CloudFormation User Guide.
//
//   - ErrCodeConcurrentResourcesLimitExceededException "ConcurrentResourcesLimitExceeded"
//     No more than 5 generated templates can be in an InProgress or Pending status
//     at one time. This error is also returned if a generated template that is
//     in an InProgress or Pending status is attempted to be updated or deleted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateGeneratedTemplate
func (c *CloudFormation) CreateGeneratedTemplate(input *CreateGeneratedTemplateInput) (*CreateGeneratedTemplateOutput, error) {
	req, out := c.CreateGeneratedTemplateRequest(input)
	return out, req.Send()
}

// CreateGeneratedTemplateWithContext is the same as CreateGeneratedTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGeneratedTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateGeneratedTemplateWithContext(ctx aws.Context, input *CreateGeneratedTemplateInput, opts ...request.Option) (*CreateGeneratedTemplateOutput, error) {
	req, out := c.CreateGeneratedTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a "aws/request.Request" representing the
// client's request for the CreateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStack for more information on using the CreateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStackRequest method.
//	req, resp := client.CreateStackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack
func (c *CloudFormation) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	output = &CreateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStack API operation for AWS CloudFormation.
//
// Creates a stack as specified in the template. After the call completes successfully,
// the stack creation starts. You can check the status of the stack through
// the DescribeStacks operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateStack for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The quota for the resource has already been reached.
//
//     For information about resource and stack limitations, see CloudFormation
//     quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//     in the CloudFormation User Guide.
//
//   - ErrCodeAlreadyExistsException "AlreadyExistsException"
//     The resource with the name requested already exists.
//
//   - ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//     A client request token already exists.
//
//   - ErrCodeInsufficientCapabilitiesException "InsufficientCapabilitiesException"
//     The template contains resources with capabilities that weren't specified
//     in the Capabilities parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack
func (c *CloudFormation) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	return out, req.Send()
}

// CreateStackWithContext is the same as CreateStack with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateStackWithContext(ctx aws.Context, input *CreateStackInput, opts ...request.Option) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStackInstances = "CreateStackInstances"

// CreateStackInstancesRequest generates a "aws/request.Request" representing the
// client's request for the CreateStackInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStackInstances for more information on using the CreateStackInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStackInstancesRequest method.
//	req, resp := client.CreateStackInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances
func (c *CloudFormation) CreateStackInstancesRequest(input *CreateStackInstancesInput) (req *request.Request, output *CreateStackInstancesOutput) {
	op := &request.Operation{
		Name:       opCreateStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInstancesInput{}
	}

	output = &CreateStackInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStackInstances API operation for AWS CloudFormation.
//
// Creates stack instances for the specified accounts, within the specified
// Amazon Web Services Regions. A stack instance refers to a stack in a specific
// account and Region. You must specify at least one value for either Accounts
// or DeploymentTargets, and you must specify at least one value for Regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateStackInstances for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeOperationInProgressException "OperationInProgressException"
//     Another operation is currently in progress for this stack set. Only one operation
//     can be performed for a stack set at a given time.
//
//   - ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//     The specified operation ID already exists.
//
//   - ErrCodeStaleRequestException "StaleRequestException"
//     Another operation has been performed on this stack set since the specified
//     operation was performed.
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The quota for the resource has already been reached.
//
//     For information about resource and stack limitations, see CloudFormation
//     quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//     in the CloudFormation User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances
func (c *CloudFormation) CreateStackInstances(input *CreateStackInstancesInput) (*CreateStackInstancesOutput, error) {
	req, out := c.CreateStackInstancesRequest(input)
	return out, req.Send()
}

// CreateStackInstancesWithContext is the same as CreateStackInstances with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStackInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateStackInstancesWithContext(ctx aws.Context, input *CreateStackInstancesInput, opts ...request.Option) (*CreateStackInstancesOutput, error) {
	req, out := c.CreateStackInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStackSet = "CreateStackSet"

// CreateStackSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStackSet for more information on using the CreateStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStackSetRequest method.
//	req, resp := client.CreateStackSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet
func (c *CloudFormation) CreateStackSetRequest(input *CreateStackSetInput) (req *request.Request, output *CreateStackSetOutput) {
	op := &request.Operation{
		Name:       opCreateStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackSetInput{}
	}

	output = &CreateStackSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStackSet API operation for AWS CloudFormation.
//
// Creates a stack set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateStackSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeNameAlreadyExistsException "NameAlreadyExistsException"
//     The specified name is already in use.
//
//   - ErrCodeCreatedButModifiedException "CreatedButModifiedException"
//     The specified resource exists, but has been changed.
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The quota for the resource has already been reached.
//
//     For information about resource and stack limitations, see CloudFormation
//     quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//     in the CloudFormation User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet
func (c *CloudFormation) CreateStackSet(input *CreateStackSetInput) (*CreateStackSetOutput, error) {
	req, out := c.CreateStackSetRequest(input)
	return out, req.Send()
}

// CreateStackSetWithContext is the same as CreateStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) CreateStackSetWithContext(ctx aws.Context, input *CreateStackSetInput, opts ...request.Option) (*CreateStackSetOutput, error) {
	req, out := c.CreateStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateOrganizationsAccess = "DeactivateOrganizationsAccess"

// DeactivateOrganizationsAccessRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateOrganizationsAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateOrganizationsAccess for more information on using the DeactivateOrganizationsAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeactivateOrganizationsAccessRequest method.
//	req, resp := client.DeactivateOrganizationsAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateOrganizationsAccess
func (c *CloudFormation) DeactivateOrganizationsAccessRequest(input *DeactivateOrganizationsAccessInput) (req *request.Request, output *DeactivateOrganizationsAccessOutput) {
	op := &request.Operation{
		Name:       opDeactivateOrganizationsAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivateOrganizationsAccessInput{}
	}

	output = &DeactivateOrganizationsAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeactivateOrganizationsAccess API operation for AWS CloudFormation.
//
// Deactivates trusted access with Organizations. If trusted access is deactivated,
// the management account does not have permissions to create and manage service-managed
// StackSets for your organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeactivateOrganizationsAccess for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
//   - ErrCodeOperationNotFoundException "OperationNotFoundException"
//     The specified ID refers to an operation that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateOrganizationsAccess
func (c *CloudFormation) DeactivateOrganizationsAccess(input *DeactivateOrganizationsAccessInput) (*DeactivateOrganizationsAccessOutput, error) {
	req, out := c.DeactivateOrganizationsAccessRequest(input)
	return out, req.Send()
}

// DeactivateOrganizationsAccessWithContext is the same as DeactivateOrganizationsAccess with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateOrganizationsAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeactivateOrganizationsAccessWithContext(ctx aws.Context, input *DeactivateOrganizationsAccessInput, opts ...request.Option) (*DeactivateOrganizationsAccessOutput, error) {
	req, out := c.DeactivateOrganizationsAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateType = "DeactivateType"

// DeactivateTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateType for more information on using the DeactivateType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeactivateTypeRequest method.
//	req, resp := client.DeactivateTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateType
func (c *CloudFormation) DeactivateTypeRequest(input *DeactivateTypeInput) (req *request.Request, output *DeactivateTypeOutput) {
	op := &request.Operation{
		Name:       opDeactivateType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivateTypeInput{}
	}

	output = &DeactivateTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeactivateType API operation for AWS CloudFormation.
//
// Deactivates a public extension that was previously activated in this account
// and Region.
//
// Once deactivated, an extension can't be used in any CloudFormation operation.
// This includes stack update operations where the stack template includes the
// extension, even if no updates are being made to the extension. In addition,
// deactivated extensions aren't automatically updated if a new version of the
// extension is released.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeactivateType for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
//   - ErrCodeTypeNotFoundException "TypeNotFoundException"
//     The specified extension doesn't exist in the CloudFormation registry.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateType
func (c *CloudFormation) DeactivateType(input *DeactivateTypeInput) (*DeactivateTypeOutput, error) {
	req, out := c.DeactivateTypeRequest(input)
	return out, req.Send()
}

// DeactivateTypeWithContext is the same as DeactivateType with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeactivateTypeWithContext(ctx aws.Context, input *DeactivateTypeInput, opts ...request.Option) (*DeactivateTypeOutput, error) {
	req, out := c.DeactivateTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChangeSet = "DeleteChangeSet"

// DeleteChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChangeSet for more information on using the DeleteChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChangeSetRequest method.
//	req, resp := client.DeleteChangeSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet
func (c *CloudFormation) DeleteChangeSetRequest(input *DeleteChangeSetInput) (req *request.Request, output *DeleteChangeSetOutput) {
	op := &request.Operation{
		Name:       opDeleteChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChangeSetInput{}
	}

	output = &DeleteChangeSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChangeSet API operation for AWS CloudFormation.
//
// Deletes the specified change set. Deleting change sets ensures that no one
// executes the wrong change set.
//
// If the call successfully completes, CloudFormation successfully deleted the
// change set.
//
// If IncludeNestedStacks specifies True during the creation of the nested change
// set, then DeleteChangeSet will delete all change sets that belong to the
// stacks hierarchy and will also delete all change sets for nested stacks with
// the status of REVIEW_IN_PROGRESS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteChangeSet for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeInvalidChangeSetStatusException "InvalidChangeSetStatus"
//     The specified change set can't be used to update the stack. For example,
//     the change set status might be CREATE_IN_PROGRESS, or the stack status might
//     be UPDATE_IN_PROGRESS.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet
func (c *CloudFormation) DeleteChangeSet(input *DeleteChangeSetInput) (*DeleteChangeSetOutput, error) {
	req, out := c.DeleteChangeSetRequest(input)
	return out, req.Send()
}

// DeleteChangeSetWithContext is the same as DeleteChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteChangeSetWithContext(ctx aws.Context, input *DeleteChangeSetInput, opts ...request.Option) (*DeleteChangeSetOutput, error) {
	req, out := c.DeleteChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGeneratedTemplate = "DeleteGeneratedTemplate"

// DeleteGeneratedTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGeneratedTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGeneratedTemplate for more information on using the DeleteGeneratedTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGeneratedTemplateRequest method.
//	req, resp := client.DeleteGeneratedTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteGeneratedTemplate
func (c *CloudFormation) DeleteGeneratedTemplateRequest(input *DeleteGeneratedTemplateInput) (req *request.Request, output *DeleteGeneratedTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteGeneratedTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGeneratedTemplateInput{}
	}

	output = &DeleteGeneratedTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGeneratedTemplate API operation for AWS CloudFormation.
//
// Deleted a generated template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteGeneratedTemplate for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeGeneratedTemplateNotFoundException "GeneratedTemplateNotFound"
//     The generated template was not found.
//
//   - ErrCodeConcurrentResourcesLimitExceededException "ConcurrentResourcesLimitExceeded"
//     No more than 5 generated templates can be in an InProgress or Pending status
//     at one time. This error is also returned if a generated template that is
//     in an InProgress or Pending status is attempted to be updated or deleted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteGeneratedTemplate
func (c *CloudFormation) DeleteGeneratedTemplate(input *DeleteGeneratedTemplateInput) (*DeleteGeneratedTemplateOutput, error) {
	req, out := c.DeleteGeneratedTemplateRequest(input)
	return out, req.Send()
}

// DeleteGeneratedTemplateWithContext is the same as DeleteGeneratedTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGeneratedTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteGeneratedTemplateWithContext(ctx aws.Context, input *DeleteGeneratedTemplateInput, opts ...request.Option) (*DeleteGeneratedTemplateOutput, error) {
	req, out := c.DeleteGeneratedTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStack for more information on using the DeleteStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStackRequest method.
//	req, resp := client.DeleteStackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack
func (c *CloudFormation) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	output = &DeleteStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStack API operation for AWS CloudFormation.
//
// Deletes a specified stack. Once the call completes successfully, stack deletion
// starts. Deleted stacks don't show up in the DescribeStacks operation if the
// deletion has been completed successfully.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteStack for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//     A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack
func (c *CloudFormation) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	return out, req.Send()
}

// DeleteStackWithContext is the same as DeleteStack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteStackWithContext(ctx aws.Context, input *DeleteStackInput, opts ...request.Option) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStackInstances = "DeleteStackInstances"

// DeleteStackInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStackInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStackInstances for more information on using the DeleteStackInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStackInstancesRequest method.
//	req, resp := client.DeleteStackInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances
func (c *CloudFormation) DeleteStackInstancesRequest(input *DeleteStackInstancesInput) (req *request.Request, output *DeleteStackInstancesOutput) {
	op := &request.Operation{
		Name:       opDeleteStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInstancesInput{}
	}

	output = &DeleteStackInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStackInstances API operation for AWS CloudFormation.
//
// Deletes stack instances for the specified accounts, in the specified Amazon
// Web Services Regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteStackInstances for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeOperationInProgressException "OperationInProgressException"
//     Another operation is currently in progress for this stack set. Only one operation
//     can be performed for a stack set at a given time.
//
//   - ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//     The specified operation ID already exists.
//
//   - ErrCodeStaleRequestException "StaleRequestException"
//     Another operation has been performed on this stack set since the specified
//     operation was performed.
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances
func (c *CloudFormation) DeleteStackInstances(input *DeleteStackInstancesInput) (*DeleteStackInstancesOutput, error) {
	req, out := c.DeleteStackInstancesRequest(input)
	return out, req.Send()
}

// DeleteStackInstancesWithContext is the same as DeleteStackInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStackInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteStackInstancesWithContext(ctx aws.Context, input *DeleteStackInstancesInput, opts ...request.Option) (*DeleteStackInstancesOutput, error) {
	req, out := c.DeleteStackInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStackSet = "DeleteStackSet"

// DeleteStackSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStackSet for more information on using the DeleteStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStackSetRequest method.
//	req, resp := client.DeleteStackSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet
func (c *CloudFormation) DeleteStackSetRequest(input *DeleteStackSetInput) (req *request.Request, output *DeleteStackSetOutput) {
	op := &request.Operation{
		Name:       opDeleteStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackSetInput{}
	}

	output = &DeleteStackSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStackSet API operation for AWS CloudFormation.
//
// Deletes a stack set. Before you can delete a stack set, all its member stack
// instances must be deleted. For more information about how to complete this,
// see DeleteStackInstances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteStackSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotEmptyException "StackSetNotEmptyException"
//     You can't yet delete this stack set, because it still contains one or more
//     stack instances. Delete all stack instances from the stack set before deleting
//     the stack set.
//
//   - ErrCodeOperationInProgressException "OperationInProgressException"
//     Another operation is currently in progress for this stack set. Only one operation
//     can be performed for a stack set at a given time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet
func (c *CloudFormation) DeleteStackSet(input *DeleteStackSetInput) (*DeleteStackSetOutput, error) {
	req, out := c.DeleteStackSetRequest(input)
	return out, req.Send()
}

// DeleteStackSetWithContext is the same as DeleteStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeleteStackSetWithContext(ctx aws.Context, input *DeleteStackSetInput, opts ...request.Option) (*DeleteStackSetOutput, error) {
	req, out := c.DeleteStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterType = "DeregisterType"

// DeregisterTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterType for more information on using the DeregisterType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterTypeRequest method.
//	req, resp := client.DeregisterTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType
func (c *CloudFormation) DeregisterTypeRequest(input *DeregisterTypeInput) (req *request.Request, output *DeregisterTypeOutput) {
	op := &request.Operation{
		Name:       opDeregisterType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTypeInput{}
	}

	output = &DeregisterTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterType API operation for AWS CloudFormation.
//
// Marks an extension or extension version as DEPRECATED in the CloudFormation
// registry, removing it from active use. Deprecated extensions or extension
// versions cannot be used in CloudFormation operations.
//
// To deregister an entire extension, you must individually deregister all active
// versions of that extension. If an extension has only a single active version,
// deregistering that version results in the extension itself being deregistered
// and marked as deprecated in the registry.
//
// You can't deregister the default version of an extension if there are other
// active version of that extension. If you do deregister the default version
// of an extension, the extension type itself is deregistered as well and marked
// as deprecated.
//
// To view the deprecation status of an extension or extension version, use
// DescribeType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeregisterType for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
//   - ErrCodeTypeNotFoundException "TypeNotFoundException"
//     The specified extension doesn't exist in the CloudFormation registry.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType
func (c *CloudFormation) DeregisterType(input *DeregisterTypeInput) (*DeregisterTypeOutput, error) {
	req, out := c.DeregisterTypeRequest(input)
	return out, req.Send()
}

// DeregisterTypeWithContext is the same as DeregisterType with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DeregisterTypeWithContext(ctx aws.Context, input *DeregisterTypeInput, opts ...request.Option) (*DeregisterTypeOutput, error) {
	req, out := c.DeregisterTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountLimits for more information on using the DescribeAccountLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountLimitsRequest method.
//	req, resp := client.DescribeAccountLimitsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits
func (c *CloudFormation) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *request.Request, output *DescribeAccountLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	output = &DescribeAccountLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountLimits API operation for AWS CloudFormation.
//
// Retrieves your account's CloudFormation limits, such as the maximum number
// of stacks that you can create in your account. For more information about
// account limits, see CloudFormation Quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
// in the CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeAccountLimits for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits
func (c *CloudFormation) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	return out, req.Send()
}

// DescribeAccountLimitsWithContext is the same as DescribeAccountLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeAccountLimitsWithContext(ctx aws.Context, input *DescribeAccountLimitsInput, opts ...request.Option) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAccountLimitsPages iterates over the pages of a DescribeAccountLimits operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAccountLimits method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAccountLimits operation.
//	pageNum := 0
//	err := client.DescribeAccountLimitsPages(params,
//	    func(page *cloudformation.DescribeAccountLimitsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) DescribeAccountLimitsPages(input *DescribeAccountLimitsInput, fn func(*DescribeAccountLimitsOutput, bool) bool) error {
	return c.DescribeAccountLimitsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAccountLimitsPagesWithContext same as DescribeAccountLimitsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeAccountLimitsPagesWithContext(ctx aws.Context, input *DescribeAccountLimitsInput, fn func(*DescribeAccountLimitsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAccountLimitsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAccountLimitsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAccountLimitsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeChangeSet = "DescribeChangeSet"

// DescribeChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChangeSet for more information on using the DescribeChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChangeSetRequest method.
//	req, resp := client.DescribeChangeSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet
func (c *CloudFormation) DescribeChangeSetRequest(input *DescribeChangeSetInput) (req *request.Request, output *DescribeChangeSetOutput) {
	op := &request.Operation{
		Name:       opDescribeChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChangeSetInput{}
	}

	output = &DescribeChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChangeSet API operation for AWS CloudFormation.
//
// Returns the inputs for the change set and a list of changes that CloudFormation
// will make if you execute the change set. For more information, see Updating
// Stacks Using Change Sets (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html)
// in the CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeChangeSet for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeChangeSetNotFoundException "ChangeSetNotFound"
//     The specified change set name or ID doesn't exit. To view valid change sets
//     for a stack, use the ListChangeSets operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet
func (c *CloudFormation) DescribeChangeSet(input *DescribeChangeSetInput) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	return out, req.Send()
}

// DescribeChangeSetWithContext is the same as DescribeChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeChangeSetWithContext(ctx aws.Context, input *DescribeChangeSetInput, opts ...request.Option) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChangeSetHooks = "DescribeChangeSetHooks"

// DescribeChangeSetHooksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChangeSetHooks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChangeSetHooks for more information on using the DescribeChangeSetHooks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChangeSetHooksRequest method.
//	req, resp := client.DescribeChangeSetHooksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetHooks
func (c *CloudFormation) DescribeChangeSetHooksRequest(input *DescribeChangeSetHooksInput) (req *request.Request, output *DescribeChangeSetHooksOutput) {
	op := &request.Operation{
		Name:       opDescribeChangeSetHooks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChangeSetHooksInput{}
	}

	output = &DescribeChangeSetHooksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChangeSetHooks API operation for AWS CloudFormation.
//
// Returns hook-related information for the change set and a list of changes
// that CloudFormation makes when you run the change set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeChangeSetHooks for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeChangeSetNotFoundException "ChangeSetNotFound"
//     The specified change set name or ID doesn't exit. To view valid change sets
//     for a stack, use the ListChangeSets operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetHooks
func (c *CloudFormation) DescribeChangeSetHooks(input *DescribeChangeSetHooksInput) (*DescribeChangeSetHooksOutput, error) {
	req, out := c.DescribeChangeSetHooksRequest(input)
	return out, req.Send()
}

// DescribeChangeSetHooksWithContext is the same as DescribeChangeSetHooks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChangeSetHooks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeChangeSetHooksWithContext(ctx aws.Context, input *DescribeChangeSetHooksInput, opts ...request.Option) (*DescribeChangeSetHooksOutput, error) {
	req, out := c.DescribeChangeSetHooksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGeneratedTemplate = "DescribeGeneratedTemplate"

// DescribeGeneratedTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGeneratedTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGeneratedTemplate for more information on using the DescribeGeneratedTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGeneratedTemplateRequest method.
//	req, resp := client.DescribeGeneratedTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeGeneratedTemplate
func (c *CloudFormation) DescribeGeneratedTemplateRequest(input *DescribeGeneratedTemplateInput) (req *request.Request, output *DescribeGeneratedTemplateOutput) {
	op := &request.Operation{
		Name:       opDescribeGeneratedTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGeneratedTemplateInput{}
	}

	output = &DescribeGeneratedTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGeneratedTemplate API operation for AWS CloudFormation.
//
// Describes a generated template. The output includes details about the progress
// of the creation of a generated template started by a CreateGeneratedTemplate
// API action or the update of a generated template started with an UpdateGeneratedTemplate
// API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeGeneratedTemplate for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeGeneratedTemplateNotFoundException "GeneratedTemplateNotFound"
//     The generated template was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeGeneratedTemplate
func (c *CloudFormation) DescribeGeneratedTemplate(input *DescribeGeneratedTemplateInput) (*DescribeGeneratedTemplateOutput, error) {
	req, out := c.DescribeGeneratedTemplateRequest(input)
	return out, req.Send()
}

// DescribeGeneratedTemplateWithContext is the same as DescribeGeneratedTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGeneratedTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeGeneratedTemplateWithContext(ctx aws.Context, input *DescribeGeneratedTemplateInput, opts ...request.Option) (*DescribeGeneratedTemplateOutput, error) {
	req, out := c.DescribeGeneratedTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationsAccess = "DescribeOrganizationsAccess"

// DescribeOrganizationsAccessRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationsAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationsAccess for more information on using the DescribeOrganizationsAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOrganizationsAccessRequest method.
//	req, resp := client.DescribeOrganizationsAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeOrganizationsAccess
func (c *CloudFormation) DescribeOrganizationsAccessRequest(input *DescribeOrganizationsAccessInput) (req *request.Request, output *DescribeOrganizationsAccessOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationsAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationsAccessInput{}
	}

	output = &DescribeOrganizationsAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationsAccess API operation for AWS CloudFormation.
//
// Retrieves information about the account's OrganizationAccess status. This
// API can be called either by the management account or the delegated administrator
// by using the CallAs parameter. This API can also be called without the CallAs
// parameter by the management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeOrganizationsAccess for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
//   - ErrCodeOperationNotFoundException "OperationNotFoundException"
//     The specified ID refers to an operation that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeOrganizationsAccess
func (c *CloudFormation) DescribeOrganizationsAccess(input *DescribeOrganizationsAccessInput) (*DescribeOrganizationsAccessOutput, error) {
	req, out := c.DescribeOrganizationsAccessRequest(input)
	return out, req.Send()
}

// DescribeOrganizationsAccessWithContext is the same as DescribeOrganizationsAccess with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationsAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeOrganizationsAccessWithContext(ctx aws.Context, input *DescribeOrganizationsAccessInput, opts ...request.Option) (*DescribeOrganizationsAccessOutput, error) {
	req, out := c.DescribeOrganizationsAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePublisher = "DescribePublisher"

// DescribePublisherRequest generates a "aws/request.Request" representing the
// client's request for the DescribePublisher operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePublisher for more information on using the DescribePublisher
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePublisherRequest method.
//	req, resp := client.DescribePublisherRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribePublisher
func (c *CloudFormation) DescribePublisherRequest(input *DescribePublisherInput) (req *request.Request, output *DescribePublisherOutput) {
	op := &request.Operation{
		Name:       opDescribePublisher,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePublisherInput{}
	}

	output = &DescribePublisherOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePublisher API operation for AWS CloudFormation.
//
// Returns information about a CloudFormation extension publisher.
//
// If you don't supply a PublisherId, and you have registered as an extension
// publisher, DescribePublisher returns information about your own publisher
// account.
//
// For more information about registering as a publisher, see:
//
//   - RegisterPublisher (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html)
//
//   - Publishing extensions to make them available for public use (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html)
//     in the CloudFormation CLI User Guide
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribePublisher for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribePublisher
func (c *CloudFormation) DescribePublisher(input *DescribePublisherInput) (*DescribePublisherOutput, error) {
	req, out := c.DescribePublisherRequest(input)
	return out, req.Send()
}

// DescribePublisherWithContext is the same as DescribePublisher with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePublisher for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribePublisherWithContext(ctx aws.Context, input *DescribePublisherInput, opts ...request.Option) (*DescribePublisherOutput, error) {
	req, out := c.DescribePublisherRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourceScan = "DescribeResourceScan"

// DescribeResourceScanRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourceScan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourceScan for more information on using the DescribeResourceScan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeResourceScanRequest method.
//	req, resp := client.DescribeResourceScanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeResourceScan
func (c *CloudFormation) DescribeResourceScanRequest(input *DescribeResourceScanInput) (req *request.Request, output *DescribeResourceScanOutput) {
	op := &request.Operation{
		Name:       opDescribeResourceScan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceScanInput{}
	}

	output = &DescribeResourceScanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourceScan API operation for AWS CloudFormation.
//
// Describes details of a resource scan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeResourceScan for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeResourceScanNotFoundException "ResourceScanNotFound"
//     The resource scan was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeResourceScan
func (c *CloudFormation) DescribeResourceScan(input *DescribeResourceScanInput) (*DescribeResourceScanOutput, error) {
	req, out := c.DescribeResourceScanRequest(input)
	return out, req.Send()
}

// DescribeResourceScanWithContext is the same as DescribeResourceScan with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourceScan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeResourceScanWithContext(ctx aws.Context, input *DescribeResourceScanInput, opts ...request.Option) (*DescribeResourceScanOutput, error) {
	req, out := c.DescribeResourceScanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackDriftDetectionStatus = "DescribeStackDriftDetectionStatus"

// DescribeStackDriftDetectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackDriftDetectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackDriftDetectionStatus for more information on using the DescribeStackDriftDetectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStackDriftDetectionStatusRequest method.
//	req, resp := client.DescribeStackDriftDetectionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus
func (c *CloudFormation) DescribeStackDriftDetectionStatusRequest(input *DescribeStackDriftDetectionStatusInput) (req *request.Request, output *DescribeStackDriftDetectionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeStackDriftDetectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackDriftDetectionStatusInput{}
	}

	output = &DescribeStackDriftDetectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackDriftDetectionStatus API operation for AWS CloudFormation.
//
// Returns information about a stack drift detection operation. A stack drift
// detection operation detects whether a stack's actual configuration differs,
// or has drifted, from its expected configuration, as defined in the stack
// template and any values specified as template parameters. A stack is considered
// to have drifted if one or more of its resources have drifted. For more information
// about stack and resource drift, see Detecting Unregulated Configuration Changes
// to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Use DetectStackDrift to initiate a stack drift detection operation. DetectStackDrift
// returns a StackDriftDetectionId you can use to monitor the progress of the
// operation using DescribeStackDriftDetectionStatus. Once the drift detection
// operation has completed, use DescribeStackResourceDrifts to return drift
// information about the stack and its resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackDriftDetectionStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus
func (c *CloudFormation) DescribeStackDriftDetectionStatus(input *DescribeStackDriftDetectionStatusInput) (*DescribeStackDriftDetectionStatusOutput, error) {
	req, out := c.DescribeStackDriftDetectionStatusRequest(input)
	return out, req.Send()
}

// DescribeStackDriftDetectionStatusWithContext is the same as DescribeStackDriftDetectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackDriftDetectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackDriftDetectionStatusWithContext(ctx aws.Context, input *DescribeStackDriftDetectionStatusInput, opts ...request.Option) (*DescribeStackDriftDetectionStatusOutput, error) {
	req, out := c.DescribeStackDriftDetectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackEvents = "DescribeStackEvents"

// DescribeStackEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackEvents for more information on using the DescribeStackEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStackEventsRequest method.
//	req, resp := client.DescribeStackEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents
func (c *CloudFormation) DescribeStackEventsRequest(input *DescribeStackEventsInput) (req *request.Request, output *DescribeStackEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeStackEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackEventsInput{}
	}

	output = &DescribeStackEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackEvents API operation for AWS CloudFormation.
//
// Returns all stack related events for a specified stack in reverse chronological
// order. For more information about a stack's event history, see CloudFormation
// stack creation events (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html)
// in the CloudFormation User Guide.
//
// You can list events for stacks that have failed to create or have been deleted
// by specifying the unique stack identifier (stack ID).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents
func (c *CloudFormation) DescribeStackEvents(input *DescribeStackEventsInput) (*DescribeStackEventsOutput, error) {
	req, out := c.DescribeStackEventsRequest(input)
	return out, req.Send()
}

// DescribeStackEventsWithContext is the same as DescribeStackEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackEventsWithContext(ctx aws.Context, input *DescribeStackEventsInput, opts ...request.Option) (*DescribeStackEventsOutput, error) {
	req, out := c.DescribeStackEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStackEventsPages iterates over the pages of a DescribeStackEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStackEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeStackEvents operation.
//	pageNum := 0
//	err := client.DescribeStackEventsPages(params,
//	    func(page *cloudformation.DescribeStackEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) DescribeStackEventsPages(input *DescribeStackEventsInput, fn func(*DescribeStackEventsOutput, bool) bool) error {
	return c.DescribeStackEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStackEventsPagesWithContext same as DescribeStackEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackEventsPagesWithContext(ctx aws.Context, input *DescribeStackEventsInput, fn func(*DescribeStackEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStackEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStackEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStackEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStackInstance = "DescribeStackInstance"

// DescribeStackInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackInstance for more information on using the DescribeStackInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStackInstanceRequest method.
//	req, resp := client.DescribeStackInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance
func (c *CloudFormation) DescribeStackInstanceRequest(input *DescribeStackInstanceInput) (req *request.Request, output *DescribeStackInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeStackInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackInstanceInput{}
	}

	output = &DescribeStackInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackInstance API operation for AWS CloudFormation.
//
// Returns the stack instance that's associated with the specified StackSet,
// Amazon Web Services account, and Amazon Web Services Region.
//
// For a list of stack instances that are associated with a specific StackSet,
// use ListStackInstances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackInstance for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeStackInstanceNotFoundException "StackInstanceNotFoundException"
//     The specified stack instance doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance
func (c *CloudFormation) DescribeStackInstance(input *DescribeStackInstanceInput) (*DescribeStackInstanceOutput, error) {
	req, out := c.DescribeStackInstanceRequest(input)
	return out, req.Send()
}

// DescribeStackInstanceWithContext is the same as DescribeStackInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackInstanceWithContext(ctx aws.Context, input *DescribeStackInstanceInput, opts ...request.Option) (*DescribeStackInstanceOutput, error) {
	req, out := c.DescribeStackInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackResource = "DescribeStackResource"

// DescribeStackResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackResource for more information on using the DescribeStackResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStackResourceRequest method.
//	req, resp := client.DescribeStackResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource
func (c *CloudFormation) DescribeStackResourceRequest(input *DescribeStackResourceInput) (req *request.Request, output *DescribeStackResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourceInput{}
	}

	output = &DescribeStackResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackResource API operation for AWS CloudFormation.
//
// Returns a description of the specified resource in the specified stack.
//
// For deleted stacks, DescribeStackResource returns resource information for
// up to 90 days after the stack has been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource
func (c *CloudFormation) DescribeStackResource(input *DescribeStackResourceInput) (*DescribeStackResourceOutput, error) {
	req, out := c.DescribeStackResourceRequest(input)
	return out, req.Send()
}

// DescribeStackResourceWithContext is the same as DescribeStackResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackResourceWithContext(ctx aws.Context, input *DescribeStackResourceInput, opts ...request.Option) (*DescribeStackResourceOutput, error) {
	req, out := c.DescribeStackResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackResourceDrifts = "DescribeStackResourceDrifts"

// DescribeStackResourceDriftsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackResourceDrifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackResourceDrifts for more information on using the DescribeStackResourceDrifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStackResourceDriftsRequest method.
//	req, resp := client.DescribeStackResourceDriftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts
func (c *CloudFormation) DescribeStackResourceDriftsRequest(input *DescribeStackResourceDriftsInput) (req *request.Request, output *DescribeStackResourceDriftsOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResourceDrifts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackResourceDriftsInput{}
	}

	output = &DescribeStackResourceDriftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackResourceDrifts API operation for AWS CloudFormation.
//
// Returns drift information for the resources that have been checked for drift
// in the specified stack. This includes actual and expected configuration values
// for resources where CloudFormation detects configuration drift.
//
// For a given stack, there will be one StackResourceDrift for each stack resource
// that has been checked for drift. Resources that haven't yet been checked
// for drift aren't included. Resources that don't currently support drift detection
// aren't checked, and so not included. For a list of resources that support
// drift detection, see Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all supported resources for a given stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackResourceDrifts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts
func (c *CloudFormation) DescribeStackResourceDrifts(input *DescribeStackResourceDriftsInput) (*DescribeStackResourceDriftsOutput, error) {
	req, out := c.DescribeStackResourceDriftsRequest(input)
	return out, req.Send()
}

// DescribeStackResourceDriftsWithContext is the same as DescribeStackResourceDrifts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackResourceDrifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackResourceDriftsWithContext(ctx aws.Context, input *DescribeStackResourceDriftsInput, opts ...request.Option) (*DescribeStackResourceDriftsOutput, error) {
	req, out := c.DescribeStackResourceDriftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStackResourceDriftsPages iterates over the pages of a DescribeStackResourceDrifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStackResourceDrifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeStackResourceDrifts operation.
//	pageNum := 0
//	err := client.DescribeStackResourceDriftsPages(params,
//	    func(page *cloudformation.DescribeStackResourceDriftsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) DescribeStackResourceDriftsPages(input *DescribeStackResourceDriftsInput, fn func(*DescribeStackResourceDriftsOutput, bool) bool) error {
	return c.DescribeStackResourceDriftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStackResourceDriftsPagesWithContext same as DescribeStackResourceDriftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackResourceDriftsPagesWithContext(ctx aws.Context, input *DescribeStackResourceDriftsInput, fn func(*DescribeStackResourceDriftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStackResourceDriftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStackResourceDriftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStackResourceDriftsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStackResources = "DescribeStackResources"

// DescribeStackResourcesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackResources for more information on using the DescribeStackResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStackResourcesRequest method.
//	req, resp := client.DescribeStackResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources
func (c *CloudFormation) DescribeStackResourcesRequest(input *DescribeStackResourcesInput) (req *request.Request, output *DescribeStackResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourcesInput{}
	}

	output = &DescribeStackResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackResources API operation for AWS CloudFormation.
//
// Returns Amazon Web Services resource descriptions for running and deleted
// stacks. If StackName is specified, all the associated resources that are
// part of the stack are returned. If PhysicalResourceId is specified, the associated
// resources of the stack that the resource belongs to are returned.
//
// Only the first 100 resources will be returned. If your stack has more resources
// than this, you should use ListStackResources instead.
//
// For deleted stacks, DescribeStackResources returns resource information for
// up to 90 days after the stack has been deleted.
//
// You must specify either StackName or PhysicalResourceId, but not both. In
// addition, you can specify LogicalResourceId to filter the returned result.
// For more information about resources, the LogicalResourceId and PhysicalResourceId,
// go to the CloudFormation User Guide (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
//
// A ValidationError is returned if you specify both StackName and PhysicalResourceId
// in the same request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackResources for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources
func (c *CloudFormation) DescribeStackResources(input *DescribeStackResourcesInput) (*DescribeStackResourcesOutput, error) {
	req, out := c.DescribeStackResourcesRequest(input)
	return out, req.Send()
}

// DescribeStackResourcesWithContext is the same as DescribeStackResources with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackResourcesWithContext(ctx aws.Context, input *DescribeStackResourcesInput, opts ...request.Option) (*DescribeStackResourcesOutput, error) {
	req, out := c.DescribeStackResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackSet = "DescribeStackSet"

// DescribeStackSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackSet for more information on using the DescribeStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStackSetRequest method.
//	req, resp := client.DescribeStackSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet
func (c *CloudFormation) DescribeStackSetRequest(input *DescribeStackSetInput) (req *request.Request, output *DescribeStackSetOutput) {
	op := &request.Operation{
		Name:       opDescribeStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackSetInput{}
	}

	output = &DescribeStackSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackSet API operation for AWS CloudFormation.
//
// Returns the description of the specified StackSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackSet for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet
func (c *CloudFormation) DescribeStackSet(input *DescribeStackSetInput) (*DescribeStackSetOutput, error) {
	req, out := c.DescribeStackSetRequest(input)
	return out, req.Send()
}

// DescribeStackSetWithContext is the same as DescribeStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackSetWithContext(ctx aws.Context, input *DescribeStackSetInput, opts ...request.Option) (*DescribeStackSetOutput, error) {
	req, out := c.DescribeStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackSetOperation = "DescribeStackSetOperation"

// DescribeStackSetOperationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackSetOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackSetOperation for more information on using the DescribeStackSetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStackSetOperationRequest method.
//	req, resp := client.DescribeStackSetOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation
func (c *CloudFormation) DescribeStackSetOperationRequest(input *DescribeStackSetOperationInput) (req *request.Request, output *DescribeStackSetOperationOutput) {
	op := &request.Operation{
		Name:       opDescribeStackSetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackSetOperationInput{}
	}

	output = &DescribeStackSetOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackSetOperation API operation for AWS CloudFormation.
//
// Returns the description of the specified StackSet operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackSetOperation for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeOperationNotFoundException "OperationNotFoundException"
//     The specified ID refers to an operation that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation
func (c *CloudFormation) DescribeStackSetOperation(input *DescribeStackSetOperationInput) (*DescribeStackSetOperationOutput, error) {
	req, out := c.DescribeStackSetOperationRequest(input)
	return out, req.Send()
}

// DescribeStackSetOperationWithContext is the same as DescribeStackSetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackSetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStackSetOperationWithContext(ctx aws.Context, input *DescribeStackSetOperationInput, opts ...request.Option) (*DescribeStackSetOperationOutput, error) {
	req, out := c.DescribeStackSetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStacks for more information on using the DescribeStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStacksRequest method.
//	req, resp := client.DescribeStacksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks
func (c *CloudFormation) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	output = &DescribeStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStacks API operation for AWS CloudFormation.
//
// Returns the description for the specified stack; if no stack name was specified,
// then it returns the description for all the stacks created. For more information
// about a stack's event history, see CloudFormation stack creation events (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html)
// in the CloudFormation User Guide.
//
// If the stack doesn't exist, a ValidationError is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStacks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks
func (c *CloudFormation) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	return out, req.Send()
}

// DescribeStacksWithContext is the same as DescribeStacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStacksWithContext(ctx aws.Context, input *DescribeStacksInput, opts ...request.Option) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStacksPages iterates over the pages of a DescribeStacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeStacks operation.
//	pageNum := 0
//	err := client.DescribeStacksPages(params,
//	    func(page *cloudformation.DescribeStacksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) DescribeStacksPages(input *DescribeStacksInput, fn func(*DescribeStacksOutput, bool) bool) error {
	return c.DescribeStacksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStacksPagesWithContext same as DescribeStacksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeStacksPagesWithContext(ctx aws.Context, input *DescribeStacksInput, fn func(*DescribeStacksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStacksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStacksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStacksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeType = "DescribeType"

// DescribeTypeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeType for more information on using the DescribeType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTypeRequest method.
//	req, resp := client.DescribeTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType
func (c *CloudFormation) DescribeTypeRequest(input *DescribeTypeInput) (req *request.Request, output *DescribeTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTypeInput{}
	}

	output = &DescribeTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeType API operation for AWS CloudFormation.
//
// Returns detailed information about an extension that has been registered.
//
// If you specify a VersionId, DescribeType returns information about that specific
// extension version. Otherwise, it returns information about the default extension
// version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeType for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
//   - ErrCodeTypeNotFoundException "TypeNotFoundException"
//     The specified extension doesn't exist in the CloudFormation registry.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType
func (c *CloudFormation) DescribeType(input *DescribeTypeInput) (*DescribeTypeOutput, error) {
	req, out := c.DescribeTypeRequest(input)
	return out, req.Send()
}

// DescribeTypeWithContext is the same as DescribeType with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeTypeWithContext(ctx aws.Context, input *DescribeTypeInput, opts ...request.Option) (*DescribeTypeOutput, error) {
	req, out := c.DescribeTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTypeRegistration = "DescribeTypeRegistration"

// DescribeTypeRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTypeRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTypeRegistration for more information on using the DescribeTypeRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTypeRegistrationRequest method.
//	req, resp := client.DescribeTypeRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration
func (c *CloudFormation) DescribeTypeRegistrationRequest(input *DescribeTypeRegistrationInput) (req *request.Request, output *DescribeTypeRegistrationOutput) {
	op := &request.Operation{
		Name:       opDescribeTypeRegistration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTypeRegistrationInput{}
	}

	output = &DescribeTypeRegistrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTypeRegistration API operation for AWS CloudFormation.
//
// Returns information about an extension's registration, including its current
// status and type and version identifiers.
//
// When you initiate a registration request using RegisterType, you can then
// use DescribeTypeRegistration to monitor the progress of that registration
// request.
//
// Once the registration request has completed, use DescribeType to return detailed
// information about an extension.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeTypeRegistration for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration
func (c *CloudFormation) DescribeTypeRegistration(input *DescribeTypeRegistrationInput) (*DescribeTypeRegistrationOutput, error) {
	req, out := c.DescribeTypeRegistrationRequest(input)
	return out, req.Send()
}

// DescribeTypeRegistrationWithContext is the same as DescribeTypeRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTypeRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DescribeTypeRegistrationWithContext(ctx aws.Context, input *DescribeTypeRegistrationInput, opts ...request.Option) (*DescribeTypeRegistrationOutput, error) {
	req, out := c.DescribeTypeRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectStackDrift = "DetectStackDrift"

// DetectStackDriftRequest generates a "aws/request.Request" representing the
// client's request for the DetectStackDrift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectStackDrift for more information on using the DetectStackDrift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectStackDriftRequest method.
//	req, resp := client.DetectStackDriftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift
func (c *CloudFormation) DetectStackDriftRequest(input *DetectStackDriftInput) (req *request.Request, output *DetectStackDriftOutput) {
	op := &request.Operation{
		Name:       opDetectStackDrift,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectStackDriftInput{}
	}

	output = &DetectStackDriftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectStackDrift API operation for AWS CloudFormation.
//
// Detects whether a stack's actual configuration differs, or has drifted, from
// its expected configuration, as defined in the stack template and any values
// specified as template parameters. For each resource in the stack that supports
// drift detection, CloudFormation compares the actual configuration of the
// resource with its expected template configuration. Only resource properties
// explicitly defined in the stack template are checked for drift. A stack is
// considered to have drifted if one or more of its resources differ from their
// expected template configurations. For more information, see Detecting Unregulated
// Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Use DetectStackDrift to detect drift on all supported resources for a given
// stack, or DetectStackResourceDrift to detect drift on individual resources.
//
// For a list of stack resources that currently support drift detection, see
// Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// DetectStackDrift can take up to several minutes, depending on the number
// of resources contained within the stack. Use DescribeStackDriftDetectionStatus
// to monitor the progress of a detect stack drift operation. Once the drift
// detection operation has completed, use DescribeStackResourceDrifts to return
// drift information about the stack and its resources.
//
// When detecting drift on a stack, CloudFormation doesn't detect drift on any
// nested stacks belonging to that stack. Perform DetectStackDrift directly
// on the nested stack itself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DetectStackDrift for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift
func (c *CloudFormation) DetectStackDrift(input *DetectStackDriftInput) (*DetectStackDriftOutput, error) {
	req, out := c.DetectStackDriftRequest(input)
	return out, req.Send()
}

// DetectStackDriftWithContext is the same as DetectStackDrift with the addition of
// the ability to pass a context and additional request options.
//
// See DetectStackDrift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DetectStackDriftWithContext(ctx aws.Context, input *DetectStackDriftInput, opts ...request.Option) (*DetectStackDriftOutput, error) {
	req, out := c.DetectStackDriftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectStackResourceDrift = "DetectStackResourceDrift"

// DetectStackResourceDriftRequest generates a "aws/request.Request" representing the
// client's request for the DetectStackResourceDrift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectStackResourceDrift for more information on using the DetectStackResourceDrift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectStackResourceDriftRequest method.
//	req, resp := client.DetectStackResourceDriftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift
func (c *CloudFormation) DetectStackResourceDriftRequest(input *DetectStackResourceDriftInput) (req *request.Request, output *DetectStackResourceDriftOutput) {
	op := &request.Operation{
		Name:       opDetectStackResourceDrift,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectStackResourceDriftInput{}
	}

	output = &DetectStackResourceDriftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectStackResourceDrift API operation for AWS CloudFormation.
//
// Returns information about whether a resource's actual configuration differs,
// or has drifted, from its expected configuration, as defined in the stack
// template and any values specified as template parameters. This information
// includes actual and expected property values for resources in which CloudFormation
// detects drift. Only resource properties explicitly defined in the stack template
// are checked for drift. For more information about stack and resource drift,
// see Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all resources in a given stack that support
// drift detection.
//
// Resources that don't currently support drift detection can't be checked.
// For a list of resources that support drift detection, see Resources that
// Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DetectStackResourceDrift for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift
func (c *CloudFormation) DetectStackResourceDrift(input *DetectStackResourceDriftInput) (*DetectStackResourceDriftOutput, error) {
	req, out := c.DetectStackResourceDriftRequest(input)
	return out, req.Send()
}

// DetectStackResourceDriftWithContext is the same as DetectStackResourceDrift with the addition of
// the ability to pass a context and additional request options.
//
// See DetectStackResourceDrift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DetectStackResourceDriftWithContext(ctx aws.Context, input *DetectStackResourceDriftInput, opts ...request.Option) (*DetectStackResourceDriftOutput, error) {
	req, out := c.DetectStackResourceDriftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectStackSetDrift = "DetectStackSetDrift"

// DetectStackSetDriftRequest generates a "aws/request.Request" representing the
// client's request for the DetectStackSetDrift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectStackSetDrift for more information on using the DetectStackSetDrift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectStackSetDriftRequest method.
//	req, resp := client.DetectStackSetDriftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift
func (c *CloudFormation) DetectStackSetDriftRequest(input *DetectStackSetDriftInput) (req *request.Request, output *DetectStackSetDriftOutput) {
	op := &request.Operation{
		Name:       opDetectStackSetDrift,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectStackSetDriftInput{}
	}

	output = &DetectStackSetDriftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectStackSetDrift API operation for AWS CloudFormation.
//
// Detect drift on a stack set. When CloudFormation performs drift detection
// on a stack set, it performs drift detection on the stack associated with
// each stack instance in the stack set. For more information, see How CloudFormation
// performs drift detection on a stack set (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
//
// DetectStackSetDrift returns the OperationId of the stack set drift detection
// operation. Use this operation id with DescribeStackSetOperation to monitor
// the progress of the drift detection operation. The drift detection operation
// may take some time, depending on the number of stack instances included in
// the stack set, in addition to the number of resources included in each stack.
//
// Once the operation has completed, use the following actions to return drift
// information:
//
//   - Use DescribeStackSet to return detailed information about the stack
//     set, including detailed information about the last completed drift operation
//     performed on the stack set. (Information about drift operations that are
//     in progress isn't included.)
//
//   - Use ListStackInstances to return a list of stack instances belonging
//     to the stack set, including the drift status and last drift time checked
//     of each instance.
//
//   - Use DescribeStackInstance to return detailed information about a specific
//     stack instance, including its drift status and last drift time checked.
//
// For more information about performing a drift detection operation on a stack
// set, see Detecting unmanaged changes in stack sets (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
//
// You can only run a single drift detection operation on a given stack set
// at one time.
//
// To stop a drift detection stack set operation, use StopStackSetOperation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DetectStackSetDrift for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
//   - ErrCodeOperationInProgressException "OperationInProgressException"
//     Another operation is currently in progress for this stack set. Only one operation
//     can be performed for a stack set at a given time.
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift
func (c *CloudFormation) DetectStackSetDrift(input *DetectStackSetDriftInput) (*DetectStackSetDriftOutput, error) {
	req, out := c.DetectStackSetDriftRequest(input)
	return out, req.Send()
}

// DetectStackSetDriftWithContext is the same as DetectStackSetDrift with the addition of
// the ability to pass a context and additional request options.
//
// See DetectStackSetDrift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) DetectStackSetDriftWithContext(ctx aws.Context, input *DetectStackSetDriftInput, opts ...request.Option) (*DetectStackSetDriftOutput, error) {
	req, out := c.DetectStackSetDriftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEstimateTemplateCost = "EstimateTemplateCost"

// EstimateTemplateCostRequest generates a "aws/request.Request" representing the
// client's request for the EstimateTemplateCost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EstimateTemplateCost for more information on using the EstimateTemplateCost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EstimateTemplateCostRequest method.
//	req, resp := client.EstimateTemplateCostRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost
func (c *CloudFormation) EstimateTemplateCostRequest(input *EstimateTemplateCostInput) (req *request.Request, output *EstimateTemplateCostOutput) {
	op := &request.Operation{
		Name:       opEstimateTemplateCost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EstimateTemplateCostInput{}
	}

	output = &EstimateTemplateCostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EstimateTemplateCost API operation for AWS CloudFormation.
//
// Returns the estimated monthly cost of a template. The return value is an
// Amazon Web Services Simple Monthly Calculator URL with a query string that
// describes the resources required to run the template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation EstimateTemplateCost for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost
func (c *CloudFormation) EstimateTemplateCost(input *EstimateTemplateCostInput) (*EstimateTemplateCostOutput, error) {
	req, out := c.EstimateTemplateCostRequest(input)
	return out, req.Send()
}

// EstimateTemplateCostWithContext is the same as EstimateTemplateCost with the addition of
// the ability to pass a context and additional request options.
//
// See EstimateTemplateCost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) EstimateTemplateCostWithContext(ctx aws.Context, input *EstimateTemplateCostInput, opts ...request.Option) (*EstimateTemplateCostOutput, error) {
	req, out := c.EstimateTemplateCostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteChangeSet = "ExecuteChangeSet"

// ExecuteChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteChangeSet for more information on using the ExecuteChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteChangeSetRequest method.
//	req, resp := client.ExecuteChangeSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet
func (c *CloudFormation) ExecuteChangeSetRequest(input *ExecuteChangeSetInput) (req *request.Request, output *ExecuteChangeSetOutput) {
	op := &request.Operation{
		Name:       opExecuteChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecuteChangeSetInput{}
	}

	output = &ExecuteChangeSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ExecuteChangeSet API operation for AWS CloudFormation.
//
// Updates a stack using the input information that was provided when the specified
// change set was created. After the call successfully completes, CloudFormation
// starts updating the stack. Use the DescribeStacks action to view the status
// of the update.
//
// When you execute a change set, CloudFormation deletes all other change sets
// associated with the stack because they aren't valid for the updated stack.
//
// If a stack policy is associated with the stack, CloudFormation enforces the
// policy during the update. You can't specify a temporary stack policy that
// overrides the current policy.
//
// To create a change set for the entire stack hierarchy, IncludeNestedStacks
// must have been set to True.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ExecuteChangeSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidChangeSetStatusException "InvalidChangeSetStatus"
//     The specified change set can't be used to update the stack. For example,
//     the change set status might be CREATE_IN_PROGRESS, or the stack status might
//     be UPDATE_IN_PROGRESS.
//
//   - ErrCodeChangeSetNotFoundException "ChangeSetNotFound"
//     The specified change set name or ID doesn't exit. To view valid change sets
//     for a stack, use the ListChangeSets operation.
//
//   - ErrCodeInsufficientCapabilitiesException "InsufficientCapabilitiesException"
//     The template contains resources with capabilities that weren't specified
//     in the Capabilities parameter.
//
//   - ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//     A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet
func (c *CloudFormation) ExecuteChangeSet(input *ExecuteChangeSetInput) (*ExecuteChangeSetOutput, error) {
	req, out := c.ExecuteChangeSetRequest(input)
	return out, req.Send()
}

// ExecuteChangeSetWithContext is the same as ExecuteChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ExecuteChangeSetWithContext(ctx aws.Context, input *ExecuteChangeSetInput, opts ...request.Option) (*ExecuteChangeSetOutput, error) {
	req, out := c.ExecuteChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGeneratedTemplate = "GetGeneratedTemplate"

// GetGeneratedTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetGeneratedTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGeneratedTemplate for more information on using the GetGeneratedTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGeneratedTemplateRequest method.
//	req, resp := client.GetGeneratedTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetGeneratedTemplate
func (c *CloudFormation) GetGeneratedTemplateRequest(input *GetGeneratedTemplateInput) (req *request.Request, output *GetGeneratedTemplateOutput) {
	op := &request.Operation{
		Name:       opGetGeneratedTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGeneratedTemplateInput{}
	}

	output = &GetGeneratedTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGeneratedTemplate API operation for AWS CloudFormation.
//
// Retrieves a generated template. If the template is in an InProgress or Pending
// status then the template returned will be the template when the template
// was last in a Complete status. If the template has not yet been in a Complete
// status then an empty template will be returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetGeneratedTemplate for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeGeneratedTemplateNotFoundException "GeneratedTemplateNotFound"
//     The generated template was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetGeneratedTemplate
func (c *CloudFormation) GetGeneratedTemplate(input *GetGeneratedTemplateInput) (*GetGeneratedTemplateOutput, error) {
	req, out := c.GetGeneratedTemplateRequest(input)
	return out, req.Send()
}

// GetGeneratedTemplateWithContext is the same as GetGeneratedTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetGeneratedTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) GetGeneratedTemplateWithContext(ctx aws.Context, input *GetGeneratedTemplateInput, opts ...request.Option) (*GetGeneratedTemplateOutput, error) {
	req, out := c.GetGeneratedTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStackPolicy = "GetStackPolicy"

// GetStackPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetStackPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStackPolicy for more information on using the GetStackPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStackPolicyRequest method.
//	req, resp := client.GetStackPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy
func (c *CloudFormation) GetStackPolicyRequest(input *GetStackPolicyInput) (req *request.Request, output *GetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opGetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStackPolicyInput{}
	}

	output = &GetStackPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStackPolicy API operation for AWS CloudFormation.
//
// Returns the stack policy for a specified stack. If a stack doesn't have a
// policy, a null value is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetStackPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy
func (c *CloudFormation) GetStackPolicy(input *GetStackPolicyInput) (*GetStackPolicyOutput, error) {
	req, out := c.GetStackPolicyRequest(input)
	return out, req.Send()
}

// GetStackPolicyWithContext is the same as GetStackPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetStackPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) GetStackPolicyWithContext(ctx aws.Context, input *GetStackPolicyInput, opts ...request.Option) (*GetStackPolicyOutput, error) {
	req, out := c.GetStackPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplate for more information on using the GetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateRequest method.
//	req, resp := client.GetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate
func (c *CloudFormation) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	output = &GetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplate API operation for AWS CloudFormation.
//
// Returns the template body for a specified stack. You can get the template
// for running or deleted stacks.
//
// For deleted stacks, GetTemplate returns the template for up to 90 days after
// the stack has been deleted.
//
// If the template doesn't exist, a ValidationError is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetTemplate for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeChangeSetNotFoundException "ChangeSetNotFound"
//     The specified change set name or ID doesn't exit. To view valid change sets
//     for a stack, use the ListChangeSets operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate
func (c *CloudFormation) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	return out, req.Send()
}

// GetTemplateWithContext is the same as GetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) GetTemplateWithContext(ctx aws.Context, input *GetTemplateInput, opts ...request.Option) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplateSummary = "GetTemplateSummary"

// GetTemplateSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplateSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplateSummary for more information on using the GetTemplateSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateSummaryRequest method.
//	req, resp := client.GetTemplateSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary
func (c *CloudFormation) GetTemplateSummaryRequest(input *GetTemplateSummaryInput) (req *request.Request, output *GetTemplateSummaryOutput) {
	op := &request.Operation{
		Name:       opGetTemplateSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateSummaryInput{}
	}

	output = &GetTemplateSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplateSummary API operation for AWS CloudFormation.
//
// Returns information about a new or existing template. The GetTemplateSummary
// action is useful for viewing parameter information, such as default parameter
// values and parameter types, before you create or update a stack or stack
// set.
//
// You can use the GetTemplateSummary action when you submit a template, or
// you can get template information for a stack set, or a running or deleted
// stack.
//
// For deleted stacks, GetTemplateSummary returns the template information for
// up to 90 days after the stack has been deleted. If the template doesn't exist,
// a ValidationError is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetTemplateSummary for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary
func (c *CloudFormation) GetTemplateSummary(input *GetTemplateSummaryInput) (*GetTemplateSummaryOutput, error) {
	req, out := c.GetTemplateSummaryRequest(input)
	return out, req.Send()
}

// GetTemplateSummaryWithContext is the same as GetTemplateSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplateSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) GetTemplateSummaryWithContext(ctx aws.Context, input *GetTemplateSummaryInput, opts ...request.Option) (*GetTemplateSummaryOutput, error) {
	req, out := c.GetTemplateSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportStacksToStackSet = "ImportStacksToStackSet"

// ImportStacksToStackSetRequest generates a "aws/request.Request" representing the
// client's request for the ImportStacksToStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportStacksToStackSet for more information on using the ImportStacksToStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportStacksToStackSetRequest method.
//	req, resp := client.ImportStacksToStackSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ImportStacksToStackSet
func (c *CloudFormation) ImportStacksToStackSetRequest(input *ImportStacksToStackSetInput) (req *request.Request, output *ImportStacksToStackSetOutput) {
	op := &request.Operation{
		Name:       opImportStacksToStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportStacksToStackSetInput{}
	}

	output = &ImportStacksToStackSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportStacksToStackSet API operation for AWS CloudFormation.
//
// Import existing stacks into a new stack sets. Use the stack import operation
// to import up to 10 stacks into a new stack set in the same account as the
// source stack or in a different administrator account and Region, by specifying
// the stack ID of the stack you intend to import.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ImportStacksToStackSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The quota for the resource has already been reached.
//
//     For information about resource and stack limitations, see CloudFormation
//     quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//     in the CloudFormation User Guide.
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
//   - ErrCodeOperationInProgressException "OperationInProgressException"
//     Another operation is currently in progress for this stack set. Only one operation
//     can be performed for a stack set at a given time.
//
//   - ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//     The specified operation ID already exists.
//
//   - ErrCodeStackNotFoundException "StackNotFoundException"
//     The specified stack ARN doesn't exist or stack doesn't exist corresponding
//     to the ARN in input.
//
//   - ErrCodeStaleRequestException "StaleRequestException"
//     Another operation has been performed on this stack set since the specified
//     operation was performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ImportStacksToStackSet
func (c *CloudFormation) ImportStacksToStackSet(input *ImportStacksToStackSetInput) (*ImportStacksToStackSetOutput, error) {
	req, out := c.ImportStacksToStackSetRequest(input)
	return out, req.Send()
}

// ImportStacksToStackSetWithContext is the same as ImportStacksToStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See ImportStacksToStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ImportStacksToStackSetWithContext(ctx aws.Context, input *ImportStacksToStackSetInput, opts ...request.Option) (*ImportStacksToStackSetOutput, error) {
	req, out := c.ImportStacksToStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChangeSets = "ListChangeSets"

// ListChangeSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListChangeSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChangeSets for more information on using the ListChangeSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChangeSetsRequest method.
//	req, resp := client.ListChangeSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets
func (c *CloudFormation) ListChangeSetsRequest(input *ListChangeSetsInput) (req *request.Request, output *ListChangeSetsOutput) {
	op := &request.Operation{
		Name:       opListChangeSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChangeSetsInput{}
	}

	output = &ListChangeSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChangeSets API operation for AWS CloudFormation.
//
// Returns the ID and status of each active change set for a stack. For example,
// CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or CREATE_PENDING
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListChangeSets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets
func (c *CloudFormation) ListChangeSets(input *ListChangeSetsInput) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	return out, req.Send()
}

// ListChangeSetsWithContext is the same as ListChangeSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListChangeSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListChangeSetsWithContext(ctx aws.Context, input *ListChangeSetsInput, opts ...request.Option) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChangeSetsPages iterates over the pages of a ListChangeSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChangeSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChangeSets operation.
//	pageNum := 0
//	err := client.ListChangeSetsPages(params,
//	    func(page *cloudformation.ListChangeSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListChangeSetsPages(input *ListChangeSetsInput, fn func(*ListChangeSetsOutput, bool) bool) error {
	return c.ListChangeSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChangeSetsPagesWithContext same as ListChangeSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListChangeSetsPagesWithContext(ctx aws.Context, input *ListChangeSetsInput, fn func(*ListChangeSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChangeSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChangeSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChangeSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExports = "ListExports"

// ListExportsRequest generates a "aws/request.Request" representing the
// client's request for the ListExports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExports for more information on using the ListExports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExportsRequest method.
//	req, resp := client.ListExportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports
func (c *CloudFormation) ListExportsRequest(input *ListExportsInput) (req *request.Request, output *ListExportsOutput) {
	op := &request.Operation{
		Name:       opListExports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExportsInput{}
	}

	output = &ListExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExports API operation for AWS CloudFormation.
//
// Lists all exported output values in the account and Region in which you call
// this action. Use this action to see the exported output values that you can
// import into other stacks. To import values, use the Fn::ImportValue (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
// function.
//
// For more information, see CloudFormation export stack output values (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListExports for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports
func (c *CloudFormation) ListExports(input *ListExportsInput) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	return out, req.Send()
}

// ListExportsWithContext is the same as ListExports with the addition of
// the ability to pass a context and additional request options.
//
// See ListExports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListExportsWithContext(ctx aws.Context, input *ListExportsInput, opts ...request.Option) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExportsPages iterates over the pages of a ListExports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExports operation.
//	pageNum := 0
//	err := client.ListExportsPages(params,
//	    func(page *cloudformation.ListExportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListExportsPages(input *ListExportsInput, fn func(*ListExportsOutput, bool) bool) error {
	return c.ListExportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExportsPagesWithContext same as ListExportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListExportsPagesWithContext(ctx aws.Context, input *ListExportsInput, fn func(*ListExportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGeneratedTemplates = "ListGeneratedTemplates"

// ListGeneratedTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListGeneratedTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeneratedTemplates for more information on using the ListGeneratedTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGeneratedTemplatesRequest method.
//	req, resp := client.ListGeneratedTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListGeneratedTemplates
func (c *CloudFormation) ListGeneratedTemplatesRequest(input *ListGeneratedTemplatesInput) (req *request.Request, output *ListGeneratedTemplatesOutput) {
	op := &request.Operation{
		Name:       opListGeneratedTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGeneratedTemplatesInput{}
	}

	output = &ListGeneratedTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGeneratedTemplates API operation for AWS CloudFormation.
//
// Lists your generated templates in this Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListGeneratedTemplates for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListGeneratedTemplates
func (c *CloudFormation) ListGeneratedTemplates(input *ListGeneratedTemplatesInput) (*ListGeneratedTemplatesOutput, error) {
	req, out := c.ListGeneratedTemplatesRequest(input)
	return out, req.Send()
}

// ListGeneratedTemplatesWithContext is the same as ListGeneratedTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeneratedTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListGeneratedTemplatesWithContext(ctx aws.Context, input *ListGeneratedTemplatesInput, opts ...request.Option) (*ListGeneratedTemplatesOutput, error) {
	req, out := c.ListGeneratedTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGeneratedTemplatesPages iterates over the pages of a ListGeneratedTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGeneratedTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGeneratedTemplates operation.
//	pageNum := 0
//	err := client.ListGeneratedTemplatesPages(params,
//	    func(page *cloudformation.ListGeneratedTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListGeneratedTemplatesPages(input *ListGeneratedTemplatesInput, fn func(*ListGeneratedTemplatesOutput, bool) bool) error {
	return c.ListGeneratedTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGeneratedTemplatesPagesWithContext same as ListGeneratedTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListGeneratedTemplatesPagesWithContext(ctx aws.Context, input *ListGeneratedTemplatesInput, fn func(*ListGeneratedTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGeneratedTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGeneratedTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGeneratedTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImports = "ListImports"

// ListImportsRequest generates a "aws/request.Request" representing the
// client's request for the ListImports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImports for more information on using the ListImports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImportsRequest method.
//	req, resp := client.ListImportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports
func (c *CloudFormation) ListImportsRequest(input *ListImportsInput) (req *request.Request, output *ListImportsOutput) {
	op := &request.Operation{
		Name:       opListImports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImportsInput{}
	}

	output = &ListImportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImports API operation for AWS CloudFormation.
//
// Lists all stacks that are importing an exported output value. To modify or
// remove an exported output value, first use this action to see which stacks
// are using it. To see the exported output values in your account, see ListExports.
//
// For more information about importing an exported output value, see the Fn::ImportValue
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
// function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListImports for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports
func (c *CloudFormation) ListImports(input *ListImportsInput) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	return out, req.Send()
}

// ListImportsWithContext is the same as ListImports with the addition of
// the ability to pass a context and additional request options.
//
// See ListImports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListImportsWithContext(ctx aws.Context, input *ListImportsInput, opts ...request.Option) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImportsPages iterates over the pages of a ListImports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImports operation.
//	pageNum := 0
//	err := client.ListImportsPages(params,
//	    func(page *cloudformation.ListImportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListImportsPages(input *ListImportsInput, fn func(*ListImportsOutput, bool) bool) error {
	return c.ListImportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImportsPagesWithContext same as ListImportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListImportsPagesWithContext(ctx aws.Context, input *ListImportsInput, fn func(*ListImportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceScanRelatedResources = "ListResourceScanRelatedResources"

// ListResourceScanRelatedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceScanRelatedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceScanRelatedResources for more information on using the ListResourceScanRelatedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceScanRelatedResourcesRequest method.
//	req, resp := client.ListResourceScanRelatedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanRelatedResources
func (c *CloudFormation) ListResourceScanRelatedResourcesRequest(input *ListResourceScanRelatedResourcesInput) (req *request.Request, output *ListResourceScanRelatedResourcesOutput) {
	op := &request.Operation{
		Name:       opListResourceScanRelatedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceScanRelatedResourcesInput{}
	}

	output = &ListResourceScanRelatedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceScanRelatedResources API operation for AWS CloudFormation.
//
// Lists the related resources for a list of resources from a resource scan.
// The response indicates whether each returned resource is already managed
// by CloudFormation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListResourceScanRelatedResources for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeResourceScanNotFoundException "ResourceScanNotFound"
//     The resource scan was not found.
//
//   - ErrCodeResourceScanInProgressException "ResourceScanInProgress"
//     A resource scan is currently in progress. Only one can be run at a time for
//     an account in a Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanRelatedResources
func (c *CloudFormation) ListResourceScanRelatedResources(input *ListResourceScanRelatedResourcesInput) (*ListResourceScanRelatedResourcesOutput, error) {
	req, out := c.ListResourceScanRelatedResourcesRequest(input)
	return out, req.Send()
}

// ListResourceScanRelatedResourcesWithContext is the same as ListResourceScanRelatedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceScanRelatedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListResourceScanRelatedResourcesWithContext(ctx aws.Context, input *ListResourceScanRelatedResourcesInput, opts ...request.Option) (*ListResourceScanRelatedResourcesOutput, error) {
	req, out := c.ListResourceScanRelatedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceScanRelatedResourcesPages iterates over the pages of a ListResourceScanRelatedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceScanRelatedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourceScanRelatedResources operation.
//	pageNum := 0
//	err := client.ListResourceScanRelatedResourcesPages(params,
//	    func(page *cloudformation.ListResourceScanRelatedResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListResourceScanRelatedResourcesPages(input *ListResourceScanRelatedResourcesInput, fn func(*ListResourceScanRelatedResourcesOutput, bool) bool) error {
	return c.ListResourceScanRelatedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceScanRelatedResourcesPagesWithContext same as ListResourceScanRelatedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListResourceScanRelatedResourcesPagesWithContext(ctx aws.Context, input *ListResourceScanRelatedResourcesInput, fn func(*ListResourceScanRelatedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceScanRelatedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceScanRelatedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceScanRelatedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceScanResources = "ListResourceScanResources"

// ListResourceScanResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceScanResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceScanResources for more information on using the ListResourceScanResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceScanResourcesRequest method.
//	req, resp := client.ListResourceScanResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanResources
func (c *CloudFormation) ListResourceScanResourcesRequest(input *ListResourceScanResourcesInput) (req *request.Request, output *ListResourceScanResourcesOutput) {
	op := &request.Operation{
		Name:       opListResourceScanResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceScanResourcesInput{}
	}

	output = &ListResourceScanResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceScanResources API operation for AWS CloudFormation.
//
// Lists the resources from a resource scan. The results can be filtered by
// resource identifier, resource type prefix, tag key, and tag value. Only resources
// that match all specified filters are returned. The response indicates whether
// each returned resource is already managed by CloudFormation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListResourceScanResources for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeResourceScanNotFoundException "ResourceScanNotFound"
//     The resource scan was not found.
//
//   - ErrCodeResourceScanInProgressException "ResourceScanInProgress"
//     A resource scan is currently in progress. Only one can be run at a time for
//     an account in a Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanResources
func (c *CloudFormation) ListResourceScanResources(input *ListResourceScanResourcesInput) (*ListResourceScanResourcesOutput, error) {
	req, out := c.ListResourceScanResourcesRequest(input)
	return out, req.Send()
}

// ListResourceScanResourcesWithContext is the same as ListResourceScanResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceScanResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListResourceScanResourcesWithContext(ctx aws.Context, input *ListResourceScanResourcesInput, opts ...request.Option) (*ListResourceScanResourcesOutput, error) {
	req, out := c.ListResourceScanResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceScanResourcesPages iterates over the pages of a ListResourceScanResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceScanResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourceScanResources operation.
//	pageNum := 0
//	err := client.ListResourceScanResourcesPages(params,
//	    func(page *cloudformation.ListResourceScanResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListResourceScanResourcesPages(input *ListResourceScanResourcesInput, fn func(*ListResourceScanResourcesOutput, bool) bool) error {
	return c.ListResourceScanResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceScanResourcesPagesWithContext same as ListResourceScanResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListResourceScanResourcesPagesWithContext(ctx aws.Context, input *ListResourceScanResourcesInput, fn func(*ListResourceScanResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceScanResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceScanResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceScanResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceScans = "ListResourceScans"

// ListResourceScansRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceScans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceScans for more information on using the ListResourceScans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceScansRequest method.
//	req, resp := client.ListResourceScansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScans
func (c *CloudFormation) ListResourceScansRequest(input *ListResourceScansInput) (req *request.Request, output *ListResourceScansOutput) {
	op := &request.Operation{
		Name:       opListResourceScans,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceScansInput{}
	}

	output = &ListResourceScansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceScans API operation for AWS CloudFormation.
//
// List the resource scans from newest to oldest. By default it will return
// up to 10 resource scans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListResourceScans for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScans
func (c *CloudFormation) ListResourceScans(input *ListResourceScansInput) (*ListResourceScansOutput, error) {
	req, out := c.ListResourceScansRequest(input)
	return out, req.Send()
}

// ListResourceScansWithContext is the same as ListResourceScans with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceScans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListResourceScansWithContext(ctx aws.Context, input *ListResourceScansInput, opts ...request.Option) (*ListResourceScansOutput, error) {
	req, out := c.ListResourceScansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceScansPages iterates over the pages of a ListResourceScans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceScans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourceScans operation.
//	pageNum := 0
//	err := client.ListResourceScansPages(params,
//	    func(page *cloudformation.ListResourceScansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListResourceScansPages(input *ListResourceScansInput, fn func(*ListResourceScansOutput, bool) bool) error {
	return c.ListResourceScansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceScansPagesWithContext same as ListResourceScansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListResourceScansPagesWithContext(ctx aws.Context, input *ListResourceScansInput, fn func(*ListResourceScansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceScansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceScansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceScansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStackInstanceResourceDrifts = "ListStackInstanceResourceDrifts"

// ListStackInstanceResourceDriftsRequest generates a "aws/request.Request" representing the
// client's request for the ListStackInstanceResourceDrifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackInstanceResourceDrifts for more information on using the ListStackInstanceResourceDrifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStackInstanceResourceDriftsRequest method.
//	req, resp := client.ListStackInstanceResourceDriftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstanceResourceDrifts
func (c *CloudFormation) ListStackInstanceResourceDriftsRequest(input *ListStackInstanceResourceDriftsInput) (req *request.Request, output *ListStackInstanceResourceDriftsOutput) {
	op := &request.Operation{
		Name:       opListStackInstanceResourceDrifts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackInstanceResourceDriftsInput{}
	}

	output = &ListStackInstanceResourceDriftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackInstanceResourceDrifts API operation for AWS CloudFormation.
//
// Returns drift information for resources in a stack instance.
//
// ListStackInstanceResourceDrifts returns drift information for the most recent
// drift detection operation. If an operation is in progress, it may only return
// partial results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackInstanceResourceDrifts for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeStackInstanceNotFoundException "StackInstanceNotFoundException"
//     The specified stack instance doesn't exist.
//
//   - ErrCodeOperationNotFoundException "OperationNotFoundException"
//     The specified ID refers to an operation that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstanceResourceDrifts
func (c *CloudFormation) ListStackInstanceResourceDrifts(input *ListStackInstanceResourceDriftsInput) (*ListStackInstanceResourceDriftsOutput, error) {
	req, out := c.ListStackInstanceResourceDriftsRequest(input)
	return out, req.Send()
}

// ListStackInstanceResourceDriftsWithContext is the same as ListStackInstanceResourceDrifts with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackInstanceResourceDrifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackInstanceResourceDriftsWithContext(ctx aws.Context, input *ListStackInstanceResourceDriftsInput, opts ...request.Option) (*ListStackInstanceResourceDriftsOutput, error) {
	req, out := c.ListStackInstanceResourceDriftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStackInstances = "ListStackInstances"

// ListStackInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListStackInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackInstances for more information on using the ListStackInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStackInstancesRequest method.
//	req, resp := client.ListStackInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances
func (c *CloudFormation) ListStackInstancesRequest(input *ListStackInstancesInput) (req *request.Request, output *ListStackInstancesOutput) {
	op := &request.Operation{
		Name:       opListStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackInstancesInput{}
	}

	output = &ListStackInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackInstances API operation for AWS CloudFormation.
//
// Returns summary information about stack instances that are associated with
// the specified stack set. You can filter for stack instances that are associated
// with a specific Amazon Web Services account name or Region, or that have
// a specific status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackInstances for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances
func (c *CloudFormation) ListStackInstances(input *ListStackInstancesInput) (*ListStackInstancesOutput, error) {
	req, out := c.ListStackInstancesRequest(input)
	return out, req.Send()
}

// ListStackInstancesWithContext is the same as ListStackInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackInstancesWithContext(ctx aws.Context, input *ListStackInstancesInput, opts ...request.Option) (*ListStackInstancesOutput, error) {
	req, out := c.ListStackInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStackInstancesPages iterates over the pages of a ListStackInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStackInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStackInstances operation.
//	pageNum := 0
//	err := client.ListStackInstancesPages(params,
//	    func(page *cloudformation.ListStackInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListStackInstancesPages(input *ListStackInstancesInput, fn func(*ListStackInstancesOutput, bool) bool) error {
	return c.ListStackInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStackInstancesPagesWithContext same as ListStackInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackInstancesPagesWithContext(ctx aws.Context, input *ListStackInstancesInput, fn func(*ListStackInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStackInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStackInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStackInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStackResources = "ListStackResources"

// ListStackResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListStackResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackResources for more information on using the ListStackResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStackResourcesRequest method.
//	req, resp := client.ListStackResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources
func (c *CloudFormation) ListStackResourcesRequest(input *ListStackResourcesInput) (req *request.Request, output *ListStackResourcesOutput) {
	op := &request.Operation{
		Name:       opListStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackResourcesInput{}
	}

	output = &ListStackResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackResources API operation for AWS CloudFormation.
//
// Returns descriptions of all resources of the specified stack.
//
// For deleted stacks, ListStackResources returns resource information for up
// to 90 days after the stack has been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackResources for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources
func (c *CloudFormation) ListStackResources(input *ListStackResourcesInput) (*ListStackResourcesOutput, error) {
	req, out := c.ListStackResourcesRequest(input)
	return out, req.Send()
}

// ListStackResourcesWithContext is the same as ListStackResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackResourcesWithContext(ctx aws.Context, input *ListStackResourcesInput, opts ...request.Option) (*ListStackResourcesOutput, error) {
	req, out := c.ListStackResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStackResourcesPages iterates over the pages of a ListStackResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStackResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStackResources operation.
//	pageNum := 0
//	err := client.ListStackResourcesPages(params,
//	    func(page *cloudformation.ListStackResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListStackResourcesPages(input *ListStackResourcesInput, fn func(*ListStackResourcesOutput, bool) bool) error {
	return c.ListStackResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStackResourcesPagesWithContext same as ListStackResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackResourcesPagesWithContext(ctx aws.Context, input *ListStackResourcesInput, fn func(*ListStackResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStackResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStackResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStackResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStackSetAutoDeploymentTargets = "ListStackSetAutoDeploymentTargets"

// ListStackSetAutoDeploymentTargetsRequest generates a "aws/request.Request" representing the
// client's request for the ListStackSetAutoDeploymentTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackSetAutoDeploymentTargets for more information on using the ListStackSetAutoDeploymentTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStackSetAutoDeploymentTargetsRequest method.
//	req, resp := client.ListStackSetAutoDeploymentTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetAutoDeploymentTargets
func (c *CloudFormation) ListStackSetAutoDeploymentTargetsRequest(input *ListStackSetAutoDeploymentTargetsInput) (req *request.Request, output *ListStackSetAutoDeploymentTargetsOutput) {
	op := &request.Operation{
		Name:       opListStackSetAutoDeploymentTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackSetAutoDeploymentTargetsInput{}
	}

	output = &ListStackSetAutoDeploymentTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackSetAutoDeploymentTargets API operation for AWS CloudFormation.
//
// Returns summary information about deployment targets for a stack set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackSetAutoDeploymentTargets for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetAutoDeploymentTargets
func (c *CloudFormation) ListStackSetAutoDeploymentTargets(input *ListStackSetAutoDeploymentTargetsInput) (*ListStackSetAutoDeploymentTargetsOutput, error) {
	req, out := c.ListStackSetAutoDeploymentTargetsRequest(input)
	return out, req.Send()
}

// ListStackSetAutoDeploymentTargetsWithContext is the same as ListStackSetAutoDeploymentTargets with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackSetAutoDeploymentTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetAutoDeploymentTargetsWithContext(ctx aws.Context, input *ListStackSetAutoDeploymentTargetsInput, opts ...request.Option) (*ListStackSetAutoDeploymentTargetsOutput, error) {
	req, out := c.ListStackSetAutoDeploymentTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStackSetOperationResults = "ListStackSetOperationResults"

// ListStackSetOperationResultsRequest generates a "aws/request.Request" representing the
// client's request for the ListStackSetOperationResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackSetOperationResults for more information on using the ListStackSetOperationResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStackSetOperationResultsRequest method.
//	req, resp := client.ListStackSetOperationResultsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults
func (c *CloudFormation) ListStackSetOperationResultsRequest(input *ListStackSetOperationResultsInput) (req *request.Request, output *ListStackSetOperationResultsOutput) {
	op := &request.Operation{
		Name:       opListStackSetOperationResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackSetOperationResultsInput{}
	}

	output = &ListStackSetOperationResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackSetOperationResults API operation for AWS CloudFormation.
//
// Returns summary information about the results of a stack set operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackSetOperationResults for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeOperationNotFoundException "OperationNotFoundException"
//     The specified ID refers to an operation that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults
func (c *CloudFormation) ListStackSetOperationResults(input *ListStackSetOperationResultsInput) (*ListStackSetOperationResultsOutput, error) {
	req, out := c.ListStackSetOperationResultsRequest(input)
	return out, req.Send()
}

// ListStackSetOperationResultsWithContext is the same as ListStackSetOperationResults with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackSetOperationResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetOperationResultsWithContext(ctx aws.Context, input *ListStackSetOperationResultsInput, opts ...request.Option) (*ListStackSetOperationResultsOutput, error) {
	req, out := c.ListStackSetOperationResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStackSetOperationResultsPages iterates over the pages of a ListStackSetOperationResults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStackSetOperationResults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStackSetOperationResults operation.
//	pageNum := 0
//	err := client.ListStackSetOperationResultsPages(params,
//	    func(page *cloudformation.ListStackSetOperationResultsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListStackSetOperationResultsPages(input *ListStackSetOperationResultsInput, fn func(*ListStackSetOperationResultsOutput, bool) bool) error {
	return c.ListStackSetOperationResultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStackSetOperationResultsPagesWithContext same as ListStackSetOperationResultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetOperationResultsPagesWithContext(ctx aws.Context, input *ListStackSetOperationResultsInput, fn func(*ListStackSetOperationResultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStackSetOperationResultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStackSetOperationResultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStackSetOperationResultsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStackSetOperations = "ListStackSetOperations"

// ListStackSetOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListStackSetOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackSetOperations for more information on using the ListStackSetOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStackSetOperationsRequest method.
//	req, resp := client.ListStackSetOperationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations
func (c *CloudFormation) ListStackSetOperationsRequest(input *ListStackSetOperationsInput) (req *request.Request, output *ListStackSetOperationsOutput) {
	op := &request.Operation{
		Name:       opListStackSetOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackSetOperationsInput{}
	}

	output = &ListStackSetOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackSetOperations API operation for AWS CloudFormation.
//
// Returns summary information about operations performed on a stack set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackSetOperations for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations
func (c *CloudFormation) ListStackSetOperations(input *ListStackSetOperationsInput) (*ListStackSetOperationsOutput, error) {
	req, out := c.ListStackSetOperationsRequest(input)
	return out, req.Send()
}

// ListStackSetOperationsWithContext is the same as ListStackSetOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackSetOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetOperationsWithContext(ctx aws.Context, input *ListStackSetOperationsInput, opts ...request.Option) (*ListStackSetOperationsOutput, error) {
	req, out := c.ListStackSetOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStackSetOperationsPages iterates over the pages of a ListStackSetOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStackSetOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStackSetOperations operation.
//	pageNum := 0
//	err := client.ListStackSetOperationsPages(params,
//	    func(page *cloudformation.ListStackSetOperationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListStackSetOperationsPages(input *ListStackSetOperationsInput, fn func(*ListStackSetOperationsOutput, bool) bool) error {
	return c.ListStackSetOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStackSetOperationsPagesWithContext same as ListStackSetOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetOperationsPagesWithContext(ctx aws.Context, input *ListStackSetOperationsInput, fn func(*ListStackSetOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStackSetOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStackSetOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStackSetOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStackSets = "ListStackSets"

// ListStackSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListStackSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStackSets for more information on using the ListStackSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStackSetsRequest method.
//	req, resp := client.ListStackSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets
func (c *CloudFormation) ListStackSetsRequest(input *ListStackSetsInput) (req *request.Request, output *ListStackSetsOutput) {
	op := &request.Operation{
		Name:       opListStackSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackSetsInput{}
	}

	output = &ListStackSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackSets API operation for AWS CloudFormation.
//
// Returns summary information about stack sets that are associated with the
// user.
//
//   - [Self-managed permissions] If you set the CallAs parameter to SELF while
//     signed in to your Amazon Web Services account, ListStackSets returns all
//     self-managed stack sets in your Amazon Web Services account.
//
//   - [Service-managed permissions] If you set the CallAs parameter to SELF
//     while signed in to the organization's management account, ListStackSets
//     returns all stack sets in the management account.
//
//   - [Service-managed permissions] If you set the CallAs parameter to DELEGATED_ADMIN
//     while signed in to your member account, ListStackSets returns all stack
//     sets with service-managed permissions in the management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackSets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets
func (c *CloudFormation) ListStackSets(input *ListStackSetsInput) (*ListStackSetsOutput, error) {
	req, out := c.ListStackSetsRequest(input)
	return out, req.Send()
}

// ListStackSetsWithContext is the same as ListStackSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListStackSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetsWithContext(ctx aws.Context, input *ListStackSetsInput, opts ...request.Option) (*ListStackSetsOutput, error) {
	req, out := c.ListStackSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStackSetsPages iterates over the pages of a ListStackSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStackSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStackSets operation.
//	pageNum := 0
//	err := client.ListStackSetsPages(params,
//	    func(page *cloudformation.ListStackSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListStackSetsPages(input *ListStackSetsInput, fn func(*ListStackSetsOutput, bool) bool) error {
	return c.ListStackSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStackSetsPagesWithContext same as ListStackSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStackSetsPagesWithContext(ctx aws.Context, input *ListStackSetsInput, fn func(*ListStackSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStackSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStackSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStackSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStacks = "ListStacks"

// ListStacksRequest generates a "aws/request.Request" representing the
// client's request for the ListStacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStacks for more information on using the ListStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStacksRequest method.
//	req, resp := client.ListStacksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks
func (c *CloudFormation) ListStacksRequest(input *ListStacksInput) (req *request.Request, output *ListStacksOutput) {
	op := &request.Operation{
		Name:       opListStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStacksInput{}
	}

	output = &ListStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStacks API operation for AWS CloudFormation.
//
// Returns the summary information for stacks whose status matches the specified
// StackStatusFilter. Summary information for stacks that have been deleted
// is kept for 90 days after the stack is deleted. If no StackStatusFilter is
// specified, summary information for all stacks is returned (including existing
// stacks and stacks that have been deleted).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStacks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks
func (c *CloudFormation) ListStacks(input *ListStacksInput) (*ListStacksOutput, error) {
	req, out := c.ListStacksRequest(input)
	return out, req.Send()
}

// ListStacksWithContext is the same as ListStacks with the addition of
// the ability to pass a context and additional request options.
//
// See ListStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStacksWithContext(ctx aws.Context, input *ListStacksInput, opts ...request.Option) (*ListStacksOutput, error) {
	req, out := c.ListStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStacksPages iterates over the pages of a ListStacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStacks operation.
//	pageNum := 0
//	err := client.ListStacksPages(params,
//	    func(page *cloudformation.ListStacksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListStacksPages(input *ListStacksInput, fn func(*ListStacksOutput, bool) bool) error {
	return c.ListStacksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStacksPagesWithContext same as ListStacksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListStacksPagesWithContext(ctx aws.Context, input *ListStacksInput, fn func(*ListStacksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStacksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStacksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStacksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTypeRegistrations = "ListTypeRegistrations"

// ListTypeRegistrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListTypeRegistrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTypeRegistrations for more information on using the ListTypeRegistrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTypeRegistrationsRequest method.
//	req, resp := client.ListTypeRegistrationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations
func (c *CloudFormation) ListTypeRegistrationsRequest(input *ListTypeRegistrationsInput) (req *request.Request, output *ListTypeRegistrationsOutput) {
	op := &request.Operation{
		Name:       opListTypeRegistrations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTypeRegistrationsInput{}
	}

	output = &ListTypeRegistrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTypeRegistrations API operation for AWS CloudFormation.
//
// Returns a list of registration tokens for the specified extension(s).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListTypeRegistrations for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations
func (c *CloudFormation) ListTypeRegistrations(input *ListTypeRegistrationsInput) (*ListTypeRegistrationsOutput, error) {
	req, out := c.ListTypeRegistrationsRequest(input)
	return out, req.Send()
}

// ListTypeRegistrationsWithContext is the same as ListTypeRegistrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListTypeRegistrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListTypeRegistrationsWithContext(ctx aws.Context, input *ListTypeRegistrationsInput, opts ...request.Option) (*ListTypeRegistrationsOutput, error) {
	req, out := c.ListTypeRegistrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTypeRegistrationsPages iterates over the pages of a ListTypeRegistrations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTypeRegistrations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTypeRegistrations operation.
//	pageNum := 0
//	err := client.ListTypeRegistrationsPages(params,
//	    func(page *cloudformation.ListTypeRegistrationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListTypeRegistrationsPages(input *ListTypeRegistrationsInput, fn func(*ListTypeRegistrationsOutput, bool) bool) error {
	return c.ListTypeRegistrationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTypeRegistrationsPagesWithContext same as ListTypeRegistrationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListTypeRegistrationsPagesWithContext(ctx aws.Context, input *ListTypeRegistrationsInput, fn func(*ListTypeRegistrationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTypeRegistrationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTypeRegistrationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTypeRegistrationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTypeVersions = "ListTypeVersions"

// ListTypeVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTypeVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTypeVersions for more information on using the ListTypeVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTypeVersionsRequest method.
//	req, resp := client.ListTypeVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions
func (c *CloudFormation) ListTypeVersionsRequest(input *ListTypeVersionsInput) (req *request.Request, output *ListTypeVersionsOutput) {
	op := &request.Operation{
		Name:       opListTypeVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTypeVersionsInput{}
	}

	output = &ListTypeVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTypeVersions API operation for AWS CloudFormation.
//
// Returns summary information about the versions of an extension.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListTypeVersions for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions
func (c *CloudFormation) ListTypeVersions(input *ListTypeVersionsInput) (*ListTypeVersionsOutput, error) {
	req, out := c.ListTypeVersionsRequest(input)
	return out, req.Send()
}

// ListTypeVersionsWithContext is the same as ListTypeVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTypeVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListTypeVersionsWithContext(ctx aws.Context, input *ListTypeVersionsInput, opts ...request.Option) (*ListTypeVersionsOutput, error) {
	req, out := c.ListTypeVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTypeVersionsPages iterates over the pages of a ListTypeVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTypeVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTypeVersions operation.
//	pageNum := 0
//	err := client.ListTypeVersionsPages(params,
//	    func(page *cloudformation.ListTypeVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListTypeVersionsPages(input *ListTypeVersionsInput, fn func(*ListTypeVersionsOutput, bool) bool) error {
	return c.ListTypeVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTypeVersionsPagesWithContext same as ListTypeVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListTypeVersionsPagesWithContext(ctx aws.Context, input *ListTypeVersionsInput, fn func(*ListTypeVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTypeVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTypeVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTypeVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTypes = "ListTypes"

// ListTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTypes for more information on using the ListTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTypesRequest method.
//	req, resp := client.ListTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes
func (c *CloudFormation) ListTypesRequest(input *ListTypesInput) (req *request.Request, output *ListTypesOutput) {
	op := &request.Operation{
		Name:       opListTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTypesInput{}
	}

	output = &ListTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTypes API operation for AWS CloudFormation.
//
// Returns summary information about extension that have been registered with
// CloudFormation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListTypes for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes
func (c *CloudFormation) ListTypes(input *ListTypesInput) (*ListTypesOutput, error) {
	req, out := c.ListTypesRequest(input)
	return out, req.Send()
}

// ListTypesWithContext is the same as ListTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListTypesWithContext(ctx aws.Context, input *ListTypesInput, opts ...request.Option) (*ListTypesOutput, error) {
	req, out := c.ListTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTypesPages iterates over the pages of a ListTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTypes operation.
//	pageNum := 0
//	err := client.ListTypesPages(params,
//	    func(page *cloudformation.ListTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudFormation) ListTypesPages(input *ListTypesInput, fn func(*ListTypesOutput, bool) bool) error {
	return c.ListTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTypesPagesWithContext same as ListTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ListTypesPagesWithContext(ctx aws.Context, input *ListTypesInput, fn func(*ListTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPublishType = "PublishType"

// PublishTypeRequest generates a "aws/request.Request" representing the
// client's request for the PublishType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishType for more information on using the PublishType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PublishTypeRequest method.
//	req, resp := client.PublishTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PublishType
func (c *CloudFormation) PublishTypeRequest(input *PublishTypeInput) (req *request.Request, output *PublishTypeOutput) {
	op := &request.Operation{
		Name:       opPublishType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PublishTypeInput{}
	}

	output = &PublishTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PublishType API operation for AWS CloudFormation.
//
// Publishes the specified extension to the CloudFormation registry as a public
// extension in this Region. Public extensions are available for use by all
// CloudFormation users. For more information about publishing extensions, see
// Publishing extensions to make them available for public use (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html)
// in the CloudFormation CLI User Guide.
//
// To publish an extension, you must be registered as a publisher with CloudFormation.
// For more information, see RegisterPublisher (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation PublishType for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
//   - ErrCodeTypeNotFoundException "TypeNotFoundException"
//     The specified extension doesn't exist in the CloudFormation registry.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PublishType
func (c *CloudFormation) PublishType(input *PublishTypeInput) (*PublishTypeOutput, error) {
	req, out := c.PublishTypeRequest(input)
	return out, req.Send()
}

// PublishTypeWithContext is the same as PublishType with the addition of
// the ability to pass a context and additional request options.
//
// See PublishType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) PublishTypeWithContext(ctx aws.Context, input *PublishTypeInput, opts ...request.Option) (*PublishTypeOutput, error) {
	req, out := c.PublishTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRecordHandlerProgress = "RecordHandlerProgress"

// RecordHandlerProgressRequest generates a "aws/request.Request" representing the
// client's request for the RecordHandlerProgress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RecordHandlerProgress for more information on using the RecordHandlerProgress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RecordHandlerProgressRequest method.
//	req, resp := client.RecordHandlerProgressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress
func (c *CloudFormation) RecordHandlerProgressRequest(input *RecordHandlerProgressInput) (req *request.Request, output *RecordHandlerProgressOutput) {
	op := &request.Operation{
		Name:       opRecordHandlerProgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecordHandlerProgressInput{}
	}

	output = &RecordHandlerProgressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RecordHandlerProgress API operation for AWS CloudFormation.
//
// Reports progress of a resource handler to CloudFormation.
//
// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
// Don't use this API in your code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation RecordHandlerProgress for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidStateTransitionException "InvalidStateTransition"
//     Error reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
//     CloudFormation doesn't return this error to users.
//
//   - ErrCodeOperationStatusCheckFailedException "ConditionalCheckFailed"
//     Error reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
//     CloudFormation doesn't return this error to users.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress
func (c *CloudFormation) RecordHandlerProgress(input *RecordHandlerProgressInput) (*RecordHandlerProgressOutput, error) {
	req, out := c.RecordHandlerProgressRequest(input)
	return out, req.Send()
}

// RecordHandlerProgressWithContext is the same as RecordHandlerProgress with the addition of
// the ability to pass a context and additional request options.
//
// See RecordHandlerProgress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) RecordHandlerProgressWithContext(ctx aws.Context, input *RecordHandlerProgressInput, opts ...request.Option) (*RecordHandlerProgressOutput, error) {
	req, out := c.RecordHandlerProgressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterPublisher = "RegisterPublisher"

// RegisterPublisherRequest generates a "aws/request.Request" representing the
// client's request for the RegisterPublisher operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterPublisher for more information on using the RegisterPublisher
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterPublisherRequest method.
//	req, resp := client.RegisterPublisherRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterPublisher
func (c *CloudFormation) RegisterPublisherRequest(input *RegisterPublisherInput) (req *request.Request, output *RegisterPublisherOutput) {
	op := &request.Operation{
		Name:       opRegisterPublisher,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterPublisherInput{}
	}

	output = &RegisterPublisherOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterPublisher API operation for AWS CloudFormation.
//
// Registers your account as a publisher of public extensions in the CloudFormation
// registry. Public extensions are available for use by all CloudFormation users.
// This publisher ID applies to your account in all Amazon Web Services Regions.
//
// For information about requirements for registering as a public extension
// publisher, see Registering your account to publish CloudFormation extensions
// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs)
// in the CloudFormation CLI User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation RegisterPublisher for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterPublisher
func (c *CloudFormation) RegisterPublisher(input *RegisterPublisherInput) (*RegisterPublisherOutput, error) {
	req, out := c.RegisterPublisherRequest(input)
	return out, req.Send()
}

// RegisterPublisherWithContext is the same as RegisterPublisher with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterPublisher for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) RegisterPublisherWithContext(ctx aws.Context, input *RegisterPublisherInput, opts ...request.Option) (*RegisterPublisherOutput, error) {
	req, out := c.RegisterPublisherRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterType = "RegisterType"

// RegisterTypeRequest generates a "aws/request.Request" representing the
// client's request for the RegisterType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterType for more information on using the RegisterType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterTypeRequest method.
//	req, resp := client.RegisterTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType
func (c *CloudFormation) RegisterTypeRequest(input *RegisterTypeInput) (req *request.Request, output *RegisterTypeOutput) {
	op := &request.Operation{
		Name:       opRegisterType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTypeInput{}
	}

	output = &RegisterTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterType API operation for AWS CloudFormation.
//
// Registers an extension with the CloudFormation service. Registering an extension
// makes it available for use in CloudFormation templates in your Amazon Web
// Services account, and includes:
//
//   - Validating the extension schema.
//
//   - Determining which handlers, if any, have been specified for the extension.
//
//   - Making the extension available for use in your account.
//
// For more information about how to develop extensions and ready them for registration,
// see Creating Resource Providers (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html)
// in the CloudFormation CLI User Guide.
//
// You can have a maximum of 50 resource extension versions registered at a
// time. This maximum is per account and per Region. Use DeregisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html)
// to deregister specific extension versions if necessary.
//
// Once you have initiated a registration request using RegisterType, you can
// use DescribeTypeRegistration to monitor the progress of the registration
// request.
//
// Once you have registered a private extension in your account and Region,
// use SetTypeConfiguration (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html)
// to specify configuration properties for the extension. For more information,
// see Configuring extensions at the account level (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private.html#registry-set-configuration)
// in the CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation RegisterType for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType
func (c *CloudFormation) RegisterType(input *RegisterTypeInput) (*RegisterTypeOutput, error) {
	req, out := c.RegisterTypeRequest(input)
	return out, req.Send()
}

// RegisterTypeWithContext is the same as RegisterType with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) RegisterTypeWithContext(ctx aws.Context, input *RegisterTypeInput, opts ...request.Option) (*RegisterTypeOutput, error) {
	req, out := c.RegisterTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRollbackStack = "RollbackStack"

// RollbackStackRequest generates a "aws/request.Request" representing the
// client's request for the RollbackStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RollbackStack for more information on using the RollbackStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RollbackStackRequest method.
//	req, resp := client.RollbackStackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackStack
func (c *CloudFormation) RollbackStackRequest(input *RollbackStackInput) (req *request.Request, output *RollbackStackOutput) {
	op := &request.Operation{
		Name:       opRollbackStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RollbackStackInput{}
	}

	output = &RollbackStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RollbackStack API operation for AWS CloudFormation.
//
// When specifying RollbackStack, you preserve the state of previously provisioned
// resources when an operation fails. You can check the status of the stack
// through the DescribeStacks operation.
//
// Rolls back the specified stack to the last known stable state from CREATE_FAILED
// or UPDATE_FAILED stack statuses.
//
// This operation will delete a stack if it doesn't contain a last known stable
// state. A last known stable state includes any status in a *_COMPLETE. This
// includes the following stack statuses.
//
//   - CREATE_COMPLETE
//
//   - UPDATE_COMPLETE
//
//   - UPDATE_ROLLBACK_COMPLETE
//
//   - IMPORT_COMPLETE
//
//   - IMPORT_ROLLBACK_COMPLETE
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation RollbackStack for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//     A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackStack
func (c *CloudFormation) RollbackStack(input *RollbackStackInput) (*RollbackStackOutput, error) {
	req, out := c.RollbackStackRequest(input)
	return out, req.Send()
}

// RollbackStackWithContext is the same as RollbackStack with the addition of
// the ability to pass a context and additional request options.
//
// See RollbackStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) RollbackStackWithContext(ctx aws.Context, input *RollbackStackInput, opts ...request.Option) (*RollbackStackOutput, error) {
	req, out := c.RollbackStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetStackPolicy = "SetStackPolicy"

// SetStackPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SetStackPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetStackPolicy for more information on using the SetStackPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetStackPolicyRequest method.
//	req, resp := client.SetStackPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy
func (c *CloudFormation) SetStackPolicyRequest(input *SetStackPolicyInput) (req *request.Request, output *SetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opSetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetStackPolicyInput{}
	}

	output = &SetStackPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetStackPolicy API operation for AWS CloudFormation.
//
// Sets a stack policy for a specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation SetStackPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy
func (c *CloudFormation) SetStackPolicy(input *SetStackPolicyInput) (*SetStackPolicyOutput, error) {
	req, out := c.SetStackPolicyRequest(input)
	return out, req.Send()
}

// SetStackPolicyWithContext is the same as SetStackPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See SetStackPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) SetStackPolicyWithContext(ctx aws.Context, input *SetStackPolicyInput, opts ...request.Option) (*SetStackPolicyOutput, error) {
	req, out := c.SetStackPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetTypeConfiguration = "SetTypeConfiguration"

// SetTypeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the SetTypeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetTypeConfiguration for more information on using the SetTypeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetTypeConfigurationRequest method.
//	req, resp := client.SetTypeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeConfiguration
func (c *CloudFormation) SetTypeConfigurationRequest(input *SetTypeConfigurationInput) (req *request.Request, output *SetTypeConfigurationOutput) {
	op := &request.Operation{
		Name:       opSetTypeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTypeConfigurationInput{}
	}

	output = &SetTypeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetTypeConfiguration API operation for AWS CloudFormation.
//
// Specifies the configuration data for a registered CloudFormation extension,
// in the given account and Region.
//
// To view the current configuration data for an extension, refer to the ConfigurationSchema
// element of DescribeType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
// For more information, see Configuring extensions at the account level (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private.html#registry-set-configuration)
// in the CloudFormation User Guide.
//
// It's strongly recommended that you use dynamic references to restrict sensitive
// configuration definitions, such as third-party credentials. For more details
// on dynamic references, see Using dynamic references to specify template values
// (https://docs.aws.amazon.com/) in the CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation SetTypeConfiguration for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
//   - ErrCodeTypeNotFoundException "TypeNotFoundException"
//     The specified extension doesn't exist in the CloudFormation registry.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeConfiguration
func (c *CloudFormation) SetTypeConfiguration(input *SetTypeConfigurationInput) (*SetTypeConfigurationOutput, error) {
	req, out := c.SetTypeConfigurationRequest(input)
	return out, req.Send()
}

// SetTypeConfigurationWithContext is the same as SetTypeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See SetTypeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) SetTypeConfigurationWithContext(ctx aws.Context, input *SetTypeConfigurationInput, opts ...request.Option) (*SetTypeConfigurationOutput, error) {
	req, out := c.SetTypeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetTypeDefaultVersion = "SetTypeDefaultVersion"

// SetTypeDefaultVersionRequest generates a "aws/request.Request" representing the
// client's request for the SetTypeDefaultVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetTypeDefaultVersion for more information on using the SetTypeDefaultVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetTypeDefaultVersionRequest method.
//	req, resp := client.SetTypeDefaultVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion
func (c *CloudFormation) SetTypeDefaultVersionRequest(input *SetTypeDefaultVersionInput) (req *request.Request, output *SetTypeDefaultVersionOutput) {
	op := &request.Operation{
		Name:       opSetTypeDefaultVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTypeDefaultVersionInput{}
	}

	output = &SetTypeDefaultVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetTypeDefaultVersion API operation for AWS CloudFormation.
//
// Specify the default version of an extension. The default version of an extension
// will be used in CloudFormation operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation SetTypeDefaultVersion for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
//   - ErrCodeTypeNotFoundException "TypeNotFoundException"
//     The specified extension doesn't exist in the CloudFormation registry.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion
func (c *CloudFormation) SetTypeDefaultVersion(input *SetTypeDefaultVersionInput) (*SetTypeDefaultVersionOutput, error) {
	req, out := c.SetTypeDefaultVersionRequest(input)
	return out, req.Send()
}

// SetTypeDefaultVersionWithContext is the same as SetTypeDefaultVersion with the addition of
// the ability to pass a context and additional request options.
//
// See SetTypeDefaultVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) SetTypeDefaultVersionWithContext(ctx aws.Context, input *SetTypeDefaultVersionInput, opts ...request.Option) (*SetTypeDefaultVersionOutput, error) {
	req, out := c.SetTypeDefaultVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSignalResource = "SignalResource"

// SignalResourceRequest generates a "aws/request.Request" representing the
// client's request for the SignalResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SignalResource for more information on using the SignalResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SignalResourceRequest method.
//	req, resp := client.SignalResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource
func (c *CloudFormation) SignalResourceRequest(input *SignalResourceInput) (req *request.Request, output *SignalResourceOutput) {
	op := &request.Operation{
		Name:       opSignalResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalResourceInput{}
	}

	output = &SignalResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SignalResource API operation for AWS CloudFormation.
//
// Sends a signal to the specified resource with a success or failure status.
// You can use the SignalResource operation in conjunction with a creation policy
// or update policy. CloudFormation doesn't proceed with a stack creation or
// update until resources receive the required number of signals or the timeout
// period is exceeded. The SignalResource operation is useful in cases where
// you want to send signals from anywhere other than an Amazon EC2 instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation SignalResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource
func (c *CloudFormation) SignalResource(input *SignalResourceInput) (*SignalResourceOutput, error) {
	req, out := c.SignalResourceRequest(input)
	return out, req.Send()
}

// SignalResourceWithContext is the same as SignalResource with the addition of
// the ability to pass a context and additional request options.
//
// See SignalResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) SignalResourceWithContext(ctx aws.Context, input *SignalResourceInput, opts ...request.Option) (*SignalResourceOutput, error) {
	req, out := c.SignalResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartResourceScan = "StartResourceScan"

// StartResourceScanRequest generates a "aws/request.Request" representing the
// client's request for the StartResourceScan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartResourceScan for more information on using the StartResourceScan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartResourceScanRequest method.
//	req, resp := client.StartResourceScanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StartResourceScan
func (c *CloudFormation) StartResourceScanRequest(input *StartResourceScanInput) (req *request.Request, output *StartResourceScanOutput) {
	op := &request.Operation{
		Name:       opStartResourceScan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartResourceScanInput{}
	}

	output = &StartResourceScanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartResourceScan API operation for AWS CloudFormation.
//
// Starts a scan of the resources in this account in this Region. You can the
// status of a scan using the ListResourceScans API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation StartResourceScan for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeResourceScanInProgressException "ResourceScanInProgress"
//     A resource scan is currently in progress. Only one can be run at a time for
//     an account in a Region.
//
//   - ErrCodeResourceScanLimitExceededException "ResourceScanLimitExceeded"
//     The limit on resource scans has been exceeded. Reasons include:
//
//   - Exceeded the daily quota for resource scans.
//
//   - A resource scan recently failed. You must wait 10 minutes before starting
//     a new resource scan.
//
//   - The last resource scan failed after exceeding 100,000 resources. When
//     this happens, you must wait 24 hours before starting a new resource scan.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StartResourceScan
func (c *CloudFormation) StartResourceScan(input *StartResourceScanInput) (*StartResourceScanOutput, error) {
	req, out := c.StartResourceScanRequest(input)
	return out, req.Send()
}

// StartResourceScanWithContext is the same as StartResourceScan with the addition of
// the ability to pass a context and additional request options.
//
// See StartResourceScan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) StartResourceScanWithContext(ctx aws.Context, input *StartResourceScanInput, opts ...request.Option) (*StartResourceScanOutput, error) {
	req, out := c.StartResourceScanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopStackSetOperation = "StopStackSetOperation"

// StopStackSetOperationRequest generates a "aws/request.Request" representing the
// client's request for the StopStackSetOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopStackSetOperation for more information on using the StopStackSetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopStackSetOperationRequest method.
//	req, resp := client.StopStackSetOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation
func (c *CloudFormation) StopStackSetOperationRequest(input *StopStackSetOperationInput) (req *request.Request, output *StopStackSetOperationOutput) {
	op := &request.Operation{
		Name:       opStopStackSetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStackSetOperationInput{}
	}

	output = &StopStackSetOperationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopStackSetOperation API operation for AWS CloudFormation.
//
// Stops an in-progress operation on a stack set and its associated stack instances.
// StackSets will cancel all the unstarted stack instance deployments and wait
// for those are in-progress to complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation StopStackSetOperation for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeOperationNotFoundException "OperationNotFoundException"
//     The specified ID refers to an operation that doesn't exist.
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation
func (c *CloudFormation) StopStackSetOperation(input *StopStackSetOperationInput) (*StopStackSetOperationOutput, error) {
	req, out := c.StopStackSetOperationRequest(input)
	return out, req.Send()
}

// StopStackSetOperationWithContext is the same as StopStackSetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See StopStackSetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) StopStackSetOperationWithContext(ctx aws.Context, input *StopStackSetOperationInput, opts ...request.Option) (*StopStackSetOperationOutput, error) {
	req, out := c.StopStackSetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestType = "TestType"

// TestTypeRequest generates a "aws/request.Request" representing the
// client's request for the TestType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestType for more information on using the TestType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TestTypeRequest method.
//	req, resp := client.TestTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TestType
func (c *CloudFormation) TestTypeRequest(input *TestTypeInput) (req *request.Request, output *TestTypeOutput) {
	op := &request.Operation{
		Name:       opTestType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestTypeInput{}
	}

	output = &TestTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestType API operation for AWS CloudFormation.
//
// Tests a registered extension to make sure it meets all necessary requirements
// for being published in the CloudFormation registry.
//
//   - For resource types, this includes passing all contracts tests defined
//     for the type.
//
//   - For modules, this includes determining if the module's model meets all
//     necessary requirements.
//
// For more information, see Testing your public extension prior to publishing
// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing)
// in the CloudFormation CLI User Guide.
//
// If you don't specify a version, CloudFormation uses the default version of
// the extension in your account and Region for testing.
//
// To perform testing, CloudFormation assumes the execution role specified when
// the type was registered. For more information, see RegisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
//
// Once you've initiated testing on an extension using TestType, you can pass
// the returned TypeVersionArn into DescribeType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html)
// to monitor the current test status and test status description for the extension.
//
// An extension must have a test status of PASSED before it can be published.
// For more information, see Publishing extensions to make them available for
// public use (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html)
// in the CloudFormation CLI User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation TestType for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCFNRegistryException "CFNRegistryException"
//     An error occurred during a CloudFormation registry operation.
//
//   - ErrCodeTypeNotFoundException "TypeNotFoundException"
//     The specified extension doesn't exist in the CloudFormation registry.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TestType
func (c *CloudFormation) TestType(input *TestTypeInput) (*TestTypeOutput, error) {
	req, out := c.TestTypeRequest(input)
	return out, req.Send()
}

// TestTypeWithContext is the same as TestType with the addition of
// the ability to pass a context and additional request options.
//
// See TestType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) TestTypeWithContext(ctx aws.Context, input *TestTypeInput, opts ...request.Option) (*TestTypeOutput, error) {
	req, out := c.TestTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGeneratedTemplate = "UpdateGeneratedTemplate"

// UpdateGeneratedTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGeneratedTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGeneratedTemplate for more information on using the UpdateGeneratedTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGeneratedTemplateRequest method.
//	req, resp := client.UpdateGeneratedTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateGeneratedTemplate
func (c *CloudFormation) UpdateGeneratedTemplateRequest(input *UpdateGeneratedTemplateInput) (req *request.Request, output *UpdateGeneratedTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateGeneratedTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGeneratedTemplateInput{}
	}

	output = &UpdateGeneratedTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGeneratedTemplate API operation for AWS CloudFormation.
//
// Updates a generated template. This can be used to change the name, add and
// remove resources, refresh resources, and change the DeletionPolicy and UpdateReplacePolicy
// settings. You can check the status of the update to the generated template
// using the DescribeGeneratedTemplate API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateGeneratedTemplate for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeAlreadyExistsException "AlreadyExistsException"
//     The resource with the name requested already exists.
//
//   - ErrCodeGeneratedTemplateNotFoundException "GeneratedTemplateNotFound"
//     The generated template was not found.
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The quota for the resource has already been reached.
//
//     For information about resource and stack limitations, see CloudFormation
//     quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
//     in the CloudFormation User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateGeneratedTemplate
func (c *CloudFormation) UpdateGeneratedTemplate(input *UpdateGeneratedTemplateInput) (*UpdateGeneratedTemplateOutput, error) {
	req, out := c.UpdateGeneratedTemplateRequest(input)
	return out, req.Send()
}

// UpdateGeneratedTemplateWithContext is the same as UpdateGeneratedTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGeneratedTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateGeneratedTemplateWithContext(ctx aws.Context, input *UpdateGeneratedTemplateInput, opts ...request.Option) (*UpdateGeneratedTemplateOutput, error) {
	req, out := c.UpdateGeneratedTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStack for more information on using the UpdateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStackRequest method.
//	req, resp := client.UpdateStackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack
func (c *CloudFormation) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	output = &UpdateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStack API operation for AWS CloudFormation.
//
// Updates a stack as specified in the template. After the call completes successfully,
// the stack update starts. You can check the status of the stack through the
// DescribeStacks action.
//
// To get a copy of the template for an existing stack, you can use the GetTemplate
// action.
//
// For more information about creating an update template, updating a stack,
// and monitoring the progress of the update, see Updating a Stack (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateStack for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInsufficientCapabilitiesException "InsufficientCapabilitiesException"
//     The template contains resources with capabilities that weren't specified
//     in the Capabilities parameter.
//
//   - ErrCodeTokenAlreadyExistsException "TokenAlreadyExistsException"
//     A client request token already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack
func (c *CloudFormation) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	return out, req.Send()
}

// UpdateStackWithContext is the same as UpdateStack with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateStackWithContext(ctx aws.Context, input *UpdateStackInput, opts ...request.Option) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStackInstances = "UpdateStackInstances"

// UpdateStackInstancesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStackInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStackInstances for more information on using the UpdateStackInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStackInstancesRequest method.
//	req, resp := client.UpdateStackInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances
func (c *CloudFormation) UpdateStackInstancesRequest(input *UpdateStackInstancesInput) (req *request.Request, output *UpdateStackInstancesOutput) {
	op := &request.Operation{
		Name:       opUpdateStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInstancesInput{}
	}

	output = &UpdateStackInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStackInstances API operation for AWS CloudFormation.
//
// Updates the parameter values for stack instances for the specified accounts,
// within the specified Amazon Web Services Regions. A stack instance refers
// to a stack in a specific account and Region.
//
// You can only update stack instances in Amazon Web Services Regions and accounts
// where they already exist; to create additional stack instances, use CreateStackInstances
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
//
// During stack set updates, any parameters overridden for a stack instance
// aren't updated, but retain their overridden value.
//
// You can only update the parameter values that are specified in the stack
// set; to add or delete a parameter itself, use UpdateStackSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
// to update the stack set template. If you add a parameter to a template, before
// you can override the parameter value specified in the stack set you must
// first use UpdateStackSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
// to update all stack instances with the updated template and parameter value
// specified in the stack set. Once a stack instance has been updated with the
// new parameter, you can then override the parameter value using UpdateStackInstances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateStackInstances for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeStackInstanceNotFoundException "StackInstanceNotFoundException"
//     The specified stack instance doesn't exist.
//
//   - ErrCodeOperationInProgressException "OperationInProgressException"
//     Another operation is currently in progress for this stack set. Only one operation
//     can be performed for a stack set at a given time.
//
//   - ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//     The specified operation ID already exists.
//
//   - ErrCodeStaleRequestException "StaleRequestException"
//     Another operation has been performed on this stack set since the specified
//     operation was performed.
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances
func (c *CloudFormation) UpdateStackInstances(input *UpdateStackInstancesInput) (*UpdateStackInstancesOutput, error) {
	req, out := c.UpdateStackInstancesRequest(input)
	return out, req.Send()
}

// UpdateStackInstancesWithContext is the same as UpdateStackInstances with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStackInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateStackInstancesWithContext(ctx aws.Context, input *UpdateStackInstancesInput, opts ...request.Option) (*UpdateStackInstancesOutput, error) {
	req, out := c.UpdateStackInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStackSet = "UpdateStackSet"

// UpdateStackSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStackSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStackSet for more information on using the UpdateStackSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStackSetRequest method.
//	req, resp := client.UpdateStackSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet
func (c *CloudFormation) UpdateStackSetRequest(input *UpdateStackSetInput) (req *request.Request, output *UpdateStackSetOutput) {
	op := &request.Operation{
		Name:       opUpdateStackSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackSetInput{}
	}

	output = &UpdateStackSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStackSet API operation for AWS CloudFormation.
//
// Updates the stack set, and associated stack instances in the specified accounts
// and Amazon Web Services Regions.
//
// Even if the stack set operation created by updating the stack set fails (completely
// or partially, below or above a specified failure tolerance), the stack set
// is updated with your changes. Subsequent CreateStackInstances calls on the
// specified stack set use the updated stack set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateStackSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeStackSetNotFoundException "StackSetNotFoundException"
//     The specified stack set doesn't exist.
//
//   - ErrCodeOperationInProgressException "OperationInProgressException"
//     Another operation is currently in progress for this stack set. Only one operation
//     can be performed for a stack set at a given time.
//
//   - ErrCodeOperationIdAlreadyExistsException "OperationIdAlreadyExistsException"
//     The specified operation ID already exists.
//
//   - ErrCodeStaleRequestException "StaleRequestException"
//     Another operation has been performed on this stack set since the specified
//     operation was performed.
//
//   - ErrCodeInvalidOperationException "InvalidOperationException"
//     The specified operation isn't valid.
//
//   - ErrCodeStackInstanceNotFoundException "StackInstanceNotFoundException"
//     The specified stack instance doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet
func (c *CloudFormation) UpdateStackSet(input *UpdateStackSetInput) (*UpdateStackSetOutput, error) {
	req, out := c.UpdateStackSetRequest(input)
	return out, req.Send()
}

// UpdateStackSetWithContext is the same as UpdateStackSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStackSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateStackSetWithContext(ctx aws.Context, input *UpdateStackSetInput, opts ...request.Option) (*UpdateStackSetOutput, error) {
	req, out := c.UpdateStackSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTerminationProtection = "UpdateTerminationProtection"

// UpdateTerminationProtectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTerminationProtection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTerminationProtection for more information on using the UpdateTerminationProtection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTerminationProtectionRequest method.
//	req, resp := client.UpdateTerminationProtectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection
func (c *CloudFormation) UpdateTerminationProtectionRequest(input *UpdateTerminationProtectionInput) (req *request.Request, output *UpdateTerminationProtectionOutput) {
	op := &request.Operation{
		Name:       opUpdateTerminationProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTerminationProtectionInput{}
	}

	output = &UpdateTerminationProtectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTerminationProtection API operation for AWS CloudFormation.
//
// Updates termination protection for the specified stack. If a user attempts
// to delete a stack with termination protection enabled, the operation fails
// and the stack remains unchanged. For more information, see Protecting a Stack
// From Being Deleted (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
// in the CloudFormation User Guide.
//
// For nested stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
// termination protection is set on the root stack and can't be changed directly
// on the nested stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateTerminationProtection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection
func (c *CloudFormation) UpdateTerminationProtection(input *UpdateTerminationProtectionInput) (*UpdateTerminationProtectionOutput, error) {
	req, out := c.UpdateTerminationProtectionRequest(input)
	return out, req.Send()
}

// UpdateTerminationProtectionWithContext is the same as UpdateTerminationProtection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTerminationProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) UpdateTerminationProtectionWithContext(ctx aws.Context, input *UpdateTerminationProtectionInput, opts ...request.Option) (*UpdateTerminationProtectionOutput, error) {
	req, out := c.UpdateTerminationProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateTemplate = "ValidateTemplate"

// ValidateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the ValidateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateTemplate for more information on using the ValidateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateTemplateRequest method.
//	req, resp := client.ValidateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate
func (c *CloudFormation) ValidateTemplateRequest(input *ValidateTemplateInput) (req *request.Request, output *ValidateTemplateOutput) {
	op := &request.Operation{
		Name:       opValidateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateTemplateInput{}
	}

	output = &ValidateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateTemplate API operation for AWS CloudFormation.
//
// Validates a specified template. CloudFormation first checks if the template
// is valid JSON. If it isn't, CloudFormation checks if the template is valid
// YAML. If both these checks fail, CloudFormation returns a template validation
// error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ValidateTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate
func (c *CloudFormation) ValidateTemplate(input *ValidateTemplateInput) (*ValidateTemplateOutput, error) {
	req, out := c.ValidateTemplateRequest(input)
	return out, req.Send()
}

// ValidateTemplateWithContext is the same as ValidateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFormation) ValidateTemplateWithContext(ctx aws.Context, input *ValidateTemplateInput, opts ...request.Option) (*ValidateTemplateOutput, error) {
	req, out := c.ValidateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Structure that contains the results of the account gate function which CloudFormation
// invokes, if present, before proceeding with a stack set operation in an account
// and Region.
//
// For each account and Region, CloudFormation lets you specify a Lambda function
// that encapsulates any requirements that must be met before CloudFormation
// can proceed with a stack set operation in that account and Region. CloudFormation
// invokes the function each time a stack set operation is requested for that
// account and Region; if the function returns FAILED, CloudFormation cancels
// the operation in that account and Region, and sets the stack set operation
// result status for that account and Region to FAILED.
//
// For more information, see Configuring a target account gate (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-account-gating.html).
type AccountGateResult struct {
	_ struct{} `type:"structure"`

	// The status of the account gate function.
	//
	//    * SUCCEEDED: The account gate function has determined that the account
	//    and Region passes any requirements for a stack set operation to occur.
	//    CloudFormation proceeds with the stack operation in that account and Region.
	//
	//    * FAILED: The account gate function has determined that the account and
	//    Region doesn't meet the requirements for a stack set operation to occur.
	//    CloudFormation cancels the stack set operation in that account and Region,
	//    and sets the stack set operation result status for that account and Region
	//    to FAILED.
	//
	//    * SKIPPED: CloudFormation has skipped calling the account gate function
	//    for this account and Region, for one of the following reasons: An account
	//    gate function hasn't been specified for the account and Region. CloudFormation
	//    proceeds with the stack set operation in this account and Region. The
	//    AWSCloudFormationStackSetExecutionRole of the stack set administration
	//    account lacks permissions to invoke the function. CloudFormation proceeds
	//    with the stack set operation in this account and Region. Either no action
	//    is necessary, or no action is possible, on the stack. CloudFormation skips
	//    the stack set operation in this account and Region.
	Status *string `type:"string" enum:"AccountGateStatus"`

	// The reason for the account gate status assigned to this account and Region
	// for the stack set operation.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountGateResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountGateResult) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AccountGateResult) SetStatus(v string) *AccountGateResult {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AccountGateResult) SetStatusReason(v string) *AccountGateResult {
	s.StatusReason = &v
	return s
}

// The AccountLimit data type.
//
// CloudFormation has the following limits per account:
//
//   - Number of concurrent resources
//
//   - Number of stacks
//
//   - Number of stack outputs
//
// For more information about these account limits, and other CloudFormation
// limits, see CloudFormation quotas (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
// in the CloudFormation User Guide.
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The name of the account limit.
	//
	// Values: ConcurrentResourcesLimit | StackLimit | StackOutputsLimit
	Name *string `type:"string"`

	// The value that's associated with the account limit name.
	Value *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountLimit) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AccountLimit) SetName(v string) *AccountLimit {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AccountLimit) SetValue(v int64) *AccountLimit {
	s.Value = &v
	return s
}

type ActivateOrganizationsAccessInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateOrganizationsAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateOrganizationsAccessInput) GoString() string {
	return s.String()
}

type ActivateOrganizationsAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateOrganizationsAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateOrganizationsAccessOutput) GoString() string {
	return s.String()
}

type ActivateTypeInput struct {
	_ struct{} `type:"structure"`

	// Whether to automatically update the extension in this account and Region
	// when a new minor version is published by the extension publisher. Major versions
	// released by the publisher must be manually updated.
	//
	// The default is true.
	AutoUpdate *bool `type:"boolean"`

	// The name of the IAM execution role to use to activate the extension.
	ExecutionRoleArn *string `min:"1" type:"string"`

	// Contains logging configuration information for an extension.
	LoggingConfig *LoggingConfig `type:"structure"`

	// The major version of this extension you want to activate, if multiple major
	// versions are available. The default is the latest major version. CloudFormation
	// uses the latest available minor version of the major version selected.
	//
	// You can specify MajorVersion or VersionBump, but not both.
	MajorVersion *int64 `min:"1" type:"long"`

	// The Amazon Resource Name (ARN) of the public extension.
	//
	// Conditional: You must specify PublicTypeArn, or TypeName, Type, and PublisherId.
	PublicTypeArn *string `type:"string"`

	// The ID of the extension publisher.
	//
	// Conditional: You must specify PublicTypeArn, or TypeName, Type, and PublisherId.
	PublisherId *string `min:"1" type:"string"`

	// The extension type.
	//
	// Conditional: You must specify PublicTypeArn, or TypeName, Type, and PublisherId.
	Type *string `type:"string" enum:"ThirdPartyType"`

	// The name of the extension.
	//
	// Conditional: You must specify PublicTypeArn, or TypeName, Type, and PublisherId.
	TypeName *string `min:"10" type:"string"`

	// An alias to assign to the public extension, in this account and Region. If
	// you specify an alias for the extension, CloudFormation treats the alias as
	// the extension type name within this account and Region. You must use the
	// alias to refer to the extension in your templates, API calls, and CloudFormation
	// console.
	//
	// An extension alias must be unique within a given account and Region. You
	// can activate the same public resource multiple times in the same account
	// and Region, using different type name aliases.
	TypeNameAlias *string `min:"10" type:"string"`

	// Manually updates a previously-activated type to a new major or minor version,
	// if available. You can also use this parameter to update the value of AutoUpdate.
	//
	//    * MAJOR: CloudFormation updates the extension to the newest major version,
	//    if one is available.
	//
	//    * MINOR: CloudFormation updates the extension to the newest minor version,
	//    if one is available.
	VersionBump *string `type:"string" enum:"VersionBump"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateTypeInput"}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 1))
	}
	if s.MajorVersion != nil && *s.MajorVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MajorVersion", 1))
	}
	if s.PublisherId != nil && len(*s.PublisherId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublisherId", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.TypeNameAlias != nil && len(*s.TypeNameAlias) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeNameAlias", 10))
	}
	if s.LoggingConfig != nil {
		if err := s.LoggingConfig.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoUpdate sets the AutoUpdate field's value.
func (s *ActivateTypeInput) SetAutoUpdate(v bool) *ActivateTypeInput {
	s.AutoUpdate = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *ActivateTypeInput) SetExecutionRoleArn(v string) *ActivateTypeInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *ActivateTypeInput) SetLoggingConfig(v *LoggingConfig) *ActivateTypeInput {
	s.LoggingConfig = v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *ActivateTypeInput) SetMajorVersion(v int64) *ActivateTypeInput {
	s.MajorVersion = &v
	return s
}

// SetPublicTypeArn sets the PublicTypeArn field's value.
func (s *ActivateTypeInput) SetPublicTypeArn(v string) *ActivateTypeInput {
	s.PublicTypeArn = &v
	return s
}

// SetPublisherId sets the PublisherId field's value.
func (s *ActivateTypeInput) SetPublisherId(v string) *ActivateTypeInput {
	s.PublisherId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ActivateTypeInput) SetType(v string) *ActivateTypeInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ActivateTypeInput) SetTypeName(v string) *ActivateTypeInput {
	s.TypeName = &v
	return s
}

// SetTypeNameAlias sets the TypeNameAlias field's value.
func (s *ActivateTypeInput) SetTypeNameAlias(v string) *ActivateTypeInput {
	s.TypeNameAlias = &v
	return s
}

// SetVersionBump sets the VersionBump field's value.
func (s *ActivateTypeInput) SetVersionBump(v string) *ActivateTypeInput {
	s.VersionBump = &v
	return s
}

type ActivateTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the activated extension, in this account
	// and Region.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateTypeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ActivateTypeOutput) SetArn(v string) *ActivateTypeOutput {
	s.Arn = &v
	return s
}

// [Service-managed permissions] Describes whether StackSets automatically deploys
// to Organizations accounts that are added to a target organization or organizational
// unit (OU).
type AutoDeployment struct {
	_ struct{} `type:"structure"`

	// If set to true, StackSets automatically deploys additional stack instances
	// to Organizations accounts that are added to a target organization or organizational
	// unit (OU) in the specified Regions. If an account is removed from a target
	// organization or OU, StackSets deletes stack instances from the account in
	// the specified Regions.
	Enabled *bool `type:"boolean"`

	// If set to true, stack resources are retained when an account is removed from
	// a target organization or OU. If set to false, stack resources are deleted.
	// Specify only if Enabled is set to True.
	RetainStacksOnAccountRemoval *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoDeployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoDeployment) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AutoDeployment) SetEnabled(v bool) *AutoDeployment {
	s.Enabled = &v
	return s
}

// SetRetainStacksOnAccountRemoval sets the RetainStacksOnAccountRemoval field's value.
func (s *AutoDeployment) SetRetainStacksOnAccountRemoval(v bool) *AutoDeployment {
	s.RetainStacksOnAccountRemoval = &v
	return s
}

// Detailed information concerning an error generated during the setting of
// configuration data for a CloudFormation extension.
type BatchDescribeTypeConfigurationsError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `min:"3" type:"string"`

	// The error message.
	ErrorMessage *string `min:"1" type:"string"`

	// Identifying information for the configuration of a CloudFormation extension.
	TypeConfigurationIdentifier *TypeConfigurationIdentifier `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeTypeConfigurationsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeTypeConfigurationsError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchDescribeTypeConfigurationsError) SetErrorCode(v string) *BatchDescribeTypeConfigurationsError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchDescribeTypeConfigurationsError) SetErrorMessage(v string) *BatchDescribeTypeConfigurationsError {
	s.ErrorMessage = &v
	return s
}

// SetTypeConfigurationIdentifier sets the TypeConfigurationIdentifier field's value.
func (s *BatchDescribeTypeConfigurationsError) SetTypeConfigurationIdentifier(v *TypeConfigurationIdentifier) *BatchDescribeTypeConfigurationsError {
	s.TypeConfigurationIdentifier = v
	return s
}

type BatchDescribeTypeConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The list of identifiers for the desired extension configurations.
	//
	// TypeConfigurationIdentifiers is a required field
	TypeConfigurationIdentifiers []*TypeConfigurationIdentifier `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeTypeConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeTypeConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDescribeTypeConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDescribeTypeConfigurationsInput"}
	if s.TypeConfigurationIdentifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeConfigurationIdentifiers"))
	}
	if s.TypeConfigurationIdentifiers != nil && len(s.TypeConfigurationIdentifiers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeConfigurationIdentifiers", 1))
	}
	if s.TypeConfigurationIdentifiers != nil {
		for i, v := range s.TypeConfigurationIdentifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TypeConfigurationIdentifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTypeConfigurationIdentifiers sets the TypeConfigurationIdentifiers field's value.
func (s *BatchDescribeTypeConfigurationsInput) SetTypeConfigurationIdentifiers(v []*TypeConfigurationIdentifier) *BatchDescribeTypeConfigurationsInput {
	s.TypeConfigurationIdentifiers = v
	return s
}

type BatchDescribeTypeConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of information concerning any errors generated during the setting
	// of the specified configurations.
	Errors []*BatchDescribeTypeConfigurationsError `type:"list"`

	// A list of any of the specified extension configurations from the CloudFormation
	// registry.
	TypeConfigurations []*TypeConfigurationDetails `type:"list"`

	// A list of any of the specified extension configurations that CloudFormation
	// could not process for any reason.
	UnprocessedTypeConfigurations []*TypeConfigurationIdentifier `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeTypeConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeTypeConfigurationsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDescribeTypeConfigurationsOutput) SetErrors(v []*BatchDescribeTypeConfigurationsError) *BatchDescribeTypeConfigurationsOutput {
	s.Errors = v
	return s
}

// SetTypeConfigurations sets the TypeConfigurations field's value.
func (s *BatchDescribeTypeConfigurationsOutput) SetTypeConfigurations(v []*TypeConfigurationDetails) *BatchDescribeTypeConfigurationsOutput {
	s.TypeConfigurations = v
	return s
}

// SetUnprocessedTypeConfigurations sets the UnprocessedTypeConfigurations field's value.
func (s *BatchDescribeTypeConfigurationsOutput) SetUnprocessedTypeConfigurations(v []*TypeConfigurationIdentifier) *BatchDescribeTypeConfigurationsOutput {
	s.UnprocessedTypeConfigurations = v
	return s
}

// The input for the CancelUpdateStack action.
type CancelUpdateStackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this CancelUpdateStack request. Specify this token
	// if you plan to retry requests so that CloudFormation knows that you're not
	// attempting to cancel an update on a stack with the same name. You might retry
	// CancelUpdateStack requests to ensure that CloudFormation successfully received
	// them.
	ClientRequestToken *string `min:"1" type:"string"`

	//
	// If you don't pass a parameter to StackName, the API returns a response that
	// describes all resources in the account.
	//
	// The IAM policy below can be added to IAM policies when you want to limit
	// resource-level permissions and avoid returning a response when no parameter
	// is sent in the request:
	//
	// { "Version": "2012-10-17", "Statement": [{ "Effect": "Deny", "Action": "cloudformation:DescribeStacks",
	// "NotResource": "arn:aws:cloudformation:*:*:stack/*/*" }] }
	//
	// The name or the unique stack ID that's associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelUpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelUpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelUpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelUpdateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CancelUpdateStackInput) SetClientRequestToken(v string) *CancelUpdateStackInput {
	s.ClientRequestToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CancelUpdateStackInput) SetStackName(v string) *CancelUpdateStackInput {
	s.StackName = &v
	return s
}

type CancelUpdateStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelUpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelUpdateStackOutput) GoString() string {
	return s.String()
}

// The Change structure describes the changes CloudFormation will perform if
// you execute the change set.
type Change struct {
	_ struct{} `type:"structure"`

	// Is either null, if no hooks invoke for the resource, or contains the number
	// of hooks that will invoke for the resource.
	HookInvocationCount *int64 `min:"1" type:"integer"`

	// A ResourceChange structure that describes the resource and action that CloudFormation
	// will perform.
	ResourceChange *ResourceChange `type:"structure"`

	// The type of entity that CloudFormation changes. Currently, the only entity
	// type is Resource.
	Type *string `type:"string" enum:"ChangeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Change) GoString() string {
	return s.String()
}

// SetHookInvocationCount sets the HookInvocationCount field's value.
func (s *Change) SetHookInvocationCount(v int64) *Change {
	s.HookInvocationCount = &v
	return s
}

// SetResourceChange sets the ResourceChange field's value.
func (s *Change) SetResourceChange(v *ResourceChange) *Change {
	s.ResourceChange = v
	return s
}

// SetType sets the Type field's value.
func (s *Change) SetType(v string) *Change {
	s.Type = &v
	return s
}

// Specifies the resource, the hook, and the hook version to be invoked.
type ChangeSetHook struct {
	_ struct{} `type:"structure"`

	// Specify the hook failure mode for non-compliant resources in the followings
	// ways.
	//
	//    * FAIL Stops provisioning resources.
	//
	//    * WARN Allows provisioning to continue with a warning message.
	FailureMode *string `type:"string" enum:"HookFailureMode"`

	// Specifies the points in provisioning logic where a hook is invoked.
	InvocationPoint *string `type:"string" enum:"HookInvocationPoint"`

	// Specifies details about the target that the hook will run against.
	TargetDetails *ChangeSetHookTargetDetails `type:"structure"`

	// The version ID of the type configuration.
	TypeConfigurationVersionId *string `min:"1" type:"string"`

	// The unique name for your hook. Specifies a three-part namespace for your
	// hook, with a recommended pattern of Organization::Service::Hook.
	//
	// The following organization namespaces are reserved and can't be used in your
	// hook type names:
	//
	//    * Alexa
	//
	//    * AMZN
	//
	//    * Amazon
	//
	//    * ASK
	//
	//    * AWS
	//
	//    * Custom
	//
	//    * Dev
	TypeName *string `min:"10" type:"string"`

	// The version ID of the type specified.
	TypeVersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetHook) GoString() string {
	return s.String()
}

// SetFailureMode sets the FailureMode field's value.
func (s *ChangeSetHook) SetFailureMode(v string) *ChangeSetHook {
	s.FailureMode = &v
	return s
}

// SetInvocationPoint sets the InvocationPoint field's value.
func (s *ChangeSetHook) SetInvocationPoint(v string) *ChangeSetHook {
	s.InvocationPoint = &v
	return s
}

// SetTargetDetails sets the TargetDetails field's value.
func (s *ChangeSetHook) SetTargetDetails(v *ChangeSetHookTargetDetails) *ChangeSetHook {
	s.TargetDetails = v
	return s
}

// SetTypeConfigurationVersionId sets the TypeConfigurationVersionId field's value.
func (s *ChangeSetHook) SetTypeConfigurationVersionId(v string) *ChangeSetHook {
	s.TypeConfigurationVersionId = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ChangeSetHook) SetTypeName(v string) *ChangeSetHook {
	s.TypeName = &v
	return s
}

// SetTypeVersionId sets the TypeVersionId field's value.
func (s *ChangeSetHook) SetTypeVersionId(v string) *ChangeSetHook {
	s.TypeVersionId = &v
	return s
}

// Specifies RESOURCE type target details for activated hooks.
type ChangeSetHookResourceTargetDetails struct {
	_ struct{} `type:"structure"`

	// The resource's logical ID, which is defined in the stack's template.
	LogicalResourceId *string `type:"string"`

	// Specifies the action of the resource.
	ResourceAction *string `type:"string" enum:"ChangeAction"`

	// The type of CloudFormation resource, such as AWS::S3::Bucket.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetHookResourceTargetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetHookResourceTargetDetails) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ChangeSetHookResourceTargetDetails) SetLogicalResourceId(v string) *ChangeSetHookResourceTargetDetails {
	s.LogicalResourceId = &v
	return s
}

// SetResourceAction sets the ResourceAction field's value.
func (s *ChangeSetHookResourceTargetDetails) SetResourceAction(v string) *ChangeSetHookResourceTargetDetails {
	s.ResourceAction = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ChangeSetHookResourceTargetDetails) SetResourceType(v string) *ChangeSetHookResourceTargetDetails {
	s.ResourceType = &v
	return s
}

// Specifies target details for an activated hook.
type ChangeSetHookTargetDetails struct {
	_ struct{} `type:"structure"`

	// Required if TargetType is RESOURCE.
	ResourceTargetDetails *ChangeSetHookResourceTargetDetails `type:"structure"`

	// The name of the type.
	TargetType *string `type:"string" enum:"HookTargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetHookTargetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetHookTargetDetails) GoString() string {
	return s.String()
}

// SetResourceTargetDetails sets the ResourceTargetDetails field's value.
func (s *ChangeSetHookTargetDetails) SetResourceTargetDetails(v *ChangeSetHookResourceTargetDetails) *ChangeSetHookTargetDetails {
	s.ResourceTargetDetails = v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *ChangeSetHookTargetDetails) SetTargetType(v string) *ChangeSetHookTargetDetails {
	s.TargetType = &v
	return s
}

// The ChangeSetSummary structure describes a change set, its status, and the
// stack with which it's associated.
type ChangeSetSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp"`

	// Descriptive information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can't execute the change set, the status indicates why. For example,
	// a change set might be in an UNAVAILABLE state because CloudFormation is still
	// creating it or in an OBSOLETE state because the stack was already updated.
	ExecutionStatus *string `type:"string" enum:"ExecutionStatus"`

	// Indicates if the change set imports resources that already exist.
	ImportExistingResources *bool `type:"boolean"`

	// Specifies the current setting of IncludeNestedStacks for the change set.
	IncludeNestedStacks *bool `type:"boolean"`

	// The parent change set ID.
	ParentChangeSetId *string `min:"1" type:"string"`

	// The root change set ID.
	RootChangeSetId *string `min:"1" type:"string"`

	// The ID of the stack with which the change set is associated.
	StackId *string `type:"string"`

	// The name of the stack with which the change set is associated.
	StackName *string `type:"string"`

	// The state of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status *string `type:"string" enum:"ChangeSetStatus"`

	// A description of the change set's status. For example, if your change set
	// is in the FAILED state, CloudFormation shows the error message.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetSummary) GoString() string {
	return s.String()
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *ChangeSetSummary) SetChangeSetId(v string) *ChangeSetSummary {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *ChangeSetSummary) SetChangeSetName(v string) *ChangeSetSummary {
	s.ChangeSetName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ChangeSetSummary) SetCreationTime(v time.Time) *ChangeSetSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ChangeSetSummary) SetDescription(v string) *ChangeSetSummary {
	s.Description = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *ChangeSetSummary) SetExecutionStatus(v string) *ChangeSetSummary {
	s.ExecutionStatus = &v
	return s
}

// SetImportExistingResources sets the ImportExistingResources field's value.
func (s *ChangeSetSummary) SetImportExistingResources(v bool) *ChangeSetSummary {
	s.ImportExistingResources = &v
	return s
}

// SetIncludeNestedStacks sets the IncludeNestedStacks field's value.
func (s *ChangeSetSummary) SetIncludeNestedStacks(v bool) *ChangeSetSummary {
	s.IncludeNestedStacks = &v
	return s
}

// SetParentChangeSetId sets the ParentChangeSetId field's value.
func (s *ChangeSetSummary) SetParentChangeSetId(v string) *ChangeSetSummary {
	s.ParentChangeSetId = &v
	return s
}

// SetRootChangeSetId sets the RootChangeSetId field's value.
func (s *ChangeSetSummary) SetRootChangeSetId(v string) *ChangeSetSummary {
	s.RootChangeSetId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *ChangeSetSummary) SetStackId(v string) *ChangeSetSummary {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ChangeSetSummary) SetStackName(v string) *ChangeSetSummary {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeSetSummary) SetStatus(v string) *ChangeSetSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ChangeSetSummary) SetStatusReason(v string) *ChangeSetSummary {
	s.StatusReason = &v
	return s
}

// The input for the ContinueUpdateRollback action.
type ContinueUpdateRollbackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this ContinueUpdateRollback request. Specify this
	// token if you plan to retry requests so that CloudFormation knows that you're
	// not attempting to continue the rollback to a stack with the same name. You
	// might retry ContinueUpdateRollback requests to ensure that CloudFormation
	// successfully received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// A list of the logical IDs of the resources that CloudFormation skips during
	// the continue update rollback operation. You can specify only resources that
	// are in the UPDATE_FAILED state because a rollback failed. You can't specify
	// resources that are in the UPDATE_FAILED state for other reasons, for example,
	// because an update was canceled. To check why a resource update failed, use
	// the DescribeStackResources action, and view the resource status reason.
	//
	// Specify this property to skip rolling back resources that CloudFormation
	// can't successfully roll back. We recommend that you troubleshoot (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
	// resources before skipping them. CloudFormation sets the status of the specified
	// resources to UPDATE_COMPLETE and continues to roll back the stack. After
	// the rollback is complete, the state of the skipped resources will be inconsistent
	// with the state of the resources in the stack template. Before performing
	// another stack update, you must update the stack or resources to be consistent
	// with each other. If you don't, subsequent stack updates might fail, and the
	// stack will become unrecoverable.
	//
	// Specify the minimum number of resources required to successfully roll back
	// your stack. For example, a failed resource update might cause dependent resources
	// to fail. In this case, it might not be necessary to skip the dependent resources.
	//
	// To skip resources that are part of nested stacks, use the following format:
	// NestedStackName.ResourceLogicalID. If you want to specify the logical ID
	// of a stack resource (Type: AWS::CloudFormation::Stack) in the ResourcesToSkip
	// list, then its corresponding embedded stack must be in one of the following
	// states: DELETE_IN_PROGRESS, DELETE_COMPLETE, or DELETE_FAILED.
	//
	// Don't confuse a child stack's name with its corresponding logical ID defined
	// in the parent stack. For an example of a continue update rollback operation
	// with nested stacks, see Using ResourcesToSkip to recover a nested stacks
	// hierarchy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks).
	ResourcesToSkip []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an Identity and Access Management (IAM)
	// role that CloudFormation assumes to roll back the stack. CloudFormation uses
	// the role's credentials to make calls on your behalf. CloudFormation always
	// uses this role for all future operations on the stack. Provided that users
	// have permission to operate on the stack, CloudFormation uses this role even
	// if the users don't have permission to pass it. Ensure that the role grants
	// least permission.
	//
	// If you don't specify a value, CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, CloudFormation uses a
	// temporary session that's generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique ID of the stack that you want to continue rolling
	// back.
	//
	// Don't specify the name of a nested stack (a stack that was created by using
	// the AWS::CloudFormation::Stack resource). Instead, use this operation on
	// the parent stack (the stack that contains the AWS::CloudFormation::Stack
	// resource).
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContinueUpdateRollbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContinueUpdateRollbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinueUpdateRollbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinueUpdateRollbackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *ContinueUpdateRollbackInput) SetClientRequestToken(v string) *ContinueUpdateRollbackInput {
	s.ClientRequestToken = &v
	return s
}

// SetResourcesToSkip sets the ResourcesToSkip field's value.
func (s *ContinueUpdateRollbackInput) SetResourcesToSkip(v []*string) *ContinueUpdateRollbackInput {
	s.ResourcesToSkip = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ContinueUpdateRollbackInput) SetRoleARN(v string) *ContinueUpdateRollbackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ContinueUpdateRollbackInput) SetStackName(v string) *ContinueUpdateRollbackInput {
	s.StackName = &v
	return s
}

// The output for a ContinueUpdateRollback operation.
type ContinueUpdateRollbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContinueUpdateRollbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContinueUpdateRollbackOutput) GoString() string {
	return s.String()
}

// The input for the CreateChangeSet action.
type CreateChangeSetInput struct {
	_ struct{} `type:"structure"`

	// In some cases, you must explicitly acknowledge that your stack template contains
	// certain capabilities in order for CloudFormation to create the stack.
	//
	//    * CAPABILITY_IAM and CAPABILITY_NAMED_IAM Some stack templates might include
	//    resources that can affect permissions in your Amazon Web Services account;
	//    for example, by creating new Identity and Access Management (IAM) users.
	//    For those stacks, you must explicitly acknowledge this by specifying one
	//    of these capabilities. The following IAM resources require you to specify
	//    either the CAPABILITY_IAM or CAPABILITY_NAMED_IAM capability. If you have
	//    IAM resources, you can specify either capability. If you have IAM resources
	//    with custom names, you must specify CAPABILITY_NAMED_IAM. If you don't
	//    specify either of these capabilities, CloudFormation returns an InsufficientCapabilities
	//    error. If your stack template contains these resources, we suggest that
	//    you review all permissions associated with them and edit their permissions
	//    if necessary. AWS::IAM::AccessKey (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
	//    AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
	//    AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
	//    AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
	//    AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
	//    AWS::IAM::User (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
	//    AWS::IAM::UserToGroupAddition (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
	//    For more information, see Acknowledging IAM resources in CloudFormation
	//    templates (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	//
	//    * CAPABILITY_AUTO_EXPAND Some template contain macros. Macros perform
	//    custom processing on templates; this can include simple actions like find-and-replace
	//    operations, all the way to extensive transformations of entire templates.
	//    Because of this, users typically create a change set from the processed
	//    template, so that they can review the changes resulting from the macros
	//    before actually creating the stack. If your stack template contains one
	//    or more macros, and you choose to create a stack directly from the processed
	//    template, without first reviewing the resulting changes in a change set,
	//    you must acknowledge this capability. This includes the AWS::Include (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
	//    and AWS::Serverless (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
	//    transforms, which are macros hosted by CloudFormation. This capacity doesn't
	//    apply to creating change sets, and specifying it when creating change
	//    sets has no effect. If you want to create a stack from a stack template
	//    that contains macros and nested stacks, you must create or update the
	//    stack directly from the template using the CreateStack or UpdateStack
	//    action, and specifying this capability. For more information about macros,
	//    see Using CloudFormation macros to perform custom processing on templates
	//    (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
	//
	// Only one of the Capabilities and ResourceType parameters can be specified.
	Capabilities []*string `type:"list" enum:"Capability"`

	// The name of the change set. The name must be unique among all change sets
	// that are associated with the specified stack.
	//
	// A change set name can contain only alphanumeric, case sensitive characters,
	// and hyphens. It must start with an alphabetical character and can't exceed
	// 128 characters.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// The type of change set operation. To create a change set for a new stack,
	// specify CREATE. To create a change set for an existing stack, specify UPDATE.
	// To create a change set for an import operation, specify IMPORT.
	//
	// If you create a change set for a new stack, CloudFormation creates a stack
	// with a unique stack ID, but no template or resources. The stack will be in
	// the REVIEW_IN_PROGRESS (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995)
	// state until you execute the change set.
	//
	// By default, CloudFormation specifies UPDATE. You can't use the UPDATE type
	// to create a change set for a new stack or the CREATE type to create a change
	// set for an existing stack.
	ChangeSetType *string `type:"string" enum:"ChangeSetType"`

	// A unique identifier for this CreateChangeSet request. Specify this token
	// if you plan to retry requests so that CloudFormation knows that you're not
	// attempting to create another change set with the same name. You might retry
	// CreateChangeSet requests to ensure that CloudFormation successfully received
	// them.
	ClientToken *string `min:"1" type:"string"`

	// A description to help you identify this change set.
	Description *string `min:"1" type:"string"`

	// Indicates if the change set imports resources that already exist.
	//
	// This parameter can only import resources that have custom names in templates.
	// For more information, see name type (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html)
	// in the CloudFormation User Guide. To import resources that do not accept
	// custom names, such as EC2 instances, use the resource import feature instead.
	// For more information, see Bringing existing resources into CloudFormation
	// management (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import.html)
	// in the CloudFormation User Guide.
	ImportExistingResources *bool `type:"boolean"`

	// Creates a change set for the all nested stacks specified in the template.
	// The default behavior of this action is set to False. To include nested sets
	// in a change set, specify True.
	IncludeNestedStacks *bool `type:"boolean"`

	// The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon
	// SNS) topics that CloudFormation associates with the stack. To remove all
	// associated notification topics, specify an empty list.
	NotificationARNs []*string `type:"list"`

	// Determines what action will be taken if stack creation fails. If this parameter
	// is specified, the DisableRollback parameter to the ExecuteChangeSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html)
	// API operation must not be specified. This must be one of these values:
	//
	//    * DELETE - Deletes the change set if the stack creation fails. This is
	//    only valid when the ChangeSetType parameter is set to CREATE. If the deletion
	//    of the stack fails, the status of the stack is DELETE_FAILED.
	//
	//    * DO_NOTHING - if the stack creation fails, do nothing. This is equivalent
	//    to specifying true for the DisableRollback parameter to the ExecuteChangeSet
	//    (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html)
	//    API operation.
	//
	//    * ROLLBACK - if the stack creation fails, roll back the stack. This is
	//    equivalent to specifying false for the DisableRollback parameter to the
	//    ExecuteChangeSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html)
	//    API operation.
	//
	// For nested stacks, when the OnStackFailure parameter is set to DELETE for
	// the change set for the parent stack, any failure in a child stack will cause
	// the parent stack creation to fail and all stacks to be deleted.
	OnStackFailure *string `type:"string" enum:"OnStackFailure"`

	// A list of Parameter structures that specify input parameters for the change
	// set. For more information, see the Parameter data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with if you
	// execute this change set, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	//
	// If the list of resource types doesn't include a resource type that you're
	// updating, the stack update fails. By default, CloudFormation grants permissions
	// to all resource types. Identity and Access Management (IAM) uses this parameter
	// for condition keys in IAM policies for CloudFormation. For more information,
	// see Controlling access with Identity and Access Management (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html)
	// in the CloudFormation User Guide.
	//
	// Only one of the Capabilities and ResourceType parameters can be specified.
	ResourceTypes []*string `type:"list"`

	// The resources to import into your stack.
	ResourcesToImport []*ResourceToImport `type:"list"`

	// The Amazon Resource Name (ARN) of an Identity and Access Management (IAM)
	// role that CloudFormation assumes when executing the change set. CloudFormation
	// uses the role's credentials to make calls on your behalf. CloudFormation
	// uses this role for all future operations on the stack. Provided that users
	// have permission to operate on the stack, CloudFormation uses this role even
	// if the users don't have permission to pass it. Ensure that the role grants
	// least permission.
	//
	// If you don't specify a value, CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, CloudFormation uses a
	// temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The name or the unique ID of the stack for which you are creating a change
	// set. CloudFormation generates the change set by comparing this stack's information
	// with the information that you submit, such as a modified template or different
	// parameter input values.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// Key-value pairs to associate with this stack. CloudFormation also propagates
	// these tags to resources in the stack. You can specify a maximum of 50 tags.
	Tags []*Tag `type:"list"`

	// A structure that contains the body of the revised template, with a minimum
	// length of 1 byte and a maximum length of 51,200 bytes. CloudFormation generates
	// the change set by comparing this template with the template of the stack
	// that you specified.
	//
	// Conditional: You must specify only TemplateBody or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the revised template. The URL must
	// point to a template (max size: 460,800 bytes) that's located in an Amazon
	// S3 bucket or a Systems Manager document. CloudFormation generates the change
	// set by comparing this template with the stack that you specified. The location
	// for an Amazon S3 bucket must start with https://.
	//
	// Conditional: You must specify only TemplateBody or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`

	// Whether to reuse the template that's associated with the stack to create
	// the change set.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.ResourcesToImport != nil {
		for i, v := range s.ResourcesToImport {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourcesToImport", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateChangeSetInput) SetCapabilities(v []*string) *CreateChangeSetInput {
	s.Capabilities = v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *CreateChangeSetInput) SetChangeSetName(v string) *CreateChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetChangeSetType sets the ChangeSetType field's value.
func (s *CreateChangeSetInput) SetChangeSetType(v string) *CreateChangeSetInput {
	s.ChangeSetType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateChangeSetInput) SetClientToken(v string) *CreateChangeSetInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateChangeSetInput) SetDescription(v string) *CreateChangeSetInput {
	s.Description = &v
	return s
}

// SetImportExistingResources sets the ImportExistingResources field's value.
func (s *CreateChangeSetInput) SetImportExistingResources(v bool) *CreateChangeSetInput {
	s.ImportExistingResources = &v
	return s
}

// SetIncludeNestedStacks sets the IncludeNestedStacks field's value.
func (s *CreateChangeSetInput) SetIncludeNestedStacks(v bool) *CreateChangeSetInput {
	s.IncludeNestedStacks = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *CreateChangeSetInput) SetNotificationARNs(v []*string) *CreateChangeSetInput {
	s.NotificationARNs = v
	return s
}

// SetOnStackFailure sets the OnStackFailure field's value.
func (s *CreateChangeSetInput) SetOnStackFailure(v string) *CreateChangeSetInput {
	s.OnStackFailure = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateChangeSetInput) SetParameters(v []*Parameter) *CreateChangeSetInput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateChangeSetInput) SetResourceTypes(v []*string) *CreateChangeSetInput {
	s.ResourceTypes = v
	return s
}

// SetResourcesToImport sets the ResourcesToImport field's value.
func (s *CreateChangeSetInput) SetResourcesToImport(v []*ResourceToImport) *CreateChangeSetInput {
	s.ResourcesToImport = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateChangeSetInput) SetRoleARN(v string) *CreateChangeSetInput {
	s.RoleARN = &v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *CreateChangeSetInput) SetRollbackConfiguration(v *RollbackConfiguration) *CreateChangeSetInput {
	s.RollbackConfiguration = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateChangeSetInput) SetStackName(v string) *CreateChangeSetInput {
	s.StackName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChangeSetInput) SetTags(v []*Tag) *CreateChangeSetInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateChangeSetInput) SetTemplateBody(v string) *CreateChangeSetInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *CreateChangeSetInput) SetTemplateURL(v string) *CreateChangeSetInput {
	s.TemplateURL = &v
	return s
}

// SetUsePreviousTemplate sets the UsePreviousTemplate field's value.
func (s *CreateChangeSetInput) SetUsePreviousTemplate(v bool) *CreateChangeSetInput {
	s.UsePreviousTemplate = &v
	return s
}

// The output for the CreateChangeSet action.
type CreateChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the change set.
	Id *string `min:"1" type:"string"`

	// The unique ID of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChangeSetOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateChangeSetOutput) SetId(v string) *CreateChangeSetOutput {
	s.Id = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateChangeSetOutput) SetStackId(v string) *CreateChangeSetOutput {
	s.StackId = &v
	return s
}

type CreateGeneratedTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name assigned to the generated template.
	//
	// GeneratedTemplateName is a required field
	GeneratedTemplateName *string `min:"1" type:"string" required:"true"`

	// An optional list of resources to be included in the generated template.
	//
	// If no resources are specified,the template will be created without any resources.
	// Resources can be added to the template using the UpdateGeneratedTemplate
	// API action.
	Resources []*ResourceDefinition `min:"1" type:"list"`

	// An optional name or ARN of a stack to use as the base stack for the generated
	// template.
	StackName *string `type:"string"`

	// The configuration details of the generated template, including the DeletionPolicy
	// and UpdateReplacePolicy.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGeneratedTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGeneratedTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGeneratedTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGeneratedTemplateInput"}
	if s.GeneratedTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneratedTemplateName"))
	}
	if s.GeneratedTemplateName != nil && len(*s.GeneratedTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeneratedTemplateName", 1))
	}
	if s.Resources != nil && len(s.Resources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resources", 1))
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeneratedTemplateName sets the GeneratedTemplateName field's value.
func (s *CreateGeneratedTemplateInput) SetGeneratedTemplateName(v string) *CreateGeneratedTemplateInput {
	s.GeneratedTemplateName = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateGeneratedTemplateInput) SetResources(v []*ResourceDefinition) *CreateGeneratedTemplateInput {
	s.Resources = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateGeneratedTemplateInput) SetStackName(v string) *CreateGeneratedTemplateInput {
	s.StackName = &v
	return s
}

// SetTemplateConfiguration sets the TemplateConfiguration field's value.
func (s *CreateGeneratedTemplateInput) SetTemplateConfiguration(v *TemplateConfiguration) *CreateGeneratedTemplateInput {
	s.TemplateConfiguration = v
	return s
}

type CreateGeneratedTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the generated template.
	GeneratedTemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGeneratedTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGeneratedTemplateOutput) GoString() string {
	return s.String()
}

// SetGeneratedTemplateId sets the GeneratedTemplateId field's value.
func (s *CreateGeneratedTemplateOutput) SetGeneratedTemplateId(v string) *CreateGeneratedTemplateOutput {
	s.GeneratedTemplateId = &v
	return s
}

// The input for CreateStack action.
type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// In some cases, you must explicitly acknowledge that your stack template contains
	// certain capabilities in order for CloudFormation to create the stack.
	//
	//    * CAPABILITY_IAM and CAPABILITY_NAMED_IAM Some stack templates might include
	//    resources that can affect permissions in your Amazon Web Services account;
	//    for example, by creating new Identity and Access Management (IAM) users.
	//    For those stacks, you must explicitly acknowledge this by specifying one
	//    of these capabilities. The following IAM resources require you to specify
	//    either the CAPABILITY_IAM or CAPABILITY_NAMED_IAM capability. If you have
	//    IAM resources, you can specify either capability. If you have IAM resources
	//    with custom names, you must specify CAPABILITY_NAMED_IAM. If you don't
	//    specify either of these capabilities, CloudFormation returns an InsufficientCapabilities
	//    error. If your stack template contains these resources, we recommend that
	//    you review all permissions associated with them and edit their permissions
	//    if necessary. AWS::IAM::AccessKey (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
	//    AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
	//    AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
	//    AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
	//    AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
	//    AWS::IAM::User (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
	//    AWS::IAM::UserToGroupAddition (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
	//    For more information, see Acknowledging IAM Resources in CloudFormation
	//    Templates (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	//
	//    * CAPABILITY_AUTO_EXPAND Some template contain macros. Macros perform
	//    custom processing on templates; this can include simple actions like find-and-replace
	//    operations, all the way to extensive transformations of entire templates.
	//    Because of this, users typically create a change set from the processed
	//    template, so that they can review the changes resulting from the macros
	//    before actually creating the stack. If your stack template contains one
	//    or more macros, and you choose to create a stack directly from the processed
	//    template, without first reviewing the resulting changes in a change set,
	//    you must acknowledge this capability. This includes the AWS::Include (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
	//    and AWS::Serverless (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
	//    transforms, which are macros hosted by CloudFormation. If you want to
	//    create a stack from a stack template that contains macros and nested stacks,
	//    you must create the stack directly from the template using this capability.
	//    You should only create stacks directly from a stack template that contains
	//    macros if you know what processing the macro performs. Each macro relies
	//    on an underlying Lambda service function for processing stack templates.
	//    Be aware that the Lambda function owner can update the function operation
	//    without CloudFormation being notified. For more information, see Using
	//    CloudFormation macros to perform custom processing on templates (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
	//
	// Only one of the Capabilities and ResourceType parameters can be specified.
	Capabilities []*string `type:"list" enum:"Capability"`

	// A unique identifier for this CreateStack request. Specify this token if you
	// plan to retry requests so that CloudFormation knows that you're not attempting
	// to create a stack with the same name. You might retry CreateStack requests
	// to ensure that CloudFormation successfully received them.
	//
	// All events initiated by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// Set to true to disable rollback of the stack if stack creation failed. You
	// can specify either DisableRollback or OnFailure, but not both.
	//
	// Default: false
	DisableRollback *bool `type:"boolean"`

	// Whether to enable termination protection on the specified stack. If a user
	// attempts to delete a stack with termination protection enabled, the operation
	// fails and the stack remains unchanged. For more information, see Protecting
	// a Stack From Being Deleted (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
	// in the CloudFormation User Guide. Termination protection is deactivated on
	// stacks by default.
	//
	// For nested stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
	// termination protection is set on the root stack and can't be changed directly
	// on the nested stack.
	EnableTerminationProtection *bool `type:"boolean"`

	// The Amazon Simple Notification Service (Amazon SNS) topic ARNs to publish
	// stack related events. You can find your Amazon SNS topic ARNs using the Amazon
	// SNS console or your Command Line Interface (CLI).
	NotificationARNs []*string `type:"list"`

	// Determines what action will be taken if stack creation fails. This must be
	// one of: DO_NOTHING, ROLLBACK, or DELETE. You can specify either OnFailure
	// or DisableRollback, but not both.
	//
	// Default: ROLLBACK
	OnFailure *string `type:"string" enum:"OnFailure"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// create stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	// Use the following syntax to describe template resource types: AWS::* (for
	// all Amazon Web Services resources), Custom::* (for all custom resources),
	// Custom::logical_ID (for a specific custom resource), AWS::service_name::*
	// (for all resources of a particular Amazon Web Services service), and AWS::service_name::resource_logical_ID
	// (for a specific Amazon Web Services resource).
	//
	// If the list of resource types doesn't include a resource that you're creating,
	// the stack creation fails. By default, CloudFormation grants permissions to
	// all resource types. Identity and Access Management (IAM) uses this parameter
	// for CloudFormation-specific condition keys in IAM policies. For more information,
	// see Controlling Access with Identity and Access Management (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	//
	// Only one of the Capabilities and ResourceType parameters can be specified.
	ResourceTypes []*string `type:"list"`

	// When set to true, newly created resources are deleted when the operation
	// rolls back. This includes newly created resources marked with a deletion
	// policy of Retain.
	//
	// Default: false
	RetainExceptOnCreate *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an Identity and Access Management (IAM)
	// role that CloudFormation assumes to create the stack. CloudFormation uses
	// the role's credentials to make calls on your behalf. CloudFormation always
	// uses this role for all future operations on the stack. Provided that users
	// have permission to operate on the stack, CloudFormation uses this role even
	// if the users don't have permission to pass it. Ensure that the role grants
	// least privilege.
	//
	// If you don't specify a value, CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, CloudFormation uses a
	// temporary session that's generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// The name that's associated with the stack. The name must be unique in the
	// Region in which you are creating the stack.
	//
	// A stack name can contain only alphanumeric characters (case sensitive) and
	// hyphens. It must start with an alphabetical character and can't be longer
	// than 128 characters.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to Prevent
	// Updates to Stack Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (maximum size: 16 KB) located in an S3 bucket in the same Region as the stack.
	// The location for an Amazon S3 bucket must start with https://. You can specify
	// either the StackPolicyBody or the StackPolicyURL parameter, but not both.
	StackPolicyURL *string `min:"1" type:"string"`

	// Key-value pairs to associate with this stack. CloudFormation also propagates
	// these tags to the resources created in the stack. A maximum number of 50
	// tags can be specified.
	Tags []*Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template anatomy
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that's located in an Amazon S3 bucket or a Systems
	// Manager document. For more information, go to the Template anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide. The location for an Amazon S3 bucket must
	// start with https://.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// The amount of time that can pass before the stack status becomes CREATE_FAILED;
	// if DisableRollback is not set or is set to false, the stack will be rolled
	// back.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyURL", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutes", 1))
	}
	if s.RollbackConfiguration != nil {
		if err := s.RollbackConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RollbackConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateStackInput) SetCapabilities(v []*string) *CreateStackInput {
	s.Capabilities = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateStackInput) SetClientRequestToken(v string) *CreateStackInput {
	s.ClientRequestToken = &v
	return s
}

// SetDisableRollback sets the DisableRollback field's value.
func (s *CreateStackInput) SetDisableRollback(v bool) *CreateStackInput {
	s.DisableRollback = &v
	return s
}

// SetEnableTerminationProtection sets the EnableTerminationProtection field's value.
func (s *CreateStackInput) SetEnableTerminationProtection(v bool) *CreateStackInput {
	s.EnableTerminationProtection = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *CreateStackInput) SetNotificationARNs(v []*string) *CreateStackInput {
	s.NotificationARNs = v
	return s
}

// SetOnFailure sets the OnFailure field's value.
func (s *CreateStackInput) SetOnFailure(v string) *CreateStackInput {
	s.OnFailure = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateStackInput) SetParameters(v []*Parameter) *CreateStackInput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateStackInput) SetResourceTypes(v []*string) *CreateStackInput {
	s.ResourceTypes = v
	return s
}

// SetRetainExceptOnCreate sets the RetainExceptOnCreate field's value.
func (s *CreateStackInput) SetRetainExceptOnCreate(v bool) *CreateStackInput {
	s.RetainExceptOnCreate = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateStackInput) SetRoleARN(v string) *CreateStackInput {
	s.RoleARN = &v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *CreateStackInput) SetRollbackConfiguration(v *RollbackConfiguration) *CreateStackInput {
	s.RollbackConfiguration = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateStackInput) SetStackName(v string) *CreateStackInput {
	s.StackName = &v
	return s
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *CreateStackInput) SetStackPolicyBody(v string) *CreateStackInput {
	s.StackPolicyBody = &v
	return s
}

// SetStackPolicyURL sets the StackPolicyURL field's value.
func (s *CreateStackInput) SetStackPolicyURL(v string) *CreateStackInput {
	s.StackPolicyURL = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStackInput) SetTags(v []*Tag) *CreateStackInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateStackInput) SetTemplateBody(v string) *CreateStackInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *CreateStackInput) SetTemplateURL(v string) *CreateStackInput {
	s.TemplateURL = &v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *CreateStackInput) SetTimeoutInMinutes(v int64) *CreateStackInput {
	s.TimeoutInMinutes = &v
	return s
}

type CreateStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// [Self-managed permissions] The names of one or more Amazon Web Services accounts
	// that you want to create stack instances in the specified Region(s) for.
	//
	// You can specify Accounts or DeploymentTargets, but not both.
	Accounts []*string `type:"list"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// [Service-managed permissions] The Organizations accounts for which to create
	// stack instances in the specified Amazon Web Services Regions.
	//
	// You can specify Accounts or DeploymentTargets, but not both.
	DeploymentTargets *DeploymentTargets `type:"structure"`

	// The unique identifier for this stack set operation.
	//
	// The operation ID also functions as an idempotency token, to ensure that CloudFormation
	// performs the stack set operation only once, even if you retry the request
	// multiple times. You might retry stack set operation requests to ensure that
	// CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// A list of stack set parameters whose values you want to override in the selected
	// stack instances.
	//
	// Any overridden parameter values will be applied to all stack instances in
	// the specified accounts and Amazon Web Services Regions. When specifying parameters
	// and their values, be aware of how CloudFormation sets parameter values during
	// stack instance operations:
	//
	//    * To override the current value for a parameter, include the parameter
	//    and specify its value.
	//
	//    * To leave an overridden parameter set to its present value, include the
	//    parameter and specify UsePreviousValue as true. (You can't specify both
	//    a value and set UsePreviousValue to true.)
	//
	//    * To set an overridden parameter back to the value specified in the stack
	//    set, specify a parameter list but don't include the parameter in the list.
	//
	//    * To leave all parameters set to their present values, don't specify this
	//    property at all.
	//
	// During stack set updates, any parameter values overridden for a stack instance
	// aren't updated, but retain their overridden value.
	//
	// You can only override the parameter values that are specified in the stack
	// set; to add or delete a parameter itself, use UpdateStackSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
	// to update the stack set template.
	ParameterOverrides []*Parameter `type:"list"`

	// The names of one or more Amazon Web Services Regions where you want to create
	// stack instances using the specified Amazon Web Services accounts.
	//
	// Regions is a required field
	Regions []*string `type:"list" required:"true"`

	// The name or unique ID of the stack set that you want to create stack instances
	// from.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInstancesInput"}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.DeploymentTargets != nil {
		if err := s.DeploymentTargets.Validate(); err != nil {
			invalidParams.AddNested("DeploymentTargets", err.(request.ErrInvalidParams))
		}
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *CreateStackInstancesInput) SetAccounts(v []*string) *CreateStackInstancesInput {
	s.Accounts = v
	return s
}

// SetCallAs sets the CallAs field's value.
func (s *CreateStackInstancesInput) SetCallAs(v string) *CreateStackInstancesInput {
	s.CallAs = &v
	return s
}

// SetDeploymentTargets sets the DeploymentTargets field's value.
func (s *CreateStackInstancesInput) SetDeploymentTargets(v *DeploymentTargets) *CreateStackInstancesInput {
	s.DeploymentTargets = v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *CreateStackInstancesInput) SetOperationId(v string) *CreateStackInstancesInput {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *CreateStackInstancesInput) SetOperationPreferences(v *StackSetOperationPreferences) *CreateStackInstancesInput {
	s.OperationPreferences = v
	return s
}

// SetParameterOverrides sets the ParameterOverrides field's value.
func (s *CreateStackInstancesInput) SetParameterOverrides(v []*Parameter) *CreateStackInstancesInput {
	s.ParameterOverrides = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *CreateStackInstancesInput) SetRegions(v []*string) *CreateStackInstancesInput {
	s.Regions = v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *CreateStackInstancesInput) SetStackSetName(v string) *CreateStackInstancesInput {
	s.StackSetName = &v
	return s
}

type CreateStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackInstancesOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *CreateStackInstancesOutput) SetOperationId(v string) *CreateStackInstancesOutput {
	s.OperationId = &v
	return s
}

// The output for a CreateStack action.
type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *CreateStackOutput) SetStackId(v string) *CreateStackOutput {
	s.StackId = &v
	return s
}

type CreateStackSetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to use to create this stack
	// set.
	//
	// Specify an IAM role only if you are using customized administrator roles
	// to control which users or groups can manage specific stack sets within the
	// same administrator account. For more information, see Prerequisites: Granting
	// Permissions for Stack Set Operations (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// Describes whether StackSets automatically deploys to Organizations accounts
	// that are added to the target organization or organizational unit (OU). Specify
	// only if PermissionModel is SERVICE_MANAGED.
	AutoDeployment *AutoDeployment `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * To create a stack set with service-managed permissions while signed
	//    in to the management account, specify SELF.
	//
	//    * To create a stack set with service-managed permissions while signed
	//    in to a delegated administrator account, specify DELEGATED_ADMIN. Your
	//    Amazon Web Services account must be registered as a delegated admin in
	//    the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	//
	// Stack sets with service-managed permissions are created in the management
	// account, including stack sets that are created by delegated administrators.
	CallAs *string `type:"string" enum:"CallAs"`

	// In some cases, you must explicitly acknowledge that your stack set template
	// contains certain capabilities in order for CloudFormation to create the stack
	// set and related stack instances.
	//
	//    * CAPABILITY_IAM and CAPABILITY_NAMED_IAM Some stack templates might include
	//    resources that can affect permissions in your Amazon Web Services account;
	//    for example, by creating new Identity and Access Management (IAM) users.
	//    For those stack sets, you must explicitly acknowledge this by specifying
	//    one of these capabilities. The following IAM resources require you to
	//    specify either the CAPABILITY_IAM or CAPABILITY_NAMED_IAM capability.
	//    If you have IAM resources, you can specify either capability. If you have
	//    IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.
	//    If you don't specify either of these capabilities, CloudFormation returns
	//    an InsufficientCapabilities error. If your stack template contains these
	//    resources, we recommend that you review all permissions associated with
	//    them and edit their permissions if necessary. AWS::IAM::AccessKey (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
	//    AWS::IAM::Group (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
	//    AWS::IAM::InstanceProfile (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
	//    AWS::IAM::Policy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
	//    AWS::IAM::Role (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
	//    AWS::IAM::User (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
	//    AWS::IAM::UserToGroupAddition (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
	//    For more information, see Acknowledging IAM Resources in CloudFormation
	//    Templates (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	//
	//    * CAPABILITY_AUTO_EXPAND Some templates reference macros. If your stack
	//    set template references one or more macros, you must create the stack
	//    set directly from the processed template, without first reviewing the
	//    resulting changes in a change set. To create the stack set directly, you
	//    must acknowledge this capability. For more information, see Using CloudFormation
	//    Macros to Perform Custom Processing on Templates (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
	//    Stack sets with service-managed permissions don't currently support the
	//    use of macros in templates. (This includes the AWS::Include (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
	//    and AWS::Serverless (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
	//    transforms, which are macros hosted by CloudFormation.) Even if you specify
	//    this capability for a stack set with service-managed permissions, if you
	//    reference a macro in your template the stack set operation will fail.
	Capabilities []*string `type:"list" enum:"Capability"`

	// A unique identifier for this CreateStackSet request. Specify this token if
	// you plan to retry requests so that CloudFormation knows that you're not attempting
	// to create another stack set with the same name. You might retry CreateStackSet
	// requests to ensure that CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description of the stack set. You can use the description to identify the
	// stack set's purpose or other important information.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role to use to create the stack set. If you
	// do not specify an execution role, CloudFormation uses the AWSCloudFormationStackSetExecutionRole
	// role for the stack set operation.
	//
	// Specify an IAM role only if you are using customized execution roles to control
	// which stack resources users and groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// Describes whether StackSets performs non-conflicting operations concurrently
	// and queues conflicting operations.
	ManagedExecution *ManagedExecution `type:"structure"`

	// The input parameters for the stack set template.
	Parameters []*Parameter `type:"list"`

	// Describes how the IAM roles required for stack set operations are created.
	// By default, SELF-MANAGED is specified.
	//
	//    * With self-managed permissions, you must create the administrator and
	//    execution roles required to deploy to target accounts. For more information,
	//    see Grant Self-Managed Stack Set Permissions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
	//
	//    * With service-managed permissions, StackSets automatically creates the
	//    IAM roles required to deploy to accounts managed by Organizations. For
	//    more information, see Grant Service-Managed Stack Set Permissions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html).
	PermissionModel *string `type:"string" enum:"PermissionModels"`

	// The stack ID you are importing into a new stack set. Specify the Amazon Resource
	// Name (ARN) of the stack.
	StackId *string `type:"string"`

	// The name to associate with the stack set. The name must be unique in the
	// Region where you create your stack set.
	//
	// A stack name can contain only alphanumeric characters (case-sensitive) and
	// hyphens. It must start with an alphabetic character and can't be longer than
	// 128 characters.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`

	// The key-value pairs to associate with this stack set and the stacks created
	// from it. CloudFormation also propagates these tags to supported resources
	// that are created in the stacks. A maximum number of 50 tags can be specified.
	//
	// If you specify tags as part of a CreateStackSet action, CloudFormation checks
	// to see if you have the required IAM permission to tag resources. If you don't,
	// the entire CreateStackSet action fails with an access denied error, and the
	// stack set is not created.
	Tags []*Tag `type:"list"`

	// The structure that contains the template body, with a minimum length of 1
	// byte and a maximum length of 51,200 bytes. For more information, see Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the template body. The URL must point
	// to a template (maximum size: 460,800 bytes) that's located in an Amazon S3
	// bucket or a Systems Manager document. For more information, see Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackSetInput"}
	if s.AdministrationRoleARN != nil && len(*s.AdministrationRoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AdministrationRoleARN", 20))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ExecutionRoleName != nil && len(*s.ExecutionRoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleName", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdministrationRoleARN sets the AdministrationRoleARN field's value.
func (s *CreateStackSetInput) SetAdministrationRoleARN(v string) *CreateStackSetInput {
	s.AdministrationRoleARN = &v
	return s
}

// SetAutoDeployment sets the AutoDeployment field's value.
func (s *CreateStackSetInput) SetAutoDeployment(v *AutoDeployment) *CreateStackSetInput {
	s.AutoDeployment = v
	return s
}

// SetCallAs sets the CallAs field's value.
func (s *CreateStackSetInput) SetCallAs(v string) *CreateStackSetInput {
	s.CallAs = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateStackSetInput) SetCapabilities(v []*string) *CreateStackSetInput {
	s.Capabilities = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateStackSetInput) SetClientRequestToken(v string) *CreateStackSetInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStackSetInput) SetDescription(v string) *CreateStackSetInput {
	s.Description = &v
	return s
}

// SetExecutionRoleName sets the ExecutionRoleName field's value.
func (s *CreateStackSetInput) SetExecutionRoleName(v string) *CreateStackSetInput {
	s.ExecutionRoleName = &v
	return s
}

// SetManagedExecution sets the ManagedExecution field's value.
func (s *CreateStackSetInput) SetManagedExecution(v *ManagedExecution) *CreateStackSetInput {
	s.ManagedExecution = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateStackSetInput) SetParameters(v []*Parameter) *CreateStackSetInput {
	s.Parameters = v
	return s
}

// SetPermissionModel sets the PermissionModel field's value.
func (s *CreateStackSetInput) SetPermissionModel(v string) *CreateStackSetInput {
	s.PermissionModel = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateStackSetInput) SetStackId(v string) *CreateStackSetInput {
	s.StackId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *CreateStackSetInput) SetStackSetName(v string) *CreateStackSetInput {
	s.StackSetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStackSetInput) SetTags(v []*Tag) *CreateStackSetInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateStackSetInput) SetTemplateBody(v string) *CreateStackSetInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *CreateStackSetInput) SetTemplateURL(v string) *CreateStackSetInput {
	s.TemplateURL = &v
	return s
}

type CreateStackSetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the stack set that you're creating.
	StackSetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStackSetOutput) GoString() string {
	return s.String()
}

// SetStackSetId sets the StackSetId field's value.
func (s *CreateStackSetOutput) SetStackSetId(v string) *CreateStackSetOutput {
	s.StackSetId = &v
	return s
}

type DeactivateOrganizationsAccessInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateOrganizationsAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateOrganizationsAccessInput) GoString() string {
	return s.String()
}

type DeactivateOrganizationsAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateOrganizationsAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateOrganizationsAccessOutput) GoString() string {
	return s.String()
}

type DeactivateTypeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the extension, in this account and Region.
	//
	// Conditional: You must specify either Arn, or TypeName and Type.
	Arn *string `type:"string"`

	// The extension type.
	//
	// Conditional: You must specify either Arn, or TypeName and Type.
	Type *string `type:"string" enum:"ThirdPartyType"`

	// The type name of the extension, in this account and Region. If you specified
	// a type name alias when enabling the extension, use the type name alias.
	//
	// Conditional: You must specify either Arn, or TypeName and Type.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivateTypeInput"}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeactivateTypeInput) SetArn(v string) *DeactivateTypeInput {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *DeactivateTypeInput) SetType(v string) *DeactivateTypeInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DeactivateTypeInput) SetTypeName(v string) *DeactivateTypeInput {
	s.TypeName = &v
	return s
}

type DeactivateTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateTypeOutput) GoString() string {
	return s.String()
}

// The input for the DeleteChangeSet action.
type DeleteChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// delete.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// If you specified the name of a change set to delete, specify the stack name
	// or Amazon Resource Name (ARN) that's associated with it.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DeleteChangeSetInput) SetChangeSetName(v string) *DeleteChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DeleteChangeSetInput) SetStackName(v string) *DeleteChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the DeleteChangeSet action.
type DeleteChangeSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChangeSetOutput) GoString() string {
	return s.String()
}

type DeleteGeneratedTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of a generated template.
	//
	// GeneratedTemplateName is a required field
	GeneratedTemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGeneratedTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGeneratedTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGeneratedTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGeneratedTemplateInput"}
	if s.GeneratedTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneratedTemplateName"))
	}
	if s.GeneratedTemplateName != nil && len(*s.GeneratedTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeneratedTemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeneratedTemplateName sets the GeneratedTemplateName field's value.
func (s *DeleteGeneratedTemplateInput) SetGeneratedTemplateName(v string) *DeleteGeneratedTemplateInput {
	s.GeneratedTemplateName = &v
	return s
}

type DeleteGeneratedTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGeneratedTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGeneratedTemplateOutput) GoString() string {
	return s.String()
}

// The input for DeleteStack action.
type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this DeleteStack request. Specify this token if you
	// plan to retry requests so that CloudFormation knows that you're not attempting
	// to delete a stack with the same name. You might retry DeleteStack requests
	// to ensure that CloudFormation successfully received them.
	//
	// All events initiated by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// For stacks in the DELETE_FAILED state, a list of resource logical IDs that
	// are associated with the resources you want to retain. During deletion, CloudFormation
	// deletes the stack but doesn't delete the retained resources.
	//
	// Retaining resources is useful when you can't delete a resource, such as a
	// non-empty S3 bucket, but you want to delete the stack.
	RetainResources []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an Identity and Access Management (IAM)
	// role that CloudFormation assumes to delete the stack. CloudFormation uses
	// the role's credentials to make calls on your behalf.
	//
	// If you don't specify a value, CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, CloudFormation uses a
	// temporary session that's generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique stack ID that's associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteStackInput) SetClientRequestToken(v string) *DeleteStackInput {
	s.ClientRequestToken = &v
	return s
}

// SetRetainResources sets the RetainResources field's value.
func (s *DeleteStackInput) SetRetainResources(v []*string) *DeleteStackInput {
	s.RetainResources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *DeleteStackInput) SetRoleARN(v string) *DeleteStackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DeleteStackInput) SetStackName(v string) *DeleteStackInput {
	s.StackName = &v
	return s
}

type DeleteStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// [Self-managed permissions] The names of the Amazon Web Services accounts
	// that you want to delete stack instances for.
	//
	// You can specify Accounts or DeploymentTargets, but not both.
	Accounts []*string `type:"list"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// [Service-managed permissions] The Organizations accounts from which to delete
	// stack instances.
	//
	// You can specify Accounts or DeploymentTargets, but not both.
	DeploymentTargets *DeploymentTargets `type:"structure"`

	// The unique identifier for this stack set operation.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	//
	// The operation ID also functions as an idempotency token, to ensure that CloudFormation
	// performs the stack set operation only once, even if you retry the request
	// multiple times. You can retry stack set operation requests to ensure that
	// CloudFormation successfully received them.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// The Amazon Web Services Regions where you want to delete stack set instances.
	//
	// Regions is a required field
	Regions []*string `type:"list" required:"true"`

	// Removes the stack instances from the specified stack set, but doesn't delete
	// the stacks. You can't reassociate a retained stack or add an existing, saved
	// stack to a new stack set.
	//
	// For more information, see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
	//
	// RetainStacks is a required field
	RetainStacks *bool `type:"boolean" required:"true"`

	// The name or unique ID of the stack set that you want to delete stack instances
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInstancesInput"}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}
	if s.RetainStacks == nil {
		invalidParams.Add(request.NewErrParamRequired("RetainStacks"))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.DeploymentTargets != nil {
		if err := s.DeploymentTargets.Validate(); err != nil {
			invalidParams.AddNested("DeploymentTargets", err.(request.ErrInvalidParams))
		}
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *DeleteStackInstancesInput) SetAccounts(v []*string) *DeleteStackInstancesInput {
	s.Accounts = v
	return s
}

// SetCallAs sets the CallAs field's value.
func (s *DeleteStackInstancesInput) SetCallAs(v string) *DeleteStackInstancesInput {
	s.CallAs = &v
	return s
}

// SetDeploymentTargets sets the DeploymentTargets field's value.
func (s *DeleteStackInstancesInput) SetDeploymentTargets(v *DeploymentTargets) *DeleteStackInstancesInput {
	s.DeploymentTargets = v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *DeleteStackInstancesInput) SetOperationId(v string) *DeleteStackInstancesInput {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *DeleteStackInstancesInput) SetOperationPreferences(v *StackSetOperationPreferences) *DeleteStackInstancesInput {
	s.OperationPreferences = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *DeleteStackInstancesInput) SetRegions(v []*string) *DeleteStackInstancesInput {
	s.Regions = v
	return s
}

// SetRetainStacks sets the RetainStacks field's value.
func (s *DeleteStackInstancesInput) SetRetainStacks(v bool) *DeleteStackInstancesInput {
	s.RetainStacks = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DeleteStackInstancesInput) SetStackSetName(v string) *DeleteStackInstancesInput {
	s.StackSetName = &v
	return s
}

type DeleteStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackInstancesOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *DeleteStackInstancesOutput) SetOperationId(v string) *DeleteStackInstancesOutput {
	s.OperationId = &v
	return s
}

type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

type DeleteStackSetInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The name or unique ID of the stack set that you're deleting. You can obtain
	// this value by running ListStackSets.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackSetInput"}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *DeleteStackSetInput) SetCallAs(v string) *DeleteStackSetInput {
	s.CallAs = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DeleteStackSetInput) SetStackSetName(v string) *DeleteStackSetInput {
	s.StackSetName = &v
	return s
}

type DeleteStackSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStackSetOutput) GoString() string {
	return s.String()
}

// [Service-managed permissions] The Organizations accounts to which StackSets
// deploys. StackSets doesn't deploy stack instances to the organization management
// account, even if the organization management account is in your organization
// or in an OU in your organization.
//
// For update operations, you can specify either Accounts or OrganizationalUnitIds.
// For create and delete operations, specify OrganizationalUnitIds.
type DeploymentTargets struct {
	_ struct{} `type:"structure"`

	// Limit deployment targets to individual accounts or include additional accounts
	// with provided OUs.
	//
	// The following is a list of possible values for the AccountFilterType operation.
	//
	//    * INTERSECTION: StackSets deploys to the accounts specified in Accounts
	//    parameter.
	//
	//    * DIFFERENCE: StackSets excludes the accounts specified in Accounts parameter.
	//    This enables user to avoid certain accounts within an OU such as suspended
	//    accounts.
	//
	//    * UNION: StackSets includes additional accounts deployment targets. This
	//    is the default value if AccountFilterType is not provided. This enables
	//    user to update an entire OU and individual accounts from a different OU
	//    in one request, which used to be two separate requests.
	//
	//    * NONE: Deploys to all the accounts in specified organizational units
	//    (OU).
	AccountFilterType *string `type:"string" enum:"AccountFilterType"`

	// The names of one or more Amazon Web Services accounts for which you want
	// to deploy stack set updates.
	Accounts []*string `type:"list"`

	// Returns the value of the AccountsUrl property.
	AccountsUrl *string `min:"1" type:"string"`

	// The organization root ID or organizational unit (OU) IDs to which StackSets
	// deploys.
	OrganizationalUnitIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentTargets) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentTargets) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentTargets) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentTargets"}
	if s.AccountsUrl != nil && len(*s.AccountsUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountsUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountFilterType sets the AccountFilterType field's value.
func (s *DeploymentTargets) SetAccountFilterType(v string) *DeploymentTargets {
	s.AccountFilterType = &v
	return s
}

// SetAccounts sets the Accounts field's value.
func (s *DeploymentTargets) SetAccounts(v []*string) *DeploymentTargets {
	s.Accounts = v
	return s
}

// SetAccountsUrl sets the AccountsUrl field's value.
func (s *DeploymentTargets) SetAccountsUrl(v string) *DeploymentTargets {
	s.AccountsUrl = &v
	return s
}

// SetOrganizationalUnitIds sets the OrganizationalUnitIds field's value.
func (s *DeploymentTargets) SetOrganizationalUnitIds(v []*string) *DeploymentTargets {
	s.OrganizationalUnitIds = v
	return s
}

type DeregisterTypeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Arn *string `type:"string"`

	// The kind of extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Type *string `type:"string" enum:"RegistryType"`

	// The name of the extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	TypeName *string `min:"10" type:"string"`

	// The ID of a specific version of the extension. The version ID is the value
	// at the end of the Amazon Resource Name (ARN) assigned to the extension version
	// when it is registered.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterTypeInput"}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeregisterTypeInput) SetArn(v string) *DeregisterTypeInput {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *DeregisterTypeInput) SetType(v string) *DeregisterTypeInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DeregisterTypeInput) SetTypeName(v string) *DeregisterTypeInput {
	s.TypeName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeregisterTypeInput) SetVersionId(v string) *DeregisterTypeInput {
	s.VersionId = &v
	return s
}

type DeregisterTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterTypeOutput) GoString() string {
	return s.String()
}

// The input for the DescribeAccountLimits action.
type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of limits that you want to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountLimitsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountLimitsInput) SetNextToken(v string) *DescribeAccountLimitsInput {
	s.NextToken = &v
	return s
}

// The output for the DescribeAccountLimits action.
type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	// An account limit structure that contain a list of CloudFormation account
	// limits and their values.
	AccountLimits []*AccountLimit `type:"list"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of limits. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

// SetAccountLimits sets the AccountLimits field's value.
func (s *DescribeAccountLimitsOutput) SetAccountLimits(v []*AccountLimit) *DescribeAccountLimitsOutput {
	s.AccountLimits = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountLimitsOutput) SetNextToken(v string) *DescribeAccountLimitsOutput {
	s.NextToken = &v
	return s
}

type DescribeChangeSetHooksInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// describe.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// If specified, lists only the hooks related to the specified LogicalResourceId.
	LogicalResourceId *string `type:"string"`

	// A string, provided by the DescribeChangeSetHooks response output, that identifies
	// the next page of information that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// If you specified the name of a change set, specify the stack name or stack
	// ID (ARN) of the change set you want to describe.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetHooksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetHooksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChangeSetHooksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChangeSetHooksInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetHooksInput) SetChangeSetName(v string) *DescribeChangeSetHooksInput {
	s.ChangeSetName = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DescribeChangeSetHooksInput) SetLogicalResourceId(v string) *DescribeChangeSetHooksInput {
	s.LogicalResourceId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChangeSetHooksInput) SetNextToken(v string) *DescribeChangeSetHooksInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeChangeSetHooksInput) SetStackName(v string) *DescribeChangeSetHooksInput {
	s.StackName = &v
	return s
}

type DescribeChangeSetHooksOutput struct {
	_ struct{} `type:"structure"`

	// The change set identifier (stack ID).
	ChangeSetId *string `min:"1" type:"string"`

	// The change set name.
	ChangeSetName *string `min:"1" type:"string"`

	// List of hook objects.
	Hooks []*ChangeSetHook `type:"list"`

	// Pagination token, null or empty if no more results.
	NextToken *string `min:"1" type:"string"`

	// The stack identifier (stack ID).
	StackId *string `type:"string"`

	// The stack name.
	StackName *string `type:"string"`

	// Provides the status of the change set hook.
	Status *string `type:"string" enum:"ChangeSetHooksStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetHooksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetHooksOutput) GoString() string {
	return s.String()
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *DescribeChangeSetHooksOutput) SetChangeSetId(v string) *DescribeChangeSetHooksOutput {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetHooksOutput) SetChangeSetName(v string) *DescribeChangeSetHooksOutput {
	s.ChangeSetName = &v
	return s
}

// SetHooks sets the Hooks field's value.
func (s *DescribeChangeSetHooksOutput) SetHooks(v []*ChangeSetHook) *DescribeChangeSetHooksOutput {
	s.Hooks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChangeSetHooksOutput) SetNextToken(v string) *DescribeChangeSetHooksOutput {
	s.NextToken = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeChangeSetHooksOutput) SetStackId(v string) *DescribeChangeSetHooksOutput {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeChangeSetHooksOutput) SetStackName(v string) *DescribeChangeSetHooksOutput {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeChangeSetHooksOutput) SetStatus(v string) *DescribeChangeSetHooksOutput {
	s.Status = &v
	return s
}

// The input for the DescribeChangeSet action.
type DescribeChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// describe.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// A string (provided by the DescribeChangeSet response output) that identifies
	// the next page of information that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// If you specified the name of a change set, specify the stack name or ID (ARN)
	// of the change set you want to describe.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetInput) SetChangeSetName(v string) *DescribeChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChangeSetInput) SetNextToken(v string) *DescribeChangeSetInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeChangeSetInput) SetStackName(v string) *DescribeChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the DescribeChangeSet action.
type DescribeChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// If you execute the change set, the list of capabilities that were explicitly
	// acknowledged when the change set was created.
	Capabilities []*string `type:"list" enum:"Capability"`

	// The Amazon Resource Name (ARN) of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// A list of Change structures that describes the resources CloudFormation changes
	// if you execute the change set.
	Changes []*Change `type:"list"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp"`

	// Information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can't execute the change set, the status indicates why. For example,
	// a change set might be in an UNAVAILABLE state because CloudFormation is still
	// creating it or in an OBSOLETE state because the stack was already updated.
	ExecutionStatus *string `type:"string" enum:"ExecutionStatus"`

	// Indicates if the change set imports resources that already exist.
	//
	// This parameter can only import resources that have custom names (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html)
	// in templates. To import resources that do not accept custom names, such as
	// EC2 instances, use the resource import (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import.html)
	// feature instead.
	ImportExistingResources *bool `type:"boolean"`

	// Verifies if IncludeNestedStacks is set to True.
	IncludeNestedStacks *bool `type:"boolean"`

	// If the output exceeds 1 MB, a string that identifies the next page of changes.
	// If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that
	// will be associated with the stack if you execute the change set.
	NotificationARNs []*string `type:"list"`

	// Determines what action will be taken if stack creation fails. When this parameter
	// is specified, the DisableRollback parameter to the ExecuteChangeSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html)
	// API operation must not be specified. This must be one of these values:
	//
	//    * DELETE - Deletes the change set if the stack creation fails. This is
	//    only valid when the ChangeSetType parameter is set to CREATE. If the deletion
	//    of the stack fails, the status of the stack is DELETE_FAILED.
	//
	//    * DO_NOTHING - if the stack creation fails, do nothing. This is equivalent
	//    to specifying true for the DisableRollback parameter to the ExecuteChangeSet
	//    (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html)
	//    API operation.
	//
	//    * ROLLBACK - if the stack creation fails, roll back the stack. This is
	//    equivalent to specifying false for the DisableRollback parameter to the
	//    ExecuteChangeSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html)
	//    API operation.
	OnStackFailure *string `type:"string" enum:"OnStackFailure"`

	// A list of Parameter structures that describes the input parameters and their
	// values used to create the change set. For more information, see the Parameter
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// Specifies the change set ID of the parent change set in the current nested
	// change set hierarchy.
	ParentChangeSetId *string `min:"1" type:"string"`

	// The rollback triggers for CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// Specifies the change set ID of the root change set in the current nested
	// change set hierarchy.
	RootChangeSetId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the stack that's associated with the change
	// set.
	StackId *string `type:"string"`

	// The name of the stack that's associated with the change set.
	StackName *string `type:"string"`

	// The current status of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status *string `type:"string" enum:"ChangeSetStatus"`

	// A description of the change set's status. For example, if your attempt to
	// create a change set failed, CloudFormation shows the error message.
	StatusReason *string `type:"string"`

	// If you execute the change set, the tags that will be associated with the
	// stack.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *DescribeChangeSetOutput) SetCapabilities(v []*string) *DescribeChangeSetOutput {
	s.Capabilities = v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *DescribeChangeSetOutput) SetChangeSetId(v string) *DescribeChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetOutput) SetChangeSetName(v string) *DescribeChangeSetOutput {
	s.ChangeSetName = &v
	return s
}

// SetChanges sets the Changes field's value.
func (s *DescribeChangeSetOutput) SetChanges(v []*Change) *DescribeChangeSetOutput {
	s.Changes = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeChangeSetOutput) SetCreationTime(v time.Time) *DescribeChangeSetOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeChangeSetOutput) SetDescription(v string) *DescribeChangeSetOutput {
	s.Description = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *DescribeChangeSetOutput) SetExecutionStatus(v string) *DescribeChangeSetOutput {
	s.ExecutionStatus = &v
	return s
}

// SetImportExistingResources sets the ImportExistingResources field's value.
func (s *DescribeChangeSetOutput) SetImportExistingResources(v bool) *DescribeChangeSetOutput {
	s.ImportExistingResources = &v
	return s
}

// SetIncludeNestedStacks sets the IncludeNestedStacks field's value.
func (s *DescribeChangeSetOutput) SetIncludeNestedStacks(v bool) *DescribeChangeSetOutput {
	s.IncludeNestedStacks = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChangeSetOutput) SetNextToken(v string) *DescribeChangeSetOutput {
	s.NextToken = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *DescribeChangeSetOutput) SetNotificationARNs(v []*string) *DescribeChangeSetOutput {
	s.NotificationARNs = v
	return s
}

// SetOnStackFailure sets the OnStackFailure field's value.
func (s *DescribeChangeSetOutput) SetOnStackFailure(v string) *DescribeChangeSetOutput {
	s.OnStackFailure = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeChangeSetOutput) SetParameters(v []*Parameter) *DescribeChangeSetOutput {
	s.Parameters = v
	return s
}

// SetParentChangeSetId sets the ParentChangeSetId field's value.
func (s *DescribeChangeSetOutput) SetParentChangeSetId(v string) *DescribeChangeSetOutput {
	s.ParentChangeSetId = &v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *DescribeChangeSetOutput) SetRollbackConfiguration(v *RollbackConfiguration) *DescribeChangeSetOutput {
	s.RollbackConfiguration = v
	return s
}

// SetRootChangeSetId sets the RootChangeSetId field's value.
func (s *DescribeChangeSetOutput) SetRootChangeSetId(v string) *DescribeChangeSetOutput {
	s.RootChangeSetId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeChangeSetOutput) SetStackId(v string) *DescribeChangeSetOutput {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeChangeSetOutput) SetStackName(v string) *DescribeChangeSetOutput {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeChangeSetOutput) SetStatus(v string) *DescribeChangeSetOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeChangeSetOutput) SetStatusReason(v string) *DescribeChangeSetOutput {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeChangeSetOutput) SetTags(v []*Tag) *DescribeChangeSetOutput {
	s.Tags = v
	return s
}

type DescribeGeneratedTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of a generated template.
	//
	// GeneratedTemplateName is a required field
	GeneratedTemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGeneratedTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGeneratedTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGeneratedTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGeneratedTemplateInput"}
	if s.GeneratedTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneratedTemplateName"))
	}
	if s.GeneratedTemplateName != nil && len(*s.GeneratedTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeneratedTemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeneratedTemplateName sets the GeneratedTemplateName field's value.
func (s *DescribeGeneratedTemplateInput) SetGeneratedTemplateName(v string) *DescribeGeneratedTemplateInput {
	s.GeneratedTemplateName = &v
	return s
}

type DescribeGeneratedTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The time the generated template was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the generated template. The format is arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}.
	// For example, arn:aws:cloudformation:us-east-1:123456789012:generatedtemplate/2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc .
	GeneratedTemplateId *string `min:"1" type:"string"`

	// The name of the generated template.
	GeneratedTemplateName *string `min:"1" type:"string"`

	// The time the generated template was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// An object describing the progress of the template generation.
	Progress *TemplateProgress `type:"structure"`

	// A list of objects describing the details of the resources in the template
	// generation.
	Resources []*ResourceDetail `min:"1" type:"list"`

	// The stack ARN of the base stack if a base stack was provided when generating
	// the template.
	StackId *string `type:"string"`

	// The status of the template generation. Supported values are:
	//
	//    * CreatePending - the creation of the template is pending.
	//
	//    * CreateInProgress - the creation of the template is in progress.
	//
	//    * DeletePending - the deletion of the template is pending.
	//
	//    * DeleteInProgress - the deletion of the template is in progress.
	//
	//    * UpdatePending - the update of the template is pending.
	//
	//    * UpdateInProgress - the update of the template is in progress.
	//
	//    * Failed - the template operation failed.
	//
	//    * Complete - the template operation is complete.
	Status *string `type:"string" enum:"GeneratedTemplateStatus"`

	// The reason for the current template generation status. This will provide
	// more details if a failure happened.
	StatusReason *string `min:"1" type:"string"`

	// The configuration details of the generated template, including the DeletionPolicy
	// and UpdateReplacePolicy.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`

	// The number of warnings generated for this template. The warnings are found
	// in the details of each of the resources in the template.
	TotalWarnings *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGeneratedTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGeneratedTemplateOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeGeneratedTemplateOutput) SetCreationTime(v time.Time) *DescribeGeneratedTemplateOutput {
	s.CreationTime = &v
	return s
}

// SetGeneratedTemplateId sets the GeneratedTemplateId field's value.
func (s *DescribeGeneratedTemplateOutput) SetGeneratedTemplateId(v string) *DescribeGeneratedTemplateOutput {
	s.GeneratedTemplateId = &v
	return s
}

// SetGeneratedTemplateName sets the GeneratedTemplateName field's value.
func (s *DescribeGeneratedTemplateOutput) SetGeneratedTemplateName(v string) *DescribeGeneratedTemplateOutput {
	s.GeneratedTemplateName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DescribeGeneratedTemplateOutput) SetLastUpdatedTime(v time.Time) *DescribeGeneratedTemplateOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *DescribeGeneratedTemplateOutput) SetProgress(v *TemplateProgress) *DescribeGeneratedTemplateOutput {
	s.Progress = v
	return s
}

// SetResources sets the Resources field's value.
func (s *DescribeGeneratedTemplateOutput) SetResources(v []*ResourceDetail) *DescribeGeneratedTemplateOutput {
	s.Resources = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeGeneratedTemplateOutput) SetStackId(v string) *DescribeGeneratedTemplateOutput {
	s.StackId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeGeneratedTemplateOutput) SetStatus(v string) *DescribeGeneratedTemplateOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeGeneratedTemplateOutput) SetStatusReason(v string) *DescribeGeneratedTemplateOutput {
	s.StatusReason = &v
	return s
}

// SetTemplateConfiguration sets the TemplateConfiguration field's value.
func (s *DescribeGeneratedTemplateOutput) SetTemplateConfiguration(v *TemplateConfiguration) *DescribeGeneratedTemplateOutput {
	s.TemplateConfiguration = v
	return s
}

// SetTotalWarnings sets the TotalWarnings field's value.
func (s *DescribeGeneratedTemplateOutput) SetTotalWarnings(v int64) *DescribeGeneratedTemplateOutput {
	s.TotalWarnings = &v
	return s
}

type DescribeOrganizationsAccessInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationsAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationsAccessInput) GoString() string {
	return s.String()
}

// SetCallAs sets the CallAs field's value.
func (s *DescribeOrganizationsAccessInput) SetCallAs(v string) *DescribeOrganizationsAccessInput {
	s.CallAs = &v
	return s
}

type DescribeOrganizationsAccessOutput struct {
	_ struct{} `type:"structure"`

	// Presents the status of the OrganizationAccess.
	Status *string `type:"string" enum:"OrganizationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationsAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationsAccessOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DescribeOrganizationsAccessOutput) SetStatus(v string) *DescribeOrganizationsAccessOutput {
	s.Status = &v
	return s
}

type DescribePublisherInput struct {
	_ struct{} `type:"structure"`

	// The ID of the extension publisher.
	//
	// If you don't supply a PublisherId, and you have registered as an extension
	// publisher, DescribePublisher returns information about your own publisher
	// account.
	PublisherId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePublisherInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePublisherInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePublisherInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePublisherInput"}
	if s.PublisherId != nil && len(*s.PublisherId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublisherId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPublisherId sets the PublisherId field's value.
func (s *DescribePublisherInput) SetPublisherId(v string) *DescribePublisherInput {
	s.PublisherId = &v
	return s
}

type DescribePublisherOutput struct {
	_ struct{} `type:"structure"`

	// The type of account used as the identity provider when registering this publisher
	// with CloudFormation.
	IdentityProvider *string `type:"string" enum:"IdentityProvider"`

	// The ID of the extension publisher.
	PublisherId *string `min:"1" type:"string"`

	// The URL to the publisher's profile with the identity provider.
	PublisherProfile *string `type:"string"`

	// Whether the publisher is verified. Currently, all registered publishers are
	// verified.
	PublisherStatus *string `type:"string" enum:"PublisherStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePublisherOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePublisherOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *DescribePublisherOutput) SetIdentityProvider(v string) *DescribePublisherOutput {
	s.IdentityProvider = &v
	return s
}

// SetPublisherId sets the PublisherId field's value.
func (s *DescribePublisherOutput) SetPublisherId(v string) *DescribePublisherOutput {
	s.PublisherId = &v
	return s
}

// SetPublisherProfile sets the PublisherProfile field's value.
func (s *DescribePublisherOutput) SetPublisherProfile(v string) *DescribePublisherOutput {
	s.PublisherProfile = &v
	return s
}

// SetPublisherStatus sets the PublisherStatus field's value.
func (s *DescribePublisherOutput) SetPublisherStatus(v string) *DescribePublisherOutput {
	s.PublisherStatus = &v
	return s
}

type DescribeResourceScanInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource scan.
	//
	// ResourceScanId is a required field
	ResourceScanId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceScanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceScanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceScanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceScanInput"}
	if s.ResourceScanId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceScanId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceScanId sets the ResourceScanId field's value.
func (s *DescribeResourceScanInput) SetResourceScanId(v string) *DescribeResourceScanInput {
	s.ResourceScanId = &v
	return s
}

type DescribeResourceScanOutput struct {
	_ struct{} `type:"structure"`

	// The time that the resource scan was finished.
	EndTime *time.Time `type:"timestamp"`

	// The percentage of the resource scan that has been completed.
	PercentageCompleted *float64 `type:"double"`

	// The Amazon Resource Name (ARN) of the resource scan. The format is arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}.
	// An example is arn:aws:cloudformation:us-east-1:123456789012:resourceScan/f5b490f7-7ed4-428a-aa06-31ff25db0772 .
	ResourceScanId *string `type:"string"`

	// The list of resource types for the specified scan. Resource types are only
	// available for scans with a Status set to COMPLETE or FAILED .
	ResourceTypes []*string `type:"list"`

	// The number of resources that were read. This is only available for scans
	// with a Status set to COMPLETE, EXPIRED, or FAILED .
	//
	// This field may be 0 if the resource scan failed with a ResourceScanLimitExceededException.
	ResourcesRead *int64 `type:"integer"`

	// The number of resources that were listed. This is only available for scans
	// with a Status set to COMPLETE, EXPIRED, or FAILED .
	ResourcesScanned *int64 `type:"integer"`

	// The time that the resource scan was started.
	StartTime *time.Time `type:"timestamp"`

	// Status of the resource scan.
	//
	// INPROGRESS
	//
	// The resource scan is still in progress.
	//
	// COMPLETE
	//
	// The resource scan is complete.
	//
	// EXPIRED
	//
	// The resource scan has expired.
	//
	// FAILED
	//
	// The resource scan has failed.
	Status *string `type:"string" enum:"ResourceScanStatus"`

	// The reason for the resource scan status, providing more information if a
	// failure happened.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceScanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceScanOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeResourceScanOutput) SetEndTime(v time.Time) *DescribeResourceScanOutput {
	s.EndTime = &v
	return s
}

// SetPercentageCompleted sets the PercentageCompleted field's value.
func (s *DescribeResourceScanOutput) SetPercentageCompleted(v float64) *DescribeResourceScanOutput {
	s.PercentageCompleted = &v
	return s
}

// SetResourceScanId sets the ResourceScanId field's value.
func (s *DescribeResourceScanOutput) SetResourceScanId(v string) *DescribeResourceScanOutput {
	s.ResourceScanId = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *DescribeResourceScanOutput) SetResourceTypes(v []*string) *DescribeResourceScanOutput {
	s.ResourceTypes = v
	return s
}

// SetResourcesRead sets the ResourcesRead field's value.
func (s *DescribeResourceScanOutput) SetResourcesRead(v int64) *DescribeResourceScanOutput {
	s.ResourcesRead = &v
	return s
}

// SetResourcesScanned sets the ResourcesScanned field's value.
func (s *DescribeResourceScanOutput) SetResourcesScanned(v int64) *DescribeResourceScanOutput {
	s.ResourcesScanned = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeResourceScanOutput) SetStartTime(v time.Time) *DescribeResourceScanOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeResourceScanOutput) SetStatus(v string) *DescribeResourceScanOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeResourceScanOutput) SetStatusReason(v string) *DescribeResourceScanOutput {
	s.StatusReason = &v
	return s
}

type DescribeStackDriftDetectionStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the drift detection results of this operation.
	//
	// CloudFormation generates new results, with a new drift detection ID, each
	// time this operation is run. However, the number of drift results CloudFormation
	// retains for any given stack, and for how long, may vary.
	//
	// StackDriftDetectionId is a required field
	StackDriftDetectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackDriftDetectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackDriftDetectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackDriftDetectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackDriftDetectionStatusInput"}
	if s.StackDriftDetectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackDriftDetectionId"))
	}
	if s.StackDriftDetectionId != nil && len(*s.StackDriftDetectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackDriftDetectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackDriftDetectionId sets the StackDriftDetectionId field's value.
func (s *DescribeStackDriftDetectionStatusInput) SetStackDriftDetectionId(v string) *DescribeStackDriftDetectionStatusInput {
	s.StackDriftDetectionId = &v
	return s
}

type DescribeStackDriftDetectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the stack drift detection operation.
	//
	//    * DETECTION_COMPLETE: The stack drift detection operation has successfully
	//    completed for all resources in the stack that support drift detection.
	//    (Resources that don't currently support stack detection remain unchecked.)
	//    If you specified logical resource IDs for CloudFormation to use as a filter
	//    for the stack drift detection operation, only the resources with those
	//    logical IDs are checked for drift.
	//
	//    * DETECTION_FAILED: The stack drift detection operation has failed for
	//    at least one resource in the stack. Results will be available for resources
	//    on which CloudFormation successfully completed drift detection.
	//
	//    * DETECTION_IN_PROGRESS: The stack drift detection operation is currently
	//    in progress.
	//
	// DetectionStatus is a required field
	DetectionStatus *string `type:"string" required:"true" enum:"StackDriftDetectionStatus"`

	// The reason the stack drift detection operation has its current status.
	DetectionStatusReason *string `type:"string"`

	// Total number of stack resources that have drifted. This is NULL until the
	// drift detection operation reaches a status of DETECTION_COMPLETE. This value
	// will be 0 for stacks whose drift status is IN_SYNC.
	DriftedStackResourceCount *int64 `type:"integer"`

	// The ID of the drift detection results of this operation.
	//
	// CloudFormation generates new results, with a new drift detection ID, each
	// time this operation is run. However, the number of reports CloudFormation
	// retains for any given stack, and for how long, may vary.
	//
	// StackDriftDetectionId is a required field
	StackDriftDetectionId *string `min:"1" type:"string" required:"true"`

	// Status of the stack's actual configuration compared to its expected configuration.
	//
	//    * DRIFTED: The stack differs from its expected template configuration.
	//    A stack is considered to have drifted if one or more of its resources
	//    have drifted.
	//
	//    * NOT_CHECKED: CloudFormation hasn't checked if the stack differs from
	//    its expected template configuration.
	//
	//    * IN_SYNC: The stack's actual configuration matches its expected template
	//    configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	StackDriftStatus *string `type:"string" enum:"StackDriftStatus"`

	// The ID of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// Time at which the stack drift detection operation was initiated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackDriftDetectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackDriftDetectionStatusOutput) GoString() string {
	return s.String()
}

// SetDetectionStatus sets the DetectionStatus field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetDetectionStatus(v string) *DescribeStackDriftDetectionStatusOutput {
	s.DetectionStatus = &v
	return s
}

// SetDetectionStatusReason sets the DetectionStatusReason field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetDetectionStatusReason(v string) *DescribeStackDriftDetectionStatusOutput {
	s.DetectionStatusReason = &v
	return s
}

// SetDriftedStackResourceCount sets the DriftedStackResourceCount field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetDriftedStackResourceCount(v int64) *DescribeStackDriftDetectionStatusOutput {
	s.DriftedStackResourceCount = &v
	return s
}

// SetStackDriftDetectionId sets the StackDriftDetectionId field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetStackDriftDetectionId(v string) *DescribeStackDriftDetectionStatusOutput {
	s.StackDriftDetectionId = &v
	return s
}

// SetStackDriftStatus sets the StackDriftStatus field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetStackDriftStatus(v string) *DescribeStackDriftDetectionStatusOutput {
	s.StackDriftStatus = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetStackId(v string) *DescribeStackDriftDetectionStatusOutput {
	s.StackId = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *DescribeStackDriftDetectionStatusOutput) SetTimestamp(v time.Time) *DescribeStackDriftDetectionStatusOutput {
	s.Timestamp = &v
	return s
}

// The input for DescribeStackEvents action.
type DescribeStackEventsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of events that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that's associated with the stack, which aren't
	// always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackEventsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackEventsInput) SetNextToken(v string) *DescribeStackEventsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackEventsInput) SetStackName(v string) *DescribeStackEventsInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackEvents action.
type DescribeStackEventsOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of events. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackEvents structures.
	StackEvents []*StackEvent `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackEventsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackEventsOutput) SetNextToken(v string) *DescribeStackEventsOutput {
	s.NextToken = &v
	return s
}

// SetStackEvents sets the StackEvents field's value.
func (s *DescribeStackEventsOutput) SetStackEvents(v []*StackEvent) *DescribeStackEventsOutput {
	s.StackEvents = v
	return s
}

type DescribeStackInstanceInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The ID of an Amazon Web Services account that's associated with this stack
	// instance.
	//
	// StackInstanceAccount is a required field
	StackInstanceAccount *string `type:"string" required:"true"`

	// The name of a Region that's associated with this stack instance.
	//
	// StackInstanceRegion is a required field
	StackInstanceRegion *string `type:"string" required:"true"`

	// The name or the unique stack ID of the stack set that you want to get stack
	// instance information for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackInstanceInput"}
	if s.StackInstanceAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("StackInstanceAccount"))
	}
	if s.StackInstanceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("StackInstanceRegion"))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *DescribeStackInstanceInput) SetCallAs(v string) *DescribeStackInstanceInput {
	s.CallAs = &v
	return s
}

// SetStackInstanceAccount sets the StackInstanceAccount field's value.
func (s *DescribeStackInstanceInput) SetStackInstanceAccount(v string) *DescribeStackInstanceInput {
	s.StackInstanceAccount = &v
	return s
}

// SetStackInstanceRegion sets the StackInstanceRegion field's value.
func (s *DescribeStackInstanceInput) SetStackInstanceRegion(v string) *DescribeStackInstanceInput {
	s.StackInstanceRegion = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DescribeStackInstanceInput) SetStackSetName(v string) *DescribeStackInstanceInput {
	s.StackSetName = &v
	return s
}

type DescribeStackInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The stack instance that matches the specified request parameters.
	StackInstance *StackInstance `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackInstanceOutput) GoString() string {
	return s.String()
}

// SetStackInstance sets the StackInstance field's value.
func (s *DescribeStackInstanceOutput) SetStackInstance(v *StackInstance) *DescribeStackInstanceOutput {
	s.StackInstance = v
	return s
}

type DescribeStackResourceDriftsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string that identifies the next page of stack resource drift results.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack for which you want drift information.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The resource drift status values to use as filters for the resource drift
	// results returned.
	//
	//    * DELETED: The resource differs from its expected template configuration
	//    in that the resource has been deleted.
	//
	//    * MODIFIED: One or more resource properties differ from their expected
	//    template values.
	//
	//    * IN_SYNC: The resource's actual configuration matches its expected template
	//    configuration.
	//
	//    * NOT_CHECKED: CloudFormation doesn't currently return this value.
	StackResourceDriftStatusFilters []*string `min:"1" type:"list" enum:"StackResourceDriftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourceDriftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourceDriftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackResourceDriftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackResourceDriftsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.StackResourceDriftStatusFilters != nil && len(s.StackResourceDriftStatusFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackResourceDriftStatusFilters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeStackResourceDriftsInput) SetMaxResults(v int64) *DescribeStackResourceDriftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackResourceDriftsInput) SetNextToken(v string) *DescribeStackResourceDriftsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackResourceDriftsInput) SetStackName(v string) *DescribeStackResourceDriftsInput {
	s.StackName = &v
	return s
}

// SetStackResourceDriftStatusFilters sets the StackResourceDriftStatusFilters field's value.
func (s *DescribeStackResourceDriftsInput) SetStackResourceDriftStatusFilters(v []*string) *DescribeStackResourceDriftsInput {
	s.StackResourceDriftStatusFilters = v
	return s
}

type DescribeStackResourceDriftsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call DescribeStackResourceDrifts
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// Drift information for the resources that have been checked for drift in the
	// specified stack. This includes actual and expected configuration values for
	// resources where CloudFormation detects drift.
	//
	// For a given stack, there will be one StackResourceDrift for each stack resource
	// that has been checked for drift. Resources that haven't yet been checked
	// for drift aren't included. Resources that do not currently support drift
	// detection aren't checked, and so not included. For a list of resources that
	// support drift detection, see Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//
	// StackResourceDrifts is a required field
	StackResourceDrifts []*StackResourceDrift `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourceDriftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourceDriftsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackResourceDriftsOutput) SetNextToken(v string) *DescribeStackResourceDriftsOutput {
	s.NextToken = &v
	return s
}

// SetStackResourceDrifts sets the StackResourceDrifts field's value.
func (s *DescribeStackResourceDriftsOutput) SetStackResourceDrifts(v []*StackResourceDrift) *DescribeStackResourceDriftsOutput {
	s.StackResourceDrifts = v
	return s
}

// The input for DescribeStackResource action.
type DescribeStackResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or the unique stack ID that's associated with the stack, which aren't
	// always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackResourceInput"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DescribeStackResourceInput) SetLogicalResourceId(v string) *DescribeStackResourceInput {
	s.LogicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackResourceInput) SetStackName(v string) *DescribeStackResourceInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackResource action.
type DescribeStackResourceOutput struct {
	_ struct{} `type:"structure"`

	// A StackResourceDetail structure containing the description of the specified
	// resource in the specified stack.
	StackResourceDetail *StackResourceDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourceOutput) GoString() string {
	return s.String()
}

// SetStackResourceDetail sets the StackResourceDetail field's value.
func (s *DescribeStackResourceOutput) SetStackResourceDetail(v *StackResourceDetail) *DescribeStackResourceOutput {
	s.StackResourceDetail = v
	return s
}

// The input for DescribeStackResources action.
type DescribeStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by CloudFormation.
	//
	// For example, for an Amazon Elastic Compute Cloud (EC2) instance, PhysicalResourceId
	// corresponds to the InstanceId. You can pass the EC2 InstanceId to DescribeStackResources
	// to find which stack the instance belongs to and what other resources are
	// part of the stack.
	//
	// Required: Conditional. If you don't specify PhysicalResourceId, you must
	// specify StackName.
	//
	// Default: There is no default value.
	PhysicalResourceId *string `type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// aren't always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// Required: Conditional. If you don't specify StackName, you must specify PhysicalResourceId.
	StackName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourcesInput) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DescribeStackResourcesInput) SetLogicalResourceId(v string) *DescribeStackResourcesInput {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *DescribeStackResourcesInput) SetPhysicalResourceId(v string) *DescribeStackResourcesInput {
	s.PhysicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackResourcesInput) SetStackName(v string) *DescribeStackResourcesInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackResources action.
type DescribeStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of StackResource structures.
	StackResources []*StackResource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackResourcesOutput) GoString() string {
	return s.String()
}

// SetStackResources sets the StackResources field's value.
func (s *DescribeStackResourcesOutput) SetStackResources(v []*StackResource) *DescribeStackResourcesOutput {
	s.StackResources = v
	return s
}

type DescribeStackSetInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The name or unique ID of the stack set whose description you want.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackSetInput"}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *DescribeStackSetInput) SetCallAs(v string) *DescribeStackSetInput {
	s.CallAs = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DescribeStackSetInput) SetStackSetName(v string) *DescribeStackSetInput {
	s.StackSetName = &v
	return s
}

type DescribeStackSetOperationInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The unique ID of the stack set operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or the unique stack ID of the stack set for the stack operation.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackSetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackSetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackSetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackSetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *DescribeStackSetOperationInput) SetCallAs(v string) *DescribeStackSetOperationInput {
	s.CallAs = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *DescribeStackSetOperationInput) SetOperationId(v string) *DescribeStackSetOperationInput {
	s.OperationId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DescribeStackSetOperationInput) SetStackSetName(v string) *DescribeStackSetOperationInput {
	s.StackSetName = &v
	return s
}

type DescribeStackSetOperationOutput struct {
	_ struct{} `type:"structure"`

	// The specified stack set operation.
	StackSetOperation *StackSetOperation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackSetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackSetOperationOutput) GoString() string {
	return s.String()
}

// SetStackSetOperation sets the StackSetOperation field's value.
func (s *DescribeStackSetOperationOutput) SetStackSetOperation(v *StackSetOperation) *DescribeStackSetOperationOutput {
	s.StackSetOperation = v
	return s
}

type DescribeStackSetOutput struct {
	_ struct{} `type:"structure"`

	// The specified stack set.
	StackSet *StackSet `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStackSetOutput) GoString() string {
	return s.String()
}

// SetStackSet sets the StackSet field's value.
func (s *DescribeStackSetOutput) SetStackSet(v *StackSet) *DescribeStackSetOutput {
	s.StackSet = v
	return s
}

// The input for DescribeStacks action.
type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	//
	// If you don't pass a parameter to StackName, the API returns a response that
	// describes all resources in the account, which can impact performance. This
	// requires ListStacks and DescribeStacks permissions.
	//
	// Consider using the ListStacks API if you're not passing a parameter to StackName.
	//
	// The IAM policy below can be added to IAM policies when you want to limit
	// resource-level permissions and avoid returning a response when no parameter
	// is sent in the request:
	//
	// { "Version": "2012-10-17", "Statement": [{ "Effect": "Deny", "Action": "cloudformation:DescribeStacks",
	// "NotResource": "arn:aws:cloudformation:*:*:stack/*/*" }] }
	//
	// The name or the unique stack ID that's associated with the stack, which aren't
	// always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksInput) SetNextToken(v string) *DescribeStacksInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStacksInput) SetStackName(v string) *DescribeStacksInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStacks action.
type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of stack structures.
	Stacks []*Stack `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksOutput) SetNextToken(v string) *DescribeStacksOutput {
	s.NextToken = &v
	return s
}

// SetStacks sets the Stacks field's value.
func (s *DescribeStacksOutput) SetStacks(v []*Stack) *DescribeStacksOutput {
	s.Stacks = v
	return s
}

type DescribeTypeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Arn *string `type:"string"`

	// The version number of a public third-party extension.
	PublicVersionNumber *string `min:"5" type:"string"`

	// The publisher ID of the extension publisher.
	//
	// Extensions provided by Amazon Web Services are not assigned a publisher ID.
	PublisherId *string `min:"1" type:"string"`

	// The kind of extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Type *string `type:"string" enum:"RegistryType"`

	// The name of the extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	TypeName *string `min:"10" type:"string"`

	// The ID of a specific version of the extension. The version ID is the value
	// at the end of the Amazon Resource Name (ARN) assigned to the extension version
	// when it is registered.
	//
	// If you specify a VersionId, DescribeType returns information about that specific
	// extension version. Otherwise, it returns information about the default extension
	// version.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTypeInput"}
	if s.PublicVersionNumber != nil && len(*s.PublicVersionNumber) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("PublicVersionNumber", 5))
	}
	if s.PublisherId != nil && len(*s.PublisherId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublisherId", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DescribeTypeInput) SetArn(v string) *DescribeTypeInput {
	s.Arn = &v
	return s
}

// SetPublicVersionNumber sets the PublicVersionNumber field's value.
func (s *DescribeTypeInput) SetPublicVersionNumber(v string) *DescribeTypeInput {
	s.PublicVersionNumber = &v
	return s
}

// SetPublisherId sets the PublisherId field's value.
func (s *DescribeTypeInput) SetPublisherId(v string) *DescribeTypeInput {
	s.PublisherId = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeTypeInput) SetType(v string) *DescribeTypeInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DescribeTypeInput) SetTypeName(v string) *DescribeTypeInput {
	s.TypeName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DescribeTypeInput) SetVersionId(v string) *DescribeTypeInput {
	s.VersionId = &v
	return s
}

type DescribeTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension.
	Arn *string `type:"string"`

	// Whether CloudFormation automatically updates the extension in this account
	// and Region when a new minor version is published by the extension publisher.
	// Major versions released by the publisher must be manually updated. For more
	// information, see Activating public extensions for use in your account (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable)
	// in the CloudFormation User Guide.
	AutoUpdate *bool `type:"boolean"`

	// A JSON string that represent the current configuration data for the extension
	// in this account and Region.
	//
	// To set the configuration data for an extension, use SetTypeConfiguration
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html).
	// For more information, see Configuring extensions at the account level (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private.html#registry-set-configuration)
	// in the CloudFormation User Guide.
	ConfigurationSchema *string `min:"1" type:"string"`

	// The ID of the default version of the extension. The default version is used
	// when the extension version isn't specified.
	//
	// This applies only to private extensions you have registered in your account.
	// For public extensions, both those provided by Amazon Web Services and published
	// by third parties, CloudFormation returns null. For more information, see
	// RegisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
	//
	// To set the default version of an extension, use SetTypeDefaultVersion.
	DefaultVersionId *string `min:"1" type:"string"`

	// The deprecation status of the extension version.
	//
	// Valid values include:
	//
	//    * LIVE: The extension is activated or registered and can be used in CloudFormation
	//    operations, dependent on its provisioning behavior and visibility scope.
	//
	//    * DEPRECATED: The extension has been deactivated or deregistered and can
	//    no longer be used in CloudFormation operations.
	//
	// For public third-party extensions, CloudFormation returns null.
	DeprecatedStatus *string `type:"string" enum:"DeprecatedStatus"`

	// The description of the extension.
	Description *string `min:"1" type:"string"`

	// The URL of a page providing detailed documentation for this extension.
	DocumentationUrl *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM execution role used to register
	// the extension. This applies only to private extensions you have registered
	// in your account. For more information, see RegisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
	//
	// If the registered extension calls any Amazon Web Services APIs, you must
	// create an IAM execution role (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)
	// that includes the necessary permissions to call those Amazon Web Services
	// APIs, and provision that execution role in your account. CloudFormation then
	// assumes that execution role to provide your extension with the appropriate
	// credentials.
	ExecutionRoleArn *string `min:"1" type:"string"`

	// Whether the extension is activated in the account and Region.
	//
	// This only applies to public third-party extensions. For all other extensions,
	// CloudFormation returns null.
	IsActivated *bool `type:"boolean"`

	// Whether the specified extension version is set as the default version.
	//
	// This applies only to private extensions you have registered in your account,
	// and extensions published by Amazon Web Services. For public third-party extensions,
	// whether they are activated in your account, CloudFormation returns null.
	IsDefaultVersion *bool `type:"boolean"`

	// When the specified extension version was registered. This applies only to:
	//
	//    * Private extensions you have registered in your account. For more information,
	//    see RegisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
	//
	//    * Public extensions you have activated in your account with auto-update
	//    specified. For more information, see ActivateType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html).
	LastUpdated *time.Time `type:"timestamp"`

	// The latest version of a public extension that is available for use.
	//
	// This only applies if you specify a public extension, and you don't specify
	// a version. For all other requests, CloudFormation returns null.
	LatestPublicVersion *string `min:"5" type:"string"`

	// Contains logging configuration information for private extensions. This applies
	// only to private extensions you have registered in your account. For public
	// extensions, both those provided by Amazon Web Services and published by third
	// parties, CloudFormation returns null. For more information, see RegisterType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
	LoggingConfig *LoggingConfig `type:"structure"`

	// For public extensions that have been activated for this account and Region,
	// the Amazon Resource Name (ARN) of the public extension.
	OriginalTypeArn *string `type:"string"`

	// For public extensions that have been activated for this account and Region,
	// the type name of the public extension.
	//
	// If you specified a TypeNameAlias when enabling the extension in this account
	// and Region, CloudFormation treats that alias as the extension's type name
	// within the account and Region, not the type name of the public extension.
	// For more information, see Specifying aliases to refer to extensions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias)
	// in the CloudFormation User Guide.
	OriginalTypeName *string `min:"10" type:"string"`

	// For resource type extensions, the provisioning behavior of the resource type.
	// CloudFormation determines the provisioning type during registration, based
	// on the types of handlers in the schema handler package submitted.
	//
	// Valid values include:
	//
	//    * FULLY_MUTABLE: The resource type includes an update handler to process
	//    updates to the type during stack update operations.
	//
	//    * IMMUTABLE: The resource type doesn't include an update handler, so the
	//    type can't be updated and must instead be replaced during stack update
	//    operations.
	//
	//    * NON_PROVISIONABLE: The resource type doesn't include all the following
	//    handlers, and therefore can't actually be provisioned. create read delete
	ProvisioningType *string `type:"string" enum:"ProvisioningType"`

	// The version number of a public third-party extension.
	//
	// This applies only if you specify a public extension you have activated in
	// your account, or specify a public extension without specifying a version.
	// For all other extensions, CloudFormation returns null.
	PublicVersionNumber *string `min:"5" type:"string"`

	// The publisher ID of the extension publisher.
	//
	// This applies only to public third-party extensions. For private registered
	// extensions, and extensions provided by Amazon Web Services, CloudFormation
	// returns null.
	PublisherId *string `min:"1" type:"string"`

	// For extensions that are modules, the public third-party extensions that must
	// be activated in your account in order for the module itself to be activated.
	RequiredActivatedTypes []*RequiredActivatedType `type:"list"`

	// The schema that defines the extension.
	//
	// For more information about extension schemas, see Resource Provider Schema
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html)
	// in the CloudFormation CLI User Guide.
	Schema *string `min:"1" type:"string"`

	// The URL of the source code for the extension.
	SourceUrl *string `type:"string"`

	// When the specified private extension version was registered or activated
	// in your account.
	TimeCreated *time.Time `type:"timestamp"`

	// The kind of extension.
	Type *string `type:"string" enum:"RegistryType"`

	// The name of the extension.
	//
	// If the extension is a public third-party type you have activated with a type
	// name alias, CloudFormation returns the type name alias. For more information,
	// see ActivateType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html).
	TypeName *string `min:"10" type:"string"`

	// The contract test status of the registered extension version. To return the
	// extension test status of a specific extension version, you must specify VersionId.
	//
	// This applies only to registered private extension versions. CloudFormation
	// doesn't return this information for public extensions, whether they are activated
	// in your account.
	//
	//    * PASSED: The extension has passed all its contract tests. An extension
	//    must have a test status of PASSED before it can be published. For more
	//    information, see Publishing extensions to make them available for public
	//    use (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html)
	//    in the CloudFormation Command Line Interface User Guide.
	//
	//    * FAILED: The extension has failed one or more contract tests.
	//
	//    * IN_PROGRESS: Contract tests are currently being performed on the extension.
	//
	//    * NOT_TESTED: Contract tests haven't been performed on the extension.
	TypeTestsStatus *string `type:"string" enum:"TypeTestsStatus"`

	// The description of the test status. To return the extension test status of
	// a specific extension version, you must specify VersionId.
	//
	// This applies only to registered private extension versions. CloudFormation
	// doesn't return this information for public extensions, whether they are activated
	// in your account.
	TypeTestsStatusDescription *string `min:"1" type:"string"`

	// The scope at which the extension is visible and usable in CloudFormation
	// operations.
	//
	// Valid values include:
	//
	//    * PRIVATE: The extension is only visible and usable within the account
	//    in which it is registered. CloudFormation marks any extensions you register
	//    as PRIVATE.
	//
	//    * PUBLIC: The extension is publicly visible and usable within any Amazon
	//    Web Services account.
	Visibility *string `type:"string" enum:"Visibility"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTypeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeTypeOutput) SetArn(v string) *DescribeTypeOutput {
	s.Arn = &v
	return s
}

// SetAutoUpdate sets the AutoUpdate field's value.
func (s *DescribeTypeOutput) SetAutoUpdate(v bool) *DescribeTypeOutput {
	s.AutoUpdate = &v
	return s
}

// SetConfigurationSchema sets the ConfigurationSchema field's value.
func (s *DescribeTypeOutput) SetConfigurationSchema(v string) *DescribeTypeOutput {
	s.ConfigurationSchema = &v
	return s
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *DescribeTypeOutput) SetDefaultVersionId(v string) *DescribeTypeOutput {
	s.DefaultVersionId = &v
	return s
}

// SetDeprecatedStatus sets the DeprecatedStatus field's value.
func (s *DescribeTypeOutput) SetDeprecatedStatus(v string) *DescribeTypeOutput {
	s.DeprecatedStatus = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeTypeOutput) SetDescription(v string) *DescribeTypeOutput {
	s.Description = &v
	return s
}

// SetDocumentationUrl sets the DocumentationUrl field's value.
func (s *DescribeTypeOutput) SetDocumentationUrl(v string) *DescribeTypeOutput {
	s.DocumentationUrl = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *DescribeTypeOutput) SetExecutionRoleArn(v string) *DescribeTypeOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetIsActivated sets the IsActivated field's value.
func (s *DescribeTypeOutput) SetIsActivated(v bool) *DescribeTypeOutput {
	s.IsActivated = &v
	return s
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *DescribeTypeOutput) SetIsDefaultVersion(v bool) *DescribeTypeOutput {
	s.IsDefaultVersion = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *DescribeTypeOutput) SetLastUpdated(v time.Time) *DescribeTypeOutput {
	s.LastUpdated = &v
	return s
}

// SetLatestPublicVersion sets the LatestPublicVersion field's value.
func (s *DescribeTypeOutput) SetLatestPublicVersion(v string) *DescribeTypeOutput {
	s.LatestPublicVersion = &v
	return s
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *DescribeTypeOutput) SetLoggingConfig(v *LoggingConfig) *DescribeTypeOutput {
	s.LoggingConfig = v
	return s
}

// SetOriginalTypeArn sets the OriginalTypeArn field's value.
func (s *DescribeTypeOutput) SetOriginalTypeArn(v string) *DescribeTypeOutput {
	s.OriginalTypeArn = &v
	return s
}

// SetOriginalTypeName sets the OriginalTypeName field's value.
func (s *DescribeTypeOutput) SetOriginalTypeName(v string) *DescribeTypeOutput {
	s.OriginalTypeName = &v
	return s
}

// SetProvisioningType sets the ProvisioningType field's value.
func (s *DescribeTypeOutput) SetProvisioningType(v string) *DescribeTypeOutput {
	s.ProvisioningType = &v
	return s
}

// SetPublicVersionNumber sets the PublicVersionNumber field's value.
func (s *DescribeTypeOutput) SetPublicVersionNumber(v string) *DescribeTypeOutput {
	s.PublicVersionNumber = &v
	return s
}

// SetPublisherId sets the PublisherId field's value.
func (s *DescribeTypeOutput) SetPublisherId(v string) *DescribeTypeOutput {
	s.PublisherId = &v
	return s
}

// SetRequiredActivatedTypes sets the RequiredActivatedTypes field's value.
func (s *DescribeTypeOutput) SetRequiredActivatedTypes(v []*RequiredActivatedType) *DescribeTypeOutput {
	s.RequiredActivatedTypes = v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DescribeTypeOutput) SetSchema(v string) *DescribeTypeOutput {
	s.Schema = &v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *DescribeTypeOutput) SetSourceUrl(v string) *DescribeTypeOutput {
	s.SourceUrl = &v
	return s
}

// SetTimeCreated sets the TimeCreated field's value.
func (s *DescribeTypeOutput) SetTimeCreated(v time.Time) *DescribeTypeOutput {
	s.TimeCreated = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeTypeOutput) SetType(v string) *DescribeTypeOutput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DescribeTypeOutput) SetTypeName(v string) *DescribeTypeOutput {
	s.TypeName = &v
	return s
}

// SetTypeTestsStatus sets the TypeTestsStatus field's value.
func (s *DescribeTypeOutput) SetTypeTestsStatus(v string) *DescribeTypeOutput {
	s.TypeTestsStatus = &v
	return s
}

// SetTypeTestsStatusDescription sets the TypeTestsStatusDescription field's value.
func (s *DescribeTypeOutput) SetTypeTestsStatusDescription(v string) *DescribeTypeOutput {
	s.TypeTestsStatusDescription = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *DescribeTypeOutput) SetVisibility(v string) *DescribeTypeOutput {
	s.Visibility = &v
	return s
}

type DescribeTypeRegistrationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for this registration request.
	//
	// This registration token is generated by CloudFormation when you initiate
	// a registration request using RegisterType.
	//
	// RegistrationToken is a required field
	RegistrationToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTypeRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTypeRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTypeRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTypeRegistrationInput"}
	if s.RegistrationToken == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrationToken"))
	}
	if s.RegistrationToken != nil && len(*s.RegistrationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistrationToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistrationToken sets the RegistrationToken field's value.
func (s *DescribeTypeRegistrationInput) SetRegistrationToken(v string) *DescribeTypeRegistrationInput {
	s.RegistrationToken = &v
	return s
}

type DescribeTypeRegistrationOutput struct {
	_ struct{} `type:"structure"`

	// The description of the extension registration request.
	Description *string `min:"1" type:"string"`

	// The current status of the extension registration request.
	ProgressStatus *string `type:"string" enum:"RegistrationStatus"`

	// The Amazon Resource Name (ARN) of the extension being registered.
	//
	// For registration requests with a ProgressStatus of other than COMPLETE, this
	// will be null.
	TypeArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of this specific version of the extension
	// being registered.
	//
	// For registration requests with a ProgressStatus of other than COMPLETE, this
	// will be null.
	TypeVersionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTypeRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTypeRegistrationOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DescribeTypeRegistrationOutput) SetDescription(v string) *DescribeTypeRegistrationOutput {
	s.Description = &v
	return s
}

// SetProgressStatus sets the ProgressStatus field's value.
func (s *DescribeTypeRegistrationOutput) SetProgressStatus(v string) *DescribeTypeRegistrationOutput {
	s.ProgressStatus = &v
	return s
}

// SetTypeArn sets the TypeArn field's value.
func (s *DescribeTypeRegistrationOutput) SetTypeArn(v string) *DescribeTypeRegistrationOutput {
	s.TypeArn = &v
	return s
}

// SetTypeVersionArn sets the TypeVersionArn field's value.
func (s *DescribeTypeRegistrationOutput) SetTypeVersionArn(v string) *DescribeTypeRegistrationOutput {
	s.TypeVersionArn = &v
	return s
}

type DetectStackDriftInput struct {
	_ struct{} `type:"structure"`

	// The logical names of any resources you want to use as filters.
	LogicalResourceIds []*string `min:"1" type:"list"`

	// The name of the stack for which you want to detect drift.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackDriftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackDriftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectStackDriftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectStackDriftInput"}
	if s.LogicalResourceIds != nil && len(s.LogicalResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogicalResourceIds", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceIds sets the LogicalResourceIds field's value.
func (s *DetectStackDriftInput) SetLogicalResourceIds(v []*string) *DetectStackDriftInput {
	s.LogicalResourceIds = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DetectStackDriftInput) SetStackName(v string) *DetectStackDriftInput {
	s.StackName = &v
	return s
}

type DetectStackDriftOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the drift detection results of this operation.
	//
	// CloudFormation generates new results, with a new drift detection ID, each
	// time this operation is run. However, the number of drift results CloudFormation
	// retains for any given stack, and for how long, may vary.
	//
	// StackDriftDetectionId is a required field
	StackDriftDetectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackDriftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackDriftOutput) GoString() string {
	return s.String()
}

// SetStackDriftDetectionId sets the StackDriftDetectionId field's value.
func (s *DetectStackDriftOutput) SetStackDriftDetectionId(v string) *DetectStackDriftOutput {
	s.StackDriftDetectionId = &v
	return s
}

type DetectStackResourceDriftInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource for which to return drift information.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name of the stack to which the resource belongs.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackResourceDriftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackResourceDriftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectStackResourceDriftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectStackResourceDriftInput"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DetectStackResourceDriftInput) SetLogicalResourceId(v string) *DetectStackResourceDriftInput {
	s.LogicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DetectStackResourceDriftInput) SetStackName(v string) *DetectStackResourceDriftInput {
	s.StackName = &v
	return s
}

type DetectStackResourceDriftOutput struct {
	_ struct{} `type:"structure"`

	// Information about whether the resource's actual configuration has drifted
	// from its expected template configuration, including actual and expected property
	// values and any differences detected.
	//
	// StackResourceDrift is a required field
	StackResourceDrift *StackResourceDrift `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackResourceDriftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackResourceDriftOutput) GoString() string {
	return s.String()
}

// SetStackResourceDrift sets the StackResourceDrift field's value.
func (s *DetectStackResourceDriftOutput) SetStackResourceDrift(v *StackResourceDrift) *DetectStackResourceDriftOutput {
	s.StackResourceDrift = v
	return s
}

type DetectStackSetDriftInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The ID of the stack set operation.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// The user-specified preferences for how CloudFormation performs a stack set
	// operation.
	//
	// For more information about maximum concurrent accounts and failure tolerance,
	// see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// The name of the stack set on which to perform the drift detection operation.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackSetDriftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackSetDriftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectStackSetDriftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectStackSetDriftInput"}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *DetectStackSetDriftInput) SetCallAs(v string) *DetectStackSetDriftInput {
	s.CallAs = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *DetectStackSetDriftInput) SetOperationId(v string) *DetectStackSetDriftInput {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *DetectStackSetDriftInput) SetOperationPreferences(v *StackSetOperationPreferences) *DetectStackSetDriftInput {
	s.OperationPreferences = v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *DetectStackSetDriftInput) SetStackSetName(v string) *DetectStackSetDriftInput {
	s.StackSetName = &v
	return s
}

type DetectStackSetDriftOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the drift detection stack set operation.
	//
	// You can use this operation ID with DescribeStackSetOperation to monitor the
	// progress of the drift detection operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackSetDriftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectStackSetDriftOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *DetectStackSetDriftOutput) SetOperationId(v string) *DetectStackSetDriftOutput {
	s.OperationId = &v
	return s
}

// The input for an EstimateTemplateCost action.
type EstimateTemplateCostInput struct {
	_ struct{} `type:"structure"`

	// A list of Parameter structures that specify input parameters.
	Parameters []*Parameter `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide.)
	//
	// Conditional: You must pass TemplateBody or TemplateURL. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that's located in an Amazon S3 bucket or a Systems Manager document. For
	// more information, go to Template Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide. The location for an Amazon S3 bucket must
	// start with https://.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstimateTemplateCostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstimateTemplateCostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EstimateTemplateCostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EstimateTemplateCostInput"}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *EstimateTemplateCostInput) SetParameters(v []*Parameter) *EstimateTemplateCostInput {
	s.Parameters = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *EstimateTemplateCostInput) SetTemplateBody(v string) *EstimateTemplateCostInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *EstimateTemplateCostInput) SetTemplateURL(v string) *EstimateTemplateCostInput {
	s.TemplateURL = &v
	return s
}

// The output for a EstimateTemplateCost action.
type EstimateTemplateCostOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Web Services Simple Monthly Calculator URL with a query string
	// that describes the resources required to run the template.
	Url *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstimateTemplateCostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstimateTemplateCostOutput) GoString() string {
	return s.String()
}

// SetUrl sets the Url field's value.
func (s *EstimateTemplateCostOutput) SetUrl(v string) *EstimateTemplateCostOutput {
	s.Url = &v
	return s
}

// The input for the ExecuteChangeSet action.
type ExecuteChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want use
	// to update the specified stack.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for this ExecuteChangeSet request. Specify this token
	// if you plan to retry requests so that CloudFormation knows that you're not
	// attempting to execute a change set to update a stack with the same name.
	// You might retry ExecuteChangeSet requests to ensure that CloudFormation successfully
	// received them.
	ClientRequestToken *string `min:"1" type:"string"`

	// Preserves the state of previously provisioned resources when an operation
	// fails. This parameter can't be specified when the OnStackFailure parameter
	// to the CreateChangeSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html)
	// API operation was specified.
	//
	//    * True - if the stack creation fails, do nothing. This is equivalent to
	//    specifying DO_NOTHING for the OnStackFailure parameter to the CreateChangeSet
	//    (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html)
	//    API operation.
	//
	//    * False - if the stack creation fails, roll back the stack. This is equivalent
	//    to specifying ROLLBACK for the OnStackFailure parameter to the CreateChangeSet
	//    (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html)
	//    API operation.
	//
	// Default: True
	DisableRollback *bool `type:"boolean"`

	// When set to true, newly created resources are deleted when the operation
	// rolls back. This includes newly created resources marked with a deletion
	// policy of Retain.
	//
	// Default: false
	RetainExceptOnCreate *bool `type:"boolean"`

	// If you specified the name of a change set, specify the stack name or Amazon
	// Resource Name (ARN) that's associated with the change set you want to execute.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *ExecuteChangeSetInput) SetChangeSetName(v string) *ExecuteChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *ExecuteChangeSetInput) SetClientRequestToken(v string) *ExecuteChangeSetInput {
	s.ClientRequestToken = &v
	return s
}

// SetDisableRollback sets the DisableRollback field's value.
func (s *ExecuteChangeSetInput) SetDisableRollback(v bool) *ExecuteChangeSetInput {
	s.DisableRollback = &v
	return s
}

// SetRetainExceptOnCreate sets the RetainExceptOnCreate field's value.
func (s *ExecuteChangeSetInput) SetRetainExceptOnCreate(v bool) *ExecuteChangeSetInput {
	s.RetainExceptOnCreate = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ExecuteChangeSetInput) SetStackName(v string) *ExecuteChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the ExecuteChangeSet action.
type ExecuteChangeSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteChangeSetOutput) GoString() string {
	return s.String()
}

// The Export structure describes the exported output values for a stack.
type Export struct {
	_ struct{} `type:"structure"`

	// The stack that contains the exported output name and value.
	ExportingStackId *string `type:"string"`

	// The name of exported output value. Use this name and the Fn::ImportValue
	// function to import the associated value into other stacks. The name is defined
	// in the Export field in the associated stack's Outputs section.
	Name *string `type:"string"`

	// The value of the exported output, such as a resource physical ID. This value
	// is defined in the Export field in the associated stack's Outputs section.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Export) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Export) GoString() string {
	return s.String()
}

// SetExportingStackId sets the ExportingStackId field's value.
func (s *Export) SetExportingStackId(v string) *Export {
	s.ExportingStackId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Export) SetName(v string) *Export {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Export) SetValue(v string) *Export {
	s.Value = &v
	return s
}

type GetGeneratedTemplateInput struct {
	_ struct{} `type:"structure"`

	// The language to use to retrieve for the generated template. Supported values
	// are:
	//
	//    * JSON
	//
	//    * YAML
	Format *string `type:"string" enum:"TemplateFormat"`

	// The name or Amazon Resource Name (ARN) of the generated template. The format
	// is arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}.
	// For example, arn:aws:cloudformation:us-east-1:123456789012:generatedtemplate/2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc .
	//
	// GeneratedTemplateName is a required field
	GeneratedTemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeneratedTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGeneratedTemplateInput"}
	if s.GeneratedTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneratedTemplateName"))
	}
	if s.GeneratedTemplateName != nil && len(*s.GeneratedTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeneratedTemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *GetGeneratedTemplateInput) SetFormat(v string) *GetGeneratedTemplateInput {
	s.Format = &v
	return s
}

// SetGeneratedTemplateName sets the GeneratedTemplateName field's value.
func (s *GetGeneratedTemplateInput) SetGeneratedTemplateName(v string) *GetGeneratedTemplateInput {
	s.GeneratedTemplateName = &v
	return s
}

type GetGeneratedTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The status of the template generation. Supported values are:
	//
	//    * CreatePending - the creation of the template is pending.
	//
	//    * CreateInProgress - the creation of the template is in progress.
	//
	//    * DeletePending - the deletion of the template is pending.
	//
	//    * DeleteInProgress - the deletion of the template is in progress.
	//
	//    * UpdatePending - the update of the template is pending.
	//
	//    * UpdateInProgress - the update of the template is in progress.
	//
	//    * Failed - the template operation failed.
	//
	//    * Complete - the template operation is complete.
	Status *string `type:"string" enum:"GeneratedTemplateStatus"`

	// The template body of the generated template, in the language specified by
	// the Language parameter.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedTemplateOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetGeneratedTemplateOutput) SetStatus(v string) *GetGeneratedTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *GetGeneratedTemplateOutput) SetTemplateBody(v string) *GetGeneratedTemplateOutput {
	s.TemplateBody = &v
	return s
}

// The input for the GetStackPolicy action.
type GetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that's associated with the stack whose policy
	// you want to get.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStackPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStackPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStackPolicyInput"}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *GetStackPolicyInput) SetStackName(v string) *GetStackPolicyInput {
	s.StackName = &v
	return s
}

// The output for the GetStackPolicy action.
type GetStackPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Structure containing the stack policy body. (For more information, go to
	// Prevent Updates to Stack Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the CloudFormation User Guide.)
	StackPolicyBody *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStackPolicyOutput) GoString() string {
	return s.String()
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *GetStackPolicyOutput) SetStackPolicyBody(v string) *GetStackPolicyOutput {
	s.StackPolicyBody = &v
	return s
}

// The input for a GetTemplate action.
type GetTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of a change set for which CloudFormation
	// returns the associated template. If you specify a name, you must also specify
	// the StackName.
	ChangeSetName *string `min:"1" type:"string"`

	// The name or the unique stack ID that's associated with the stack, which aren't
	// always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`

	// For templates that include transforms, the stage of the template that CloudFormation
	// returns. To get the user-submitted template, specify Original. To get the
	// template after CloudFormation has processed all transforms, specify Processed.
	//
	// If the template doesn't include transforms, Original and Processed return
	// the same template. By default, CloudFormation specifies Processed.
	TemplateStage *string `type:"string" enum:"TemplateStage"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *GetTemplateInput) SetChangeSetName(v string) *GetTemplateInput {
	s.ChangeSetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *GetTemplateInput) SetStackName(v string) *GetTemplateInput {
	s.StackName = &v
	return s
}

// SetTemplateStage sets the TemplateStage field's value.
func (s *GetTemplateInput) SetTemplateStage(v string) *GetTemplateInput {
	s.TemplateStage = &v
	return s
}

// The output for GetTemplate action.
type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The stage of the template that you can retrieve. For stacks, the Original
	// and Processed templates are always available. For change sets, the Original
	// template is always available. After CloudFormation finishes creating the
	// change set, the Processed template becomes available.
	StagesAvailable []*string `type:"list" enum:"TemplateStage"`

	// Structure containing the template body. (For more information, go to Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide.)
	//
	// CloudFormation returns the same template that was used when the stack was
	// created.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// SetStagesAvailable sets the StagesAvailable field's value.
func (s *GetTemplateOutput) SetStagesAvailable(v []*string) *GetTemplateOutput {
	s.StagesAvailable = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *GetTemplateOutput) SetTemplateBody(v string) *GetTemplateOutput {
	s.TemplateBody = &v
	return s
}

// The input for the GetTemplateSummary action.
type GetTemplateSummaryInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The name or the stack ID that's associated with the stack, which aren't always
	// interchangeable. For running stacks, you can specify either the stack's name
	// or its unique stack ID. For deleted stack, you must specify the unique stack
	// ID.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	StackName *string `min:"1" type:"string"`

	// The name or unique ID of the stack set from which the stack was created.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	StackSetName *string `type:"string"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information about templates, see
	// Template anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// Specifies options for the GetTemplateSummary API action.
	TemplateSummaryConfig *TemplateSummaryConfig `type:"structure"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that's located in an Amazon S3 bucket or a Systems
	// Manager document. For more information about templates, see Template anatomy
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the CloudFormation User Guide. The location for an Amazon S3 bucket must
	// start with https://.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// StackSetName, TemplateBody, or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateSummaryInput"}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *GetTemplateSummaryInput) SetCallAs(v string) *GetTemplateSummaryInput {
	s.CallAs = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *GetTemplateSummaryInput) SetStackName(v string) *GetTemplateSummaryInput {
	s.StackName = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *GetTemplateSummaryInput) SetStackSetName(v string) *GetTemplateSummaryInput {
	s.StackSetName = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *GetTemplateSummaryInput) SetTemplateBody(v string) *GetTemplateSummaryInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateSummaryConfig sets the TemplateSummaryConfig field's value.
func (s *GetTemplateSummaryInput) SetTemplateSummaryConfig(v *TemplateSummaryConfig) *GetTemplateSummaryInput {
	s.TemplateSummaryConfig = v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *GetTemplateSummaryInput) SetTemplateURL(v string) *GetTemplateSummaryInput {
	s.TemplateURL = &v
	return s
}

// The output for the GetTemplateSummary action.
type GetTemplateSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The capabilities found within the template. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value
	// for this parameter when you use the CreateStack or UpdateStack actions with
	// your template; otherwise, those actions return an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in CloudFormation Templates
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []*string `type:"list" enum:"Capability"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// A list of the transforms that are declared in the template.
	DeclaredTransforms []*string `type:"list"`

	// The value that's defined in the Description property of the template.
	Description *string `min:"1" type:"string"`

	// The value that's defined for the Metadata property of the template.
	Metadata *string `type:"string"`

	// A list of parameter declarations that describe various properties for each
	// parameter.
	Parameters []*ParameterDeclaration `type:"list"`

	// A list of resource identifier summaries that describe the target resources
	// of an import operation and the properties you can provide during the import
	// to identify the target resources. For example, BucketName is a possible identifier
	// property for an AWS::S3::Bucket resource.
	ResourceIdentifierSummaries []*ResourceIdentifierSummary `type:"list"`

	// A list of all the template resource types that are defined in the template,
	// such as AWS::EC2::Instance, AWS::Dynamo::Table, and Custom::MyCustomInstance.
	ResourceTypes []*string `type:"list"`

	// The Amazon Web Services template format version, which identifies the capabilities
	// of the template.
	Version *string `type:"string"`

	// An object containing any warnings returned.
	Warnings *Warnings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSummaryOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *GetTemplateSummaryOutput) SetCapabilities(v []*string) *GetTemplateSummaryOutput {
	s.Capabilities = v
	return s
}

// SetCapabilitiesReason sets the CapabilitiesReason field's value.
func (s *GetTemplateSummaryOutput) SetCapabilitiesReason(v string) *GetTemplateSummaryOutput {
	s.CapabilitiesReason = &v
	return s
}

// SetDeclaredTransforms sets the DeclaredTransforms field's value.
func (s *GetTemplateSummaryOutput) SetDeclaredTransforms(v []*string) *GetTemplateSummaryOutput {
	s.DeclaredTransforms = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTemplateSummaryOutput) SetDescription(v string) *GetTemplateSummaryOutput {
	s.Description = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetTemplateSummaryOutput) SetMetadata(v string) *GetTemplateSummaryOutput {
	s.Metadata = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetTemplateSummaryOutput) SetParameters(v []*ParameterDeclaration) *GetTemplateSummaryOutput {
	s.Parameters = v
	return s
}

// SetResourceIdentifierSummaries sets the ResourceIdentifierSummaries field's value.
func (s *GetTemplateSummaryOutput) SetResourceIdentifierSummaries(v []*ResourceIdentifierSummary) *GetTemplateSummaryOutput {
	s.ResourceIdentifierSummaries = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetTemplateSummaryOutput) SetResourceTypes(v []*string) *GetTemplateSummaryOutput {
	s.ResourceTypes = v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetTemplateSummaryOutput) SetVersion(v string) *GetTemplateSummaryOutput {
	s.Version = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *GetTemplateSummaryOutput) SetWarnings(v *Warnings) *GetTemplateSummaryOutput {
	s.Warnings = v
	return s
}

type ImportStacksToStackSetInput struct {
	_ struct{} `type:"structure"`

	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * For service managed stack sets, specify DELEGATED_ADMIN.
	CallAs *string `type:"string" enum:"CallAs"`

	// A unique, user defined, identifier for the stack set operation.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// The user-specified preferences for how CloudFormation performs a stack set
	// operation.
	//
	// For more information about maximum concurrent accounts and failure tolerance,
	// see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// The list of OU ID's to which the stacks being imported has to be mapped as
	// deployment target.
	OrganizationalUnitIds []*string `type:"list"`

	// The IDs of the stacks you are importing into a stack set. You import up to
	// 10 stacks per stack set at a time.
	//
	// Specify either StackIds or StackIdsUrl.
	StackIds []*string `type:"list"`

	// The Amazon S3 URL which contains list of stack ids to be inputted.
	//
	// Specify either StackIds or StackIdsUrl.
	StackIdsUrl *string `min:"1" type:"string"`

	// The name of the stack set. The name must be unique in the Region where you
	// create your stack set.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportStacksToStackSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportStacksToStackSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportStacksToStackSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportStacksToStackSetInput"}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackIdsUrl != nil && len(*s.StackIdsUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackIdsUrl", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *ImportStacksToStackSetInput) SetCallAs(v string) *ImportStacksToStackSetInput {
	s.CallAs = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *ImportStacksToStackSetInput) SetOperationId(v string) *ImportStacksToStackSetInput {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *ImportStacksToStackSetInput) SetOperationPreferences(v *StackSetOperationPreferences) *ImportStacksToStackSetInput {
	s.OperationPreferences = v
	return s
}

// SetOrganizationalUnitIds sets the OrganizationalUnitIds field's value.
func (s *ImportStacksToStackSetInput) SetOrganizationalUnitIds(v []*string) *ImportStacksToStackSetInput {
	s.OrganizationalUnitIds = v
	return s
}

// SetStackIds sets the StackIds field's value.
func (s *ImportStacksToStackSetInput) SetStackIds(v []*string) *ImportStacksToStackSetInput {
	s.StackIds = v
	return s
}

// SetStackIdsUrl sets the StackIdsUrl field's value.
func (s *ImportStacksToStackSetInput) SetStackIdsUrl(v string) *ImportStacksToStackSetInput {
	s.StackIdsUrl = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ImportStacksToStackSetInput) SetStackSetName(v string) *ImportStacksToStackSetInput {
	s.StackSetName = &v
	return s
}

type ImportStacksToStackSetOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportStacksToStackSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportStacksToStackSetOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *ImportStacksToStackSetOutput) SetOperationId(v string) *ImportStacksToStackSetOutput {
	s.OperationId = &v
	return s
}

// The input for the ListChangeSets action.
type ListChangeSetsInput struct {
	_ struct{} `type:"structure"`

	// A string (provided by the ListChangeSets response output) that identifies
	// the next page of change sets that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the Amazon Resource Name (ARN) of the stack for which you want
	// to list change sets.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangeSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangeSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChangeSetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsInput) SetNextToken(v string) *ListChangeSetsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListChangeSetsInput) SetStackName(v string) *ListChangeSetsInput {
	s.StackName = &v
	return s
}

// The output for the ListChangeSets action.
type ListChangeSetsOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB, a string that identifies the next page of change
	// sets. If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of ChangeSetSummary structures that provides the ID and status of
	// each change set for the specified stack.
	Summaries []*ChangeSetSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangeSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangeSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsOutput) SetNextToken(v string) *ListChangeSetsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListChangeSetsOutput) SetSummaries(v []*ChangeSetSummary) *ListChangeSetsOutput {
	s.Summaries = v
	return s
}

type ListExportsInput struct {
	_ struct{} `type:"structure"`

	// A string (provided by the ListExports response output) that identifies the
	// next page of exported output values that you asked to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExportsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsInput) SetNextToken(v string) *ListExportsInput {
	s.NextToken = &v
	return s
}

type ListExportsOutput struct {
	_ struct{} `type:"structure"`

	// The output for the ListExports action.
	Exports []*Export `type:"list"`

	// If the output exceeds 100 exported output values, a string that identifies
	// the next page of exports. If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsOutput) GoString() string {
	return s.String()
}

// SetExports sets the Exports field's value.
func (s *ListExportsOutput) SetExports(v []*Export) *ListExportsOutput {
	s.Exports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsOutput) SetNextToken(v string) *ListExportsOutput {
	s.NextToken = &v
	return s
}

type ListGeneratedTemplatesInput struct {
	_ struct{} `type:"structure"`

	// If the number of available results exceeds this maximum, the response includes
	// a NextToken value that you can use for the NextToken parameter to get the
	// next set of results. By default the ListGeneratedTemplates API action will
	// return at most 50 results in each response. The maximum value is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string that identifies the next page of resource scan results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeneratedTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeneratedTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeneratedTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeneratedTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGeneratedTemplatesInput) SetMaxResults(v int64) *ListGeneratedTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeneratedTemplatesInput) SetNextToken(v string) *ListGeneratedTemplatesInput {
	s.NextToken = &v
	return s
}

type ListGeneratedTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call ListGeneratedTemplates
	// again and use that value for the NextToken parameter. If the request returns
	// all results, NextToken is set to an empty string.
	NextToken *string `min:"1" type:"string"`

	// A list of summaries of the generated templates.
	Summaries []*TemplateSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeneratedTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeneratedTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeneratedTemplatesOutput) SetNextToken(v string) *ListGeneratedTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListGeneratedTemplatesOutput) SetSummaries(v []*TemplateSummary) *ListGeneratedTemplatesOutput {
	s.Summaries = v
	return s
}

type ListImportsInput struct {
	_ struct{} `type:"structure"`

	// The name of the exported output value. CloudFormation returns the stack names
	// that are importing this value.
	//
	// ExportName is a required field
	ExportName *string `type:"string" required:"true"`

	// A string (provided by the ListImports response output) that identifies the
	// next page of stacks that are importing the specified exported output value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImportsInput"}
	if s.ExportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportName"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportName sets the ExportName field's value.
func (s *ListImportsInput) SetExportName(v string) *ListImportsInput {
	s.ExportName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportsInput) SetNextToken(v string) *ListImportsInput {
	s.NextToken = &v
	return s
}

type ListImportsOutput struct {
	_ struct{} `type:"structure"`

	// A list of stack names that are importing the specified exported output value.
	Imports []*string `type:"list"`

	// A string that identifies the next page of exports. If there is no additional
	// page, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportsOutput) GoString() string {
	return s.String()
}

// SetImports sets the Imports field's value.
func (s *ListImportsOutput) SetImports(v []*string) *ListImportsOutput {
	s.Imports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportsOutput) SetNextToken(v string) *ListImportsOutput {
	s.NextToken = &v
	return s
}

type ListResourceScanRelatedResourcesInput struct {
	_ struct{} `type:"structure"`

	// If the number of available results exceeds this maximum, the response includes
	// a NextToken value that you can use for the NextToken parameter to get the
	// next set of results. By default the ListResourceScanRelatedResources API
	// action will return up to 100 results in each response. The maximum value
	// is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string that identifies the next page of resource scan results.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource scan.
	//
	// ResourceScanId is a required field
	ResourceScanId *string `type:"string" required:"true"`

	// The list of resources for which you want to get the related resources. Up
	// to 100 resources can be provided.
	//
	// Resources is a required field
	Resources []*ScannedResourceIdentifier `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScanRelatedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScanRelatedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceScanRelatedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceScanRelatedResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceScanId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceScanId"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceScanRelatedResourcesInput) SetMaxResults(v int64) *ListResourceScanRelatedResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceScanRelatedResourcesInput) SetNextToken(v string) *ListResourceScanRelatedResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceScanId sets the ResourceScanId field's value.
func (s *ListResourceScanRelatedResourcesInput) SetResourceScanId(v string) *ListResourceScanRelatedResourcesInput {
	s.ResourceScanId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListResourceScanRelatedResourcesInput) SetResources(v []*ScannedResourceIdentifier) *ListResourceScanRelatedResourcesInput {
	s.Resources = v
	return s
}

type ListResourceScanRelatedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call ListResourceScanRelatedResources
	// again and use that value for the NextToken parameter. If the request returns
	// all results, NextToken is set to an empty string.
	NextToken *string `min:"1" type:"string"`

	// List of up to MaxResults resources in the specified resource scan related
	// to the specified resources.
	RelatedResources []*ScannedResource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScanRelatedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScanRelatedResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceScanRelatedResourcesOutput) SetNextToken(v string) *ListResourceScanRelatedResourcesOutput {
	s.NextToken = &v
	return s
}

// SetRelatedResources sets the RelatedResources field's value.
func (s *ListResourceScanRelatedResourcesOutput) SetRelatedResources(v []*ScannedResource) *ListResourceScanRelatedResourcesOutput {
	s.RelatedResources = v
	return s
}

type ListResourceScanResourcesInput struct {
	_ struct{} `type:"structure"`

	// If the number of available results exceeds this maximum, the response includes
	// a NextToken value that you can use for the NextToken parameter to get the
	// next set of results. By default the ListResourceScanResources API action
	// will return at most 100 results in each response. The maximum value is 100.
	MaxResults *int64 `type:"integer"`

	// A string that identifies the next page of resource scan results.
	NextToken *string `min:"1" type:"string"`

	// If specified, the returned resources will have the specified resource identifier
	// (or one of them in the case where the resource has multiple identifiers).
	ResourceIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) of the resource scan.
	//
	// ResourceScanId is a required field
	ResourceScanId *string `type:"string" required:"true"`

	// If specified, the returned resources will be of any of the resource types
	// with the specified prefix.
	ResourceTypePrefix *string `type:"string"`

	// If specified, the returned resources will have a matching tag key.
	TagKey *string `min:"1" type:"string"`

	// If specified, the returned resources will have a matching tag value.
	TagValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScanResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScanResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceScanResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceScanResourcesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceScanId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceScanId"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValue != nil && len(*s.TagValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceScanResourcesInput) SetMaxResults(v int64) *ListResourceScanResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceScanResourcesInput) SetNextToken(v string) *ListResourceScanResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ListResourceScanResourcesInput) SetResourceIdentifier(v string) *ListResourceScanResourcesInput {
	s.ResourceIdentifier = &v
	return s
}

// SetResourceScanId sets the ResourceScanId field's value.
func (s *ListResourceScanResourcesInput) SetResourceScanId(v string) *ListResourceScanResourcesInput {
	s.ResourceScanId = &v
	return s
}

// SetResourceTypePrefix sets the ResourceTypePrefix field's value.
func (s *ListResourceScanResourcesInput) SetResourceTypePrefix(v string) *ListResourceScanResourcesInput {
	s.ResourceTypePrefix = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *ListResourceScanResourcesInput) SetTagKey(v string) *ListResourceScanResourcesInput {
	s.TagKey = &v
	return s
}

// SetTagValue sets the TagValue field's value.
func (s *ListResourceScanResourcesInput) SetTagValue(v string) *ListResourceScanResourcesInput {
	s.TagValue = &v
	return s
}

type ListResourceScanResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call ListResourceScanResources
	// again and use that value for the NextToken parameter. If the request returns
	// all results, NextToken is set to an empty string.
	NextToken *string `min:"1" type:"string"`

	// List of up to MaxResults resources in the specified resource scan that match
	// all of the specified filters.
	Resources []*ScannedResource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScanResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScanResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceScanResourcesOutput) SetNextToken(v string) *ListResourceScanResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListResourceScanResourcesOutput) SetResources(v []*ScannedResource) *ListResourceScanResourcesOutput {
	s.Resources = v
	return s
}

type ListResourceScansInput struct {
	_ struct{} `type:"structure"`

	// If the number of available results exceeds this maximum, the response includes
	// a NextToken value that you can use for the NextToken parameter to get the
	// next set of results. The default value is 10. The maximum value is 100.
	MaxResults *int64 `type:"integer"`

	// A string that identifies the next page of resource scan results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceScansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceScansInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceScansInput) SetMaxResults(v int64) *ListResourceScansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceScansInput) SetNextToken(v string) *ListResourceScansInput {
	s.NextToken = &v
	return s
}

type ListResourceScansOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call ListResourceScans again
	// and use that value for the NextToken parameter. If the request returns all
	// results, NextToken is set to an empty string.
	NextToken *string `min:"1" type:"string"`

	// The list of scans returned.
	ResourceScanSummaries []*ResourceScanSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceScansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceScansOutput) SetNextToken(v string) *ListResourceScansOutput {
	s.NextToken = &v
	return s
}

// SetResourceScanSummaries sets the ResourceScanSummaries field's value.
func (s *ListResourceScansOutput) SetResourceScanSummaries(v []*ResourceScanSummary) *ListResourceScansOutput {
	s.ResourceScanSummaries = v
	return s
}

type ListStackInstanceResourceDriftsInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The unique ID of the drift operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name of the Amazon Web Services account that you want to list resource
	// drifts for.
	//
	// StackInstanceAccount is a required field
	StackInstanceAccount *string `type:"string" required:"true"`

	// The name of the Region where you want to list resource drifts.
	//
	// StackInstanceRegion is a required field
	StackInstanceRegion *string `type:"string" required:"true"`

	// The resource drift status of the stack instance.
	//
	//    * DELETED: The resource differs from its expected template configuration
	//    in that the resource has been deleted.
	//
	//    * MODIFIED: One or more resource properties differ from their expected
	//    template values.
	//
	//    * IN_SYNC: The resource's actual configuration matches its expected template
	//    configuration.
	//
	//    * NOT_CHECKED: CloudFormation doesn't currently return this value.
	StackInstanceResourceDriftStatuses []*string `min:"1" type:"list" enum:"StackResourceDriftStatus"`

	// The name or unique ID of the stack set that you want to list drifted resources
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackInstanceResourceDriftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackInstanceResourceDriftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackInstanceResourceDriftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackInstanceResourceDriftsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackInstanceAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("StackInstanceAccount"))
	}
	if s.StackInstanceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("StackInstanceRegion"))
	}
	if s.StackInstanceResourceDriftStatuses != nil && len(s.StackInstanceResourceDriftStatuses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackInstanceResourceDriftStatuses", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *ListStackInstanceResourceDriftsInput) SetCallAs(v string) *ListStackInstanceResourceDriftsInput {
	s.CallAs = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackInstanceResourceDriftsInput) SetMaxResults(v int64) *ListStackInstanceResourceDriftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackInstanceResourceDriftsInput) SetNextToken(v string) *ListStackInstanceResourceDriftsInput {
	s.NextToken = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *ListStackInstanceResourceDriftsInput) SetOperationId(v string) *ListStackInstanceResourceDriftsInput {
	s.OperationId = &v
	return s
}

// SetStackInstanceAccount sets the StackInstanceAccount field's value.
func (s *ListStackInstanceResourceDriftsInput) SetStackInstanceAccount(v string) *ListStackInstanceResourceDriftsInput {
	s.StackInstanceAccount = &v
	return s
}

// SetStackInstanceRegion sets the StackInstanceRegion field's value.
func (s *ListStackInstanceResourceDriftsInput) SetStackInstanceRegion(v string) *ListStackInstanceResourceDriftsInput {
	s.StackInstanceRegion = &v
	return s
}

// SetStackInstanceResourceDriftStatuses sets the StackInstanceResourceDriftStatuses field's value.
func (s *ListStackInstanceResourceDriftsInput) SetStackInstanceResourceDriftStatuses(v []*string) *ListStackInstanceResourceDriftsInput {
	s.StackInstanceResourceDriftStatuses = v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ListStackInstanceResourceDriftsInput) SetStackSetName(v string) *ListStackInstanceResourceDriftsInput {
	s.StackSetName = &v
	return s
}

type ListStackInstanceResourceDriftsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackInstanceResourceDriftSummary structures that contain information
	// about the specified stack instances.
	Summaries []*StackInstanceResourceDriftsSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackInstanceResourceDriftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackInstanceResourceDriftsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackInstanceResourceDriftsOutput) SetNextToken(v string) *ListStackInstanceResourceDriftsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackInstanceResourceDriftsOutput) SetSummaries(v []*StackInstanceResourceDriftsSummary) *ListStackInstanceResourceDriftsOutput {
	s.Summaries = v
	return s
}

type ListStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The filter to apply to stack instances
	Filters []*StackInstanceFilter `type:"list"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous request didn't return all the remaining results, the response's
	// NextToken parameter value is set to a token. To retrieve the next set of
	// results, call ListStackInstances again and assign that token to the request
	// object's NextToken parameter. If there are no remaining results, the previous
	// response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The name of the Amazon Web Services account that you want to list stack instances
	// for.
	StackInstanceAccount *string `type:"string"`

	// The name of the Region where you want to list stack instances.
	StackInstanceRegion *string `type:"string"`

	// The name or unique ID of the stack set that you want to list stack instances
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *ListStackInstancesInput) SetCallAs(v string) *ListStackInstancesInput {
	s.CallAs = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListStackInstancesInput) SetFilters(v []*StackInstanceFilter) *ListStackInstancesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackInstancesInput) SetMaxResults(v int64) *ListStackInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackInstancesInput) SetNextToken(v string) *ListStackInstancesInput {
	s.NextToken = &v
	return s
}

// SetStackInstanceAccount sets the StackInstanceAccount field's value.
func (s *ListStackInstancesInput) SetStackInstanceAccount(v string) *ListStackInstancesInput {
	s.StackInstanceAccount = &v
	return s
}

// SetStackInstanceRegion sets the StackInstanceRegion field's value.
func (s *ListStackInstancesInput) SetStackInstanceRegion(v string) *ListStackInstancesInput {
	s.StackInstanceRegion = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ListStackInstancesInput) SetStackSetName(v string) *ListStackInstancesInput {
	s.StackSetName = &v
	return s
}

type ListStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call ListStackInstances
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackInstanceSummary structures that contain information about
	// the specified stack instances.
	Summaries []*StackInstanceSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackInstancesOutput) SetNextToken(v string) *ListStackInstancesOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackInstancesOutput) SetSummaries(v []*StackInstanceSummary) *ListStackInstancesOutput {
	s.Summaries = v
	return s
}

// The input for the ListStackResource action.
type ListStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stack resources that you want to
	// retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// aren't always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackResourcesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackResourcesInput) SetNextToken(v string) *ListStackResourcesInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListStackResourcesInput) SetStackName(v string) *ListStackResourcesInput {
	s.StackName = &v
	return s
}

// The output for a ListStackResources action.
type ListStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB, a string that identifies the next page of stack
	// resources. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackResourceSummary structures.
	StackResourceSummaries []*StackResourceSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackResourcesOutput) SetNextToken(v string) *ListStackResourcesOutput {
	s.NextToken = &v
	return s
}

// SetStackResourceSummaries sets the StackResourceSummaries field's value.
func (s *ListStackResourcesOutput) SetStackResourceSummaries(v []*StackResourceSummary) *ListStackResourcesOutput {
	s.StackResourceSummaries = v
	return s
}

type ListStackSetAutoDeploymentTargetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether you are acting as an account administrator in the organization's
	// management account or as a delegated administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for StackSets with self-managed permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string that identifies the next page of stack set deployment targets that
	// you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or unique ID of the stack set that you want to get automatic deployment
	// targets for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetAutoDeploymentTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetAutoDeploymentTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetAutoDeploymentTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackSetAutoDeploymentTargetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *ListStackSetAutoDeploymentTargetsInput) SetCallAs(v string) *ListStackSetAutoDeploymentTargetsInput {
	s.CallAs = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackSetAutoDeploymentTargetsInput) SetMaxResults(v int64) *ListStackSetAutoDeploymentTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetAutoDeploymentTargetsInput) SetNextToken(v string) *ListStackSetAutoDeploymentTargetsInput {
	s.NextToken = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ListStackSetAutoDeploymentTargetsInput) SetStackSetName(v string) *ListStackSetAutoDeploymentTargetsInput {
	s.StackSetName = &v
	return s
}

type ListStackSetAutoDeploymentTargetsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call ListStackSetAutoDeploymentTargets
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetAutoDeploymentTargets.html)
	// again and use that value for the NextToken parameter. If the request returns
	// all results, NextToken is set to an empty string.
	NextToken *string `min:"1" type:"string"`

	// An array of summaries of the deployment targets for the stack set.
	Summaries []*StackSetAutoDeploymentTargetSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetAutoDeploymentTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetAutoDeploymentTargetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetAutoDeploymentTargetsOutput) SetNextToken(v string) *ListStackSetAutoDeploymentTargetsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackSetAutoDeploymentTargetsOutput) SetSummaries(v []*StackSetAutoDeploymentTargetSummary) *ListStackSetAutoDeploymentTargetsOutput {
	s.Summaries = v
	return s
}

type ListStackSetOperationResultsInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The filter to apply to operation results.
	Filters []*OperationResultFilter `type:"list"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous request didn't return all the remaining results, the response
	// object's NextToken parameter value is set to a token. To retrieve the next
	// set of results, call ListStackSetOperationResults again and assign that token
	// to the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The ID of the stack set operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or unique ID of the stack set that you want to get operation results
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetOperationResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetOperationResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetOperationResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackSetOperationResultsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *ListStackSetOperationResultsInput) SetCallAs(v string) *ListStackSetOperationResultsInput {
	s.CallAs = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListStackSetOperationResultsInput) SetFilters(v []*OperationResultFilter) *ListStackSetOperationResultsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackSetOperationResultsInput) SetMaxResults(v int64) *ListStackSetOperationResultsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetOperationResultsInput) SetNextToken(v string) *ListStackSetOperationResultsInput {
	s.NextToken = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *ListStackSetOperationResultsInput) SetOperationId(v string) *ListStackSetOperationResultsInput {
	s.OperationId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ListStackSetOperationResultsInput) SetStackSetName(v string) *ListStackSetOperationResultsInput {
	s.StackSetName = &v
	return s
}

type ListStackSetOperationResultsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all results, NextToken is set to a token. To
	// retrieve the next set of results, call ListOperationResults again and assign
	// that token to the request object's NextToken parameter. If there are no remaining
	// results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetOperationResultSummary structures that contain information
	// about the specified operation results, for accounts and Amazon Web Services
	// Regions that are included in the operation.
	Summaries []*StackSetOperationResultSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetOperationResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetOperationResultsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetOperationResultsOutput) SetNextToken(v string) *ListStackSetOperationResultsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackSetOperationResultsOutput) SetSummaries(v []*StackSetOperationResultSummary) *ListStackSetOperationResultsOutput {
	s.Summaries = v
	return s
}

type ListStackSetOperationsInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListStackSetOperations again and assign that
	// token to the request object's NextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The name or unique ID of the stack set that you want to get operation summaries
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackSetOperationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *ListStackSetOperationsInput) SetCallAs(v string) *ListStackSetOperationsInput {
	s.CallAs = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackSetOperationsInput) SetMaxResults(v int64) *ListStackSetOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetOperationsInput) SetNextToken(v string) *ListStackSetOperationsInput {
	s.NextToken = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *ListStackSetOperationsInput) SetStackSetName(v string) *ListStackSetOperationsInput {
	s.StackSetName = &v
	return s
}

type ListStackSetOperationsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all results, NextToken is set to a token. To
	// retrieve the next set of results, call ListOperationResults again and assign
	// that token to the request object's NextToken parameter. If there are no remaining
	// results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetOperationSummary structures that contain summary information
	// about operations for the specified stack set.
	Summaries []*StackSetOperationSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetOperationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetOperationsOutput) SetNextToken(v string) *ListStackSetOperationsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackSetOperationsOutput) SetSummaries(v []*StackSetOperationSummary) *ListStackSetOperationsOutput {
	s.Summaries = v
	return s
}

type ListStackSetsInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the management account or as a delegated administrator in
	// a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListStackSets again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The status of the stack sets that you want to get summary information about.
	Status *string `type:"string" enum:"StackSetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *ListStackSetsInput) SetCallAs(v string) *ListStackSetsInput {
	s.CallAs = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStackSetsInput) SetMaxResults(v int64) *ListStackSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetsInput) SetNextToken(v string) *ListStackSetsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListStackSetsInput) SetStatus(v string) *ListStackSetsInput {
	s.Status = &v
	return s
}

type ListStackSetsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call ListStackInstances
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSetSummary structures that contain information about the user's
	// stack sets.
	Summaries []*StackSetSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStackSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackSetsOutput) SetNextToken(v string) *ListStackSetsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListStackSetsOutput) SetSummaries(v []*StackSetSummary) *ListStackSetsOutput {
	s.Summaries = v
	return s
}

// The input for ListStacks action.
type ListStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Stack status to use as a filter. Specify one or more stack status codes to
	// list only stacks with the specified status codes. For a complete list of
	// stack status codes, see the StackStatus parameter of the Stack data type.
	StackStatusFilter []*string `type:"list" enum:"StackStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListStacksInput) SetNextToken(v string) *ListStacksInput {
	s.NextToken = &v
	return s
}

// SetStackStatusFilter sets the StackStatusFilter field's value.
func (s *ListStacksInput) SetStackStatusFilter(v []*string) *ListStacksInput {
	s.StackStatusFilter = v
	return s
}

// The output for ListStacks action.
type ListStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSummary structures containing information about the specified
	// stacks.
	StackSummaries []*StackSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStacksOutput) SetNextToken(v string) *ListStacksOutput {
	s.NextToken = &v
	return s
}

// SetStackSummaries sets the StackSummaries field's value.
func (s *ListStacksOutput) SetStackSummaries(v []*StackSummary) *ListStacksOutput {
	s.StackSummaries = v
	return s
}

type ListTypeRegistrationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The current status of the extension registration request.
	//
	// The default is IN_PROGRESS.
	RegistrationStatusFilter *string `type:"string" enum:"RegistrationStatus"`

	// The kind of extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Type *string `type:"string" enum:"RegistryType"`

	// The Amazon Resource Name (ARN) of the extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	TypeArn *string `type:"string"`

	// The name of the extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypeRegistrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypeRegistrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypeRegistrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTypeRegistrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTypeRegistrationsInput) SetMaxResults(v int64) *ListTypeRegistrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypeRegistrationsInput) SetNextToken(v string) *ListTypeRegistrationsInput {
	s.NextToken = &v
	return s
}

// SetRegistrationStatusFilter sets the RegistrationStatusFilter field's value.
func (s *ListTypeRegistrationsInput) SetRegistrationStatusFilter(v string) *ListTypeRegistrationsInput {
	s.RegistrationStatusFilter = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListTypeRegistrationsInput) SetType(v string) *ListTypeRegistrationsInput {
	s.Type = &v
	return s
}

// SetTypeArn sets the TypeArn field's value.
func (s *ListTypeRegistrationsInput) SetTypeArn(v string) *ListTypeRegistrationsInput {
	s.TypeArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ListTypeRegistrationsInput) SetTypeName(v string) *ListTypeRegistrationsInput {
	s.TypeName = &v
	return s
}

type ListTypeRegistrationsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call this action again and
	// assign that token to the request object's NextToken parameter. If the request
	// returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of extension registration tokens.
	//
	// Use DescribeTypeRegistration to return detailed information about a type
	// registration request.
	RegistrationTokenList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypeRegistrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypeRegistrationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypeRegistrationsOutput) SetNextToken(v string) *ListTypeRegistrationsOutput {
	s.NextToken = &v
	return s
}

// SetRegistrationTokenList sets the RegistrationTokenList field's value.
func (s *ListTypeRegistrationsOutput) SetRegistrationTokenList(v []*string) *ListTypeRegistrationsOutput {
	s.RegistrationTokenList = v
	return s
}

type ListTypeVersionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension for which you want version
	// summary information.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Arn *string `type:"string"`

	// The deprecation status of the extension versions that you want to get summary
	// information about.
	//
	// Valid values include:
	//
	//    * LIVE: The extension version is registered and can be used in CloudFormation
	//    operations, dependent on its provisioning behavior and visibility scope.
	//
	//    * DEPRECATED: The extension version has been deregistered and can no longer
	//    be used in CloudFormation operations.
	//
	// The default is LIVE.
	DeprecatedStatus *string `type:"string" enum:"DeprecatedStatus"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The publisher ID of the extension publisher.
	//
	// Extensions published by Amazon aren't assigned a publisher ID.
	PublisherId *string `min:"1" type:"string"`

	// The kind of the extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Type *string `type:"string" enum:"RegistryType"`

	// The name of the extension for which you want version summary information.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypeVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypeVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypeVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTypeVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PublisherId != nil && len(*s.PublisherId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublisherId", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTypeVersionsInput) SetArn(v string) *ListTypeVersionsInput {
	s.Arn = &v
	return s
}

// SetDeprecatedStatus sets the DeprecatedStatus field's value.
func (s *ListTypeVersionsInput) SetDeprecatedStatus(v string) *ListTypeVersionsInput {
	s.DeprecatedStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTypeVersionsInput) SetMaxResults(v int64) *ListTypeVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypeVersionsInput) SetNextToken(v string) *ListTypeVersionsInput {
	s.NextToken = &v
	return s
}

// SetPublisherId sets the PublisherId field's value.
func (s *ListTypeVersionsInput) SetPublisherId(v string) *ListTypeVersionsInput {
	s.PublisherId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListTypeVersionsInput) SetType(v string) *ListTypeVersionsInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ListTypeVersionsInput) SetTypeName(v string) *ListTypeVersionsInput {
	s.TypeName = &v
	return s
}

type ListTypeVersionsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call this action again
	// and assign that token to the request object's NextToken parameter. If the
	// request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of TypeVersionSummary structures that contain information about the
	// specified extension's versions.
	TypeVersionSummaries []*TypeVersionSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypeVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypeVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypeVersionsOutput) SetNextToken(v string) *ListTypeVersionsOutput {
	s.NextToken = &v
	return s
}

// SetTypeVersionSummaries sets the TypeVersionSummaries field's value.
func (s *ListTypeVersionsOutput) SetTypeVersionSummaries(v []*TypeVersionSummary) *ListTypeVersionsOutput {
	s.TypeVersionSummaries = v
	return s
}

type ListTypesInput struct {
	_ struct{} `type:"structure"`

	// The deprecation status of the extension that you want to get summary information
	// about.
	//
	// Valid values include:
	//
	//    * LIVE: The extension is registered for use in CloudFormation operations.
	//
	//    * DEPRECATED: The extension has been deregistered and can no longer be
	//    used in CloudFormation operations.
	DeprecatedStatus *string `type:"string" enum:"DeprecatedStatus"`

	// Filter criteria to use in determining which extensions to return.
	//
	// Filters must be compatible with Visibility to return valid results. For example,
	// specifying AWS_TYPES for Category and PRIVATE for Visibility returns an empty
	// list of types, but specifying PUBLIC for Visibility returns the desired list.
	Filters *TypeFilters `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// For resource types, the provisioning behavior of the resource type. CloudFormation
	// determines the provisioning type during registration, based on the types
	// of handlers in the schema handler package submitted.
	//
	// Valid values include:
	//
	//    * FULLY_MUTABLE: The resource type includes an update handler to process
	//    updates to the type during stack update operations.
	//
	//    * IMMUTABLE: The resource type doesn't include an update handler, so the
	//    type can't be updated and must instead be replaced during stack update
	//    operations.
	//
	//    * NON_PROVISIONABLE: The resource type doesn't include create, read, and
	//    delete handlers, and therefore can't actually be provisioned.
	//
	// The default is FULLY_MUTABLE.
	ProvisioningType *string `type:"string" enum:"ProvisioningType"`

	// The type of extension.
	Type *string `type:"string" enum:"RegistryType"`

	// The scope at which the extensions are visible and usable in CloudFormation
	// operations.
	//
	// Valid values include:
	//
	//    * PRIVATE: Extensions that are visible and usable within this account
	//    and Region. This includes: Private extensions you have registered in this
	//    account and Region. Public extensions that you have activated in this
	//    account and Region.
	//
	//    * PUBLIC: Extensions that are publicly visible and available to be activated
	//    within any Amazon Web Services account. This includes extensions from
	//    Amazon Web Services, in addition to third-party publishers.
	//
	// The default is PRIVATE.
	Visibility *string `type:"string" enum:"Visibility"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeprecatedStatus sets the DeprecatedStatus field's value.
func (s *ListTypesInput) SetDeprecatedStatus(v string) *ListTypesInput {
	s.DeprecatedStatus = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListTypesInput) SetFilters(v *TypeFilters) *ListTypesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTypesInput) SetMaxResults(v int64) *ListTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypesInput) SetNextToken(v string) *ListTypesInput {
	s.NextToken = &v
	return s
}

// SetProvisioningType sets the ProvisioningType field's value.
func (s *ListTypesInput) SetProvisioningType(v string) *ListTypesInput {
	s.ProvisioningType = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListTypesInput) SetType(v string) *ListTypesInput {
	s.Type = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *ListTypesInput) SetVisibility(v string) *ListTypesInput {
	s.Visibility = &v
	return s
}

type ListTypesOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all the remaining results, NextToken is set
	// to a token. To retrieve the next set of results, call this action again and
	// assign that token to the request object's NextToken parameter. If the request
	// returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of TypeSummary structures that contain information about the specified
	// extensions.
	TypeSummaries []*TypeSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypesOutput) SetNextToken(v string) *ListTypesOutput {
	s.NextToken = &v
	return s
}

// SetTypeSummaries sets the TypeSummaries field's value.
func (s *ListTypesOutput) SetTypeSummaries(v []*TypeSummary) *ListTypesOutput {
	s.TypeSummaries = v
	return s
}

// Contains logging configuration information for an extension.
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch Logs group to which CloudFormation sends error logging
	// information when invoking the extension's handlers.
	//
	// LogGroupName is a required field
	LogGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the role that CloudFormation should assume
	// when sending log entries to CloudWatch Logs.
	//
	// LogRoleArn is a required field
	LogRoleArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfig"}
	if s.LogGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.LogRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LogRoleArn"))
	}
	if s.LogRoleArn != nil && len(*s.LogRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogRoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *LoggingConfig) SetLogGroupName(v string) *LoggingConfig {
	s.LogGroupName = &v
	return s
}

// SetLogRoleArn sets the LogRoleArn field's value.
func (s *LoggingConfig) SetLogRoleArn(v string) *LoggingConfig {
	s.LogRoleArn = &v
	return s
}

// Describes whether StackSets performs non-conflicting operations concurrently
// and queues conflicting operations.
type ManagedExecution struct {
	_ struct{} `type:"structure"`

	// When true, StackSets performs non-conflicting operations concurrently and
	// queues conflicting operations. After conflicting operations finish, StackSets
	// starts queued operations in request order.
	//
	// If there are already running or queued operations, StackSets queues all incoming
	// operations even if they are non-conflicting.
	//
	// You can't modify your stack set's execution configuration while there are
	// running or queued operations for that stack set.
	//
	// When false (default), StackSets performs one operation at a time in request
	// order.
	Active *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedExecution) GoString() string {
	return s.String()
}

// SetActive sets the Active field's value.
func (s *ManagedExecution) SetActive(v bool) *ManagedExecution {
	s.Active = &v
	return s
}

// Contains information about the module from which the resource was created,
// if the resource was created from a module included in the stack template.
//
// For more information about modules, see Using modules to encapsulate and
// reuse resource configurations (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/modules.html)
// in the CloudFormation User Guide.
type ModuleInfo struct {
	_ struct{} `type:"structure"`

	// A concatenated list of the logical IDs of the module or modules containing
	// the resource. Modules are listed starting with the inner-most nested module,
	// and separated by /.
	//
	// In the following example, the resource was created from a module, moduleA,
	// that's nested inside a parent module, moduleB.
	//
	// moduleA/moduleB
	//
	// For more information, see Referencing resources in a module (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources)
	// in the CloudFormation User Guide.
	LogicalIdHierarchy *string `type:"string"`

	// A concatenated list of the module type or types containing the resource.
	// Module types are listed starting with the inner-most nested module, and separated
	// by /.
	//
	// In the following example, the resource was created from a module of type
	// AWS::First::Example::MODULE, that's nested inside a parent module of type
	// AWS::Second::Example::MODULE.
	//
	// AWS::First::Example::MODULE/AWS::Second::Example::MODULE
	TypeHierarchy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModuleInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModuleInfo) GoString() string {
	return s.String()
}

// SetLogicalIdHierarchy sets the LogicalIdHierarchy field's value.
func (s *ModuleInfo) SetLogicalIdHierarchy(v string) *ModuleInfo {
	s.LogicalIdHierarchy = &v
	return s
}

// SetTypeHierarchy sets the TypeHierarchy field's value.
func (s *ModuleInfo) SetTypeHierarchy(v string) *ModuleInfo {
	s.TypeHierarchy = &v
	return s
}

// The status that operation results are filtered by.
type OperationResultFilter struct {
	_ struct{} `type:"structure"`

	// The type of filter to apply.
	Name *string `type:"string" enum:"OperationResultFilterName"`

	// The value to filter by.
	Values *string `min:"6" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationResultFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationResultFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OperationResultFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OperationResultFilter"}
	if s.Values != nil && len(*s.Values) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *OperationResultFilter) SetName(v string) *OperationResultFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *OperationResultFilter) SetValues(v string) *OperationResultFilter {
	s.Values = &v
	return s
}

// The Output data type.
type Output struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the output.
	Description *string `min:"1" type:"string"`

	// The name of the export associated with the output.
	ExportName *string `type:"string"`

	// The key associated with the output.
	OutputKey *string `type:"string"`

	// The value associated with the output.
	OutputValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Output) SetDescription(v string) *Output {
	s.Description = &v
	return s
}

// SetExportName sets the ExportName field's value.
func (s *Output) SetExportName(v string) *Output {
	s.ExportName = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *Output) SetOutputKey(v string) *Output {
	s.OutputKey = &v
	return s
}

// SetOutputValue sets the OutputValue field's value.
func (s *Output) SetOutputValue(v string) *Output {
	s.OutputValue = &v
	return s
}

// The Parameter data type.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, CloudFormation uses the default value that's
	// specified in your template.
	ParameterKey *string `type:"string"`

	// The input value associated with the parameter.
	ParameterValue *string `type:"string"`

	// Read-only. The value that corresponds to a SSM parameter key. This field
	// is returned only for SSM (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types)
	// parameter types in the template.
	ResolvedValue *string `type:"string"`

	// During a stack update, use the existing parameter value that the stack is
	// using for a given parameter key. If you specify true, do not specify a parameter
	// value.
	UsePreviousValue *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) GoString() string {
	return s.String()
}

// SetParameterKey sets the ParameterKey field's value.
func (s *Parameter) SetParameterKey(v string) *Parameter {
	s.ParameterKey = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetResolvedValue sets the ResolvedValue field's value.
func (s *Parameter) SetResolvedValue(v string) *Parameter {
	s.ResolvedValue = &v
	return s
}

// SetUsePreviousValue sets the UsePreviousValue field's value.
func (s *Parameter) SetUsePreviousValue(v bool) *Parameter {
	s.UsePreviousValue = &v
	return s
}

// A set of criteria that CloudFormation uses to validate parameter values.
// Although other constraints might be defined in the stack template, CloudFormation
// returns only the AllowedValues property.
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// A list of values that are permitted for a parameter.
	AllowedValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *ParameterConstraints) SetAllowedValues(v []*string) *ParameterConstraints {
	s.AllowedValues = v
	return s
}

// The ParameterDeclaration data type.
type ParameterDeclaration struct {
	_ struct{} `type:"structure"`

	// The default value of the parameter.
	DefaultValue *string `type:"string"`

	// The description that's associate with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag that indicates whether the parameter value is shown as plain text in
	// logs and in the Amazon Web Services Management Console.
	NoEcho *bool `type:"boolean"`

	// The criteria that CloudFormation uses to validate parameter values.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The name that's associated with the parameter.
	ParameterKey *string `type:"string"`

	// The type of parameter.
	ParameterType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterDeclaration) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ParameterDeclaration) SetDefaultValue(v string) *ParameterDeclaration {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ParameterDeclaration) SetDescription(v string) *ParameterDeclaration {
	s.Description = &v
	return s
}

// SetNoEcho sets the NoEcho field's value.
func (s *ParameterDeclaration) SetNoEcho(v bool) *ParameterDeclaration {
	s.NoEcho = &v
	return s
}

// SetParameterConstraints sets the ParameterConstraints field's value.
func (s *ParameterDeclaration) SetParameterConstraints(v *ParameterConstraints) *ParameterDeclaration {
	s.ParameterConstraints = v
	return s
}

// SetParameterKey sets the ParameterKey field's value.
func (s *ParameterDeclaration) SetParameterKey(v string) *ParameterDeclaration {
	s.ParameterKey = &v
	return s
}

// SetParameterType sets the ParameterType field's value.
func (s *ParameterDeclaration) SetParameterType(v string) *ParameterDeclaration {
	s.ParameterType = &v
	return s
}

// Context information that enables CloudFormation to uniquely identify a resource.
// CloudFormation uses context key-value pairs in cases where a resource's logical
// and physical IDs aren't enough to uniquely identify that resource. Each context
// key-value pair specifies a resource that contains the targeted resource.
type PhysicalResourceIdContextKeyValuePair struct {
	_ struct{} `type:"structure"`

	// The resource context key.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The resource context value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhysicalResourceIdContextKeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhysicalResourceIdContextKeyValuePair) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *PhysicalResourceIdContextKeyValuePair) SetKey(v string) *PhysicalResourceIdContextKeyValuePair {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PhysicalResourceIdContextKeyValuePair) SetValue(v string) *PhysicalResourceIdContextKeyValuePair {
	s.Value = &v
	return s
}

// Information about a resource property whose actual value differs from its
// expected value, as defined in the stack template and any values specified
// as template parameters. These will be present only for resources whose StackResourceDriftStatus
// is MODIFIED. For more information, see Detecting Unregulated Configuration
// Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
type PropertyDifference struct {
	_ struct{} `type:"structure"`

	// The actual property value of the resource property.
	//
	// ActualValue is a required field
	ActualValue *string `type:"string" required:"true"`

	// The type of property difference.
	//
	//    * ADD: A value has been added to a resource property that's an array or
	//    list data type.
	//
	//    * REMOVE: The property has been removed from the current resource configuration.
	//
	//    * NOT_EQUAL: The current property value differs from its expected value
	//    (as defined in the stack template and any values specified as template
	//    parameters).
	//
	// DifferenceType is a required field
	DifferenceType *string `type:"string" required:"true" enum:"DifferenceType"`

	// The expected property value of the resource property, as defined in the stack
	// template and any values specified as template parameters.
	//
	// ExpectedValue is a required field
	ExpectedValue *string `type:"string" required:"true"`

	// The fully-qualified path to the resource property.
	//
	// PropertyPath is a required field
	PropertyPath *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyDifference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyDifference) GoString() string {
	return s.String()
}

// SetActualValue sets the ActualValue field's value.
func (s *PropertyDifference) SetActualValue(v string) *PropertyDifference {
	s.ActualValue = &v
	return s
}

// SetDifferenceType sets the DifferenceType field's value.
func (s *PropertyDifference) SetDifferenceType(v string) *PropertyDifference {
	s.DifferenceType = &v
	return s
}

// SetExpectedValue sets the ExpectedValue field's value.
func (s *PropertyDifference) SetExpectedValue(v string) *PropertyDifference {
	s.ExpectedValue = &v
	return s
}

// SetPropertyPath sets the PropertyPath field's value.
func (s *PropertyDifference) SetPropertyPath(v string) *PropertyDifference {
	s.PropertyPath = &v
	return s
}

type PublishTypeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension.
	//
	// Conditional: You must specify Arn, or TypeName and Type.
	Arn *string `type:"string"`

	// The version number to assign to this version of the extension.
	//
	// Use the following format, and adhere to semantic versioning when assigning
	// a version number to your extension:
	//
	// MAJOR.MINOR.PATCH
	//
	// For more information, see Semantic Versioning 2.0.0 (https://semver.org/).
	//
	// If you don't specify a version number, CloudFormation increments the version
	// number by one minor version release.
	//
	// You cannot specify a version number the first time you publish a type. CloudFormation
	// automatically sets the first version number to be 1.0.0.
	PublicVersionNumber *string `min:"5" type:"string"`

	// The type of the extension.
	//
	// Conditional: You must specify Arn, or TypeName and Type.
	Type *string `type:"string" enum:"ThirdPartyType"`

	// The name of the extension.
	//
	// Conditional: You must specify Arn, or TypeName and Type.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishTypeInput"}
	if s.PublicVersionNumber != nil && len(*s.PublicVersionNumber) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("PublicVersionNumber", 5))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *PublishTypeInput) SetArn(v string) *PublishTypeInput {
	s.Arn = &v
	return s
}

// SetPublicVersionNumber sets the PublicVersionNumber field's value.
func (s *PublishTypeInput) SetPublicVersionNumber(v string) *PublishTypeInput {
	s.PublicVersionNumber = &v
	return s
}

// SetType sets the Type field's value.
func (s *PublishTypeInput) SetType(v string) *PublishTypeInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *PublishTypeInput) SetTypeName(v string) *PublishTypeInput {
	s.TypeName = &v
	return s
}

type PublishTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the public extension upon publication.
	PublicTypeArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishTypeOutput) GoString() string {
	return s.String()
}

// SetPublicTypeArn sets the PublicTypeArn field's value.
func (s *PublishTypeOutput) SetPublicTypeArn(v string) *PublishTypeOutput {
	s.PublicTypeArn = &v
	return s
}

type RecordHandlerProgressInput struct {
	_ struct{} `type:"structure"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	//
	// BearerToken is a required field
	BearerToken *string `min:"1" type:"string" required:"true"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	ClientRequestToken *string `min:"1" type:"string"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	CurrentOperationStatus *string `type:"string" enum:"OperationStatus"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	ErrorCode *string `type:"string" enum:"HandlerErrorCode"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	//
	// OperationStatus is a required field
	OperationStatus *string `type:"string" required:"true" enum:"OperationStatus"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	ResourceModel *string `min:"1" type:"string"`

	// Reserved for use by the CloudFormation CLI (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordHandlerProgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordHandlerProgressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordHandlerProgressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordHandlerProgressInput"}
	if s.BearerToken == nil {
		invalidParams.Add(request.NewErrParamRequired("BearerToken"))
	}
	if s.BearerToken != nil && len(*s.BearerToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BearerToken", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.OperationStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationStatus"))
	}
	if s.ResourceModel != nil && len(*s.ResourceModel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceModel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBearerToken sets the BearerToken field's value.
func (s *RecordHandlerProgressInput) SetBearerToken(v string) *RecordHandlerProgressInput {
	s.BearerToken = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *RecordHandlerProgressInput) SetClientRequestToken(v string) *RecordHandlerProgressInput {
	s.ClientRequestToken = &v
	return s
}

// SetCurrentOperationStatus sets the CurrentOperationStatus field's value.
func (s *RecordHandlerProgressInput) SetCurrentOperationStatus(v string) *RecordHandlerProgressInput {
	s.CurrentOperationStatus = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *RecordHandlerProgressInput) SetErrorCode(v string) *RecordHandlerProgressInput {
	s.ErrorCode = &v
	return s
}

// SetOperationStatus sets the OperationStatus field's value.
func (s *RecordHandlerProgressInput) SetOperationStatus(v string) *RecordHandlerProgressInput {
	s.OperationStatus = &v
	return s
}

// SetResourceModel sets the ResourceModel field's value.
func (s *RecordHandlerProgressInput) SetResourceModel(v string) *RecordHandlerProgressInput {
	s.ResourceModel = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *RecordHandlerProgressInput) SetStatusMessage(v string) *RecordHandlerProgressInput {
	s.StatusMessage = &v
	return s
}

type RecordHandlerProgressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordHandlerProgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordHandlerProgressOutput) GoString() string {
	return s.String()
}

type RegisterPublisherInput struct {
	_ struct{} `type:"structure"`

	// Whether you accept the Terms and Conditions (https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf)
	// for publishing extensions in the CloudFormation registry. You must accept
	// the terms and conditions in order to register to publish public extensions
	// to the CloudFormation registry.
	//
	// The default is false.
	AcceptTermsAndConditions *bool `type:"boolean"`

	// If you are using a Bitbucket or GitHub account for identity verification,
	// the Amazon Resource Name (ARN) for your connection to that account.
	//
	// For more information, see Registering your account to publish CloudFormation
	// extensions (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs)
	// in the CloudFormation CLI User Guide.
	ConnectionArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterPublisherInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterPublisherInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterPublisherInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterPublisherInput"}
	if s.ConnectionArn != nil && len(*s.ConnectionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptTermsAndConditions sets the AcceptTermsAndConditions field's value.
func (s *RegisterPublisherInput) SetAcceptTermsAndConditions(v bool) *RegisterPublisherInput {
	s.AcceptTermsAndConditions = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *RegisterPublisherInput) SetConnectionArn(v string) *RegisterPublisherInput {
	s.ConnectionArn = &v
	return s
}

type RegisterPublisherOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned this account by CloudFormation for publishing extensions.
	PublisherId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterPublisherOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterPublisherOutput) GoString() string {
	return s.String()
}

// SetPublisherId sets the PublisherId field's value.
func (s *RegisterPublisherOutput) SetPublisherId(v string) *RegisterPublisherOutput {
	s.PublisherId = &v
	return s
}

type RegisterTypeInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that acts as an idempotency key for this registration
	// request. Specifying a client request token prevents CloudFormation from generating
	// more than one version of an extension from the same registration request,
	// even if the request is submitted multiple times.
	ClientRequestToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume
	// when invoking the extension.
	//
	// For CloudFormation to assume the specified execution role, the role must
	// contain a trust relationship with the CloudFormation service principal (resources.cloudformation.amazonaws.com).
	// For more information about adding trust relationships, see Modifying a role
	// trust policy (https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy)
	// in the Identity and Access Management User Guide.
	//
	// If your extension calls Amazon Web Services APIs in any of its handlers,
	// you must create an IAM execution role (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)
	// that includes the necessary permissions to call those Amazon Web Services
	// APIs, and provision that execution role in your account. When CloudFormation
	// needs to invoke the resource type handler, CloudFormation assumes this execution
	// role to create a temporary session token, which it then passes to the resource
	// type handler, thereby supplying your resource type with the appropriate credentials.
	ExecutionRoleArn *string `min:"1" type:"string"`

	// Specifies logging configuration information for an extension.
	LoggingConfig *LoggingConfig `type:"structure"`

	// A URL to the S3 bucket containing the extension project package that contains
	// the necessary files for the extension you want to register.
	//
	// For information about generating a schema handler package for the extension
	// you want to register, see submit (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html)
	// in the CloudFormation CLI User Guide.
	//
	// The user registering the extension must be able to access the package in
	// the S3 bucket. That's, the user needs to have GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
	// permissions for the schema handler package. For more information, see Actions,
	// Resources, and Condition Keys for Amazon S3 (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html)
	// in the Identity and Access Management User Guide.
	//
	// SchemaHandlerPackage is a required field
	SchemaHandlerPackage *string `min:"1" type:"string" required:"true"`

	// The kind of extension.
	Type *string `type:"string" enum:"RegistryType"`

	// The name of the extension being registered.
	//
	// We suggest that extension names adhere to the following patterns:
	//
	//    * For resource types, company_or_organization::service::type.
	//
	//    * For modules, company_or_organization::service::type::MODULE.
	//
	//    * For hooks, MyCompany::Testing::MyTestHook.
	//
	// The following organization namespaces are reserved and can't be used in your
	// extension names:
	//
	//    * Alexa
	//
	//    * AMZN
	//
	//    * Amazon
	//
	//    * AWS
	//
	//    * Custom
	//
	//    * Dev
	//
	// TypeName is a required field
	TypeName *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterTypeInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 1))
	}
	if s.SchemaHandlerPackage == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaHandlerPackage"))
	}
	if s.SchemaHandlerPackage != nil && len(*s.SchemaHandlerPackage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaHandlerPackage", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.LoggingConfig != nil {
		if err := s.LoggingConfig.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *RegisterTypeInput) SetClientRequestToken(v string) *RegisterTypeInput {
	s.ClientRequestToken = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *RegisterTypeInput) SetExecutionRoleArn(v string) *RegisterTypeInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *RegisterTypeInput) SetLoggingConfig(v *LoggingConfig) *RegisterTypeInput {
	s.LoggingConfig = v
	return s
}

// SetSchemaHandlerPackage sets the SchemaHandlerPackage field's value.
func (s *RegisterTypeInput) SetSchemaHandlerPackage(v string) *RegisterTypeInput {
	s.SchemaHandlerPackage = &v
	return s
}

// SetType sets the Type field's value.
func (s *RegisterTypeInput) SetType(v string) *RegisterTypeInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *RegisterTypeInput) SetTypeName(v string) *RegisterTypeInput {
	s.TypeName = &v
	return s
}

type RegisterTypeOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for this registration request.
	//
	// Use this registration token when calling DescribeTypeRegistration, which
	// returns information about the status and IDs of the extension registration.
	RegistrationToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterTypeOutput) GoString() string {
	return s.String()
}

// SetRegistrationToken sets the RegistrationToken field's value.
func (s *RegisterTypeOutput) SetRegistrationToken(v string) *RegisterTypeOutput {
	s.RegistrationToken = &v
	return s
}

// For extensions that are modules, a public third-party extension that must
// be activated in your account in order for the module itself to be activated.
//
// For more information, see Activating public modules for use in your account
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/modules.html#module-enabling)
// in the CloudFormation User Guide.
type RequiredActivatedType struct {
	_ struct{} `type:"structure"`

	// The type name of the public extension.
	//
	// If you specified a TypeNameAlias when enabling the extension in this account
	// and Region, CloudFormation treats that alias as the extension's type name
	// within the account and Region, not the type name of the public extension.
	// For more information, see Specifying aliases to refer to extensions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias)
	// in the CloudFormation User Guide.
	OriginalTypeName *string `min:"10" type:"string"`

	// The publisher ID of the extension publisher.
	PublisherId *string `min:"1" type:"string"`

	// A list of the major versions of the extension type that the macro supports.
	SupportedMajorVersions []*int64 `type:"list"`

	// An alias assigned to the public extension, in this account and Region. If
	// you specify an alias for the extension, CloudFormation treats the alias as
	// the extension type name within this account and Region. You must use the
	// alias to refer to the extension in your templates, API calls, and CloudFormation
	// console.
	TypeNameAlias *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequiredActivatedType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequiredActivatedType) GoString() string {
	return s.String()
}

// SetOriginalTypeName sets the OriginalTypeName field's value.
func (s *RequiredActivatedType) SetOriginalTypeName(v string) *RequiredActivatedType {
	s.OriginalTypeName = &v
	return s
}

// SetPublisherId sets the PublisherId field's value.
func (s *RequiredActivatedType) SetPublisherId(v string) *RequiredActivatedType {
	s.PublisherId = &v
	return s
}

// SetSupportedMajorVersions sets the SupportedMajorVersions field's value.
func (s *RequiredActivatedType) SetSupportedMajorVersions(v []*int64) *RequiredActivatedType {
	s.SupportedMajorVersions = v
	return s
}

// SetTypeNameAlias sets the TypeNameAlias field's value.
func (s *RequiredActivatedType) SetTypeNameAlias(v string) *RequiredActivatedType {
	s.TypeNameAlias = &v
	return s
}

// The ResourceChange structure describes the resource and the action that CloudFormation
// will perform on it if you execute this change set.
type ResourceChange struct {
	_ struct{} `type:"structure"`

	// The action that CloudFormation takes on the resource, such as Add (adds a
	// new resource), Modify (changes a resource), Remove (deletes a resource),
	// Import (imports a resource), or Dynamic (exact action for the resource can't
	// be determined).
	Action *string `type:"string" enum:"ChangeAction"`

	// The change set ID of the nested change set.
	ChangeSetId *string `min:"1" type:"string"`

	// For the Modify action, a list of ResourceChangeDetail structures that describes
	// the changes that CloudFormation will make to the resource.
	Details []*ResourceChangeDetail `type:"list"`

	// The resource's logical ID, which is defined in the stack's template.
	LogicalResourceId *string `type:"string"`

	// Contains information about the module from which the resource was created,
	// if the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo `type:"structure"`

	// The resource's physical ID (resource name). Resources that you are adding
	// don't have physical IDs because they haven't been created.
	PhysicalResourceId *string `type:"string"`

	// The action that will be taken on the physical resource when the change set
	// is executed.
	//
	//    * Delete The resource will be deleted.
	//
	//    * Retain The resource will be retained.
	//
	//    * Snapshot The resource will have a snapshot taken.
	//
	//    * ReplaceAndDelete The resource will be replaced and then deleted.
	//
	//    * ReplaceAndRetain The resource will be replaced and then retained.
	//
	//    * ReplaceAndSnapshot The resource will be replaced and then have a snapshot
	//    taken.
	PolicyAction *string `type:"string" enum:"PolicyAction"`

	// For the Modify action, indicates whether CloudFormation will replace the
	// resource by creating a new one and deleting the old one. This value depends
	// on the value of the RequiresRecreation property in the ResourceTargetDefinition
	// structure. For example, if the RequiresRecreation field is Always and the
	// Evaluation field is Static, Replacement is True. If the RequiresRecreation
	// field is Always and the Evaluation field is Dynamic, Replacement is Conditionally.
	//
	// If you have multiple changes with different RequiresRecreation values, the
	// Replacement value depends on the change with the most impact. A RequiresRecreation
	// value of Always has the most impact, followed by Conditionally, and then
	// Never.
	Replacement *string `type:"string" enum:"Replacement"`

	// The type of CloudFormation resource, such as AWS::S3::Bucket.
	ResourceType *string `min:"1" type:"string"`

	// For the Modify action, indicates which resource attribute is triggering this
	// update, such as a change in the resource attribute's Metadata, Properties,
	// or Tags.
	Scope []*string `type:"list" enum:"ResourceAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceChange) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ResourceChange) SetAction(v string) *ResourceChange {
	s.Action = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *ResourceChange) SetChangeSetId(v string) *ResourceChange {
	s.ChangeSetId = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ResourceChange) SetDetails(v []*ResourceChangeDetail) *ResourceChange {
	s.Details = v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ResourceChange) SetLogicalResourceId(v string) *ResourceChange {
	s.LogicalResourceId = &v
	return s
}

// SetModuleInfo sets the ModuleInfo field's value.
func (s *ResourceChange) SetModuleInfo(v *ModuleInfo) *ResourceChange {
	s.ModuleInfo = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *ResourceChange) SetPhysicalResourceId(v string) *ResourceChange {
	s.PhysicalResourceId = &v
	return s
}

// SetPolicyAction sets the PolicyAction field's value.
func (s *ResourceChange) SetPolicyAction(v string) *ResourceChange {
	s.PolicyAction = &v
	return s
}

// SetReplacement sets the Replacement field's value.
func (s *ResourceChange) SetReplacement(v string) *ResourceChange {
	s.Replacement = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceChange) SetResourceType(v string) *ResourceChange {
	s.ResourceType = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ResourceChange) SetScope(v []*string) *ResourceChange {
	s.Scope = v
	return s
}

// For a resource with Modify as the action, the ResourceChange structure describes
// the changes CloudFormation will make to that resource.
type ResourceChangeDetail struct {
	_ struct{} `type:"structure"`

	// The identity of the entity that triggered this change. This entity is a member
	// of the group that's specified by the ChangeSource field. For example, if
	// you modified the value of the KeyPairName parameter, the CausingEntity is
	// the name of the parameter (KeyPairName).
	//
	// If the ChangeSource value is DirectModification, no value is given for CausingEntity.
	CausingEntity *string `type:"string"`

	// The group to which the CausingEntity value belongs. There are five entity
	// groups:
	//
	//    * ResourceReference entities are Ref intrinsic functions that refer to
	//    resources in the template, such as { "Ref" : "MyEC2InstanceResource" }.
	//
	//    * ParameterReference entities are Ref intrinsic functions that get template
	//    parameter values, such as { "Ref" : "MyPasswordParameter" }.
	//
	//    * ResourceAttribute entities are Fn::GetAtt intrinsic functions that get
	//    resource attribute values, such as { "Fn::GetAtt" : [ "MyEC2InstanceResource",
	//    "PublicDnsName" ] }.
	//
	//    * DirectModification entities are changes that are made directly to the
	//    template.
	//
	//    * Automatic entities are AWS::CloudFormation::Stack resource types, which
	//    are also known as nested stacks. If you made no changes to the AWS::CloudFormation::Stack
	//    resource, CloudFormation sets the ChangeSource to Automatic because the
	//    nested stack's template might have changed. Changes to a nested stack's
	//    template aren't visible to CloudFormation until you run an update on the
	//    parent stack.
	ChangeSource *string `type:"string" enum:"ChangeSource"`

	// Indicates whether CloudFormation can determine the target value, and whether
	// the target value will change before you execute a change set.
	//
	// For Static evaluations, CloudFormation can determine that the target value
	// will change, and its value. For example, if you directly modify the InstanceType
	// property of an EC2 instance, CloudFormation knows that this property value
	// will change, and its value, so this is a Static evaluation.
	//
	// For Dynamic evaluations, can't determine the target value because it depends
	// on the result of an intrinsic function, such as a Ref or Fn::GetAtt intrinsic
	// function, when the stack is updated. For example, if your template includes
	// a reference to a resource that's conditionally recreated, the value of the
	// reference (the physical ID of the resource) might change, depending on if
	// the resource is recreated. If the resource is recreated, it will have a new
	// physical ID, so all references to that resource will also be updated.
	Evaluation *string `type:"string" enum:"EvaluationType"`

	// A ResourceTargetDefinition structure that describes the field that CloudFormation
	// will change and whether the resource will be recreated.
	Target *ResourceTargetDefinition `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceChangeDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceChangeDetail) GoString() string {
	return s.String()
}

// SetCausingEntity sets the CausingEntity field's value.
func (s *ResourceChangeDetail) SetCausingEntity(v string) *ResourceChangeDetail {
	s.CausingEntity = &v
	return s
}

// SetChangeSource sets the ChangeSource field's value.
func (s *ResourceChangeDetail) SetChangeSource(v string) *ResourceChangeDetail {
	s.ChangeSource = &v
	return s
}

// SetEvaluation sets the Evaluation field's value.
func (s *ResourceChangeDetail) SetEvaluation(v string) *ResourceChangeDetail {
	s.Evaluation = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ResourceChangeDetail) SetTarget(v *ResourceTargetDefinition) *ResourceChangeDetail {
	s.Target = v
	return s
}

// A resource included in a generated template. This data type is used with
// the CreateGeneratedTemplate and UpdateGeneratedTemplate API actions.
type ResourceDefinition struct {
	_ struct{} `type:"structure"`

	// The logical resource id for this resource in the generated template.
	LogicalResourceId *string `type:"string"`

	// A list of up to 256 key-value pairs that identifies the scanned resource.
	// The key is the name of one of the primary identifiers for the resource. (Primary
	// identifiers are specified in the primaryIdentifier list in the resource schema.)
	// The value is the value of that primary identifier. For example, for a AWS::DynamoDB::Table
	// resource, the primary identifiers is TableName so the key-value pair could
	// be "TableName": "MyDDBTable". For more information, see primaryIdentifier
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-primaryidentifier)
	// in the CloudFormation Command Line Interface User guide for extension development.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier map[string]*string `min:"1" type:"map" required:"true"`

	// The type of the resource, such as AWS::DynamoDB::Table. For the list of supported
	// resources, see IaC generator supported resource types (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html)
	// in the CloudFormation User Guide
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceDefinition"}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(s.ResourceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ResourceDefinition) SetLogicalResourceId(v string) *ResourceDefinition {
	s.LogicalResourceId = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ResourceDefinition) SetResourceIdentifier(v map[string]*string) *ResourceDefinition {
	s.ResourceIdentifier = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceDefinition) SetResourceType(v string) *ResourceDefinition {
	s.ResourceType = &v
	return s
}

// Details about a resource in a generated template
type ResourceDetail struct {
	_ struct{} `type:"structure"`

	// The logical id for this resource in the final generated template.
	LogicalResourceId *string `type:"string"`

	// A list of up to 256 key-value pairs that identifies the resource in the generated
	// template. The key is the name of one of the primary identifiers for the resource.
	// (Primary identifiers are specified in the primaryIdentifier list in the resource
	// schema.) The value is the value of that primary identifier. For example,
	// for a AWS::DynamoDB::Table resource, the primary identifiers is TableName
	// so the key-value pair could be "TableName": "MyDDBTable". For more information,
	// see primaryIdentifier (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-primaryidentifier)
	// in the CloudFormation Command Line Interface User guide for extension development.
	ResourceIdentifier map[string]*string `min:"1" type:"map"`

	// Status of the processing of a resource in a generated template.
	//
	// InProgress
	//
	// The resource processing is still in progress.
	//
	// Complete
	//
	// The resource processing is complete.
	//
	// Pending
	//
	// The resource processing is pending.
	//
	// Failed
	//
	// The resource processing has failed.
	ResourceStatus *string `type:"string" enum:"GeneratedTemplateResourceStatus"`

	// The reason for the resource detail, providing more information if a failure
	// happened.
	ResourceStatusReason *string `type:"string"`

	// The type of the resource, such as AWS::DynamoDB::Table. For the list of supported
	// resources, see IaC generator supported resource types (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html)
	// In the CloudFormation User Guide
	ResourceType *string `min:"1" type:"string"`

	// The warnings generated for this resource.
	Warnings []*WarningDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetail) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ResourceDetail) SetLogicalResourceId(v string) *ResourceDetail {
	s.LogicalResourceId = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ResourceDetail) SetResourceIdentifier(v map[string]*string) *ResourceDetail {
	s.ResourceIdentifier = v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *ResourceDetail) SetResourceStatus(v string) *ResourceDetail {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *ResourceDetail) SetResourceStatusReason(v string) *ResourceDetail {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceDetail) SetResourceType(v string) *ResourceDetail {
	s.ResourceType = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *ResourceDetail) SetWarnings(v []*WarningDetail) *ResourceDetail {
	s.Warnings = v
	return s
}

// Describes the target resources of a specific type in your import template
// (for example, all AWS::S3::Bucket resources) and the properties you can provide
// during the import to identify resources of that type.
type ResourceIdentifierSummary struct {
	_ struct{} `type:"structure"`

	// The logical IDs of the target resources of the specified ResourceType, as
	// defined in the import template.
	LogicalResourceIds []*string `min:"1" type:"list"`

	// The resource properties you can provide during the import to identify your
	// target resources. For example, BucketName is a possible identifier property
	// for AWS::S3::Bucket resources.
	ResourceIdentifiers []*string `type:"list"`

	// The template resource type of the target resources, such as AWS::S3::Bucket.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceIdentifierSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceIdentifierSummary) GoString() string {
	return s.String()
}

// SetLogicalResourceIds sets the LogicalResourceIds field's value.
func (s *ResourceIdentifierSummary) SetLogicalResourceIds(v []*string) *ResourceIdentifierSummary {
	s.LogicalResourceIds = v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *ResourceIdentifierSummary) SetResourceIdentifiers(v []*string) *ResourceIdentifierSummary {
	s.ResourceIdentifiers = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceIdentifierSummary) SetResourceType(v string) *ResourceIdentifierSummary {
	s.ResourceType = &v
	return s
}

// A summary of the resource scan. This is returned by the ListResourceScan
// API action.
type ResourceScanSummary struct {
	_ struct{} `type:"structure"`

	// The time that the resource scan was finished.
	EndTime *time.Time `type:"timestamp"`

	// The percentage of the resource scan that has been completed.
	PercentageCompleted *float64 `type:"double"`

	// The Amazon Resource Name (ARN) of the resource scan.
	ResourceScanId *string `type:"string"`

	// The time that the resource scan was started.
	StartTime *time.Time `type:"timestamp"`

	// Status of the resource scan.
	//
	// INPROGRESS
	//
	// The resource scan is still in progress.
	//
	// COMPLETE
	//
	// The resource scan is complete.
	//
	// EXPIRED
	//
	// The resource scan has expired.
	//
	// FAILED
	//
	// The resource scan has failed.
	Status *string `type:"string" enum:"ResourceScanStatus"`

	// The reason for the resource scan status, providing more information if a
	// failure happened.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceScanSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceScanSummary) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ResourceScanSummary) SetEndTime(v time.Time) *ResourceScanSummary {
	s.EndTime = &v
	return s
}

// SetPercentageCompleted sets the PercentageCompleted field's value.
func (s *ResourceScanSummary) SetPercentageCompleted(v float64) *ResourceScanSummary {
	s.PercentageCompleted = &v
	return s
}

// SetResourceScanId sets the ResourceScanId field's value.
func (s *ResourceScanSummary) SetResourceScanId(v string) *ResourceScanSummary {
	s.ResourceScanId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ResourceScanSummary) SetStartTime(v time.Time) *ResourceScanSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceScanSummary) SetStatus(v string) *ResourceScanSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ResourceScanSummary) SetStatusReason(v string) *ResourceScanSummary {
	s.StatusReason = &v
	return s
}

// The field that CloudFormation will change, such as the name of a resource's
// property, and whether the resource will be recreated.
type ResourceTargetDefinition struct {
	_ struct{} `type:"structure"`

	// Indicates which resource attribute is triggering this update, such as a change
	// in the resource attribute's Metadata, Properties, or Tags.
	Attribute *string `type:"string" enum:"ResourceAttribute"`

	// If the Attribute value is Properties, the name of the property. For all other
	// attributes, the value is null.
	Name *string `type:"string"`

	// If the Attribute value is Properties, indicates whether a change to this
	// property causes the resource to be recreated. The value can be Never, Always,
	// or Conditionally. To determine the conditions for a Conditionally recreation,
	// see the update behavior for that property (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.
	RequiresRecreation *string `type:"string" enum:"RequiresRecreation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTargetDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTargetDefinition) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *ResourceTargetDefinition) SetAttribute(v string) *ResourceTargetDefinition {
	s.Attribute = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceTargetDefinition) SetName(v string) *ResourceTargetDefinition {
	s.Name = &v
	return s
}

// SetRequiresRecreation sets the RequiresRecreation field's value.
func (s *ResourceTargetDefinition) SetRequiresRecreation(v string) *ResourceTargetDefinition {
	s.RequiresRecreation = &v
	return s
}

// Describes the target resource of an import operation.
type ResourceToImport struct {
	_ struct{} `type:"structure"`

	// The logical ID of the target resource as specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// A key-value pair that identifies the target resource. The key is an identifier
	// property (for example, BucketName for AWS::S3::Bucket resources) and the
	// value is the actual property value (for example, MyS3Bucket).
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier map[string]*string `min:"1" type:"map" required:"true"`

	// The type of resource to import into your stack, such as AWS::S3::Bucket.
	// For a list of supported resource types, see Resources that support import
	// operations (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html)
	// in the CloudFormation User Guide.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceToImport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceToImport) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceToImport) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceToImport"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(s.ResourceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ResourceToImport) SetLogicalResourceId(v string) *ResourceToImport {
	s.LogicalResourceId = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ResourceToImport) SetResourceIdentifier(v map[string]*string) *ResourceToImport {
	s.ResourceIdentifier = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceToImport) SetResourceType(v string) *ResourceToImport {
	s.ResourceType = &v
	return s
}

// Structure containing the rollback triggers for CloudFormation to monitor
// during stack creation and updating operations, and for the specified monitoring
// period afterwards.
//
// Rollback triggers enable you to have CloudFormation monitor the state of
// your application during stack creation and updating, and to roll back that
// operation if the application breaches the threshold of any of the alarms
// you've specified. For more information, see Monitor and Roll Back Stack Operations
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-rollback-triggers.html).
type RollbackConfiguration struct {
	_ struct{} `type:"structure"`

	// The amount of time, in minutes, during which CloudFormation should monitor
	// all the rollback triggers after the stack creation or update operation deploys
	// all necessary resources.
	//
	// The default is 0 minutes.
	//
	// If you specify a monitoring period but don't specify any rollback triggers,
	// CloudFormation still waits the specified period of time before cleaning up
	// old resources after update operations. You can use this monitoring period
	// to perform any manual stack validation desired, and manually cancel the stack
	// creation or update (using CancelUpdateStack (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html),
	// for example) as necessary.
	//
	// If you specify 0 for this parameter, CloudFormation still monitors the specified
	// rollback triggers during stack creation and update operations. Then, for
	// update operations, it begins disposing of old resources immediately once
	// the operation completes.
	MonitoringTimeInMinutes *int64 `type:"integer"`

	// The triggers to monitor during stack creation or update actions.
	//
	// By default, CloudFormation saves the rollback triggers specified for a stack
	// and applies them to any subsequent update operations for the stack, unless
	// you specify otherwise. If you do specify rollback triggers for this parameter,
	// those triggers replace any list of triggers previously specified for the
	// stack. This means:
	//
	//    * To use the rollback triggers previously specified for this stack, if
	//    any, don't specify this parameter.
	//
	//    * To specify new or updated rollback triggers, you must specify all the
	//    triggers that you want used for this stack, even triggers you've specified
	//    before (for example, when creating the stack or during a previous stack
	//    update). Any triggers that you don't include in the updated list of triggers
	//    are no longer applied to the stack.
	//
	//    * To remove all currently specified triggers, specify an empty list for
	//    this parameter.
	//
	// If a specified trigger is missing, the entire stack operation fails and is
	// rolled back.
	RollbackTriggers []*RollbackTrigger `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackConfiguration"}
	if s.RollbackTriggers != nil {
		for i, v := range s.RollbackTriggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RollbackTriggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitoringTimeInMinutes sets the MonitoringTimeInMinutes field's value.
func (s *RollbackConfiguration) SetMonitoringTimeInMinutes(v int64) *RollbackConfiguration {
	s.MonitoringTimeInMinutes = &v
	return s
}

// SetRollbackTriggers sets the RollbackTriggers field's value.
func (s *RollbackConfiguration) SetRollbackTriggers(v []*RollbackTrigger) *RollbackConfiguration {
	s.RollbackTriggers = v
	return s
}

type RollbackStackInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this RollbackStack request.
	ClientRequestToken *string `min:"1" type:"string"`

	// When set to true, newly created resources are deleted when the operation
	// rolls back. This includes newly created resources marked with a deletion
	// policy of Retain.
	//
	// Default: false
	RetainExceptOnCreate *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an Identity and Access Management role
	// that CloudFormation assumes to rollback the stack.
	RoleARN *string `min:"20" type:"string"`

	// The name that's associated with the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackStackInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *RollbackStackInput) SetClientRequestToken(v string) *RollbackStackInput {
	s.ClientRequestToken = &v
	return s
}

// SetRetainExceptOnCreate sets the RetainExceptOnCreate field's value.
func (s *RollbackStackInput) SetRetainExceptOnCreate(v bool) *RollbackStackInput {
	s.RetainExceptOnCreate = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RollbackStackInput) SetRoleARN(v string) *RollbackStackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *RollbackStackInput) SetStackName(v string) *RollbackStackInput {
	s.StackName = &v
	return s
}

type RollbackStackOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackStackOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *RollbackStackOutput) SetStackId(v string) *RollbackStackOutput {
	s.StackId = &v
	return s
}

// A rollback trigger CloudFormation monitors during creation and updating of
// stacks. If any of the alarms you specify goes to ALARM state during the stack
// operation or within the specified monitoring period afterwards, CloudFormation
// rolls back the entire stack operation.
type RollbackTrigger struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rollback trigger.
	//
	// If a specified trigger is missing, the entire stack operation fails and is
	// rolled back.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The resource type of the rollback trigger. Specify either AWS::CloudWatch::Alarm
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html)
	// or AWS::CloudWatch::CompositeAlarm (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html)
	// resource types.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackTrigger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackTrigger) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackTrigger"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *RollbackTrigger) SetArn(v string) *RollbackTrigger {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *RollbackTrigger) SetType(v string) *RollbackTrigger {
	s.Type = &v
	return s
}

// A scanned resource returned by ListResourceScanResources or ListResourceScanRelatedResources.
type ScannedResource struct {
	_ struct{} `type:"structure"`

	// If true, the resource is managed by a CloudFormation stack.
	ManagedByStack *bool `type:"boolean"`

	// A list of up to 256 key-value pairs that identifies for the scanned resource.
	// The key is the name of one of the primary identifiers for the resource. (Primary
	// identifiers are specified in the primaryIdentifier list in the resource schema.)
	// The value is the value of that primary identifier. For example, for a AWS::DynamoDB::Table
	// resource, the primary identifiers is TableName so the key-value pair could
	// be "TableName": "MyDDBTable". For more information, see primaryIdentifier
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-primaryidentifier)
	// in the CloudFormation Command Line Interface User guide for extension development.
	ResourceIdentifier map[string]*string `type:"map"`

	// The type of the resource, such as AWS::DynamoDB::Table. For the list of supported
	// resources, see Resource type support (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html)
	// In the CloudFormation User Guide
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScannedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScannedResource) GoString() string {
	return s.String()
}

// SetManagedByStack sets the ManagedByStack field's value.
func (s *ScannedResource) SetManagedByStack(v bool) *ScannedResource {
	s.ManagedByStack = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ScannedResource) SetResourceIdentifier(v map[string]*string) *ScannedResource {
	s.ResourceIdentifier = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ScannedResource) SetResourceType(v string) *ScannedResource {
	s.ResourceType = &v
	return s
}

// Identifies a scanned resource. This is used with the ListResourceScanRelatedResources
// API action.
type ScannedResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// A list of up to 256 key-value pairs that identifies the scanned resource.
	// The key is the name of one of the primary identifiers for the resource. (Primary
	// identifiers are specified in the primaryIdentifier list in the resource schema.)
	// The value is the value of that primary identifier. For example, for a AWS::DynamoDB::Table
	// resource, the primary identifiers is TableName so the key-value pair could
	// be "TableName": "MyDDBTable". For more information, see primaryIdentifier
	// (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-primaryidentifier)
	// in the CloudFormation Command Line Interface User guide for extension development.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier map[string]*string `type:"map" required:"true"`

	// The type of the resource, such as AWS::DynamoDB::Table. For the list of supported
	// resources, see IaC generator supported resource types (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html)
	// In the CloudFormation User Guide.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScannedResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScannedResourceIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScannedResourceIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScannedResourceIdentifier"}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ScannedResourceIdentifier) SetResourceIdentifier(v map[string]*string) *ScannedResourceIdentifier {
	s.ResourceIdentifier = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ScannedResourceIdentifier) SetResourceType(v string) *ScannedResourceIdentifier {
	s.ResourceType = &v
	return s
}

// The input for the SetStackPolicy action.
type SetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that you want to associate a policy with.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to Prevent
	// updates to stack resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (maximum size: 16 KB) located in an Amazon S3 bucket in the same Amazon Web
	// Services Region as the stack. The location for an Amazon S3 bucket must start
	// with https://. You can specify either the StackPolicyBody or the StackPolicyURL
	// parameter, but not both.
	StackPolicyURL *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetStackPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetStackPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetStackPolicyInput"}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *SetStackPolicyInput) SetStackName(v string) *SetStackPolicyInput {
	s.StackName = &v
	return s
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *SetStackPolicyInput) SetStackPolicyBody(v string) *SetStackPolicyInput {
	s.StackPolicyBody = &v
	return s
}

// SetStackPolicyURL sets the StackPolicyURL field's value.
func (s *SetStackPolicyInput) SetStackPolicyURL(v string) *SetStackPolicyInput {
	s.StackPolicyURL = &v
	return s
}

type SetStackPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetStackPolicyOutput) GoString() string {
	return s.String()
}

type SetTypeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The configuration data for the extension, in this account and Region.
	//
	// The configuration data must be formatted as JSON, and validate against the
	// schema returned in the ConfigurationSchema response element of DescribeType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
	// For more information, see Defining account-level configuration data for an
	// extension (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration)
	// in the CloudFormation CLI User Guide.
	//
	// Configuration is a required field
	Configuration *string `min:"1" type:"string" required:"true"`

	// An alias by which to refer to this extension configuration data.
	//
	// Conditional: Specifying a configuration alias is required when setting a
	// configuration for a resource type extension.
	ConfigurationAlias *string `min:"1" type:"string"`

	// The type of extension.
	//
	// Conditional: You must specify ConfigurationArn, or Type and TypeName.
	Type *string `type:"string" enum:"ThirdPartyType"`

	// The Amazon Resource Name (ARN) for the extension, in this account and Region.
	//
	// For public extensions, this will be the ARN assigned when you call the ActivateType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
	// API operation in this account and Region. For private extensions, this will
	// be the ARN assigned when you call the RegisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html)
	// API operation in this account and Region.
	//
	// Do not include the extension versions suffix at the end of the ARN. You can
	// set the configuration for an extension, but not for a specific extension
	// version.
	TypeArn *string `type:"string"`

	// The name of the extension.
	//
	// Conditional: You must specify ConfigurationArn, or Type and TypeName.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTypeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTypeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTypeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTypeConfigurationInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Configuration != nil && len(*s.Configuration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Configuration", 1))
	}
	if s.ConfigurationAlias != nil && len(*s.ConfigurationAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAlias", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *SetTypeConfigurationInput) SetConfiguration(v string) *SetTypeConfigurationInput {
	s.Configuration = &v
	return s
}

// SetConfigurationAlias sets the ConfigurationAlias field's value.
func (s *SetTypeConfigurationInput) SetConfigurationAlias(v string) *SetTypeConfigurationInput {
	s.ConfigurationAlias = &v
	return s
}

// SetType sets the Type field's value.
func (s *SetTypeConfigurationInput) SetType(v string) *SetTypeConfigurationInput {
	s.Type = &v
	return s
}

// SetTypeArn sets the TypeArn field's value.
func (s *SetTypeConfigurationInput) SetTypeArn(v string) *SetTypeConfigurationInput {
	s.TypeArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *SetTypeConfigurationInput) SetTypeName(v string) *SetTypeConfigurationInput {
	s.TypeName = &v
	return s
}

type SetTypeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the configuration data, in this account
	// and Region.
	//
	// Conditional: You must specify ConfigurationArn, or Type and TypeName.
	ConfigurationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTypeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTypeConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfigurationArn sets the ConfigurationArn field's value.
func (s *SetTypeConfigurationOutput) SetConfigurationArn(v string) *SetTypeConfigurationOutput {
	s.ConfigurationArn = &v
	return s
}

type SetTypeDefaultVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension for which you want version
	// summary information.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Arn *string `type:"string"`

	// The kind of extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	Type *string `type:"string" enum:"RegistryType"`

	// The name of the extension.
	//
	// Conditional: You must specify either TypeName and Type, or Arn.
	TypeName *string `min:"10" type:"string"`

	// The ID of a specific version of the extension. The version ID is the value
	// at the end of the Amazon Resource Name (ARN) assigned to the extension version
	// when it is registered.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTypeDefaultVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTypeDefaultVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTypeDefaultVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTypeDefaultVersionInput"}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *SetTypeDefaultVersionInput) SetArn(v string) *SetTypeDefaultVersionInput {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *SetTypeDefaultVersionInput) SetType(v string) *SetTypeDefaultVersionInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *SetTypeDefaultVersionInput) SetTypeName(v string) *SetTypeDefaultVersionInput {
	s.TypeName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *SetTypeDefaultVersionInput) SetVersionId(v string) *SetTypeDefaultVersionInput {
	s.VersionId = &v
	return s
}

type SetTypeDefaultVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTypeDefaultVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTypeDefaultVersionOutput) GoString() string {
	return s.String()
}

// The input for the SignalResource action.
type SignalResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical ID of the resource that you want to signal. The logical ID is
	// the name of the resource that given in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The stack name or unique stack ID that includes the resource that you want
	// to signal.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The status of the signal, which is either success or failure. A failure signal
	// causes CloudFormation to immediately fail the stack creation or update.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ResourceSignalStatus"`

	// A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
	// groups, specify the instance ID that you are signaling as the unique ID.
	// If you send multiple signals to a single resource (such as signaling a wait
	// condition), each signal requires a different unique ID.
	//
	// UniqueId is a required field
	UniqueId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignalResourceInput"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.UniqueId == nil {
		invalidParams.Add(request.NewErrParamRequired("UniqueId"))
	}
	if s.UniqueId != nil && len(*s.UniqueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UniqueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *SignalResourceInput) SetLogicalResourceId(v string) *SignalResourceInput {
	s.LogicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *SignalResourceInput) SetStackName(v string) *SignalResourceInput {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SignalResourceInput) SetStatus(v string) *SignalResourceInput {
	s.Status = &v
	return s
}

// SetUniqueId sets the UniqueId field's value.
func (s *SignalResourceInput) SetUniqueId(v string) *SignalResourceInput {
	s.UniqueId = &v
	return s
}

type SignalResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignalResourceOutput) GoString() string {
	return s.String()
}

// The Stack data type.
type Stack struct {
	_ struct{} `type:"structure"`

	// The capabilities allowed in the stack.
	Capabilities []*string `type:"list" enum:"Capability"`

	// The unique ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The time at which the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp"`

	// A user-defined description associated with the stack.
	Description *string `min:"1" type:"string"`

	// The detailed status of the resource or stack. If CONFIGURATION_COMPLETE is
	// present, the resource or resource configuration phase has completed and the
	// stabilization of the resources is in progress. The stack sets CONFIGURATION_COMPLETE
	// when all of the resources in the stack have reached that event. For more
	// information, see CloudFormation stack deployment (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html)
	// in the CloudFormation User Guide.
	DetailedStatus *string `type:"string" enum:"DetailedStatus"`

	// Boolean to enable or disable rollback on stack creation failures:
	//
	//    * true: disable rollback.
	//
	//    * false: enable rollback.
	DisableRollback *bool `type:"boolean"`

	// Information about whether a stack's actual configuration differs, or has
	// drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackDriftInformation `type:"structure"`

	// Whether termination protection is enabled for the stack.
	//
	// For nested stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
	// termination protection is set on the root stack and can't be changed directly
	// on the nested stack. For more information, see Protecting a Stack From Being
	// Deleted (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
	// in the CloudFormation User Guide.
	EnableTerminationProtection *bool `type:"boolean"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events
	// are published.
	NotificationARNs []*string `type:"list"`

	// A list of output structures.
	Outputs []*Output `type:"list"`

	// A list of Parameter structures.
	Parameters []*Parameter `type:"list"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the direct parent of this stack. For the first level of nested stacks,
	// the root stack is also the parent stack.
	//
	// For more information, see Working with Nested Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the CloudFormation User Guide.
	ParentId *string `type:"string"`

	// When set to true, newly created resources are deleted when the operation
	// rolls back. This includes newly created resources marked with a deletion
	// policy of Retain.
	//
	// Default: false
	RetainExceptOnCreate *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an Identity and Access Management (IAM)
	// role that's associated with the stack. During a stack operation, CloudFormation
	// uses this role's credentials to make calls on your behalf.
	RoleARN *string `min:"20" type:"string"`

	// The rollback triggers for CloudFormation to monitor during stack creation
	// and updating operations, and for the specified monitoring period afterwards.
	RollbackConfiguration *RollbackConfiguration `type:"structure"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the top-level stack to which the nested stack ultimately belongs.
	//
	// For more information, see Working with Nested Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the CloudFormation User Guide.
	RootId *string `type:"string"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Current status of the stack.
	//
	// StackStatus is a required field
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// A list of Tags that specify information about the stack.
	Tags []*Tag `type:"list"`

	// The amount of time within which stack creation should complete.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stack) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *Stack) SetCapabilities(v []*string) *Stack {
	s.Capabilities = v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *Stack) SetChangeSetId(v string) *Stack {
	s.ChangeSetId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Stack) SetCreationTime(v time.Time) *Stack {
	s.CreationTime = &v
	return s
}

// SetDeletionTime sets the DeletionTime field's value.
func (s *Stack) SetDeletionTime(v time.Time) *Stack {
	s.DeletionTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Stack) SetDescription(v string) *Stack {
	s.Description = &v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *Stack) SetDetailedStatus(v string) *Stack {
	s.DetailedStatus = &v
	return s
}

// SetDisableRollback sets the DisableRollback field's value.
func (s *Stack) SetDisableRollback(v bool) *Stack {
	s.DisableRollback = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *Stack) SetDriftInformation(v *StackDriftInformation) *Stack {
	s.DriftInformation = v
	return s
}

// SetEnableTerminationProtection sets the EnableTerminationProtection field's value.
func (s *Stack) SetEnableTerminationProtection(v bool) *Stack {
	s.EnableTerminationProtection = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Stack) SetLastUpdatedTime(v time.Time) *Stack {
	s.LastUpdatedTime = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *Stack) SetNotificationARNs(v []*string) *Stack {
	s.NotificationARNs = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Stack) SetOutputs(v []*Output) *Stack {
	s.Outputs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Stack) SetParameters(v []*Parameter) *Stack {
	s.Parameters = v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *Stack) SetParentId(v string) *Stack {
	s.ParentId = &v
	return s
}

// SetRetainExceptOnCreate sets the RetainExceptOnCreate field's value.
func (s *Stack) SetRetainExceptOnCreate(v bool) *Stack {
	s.RetainExceptOnCreate = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *Stack) SetRoleARN(v string) *Stack {
	s.RoleARN = &v
	return s
}

// SetRollbackConfiguration sets the RollbackConfiguration field's value.
func (s *Stack) SetRollbackConfiguration(v *RollbackConfiguration) *Stack {
	s.RollbackConfiguration = v
	return s
}

// SetRootId sets the RootId field's value.
func (s *Stack) SetRootId(v string) *Stack {
	s.RootId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *Stack) SetStackId(v string) *Stack {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *Stack) SetStackName(v string) *Stack {
	s.StackName = &v
	return s
}

// SetStackStatus sets the StackStatus field's value.
func (s *Stack) SetStackStatus(v string) *Stack {
	s.StackStatus = &v
	return s
}

// SetStackStatusReason sets the StackStatusReason field's value.
func (s *Stack) SetStackStatusReason(v string) *Stack {
	s.StackStatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Stack) SetTags(v []*Tag) *Stack {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *Stack) SetTimeoutInMinutes(v int64) *Stack {
	s.TimeoutInMinutes = &v
	return s
}

// Contains information about whether the stack's actual configuration differs,
// or has drifted, from its expected configuration, as defined in the stack
// template and any values specified as template parameters. A stack is considered
// to have drifted if one or more of its resources have drifted.
type StackDriftInformation struct {
	_ struct{} `type:"structure"`

	// Most recent time when a drift detection operation was initiated on the stack,
	// or any of its individual resources that support drift detection.
	LastCheckTimestamp *time.Time `type:"timestamp"`

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	//
	//    * DRIFTED: The stack differs from its expected template configuration.
	//    A stack is considered to have drifted if one or more of its resources
	//    have drifted.
	//
	//    * NOT_CHECKED: CloudFormation hasn't checked if the stack differs from
	//    its expected template configuration.
	//
	//    * IN_SYNC: The stack's actual configuration matches its expected template
	//    configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	//
	// StackDriftStatus is a required field
	StackDriftStatus *string `type:"string" required:"true" enum:"StackDriftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackDriftInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackDriftInformation) GoString() string {
	return s.String()
}

// SetLastCheckTimestamp sets the LastCheckTimestamp field's value.
func (s *StackDriftInformation) SetLastCheckTimestamp(v time.Time) *StackDriftInformation {
	s.LastCheckTimestamp = &v
	return s
}

// SetStackDriftStatus sets the StackDriftStatus field's value.
func (s *StackDriftInformation) SetStackDriftStatus(v string) *StackDriftInformation {
	s.StackDriftStatus = &v
	return s
}

// Contains information about whether the stack's actual configuration differs,
// or has drifted, from its expected configuration, as defined in the stack
// template and any values specified as template parameters. A stack is considered
// to have drifted if one or more of its resources have drifted.
type StackDriftInformationSummary struct {
	_ struct{} `type:"structure"`

	// Most recent time when a drift detection operation was initiated on the stack,
	// or any of its individual resources that support drift detection.
	LastCheckTimestamp *time.Time `type:"timestamp"`

	// Status of the stack's actual configuration compared to its expected template
	// configuration.
	//
	//    * DRIFTED: The stack differs from its expected template configuration.
	//    A stack is considered to have drifted if one or more of its resources
	//    have drifted.
	//
	//    * NOT_CHECKED: CloudFormation hasn't checked if the stack differs from
	//    its expected template configuration.
	//
	//    * IN_SYNC: The stack's actual configuration matches its expected template
	//    configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	//
	// StackDriftStatus is a required field
	StackDriftStatus *string `type:"string" required:"true" enum:"StackDriftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackDriftInformationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackDriftInformationSummary) GoString() string {
	return s.String()
}

// SetLastCheckTimestamp sets the LastCheckTimestamp field's value.
func (s *StackDriftInformationSummary) SetLastCheckTimestamp(v time.Time) *StackDriftInformationSummary {
	s.LastCheckTimestamp = &v
	return s
}

// SetStackDriftStatus sets the StackDriftStatus field's value.
func (s *StackDriftInformationSummary) SetStackDriftStatus(v string) *StackDriftInformationSummary {
	s.StackDriftStatus = &v
	return s
}

// The StackEvent data type.
type StackEvent struct {
	_ struct{} `type:"structure"`

	// The token passed to the operation that generated this event.
	//
	// All events triggered by a given stack operation are assigned the same client
	// request token, which you can use to track operations. For example, if you
	// execute a CreateStack operation with the token token1, then all the StackEvents
	// generated by that operation will have ClientRequestToken set as token1.
	//
	// In the console, stack operations display the client request token on the
	// Events tab. Stack operations that are initiated from the console use the
	// token format Console-StackOperation-ID, which helps you easily identify the
	// stack operation . For example, if you create a stack using the console, each
	// stack event would be assigned the same token in the following format: Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
	ClientRequestToken *string `min:"1" type:"string"`

	// An optional field containing information about the detailed status of the
	// stack event.
	//
	//    * CONFIGURATION_COMPLETE - all of the resources in the stack have reached
	//    that event. For more information, see CloudFormation stack deployment
	//    (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html)
	//    in the CloudFormation User Guide.
	//
	//    * VALIDATION_FAILED - template validation failed because of invalid properties
	//    in the template. The ResourceStatusReason field shows what properties
	//    are defined incorrectly.
	DetailedStatus *string `type:"string" enum:"DetailedStatus"`

	// The unique ID of this event.
	//
	// EventId is a required field
	EventId *string `type:"string" required:"true"`

	// Specify the hook failure mode for non-compliant resources in the followings
	// ways.
	//
	//    * FAIL Stops provisioning resources.
	//
	//    * WARN Allows provisioning to continue with a warning message.
	HookFailureMode *string `type:"string" enum:"HookFailureMode"`

	// Invocation points are points in provisioning logic where hooks are initiated.
	HookInvocationPoint *string `type:"string" enum:"HookInvocationPoint"`

	// Provides the status of the change set hook.
	HookStatus *string `type:"string" enum:"HookStatus"`

	// Provides the reason for the hook status.
	HookStatusReason *string `min:"1" type:"string"`

	// The name of the hook.
	HookType *string `min:"1" type:"string"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier associated with the physical instance of the
	// resource.
	PhysicalResourceId *string `type:"string"`

	// BLOB of the properties used to create the resource.
	ResourceProperties *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to Amazon Web Services Resource
	// Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.)
	ResourceType *string `min:"1" type:"string"`

	// The unique ID name of the instance of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The name associated with a stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackEvent) GoString() string {
	return s.String()
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StackEvent) SetClientRequestToken(v string) *StackEvent {
	s.ClientRequestToken = &v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *StackEvent) SetDetailedStatus(v string) *StackEvent {
	s.DetailedStatus = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *StackEvent) SetEventId(v string) *StackEvent {
	s.EventId = &v
	return s
}

// SetHookFailureMode sets the HookFailureMode field's value.
func (s *StackEvent) SetHookFailureMode(v string) *StackEvent {
	s.HookFailureMode = &v
	return s
}

// SetHookInvocationPoint sets the HookInvocationPoint field's value.
func (s *StackEvent) SetHookInvocationPoint(v string) *StackEvent {
	s.HookInvocationPoint = &v
	return s
}

// SetHookStatus sets the HookStatus field's value.
func (s *StackEvent) SetHookStatus(v string) *StackEvent {
	s.HookStatus = &v
	return s
}

// SetHookStatusReason sets the HookStatusReason field's value.
func (s *StackEvent) SetHookStatusReason(v string) *StackEvent {
	s.HookStatusReason = &v
	return s
}

// SetHookType sets the HookType field's value.
func (s *StackEvent) SetHookType(v string) *StackEvent {
	s.HookType = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackEvent) SetLogicalResourceId(v string) *StackEvent {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackEvent) SetPhysicalResourceId(v string) *StackEvent {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceProperties sets the ResourceProperties field's value.
func (s *StackEvent) SetResourceProperties(v string) *StackEvent {
	s.ResourceProperties = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackEvent) SetResourceStatus(v string) *StackEvent {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackEvent) SetResourceStatusReason(v string) *StackEvent {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackEvent) SetResourceType(v string) *StackEvent {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackEvent) SetStackId(v string) *StackEvent {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackEvent) SetStackName(v string) *StackEvent {
	s.StackName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackEvent) SetTimestamp(v time.Time) *StackEvent {
	s.Timestamp = &v
	return s
}

// An CloudFormation stack, in a specific account and Region, that's part of
// a stack set operation. A stack instance is a reference to an attempted or
// actual stack in a given account within a given Region. A stack instance can
// exist without a stack—for example, if the stack couldn't be created for
// some reason. A stack instance is associated with only one stack set. Each
// stack instance contains the ID of its associated stack set, in addition to
// the ID of the actual stack and the stack status.
type StackInstance struct {
	_ struct{} `type:"structure"`

	// [Self-managed permissions] The name of the Amazon Web Services account that
	// the stack instance is associated with.
	Account *string `type:"string"`

	// Status of the stack instance's actual configuration compared to the expected
	// template and parameter configuration of the stack set to which it belongs.
	//
	//    * DRIFTED: The stack differs from the expected template and parameter
	//    configuration of the stack set to which it belongs. A stack instance is
	//    considered to have drifted if one or more of the resources in the associated
	//    stack have drifted.
	//
	//    * NOT_CHECKED: CloudFormation hasn't checked if the stack instance differs
	//    from its expected stack set configuration.
	//
	//    * IN_SYNC: The stack instance's actual configuration matches its expected
	//    stack set configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	DriftStatus *string `type:"string" enum:"StackDriftStatus"`

	// Most recent time when CloudFormation performed a drift detection operation
	// on the stack instance. This value will be NULL for any stack instance on
	// which drift detection hasn't yet been performed.
	LastDriftCheckTimestamp *time.Time `type:"timestamp"`

	// The last unique ID of a StackSet operation performed on a stack instance.
	LastOperationId *string `min:"1" type:"string"`

	// [Service-managed permissions] The organization root ID or organizational
	// unit (OU) IDs that you specified for DeploymentTargets (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
	OrganizationalUnitId *string `type:"string"`

	// A list of parameters from the stack set template whose values have been overridden
	// in this stack instance.
	ParameterOverrides []*Parameter `type:"list"`

	// The name of the Amazon Web Services Region that the stack instance is associated
	// with.
	Region *string `type:"string"`

	// The ID of the stack instance.
	StackId *string `type:"string"`

	// The detailed status of the stack instance.
	StackInstanceStatus *StackInstanceComprehensiveStatus `type:"structure"`

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string `type:"string"`

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually. INOPERABLE can be returned here when
	//    the cause is a failed import. If it's due to a failed import, the operation
	//    can be retried once the failures are fixed. To see if this is due to a
	//    failed import, look at the DetailedStatus member in the StackInstanceSummary
	//    member that is a peer to this Status member.
	//
	//    * OUTDATED: The stack isn't currently up to date with the stack set because:
	//    The associated stack failed during a CreateStackSet or UpdateStackSet
	//    operation. The stack was part of a CreateStackSet or UpdateStackSet operation
	//    that failed or was stopped before the stack was created or updated.
	//
	//    * CURRENT: The stack is currently up to date with the stack set.
	Status *string `type:"string" enum:"StackInstanceStatus"`

	// The explanation for the specific status code that's assigned to this stack
	// instance.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstance) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *StackInstance) SetAccount(v string) *StackInstance {
	s.Account = &v
	return s
}

// SetDriftStatus sets the DriftStatus field's value.
func (s *StackInstance) SetDriftStatus(v string) *StackInstance {
	s.DriftStatus = &v
	return s
}

// SetLastDriftCheckTimestamp sets the LastDriftCheckTimestamp field's value.
func (s *StackInstance) SetLastDriftCheckTimestamp(v time.Time) *StackInstance {
	s.LastDriftCheckTimestamp = &v
	return s
}

// SetLastOperationId sets the LastOperationId field's value.
func (s *StackInstance) SetLastOperationId(v string) *StackInstance {
	s.LastOperationId = &v
	return s
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *StackInstance) SetOrganizationalUnitId(v string) *StackInstance {
	s.OrganizationalUnitId = &v
	return s
}

// SetParameterOverrides sets the ParameterOverrides field's value.
func (s *StackInstance) SetParameterOverrides(v []*Parameter) *StackInstance {
	s.ParameterOverrides = v
	return s
}

// SetRegion sets the Region field's value.
func (s *StackInstance) SetRegion(v string) *StackInstance {
	s.Region = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackInstance) SetStackId(v string) *StackInstance {
	s.StackId = &v
	return s
}

// SetStackInstanceStatus sets the StackInstanceStatus field's value.
func (s *StackInstance) SetStackInstanceStatus(v *StackInstanceComprehensiveStatus) *StackInstance {
	s.StackInstanceStatus = v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackInstance) SetStackSetId(v string) *StackInstance {
	s.StackSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackInstance) SetStatus(v string) *StackInstance {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *StackInstance) SetStatusReason(v string) *StackInstance {
	s.StatusReason = &v
	return s
}

// The detailed status of the stack instance.
type StackInstanceComprehensiveStatus struct {
	_ struct{} `type:"structure"`

	//    * CANCELLED: The operation in the specified account and Region has been
	//    canceled. This is either because a user has stopped the stack set operation,
	//    or because the failure tolerance of the stack set operation has been exceeded.
	//
	//    * FAILED: The operation in the specified account and Region failed. If
	//    the stack set operation fails in enough accounts within a Region, the
	//    failure tolerance for the stack set operation as a whole might be exceeded.
	//
	//    * FAILED_IMPORT: The import of the stack instance in the specified account
	//    and Region failed and left the stack in an unstable state. Once the issues
	//    causing the failure are fixed, the import operation can be retried. If
	//    enough stack set operations fail in enough accounts within a Region, the
	//    failure tolerance for the stack set operation as a whole might be exceeded.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually.
	//
	//    * PENDING: The operation in the specified account and Region has yet to
	//    start.
	//
	//    * RUNNING: The operation in the specified account and Region is currently
	//    in progress.
	//
	//    * SKIPPED_SUSPENDED_ACCOUNT: The operation in the specified account and
	//    Region has been skipped because the account was suspended at the time
	//    of the operation.
	//
	//    * SUCCEEDED: The operation in the specified account and Region completed
	//    successfully.
	DetailedStatus *string `type:"string" enum:"StackInstanceDetailedStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstanceComprehensiveStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstanceComprehensiveStatus) GoString() string {
	return s.String()
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *StackInstanceComprehensiveStatus) SetDetailedStatus(v string) *StackInstanceComprehensiveStatus {
	s.DetailedStatus = &v
	return s
}

// The filter to apply to stack instances
type StackInstanceFilter struct {
	_ struct{} `type:"structure"`

	// The type of filter to apply.
	Name *string `type:"string" enum:"StackInstanceFilterName"`

	// The status to filter by.
	Values *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstanceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstanceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StackInstanceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StackInstanceFilter"}
	if s.Values != nil && len(*s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StackInstanceFilter) SetName(v string) *StackInstanceFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *StackInstanceFilter) SetValues(v string) *StackInstanceFilter {
	s.Values = &v
	return s
}

// The structure containing summary information about resource drifts for a
// stack instance.
type StackInstanceResourceDriftsSummary struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Context information that enables CloudFormation to uniquely identify a resource.
	// CloudFormation uses context key-value pairs in cases where a resource's logical
	// and physical IDs aren't enough to uniquely identify that resource. Each context
	// key-value pair specifies a unique resource that contains the targeted resource.
	PhysicalResourceIdContext []*PhysicalResourceIdContextKeyValuePair `type:"list"`

	// Status of the actual configuration of the resource compared to its expected
	// configuration. These will be present only for resources whose StackInstanceResourceDriftStatus
	// is MODIFIED.
	PropertyDifferences []*PropertyDifference `type:"list"`

	// Type of resource. For more information, go to Amazon Web Services Resource
	// Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// The ID of the stack instance.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The drift status of the resource in a stack instance.
	//
	//    * DELETED: The resource differs from its expected template configuration
	//    in that the resource has been deleted.
	//
	//    * MODIFIED: One or more resource properties differ from their expected
	//    template values.
	//
	//    * IN_SYNC: The resource's actual configuration matches its expected template
	//    configuration.
	//
	//    * NOT_CHECKED: CloudFormation doesn't currently return this value.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus *string `type:"string" required:"true" enum:"StackResourceDriftStatus"`

	// Time at which the stack instance drift detection operation was initiated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstanceResourceDriftsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstanceResourceDriftsSummary) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackInstanceResourceDriftsSummary) SetLogicalResourceId(v string) *StackInstanceResourceDriftsSummary {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackInstanceResourceDriftsSummary) SetPhysicalResourceId(v string) *StackInstanceResourceDriftsSummary {
	s.PhysicalResourceId = &v
	return s
}

// SetPhysicalResourceIdContext sets the PhysicalResourceIdContext field's value.
func (s *StackInstanceResourceDriftsSummary) SetPhysicalResourceIdContext(v []*PhysicalResourceIdContextKeyValuePair) *StackInstanceResourceDriftsSummary {
	s.PhysicalResourceIdContext = v
	return s
}

// SetPropertyDifferences sets the PropertyDifferences field's value.
func (s *StackInstanceResourceDriftsSummary) SetPropertyDifferences(v []*PropertyDifference) *StackInstanceResourceDriftsSummary {
	s.PropertyDifferences = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackInstanceResourceDriftsSummary) SetResourceType(v string) *StackInstanceResourceDriftsSummary {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackInstanceResourceDriftsSummary) SetStackId(v string) *StackInstanceResourceDriftsSummary {
	s.StackId = &v
	return s
}

// SetStackResourceDriftStatus sets the StackResourceDriftStatus field's value.
func (s *StackInstanceResourceDriftsSummary) SetStackResourceDriftStatus(v string) *StackInstanceResourceDriftsSummary {
	s.StackResourceDriftStatus = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackInstanceResourceDriftsSummary) SetTimestamp(v time.Time) *StackInstanceResourceDriftsSummary {
	s.Timestamp = &v
	return s
}

// The structure that contains summary information about a stack instance.
type StackInstanceSummary struct {
	_ struct{} `type:"structure"`

	// [Self-managed permissions] The name of the Amazon Web Services account that
	// the stack instance is associated with.
	Account *string `type:"string"`

	// Status of the stack instance's actual configuration compared to the expected
	// template and parameter configuration of the stack set to which it belongs.
	//
	//    * DRIFTED: The stack differs from the expected template and parameter
	//    configuration of the stack set to which it belongs. A stack instance is
	//    considered to have drifted if one or more of the resources in the associated
	//    stack have drifted.
	//
	//    * NOT_CHECKED: CloudFormation hasn't checked if the stack instance differs
	//    from its expected stack set configuration.
	//
	//    * IN_SYNC: The stack instance's actual configuration matches its expected
	//    stack set configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	DriftStatus *string `type:"string" enum:"StackDriftStatus"`

	// Most recent time when CloudFormation performed a drift detection operation
	// on the stack instance. This value will be NULL for any stack instance on
	// which drift detection hasn't yet been performed.
	LastDriftCheckTimestamp *time.Time `type:"timestamp"`

	// The last unique ID of a StackSet operation performed on a stack instance.
	LastOperationId *string `min:"1" type:"string"`

	// [Service-managed permissions] The organization root ID or organizational
	// unit (OU) IDs that you specified for DeploymentTargets (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
	OrganizationalUnitId *string `type:"string"`

	// The name of the Amazon Web Services Region that the stack instance is associated
	// with.
	Region *string `type:"string"`

	// The ID of the stack instance.
	StackId *string `type:"string"`

	// The detailed status of the stack instance.
	StackInstanceStatus *StackInstanceComprehensiveStatus `type:"structure"`

	// The name or unique ID of the stack set that the stack instance is associated
	// with.
	StackSetId *string `type:"string"`

	// The status of the stack instance, in terms of its synchronization with its
	// associated stack set.
	//
	//    * INOPERABLE: A DeleteStackInstances operation has failed and left the
	//    stack in an unstable state. Stacks in this state are excluded from further
	//    UpdateStackSet operations. You might need to perform a DeleteStackInstances
	//    operation, with RetainStacks set to true, to delete the stack instance,
	//    and then delete the stack manually. INOPERABLE can be returned here when
	//    the cause is a failed import. If it's due to a failed import, the operation
	//    can be retried once the failures are fixed. To see if this is due to a
	//    failed import, call the DescribeStackInstance API operation, look at the
	//    DetailedStatus member returned in the StackInstanceSummary member.
	//
	//    * OUTDATED: The stack isn't currently up to date with the stack set because:
	//    The associated stack failed during a CreateStackSet or UpdateStackSet
	//    operation. The stack was part of a CreateStackSet or UpdateStackSet operation
	//    that failed or was stopped before the stack was created or updated.
	//
	//    * CURRENT: The stack is currently up to date with the stack set.
	Status *string `type:"string" enum:"StackInstanceStatus"`

	// The explanation for the specific status code assigned to this stack instance.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackInstanceSummary) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *StackInstanceSummary) SetAccount(v string) *StackInstanceSummary {
	s.Account = &v
	return s
}

// SetDriftStatus sets the DriftStatus field's value.
func (s *StackInstanceSummary) SetDriftStatus(v string) *StackInstanceSummary {
	s.DriftStatus = &v
	return s
}

// SetLastDriftCheckTimestamp sets the LastDriftCheckTimestamp field's value.
func (s *StackInstanceSummary) SetLastDriftCheckTimestamp(v time.Time) *StackInstanceSummary {
	s.LastDriftCheckTimestamp = &v
	return s
}

// SetLastOperationId sets the LastOperationId field's value.
func (s *StackInstanceSummary) SetLastOperationId(v string) *StackInstanceSummary {
	s.LastOperationId = &v
	return s
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *StackInstanceSummary) SetOrganizationalUnitId(v string) *StackInstanceSummary {
	s.OrganizationalUnitId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *StackInstanceSummary) SetRegion(v string) *StackInstanceSummary {
	s.Region = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackInstanceSummary) SetStackId(v string) *StackInstanceSummary {
	s.StackId = &v
	return s
}

// SetStackInstanceStatus sets the StackInstanceStatus field's value.
func (s *StackInstanceSummary) SetStackInstanceStatus(v *StackInstanceComprehensiveStatus) *StackInstanceSummary {
	s.StackInstanceStatus = v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackInstanceSummary) SetStackSetId(v string) *StackInstanceSummary {
	s.StackSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackInstanceSummary) SetStatus(v string) *StackInstanceSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *StackInstanceSummary) SetStatusReason(v string) *StackInstanceSummary {
	s.StatusReason = &v
	return s
}

// The StackResource data type.
type StackResource struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformation `type:"structure"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// Contains information about the module from which the resource was created,
	// if the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo `type:"structure"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. For more information, go to Amazon Web Services Resource
	// Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResource) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StackResource) SetDescription(v string) *StackResource {
	s.Description = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *StackResource) SetDriftInformation(v *StackResourceDriftInformation) *StackResource {
	s.DriftInformation = v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResource) SetLogicalResourceId(v string) *StackResource {
	s.LogicalResourceId = &v
	return s
}

// SetModuleInfo sets the ModuleInfo field's value.
func (s *StackResource) SetModuleInfo(v *ModuleInfo) *StackResource {
	s.ModuleInfo = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResource) SetPhysicalResourceId(v string) *StackResource {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResource) SetResourceStatus(v string) *StackResource {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResource) SetResourceStatusReason(v string) *StackResource {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResource) SetResourceType(v string) *StackResource {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackResource) SetStackId(v string) *StackResource {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackResource) SetStackName(v string) *StackResource {
	s.StackName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackResource) SetTimestamp(v time.Time) *StackResource {
	s.Timestamp = &v
	return s
}

// Contains detailed information about the specified stack resource.
type StackResourceDetail struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformation `type:"structure"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The content of the Metadata attribute declared for the resource. For more
	// information, see Metadata Attribute (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html)
	// in the CloudFormation User Guide.
	Metadata *string `type:"string"`

	// Contains information about the module from which the resource was created,
	// if the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo `type:"structure"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. For more information, go to Amazon Web Services Resource
	// Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceDetail) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StackResourceDetail) SetDescription(v string) *StackResourceDetail {
	s.Description = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *StackResourceDetail) SetDriftInformation(v *StackResourceDriftInformation) *StackResourceDetail {
	s.DriftInformation = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *StackResourceDetail) SetLastUpdatedTimestamp(v time.Time) *StackResourceDetail {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResourceDetail) SetLogicalResourceId(v string) *StackResourceDetail {
	s.LogicalResourceId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *StackResourceDetail) SetMetadata(v string) *StackResourceDetail {
	s.Metadata = &v
	return s
}

// SetModuleInfo sets the ModuleInfo field's value.
func (s *StackResourceDetail) SetModuleInfo(v *ModuleInfo) *StackResourceDetail {
	s.ModuleInfo = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResourceDetail) SetPhysicalResourceId(v string) *StackResourceDetail {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResourceDetail) SetResourceStatus(v string) *StackResourceDetail {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResourceDetail) SetResourceStatusReason(v string) *StackResourceDetail {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResourceDetail) SetResourceType(v string) *StackResourceDetail {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackResourceDetail) SetStackId(v string) *StackResourceDetail {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackResourceDetail) SetStackName(v string) *StackResourceDetail {
	s.StackName = &v
	return s
}

// Contains the drift information for a resource that has been checked for drift.
// This includes actual and expected property values for resources in which
// CloudFormation has detected drift. Only resource properties explicitly defined
// in the stack template are checked for drift. For more information, see Detecting
// Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
//
// Resources that don't currently support drift detection can't be checked.
// For a list of resources that support drift detection, see Resources that
// Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all resources in a given stack that support
// drift detection.
type StackResourceDrift struct {
	_ struct{} `type:"structure"`

	// A JSON structure containing the actual property values of the stack resource.
	//
	// For resources whose StackResourceDriftStatus is DELETED, this structure will
	// not be present.
	ActualProperties *string `type:"string"`

	// A JSON structure containing the expected property values of the stack resource,
	// as defined in the stack template and any values specified as template parameters.
	//
	// For resources whose StackResourceDriftStatus is DELETED, this structure will
	// not be present.
	ExpectedProperties *string `type:"string"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// Contains information about the module from which the resource was created,
	// if the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo `type:"structure"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Context information that enables CloudFormation to uniquely identify a resource.
	// CloudFormation uses context key-value pairs in cases where a resource's logical
	// and physical IDs aren't enough to uniquely identify that resource. Each context
	// key-value pair specifies a unique resource that contains the targeted resource.
	PhysicalResourceIdContext []*PhysicalResourceIdContextKeyValuePair `type:"list"`

	// A collection of the resource properties whose actual values differ from their
	// expected values. These will be present only for resources whose StackResourceDriftStatus
	// is MODIFIED.
	PropertyDifferences []*PropertyDifference `type:"list"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// The ID of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// Status of the resource's actual configuration compared to its expected configuration.
	//
	//    * DELETED: The resource differs from its expected template configuration
	//    because the resource has been deleted.
	//
	//    * MODIFIED: One or more resource properties differ from their expected
	//    values (as defined in the stack template and any values specified as template
	//    parameters).
	//
	//    * IN_SYNC: The resource's actual configuration matches its expected template
	//    configuration.
	//
	//    * NOT_CHECKED: CloudFormation does not currently return this value.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus *string `type:"string" required:"true" enum:"StackResourceDriftStatus"`

	// Time at which CloudFormation performed drift detection on the stack resource.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceDrift) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceDrift) GoString() string {
	return s.String()
}

// SetActualProperties sets the ActualProperties field's value.
func (s *StackResourceDrift) SetActualProperties(v string) *StackResourceDrift {
	s.ActualProperties = &v
	return s
}

// SetExpectedProperties sets the ExpectedProperties field's value.
func (s *StackResourceDrift) SetExpectedProperties(v string) *StackResourceDrift {
	s.ExpectedProperties = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResourceDrift) SetLogicalResourceId(v string) *StackResourceDrift {
	s.LogicalResourceId = &v
	return s
}

// SetModuleInfo sets the ModuleInfo field's value.
func (s *StackResourceDrift) SetModuleInfo(v *ModuleInfo) *StackResourceDrift {
	s.ModuleInfo = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResourceDrift) SetPhysicalResourceId(v string) *StackResourceDrift {
	s.PhysicalResourceId = &v
	return s
}

// SetPhysicalResourceIdContext sets the PhysicalResourceIdContext field's value.
func (s *StackResourceDrift) SetPhysicalResourceIdContext(v []*PhysicalResourceIdContextKeyValuePair) *StackResourceDrift {
	s.PhysicalResourceIdContext = v
	return s
}

// SetPropertyDifferences sets the PropertyDifferences field's value.
func (s *StackResourceDrift) SetPropertyDifferences(v []*PropertyDifference) *StackResourceDrift {
	s.PropertyDifferences = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResourceDrift) SetResourceType(v string) *StackResourceDrift {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackResourceDrift) SetStackId(v string) *StackResourceDrift {
	s.StackId = &v
	return s
}

// SetStackResourceDriftStatus sets the StackResourceDriftStatus field's value.
func (s *StackResourceDrift) SetStackResourceDriftStatus(v string) *StackResourceDrift {
	s.StackResourceDriftStatus = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackResourceDrift) SetTimestamp(v time.Time) *StackResourceDrift {
	s.Timestamp = &v
	return s
}

// Contains information about whether the resource's actual configuration differs,
// or has drifted, from its expected configuration.
type StackResourceDriftInformation struct {
	_ struct{} `type:"structure"`

	// When CloudFormation last checked if the resource had drifted from its expected
	// configuration.
	LastCheckTimestamp *time.Time `type:"timestamp"`

	// Status of the resource's actual configuration compared to its expected configuration
	//
	//    * DELETED: The resource differs from its expected configuration in that
	//    it has been deleted.
	//
	//    * MODIFIED: The resource differs from its expected configuration.
	//
	//    * NOT_CHECKED: CloudFormation has not checked if the resource differs
	//    from its expected configuration. Any resources that do not currently support
	//    drift detection have a status of NOT_CHECKED. For more information, see
	//    Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//
	//    * IN_SYNC: The resource's actual configuration matches its expected configuration.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus *string `type:"string" required:"true" enum:"StackResourceDriftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceDriftInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceDriftInformation) GoString() string {
	return s.String()
}

// SetLastCheckTimestamp sets the LastCheckTimestamp field's value.
func (s *StackResourceDriftInformation) SetLastCheckTimestamp(v time.Time) *StackResourceDriftInformation {
	s.LastCheckTimestamp = &v
	return s
}

// SetStackResourceDriftStatus sets the StackResourceDriftStatus field's value.
func (s *StackResourceDriftInformation) SetStackResourceDriftStatus(v string) *StackResourceDriftInformation {
	s.StackResourceDriftStatus = &v
	return s
}

// Summarizes information about whether the resource's actual configuration
// differs, or has drifted, from its expected configuration.
type StackResourceDriftInformationSummary struct {
	_ struct{} `type:"structure"`

	// When CloudFormation last checked if the resource had drifted from its expected
	// configuration.
	LastCheckTimestamp *time.Time `type:"timestamp"`

	// Status of the resource's actual configuration compared to its expected configuration.
	//
	//    * DELETED: The resource differs from its expected configuration in that
	//    it has been deleted.
	//
	//    * MODIFIED: The resource differs from its expected configuration.
	//
	//    * NOT_CHECKED: CloudFormation hasn't checked if the resource differs from
	//    its expected configuration. Any resources that don't currently support
	//    drift detection have a status of NOT_CHECKED. For more information, see
	//    Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//    If you performed an ContinueUpdateRollback operation on a stack, any resources
	//    included in ResourcesToSkip will also have a status of NOT_CHECKED. For
	//    more information about skipping resources during rollback operations,
	//    see Continue Rolling Back an Update (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html)
	//    in the CloudFormation User Guide.
	//
	//    * IN_SYNC: The resource's actual configuration matches its expected configuration.
	//
	// StackResourceDriftStatus is a required field
	StackResourceDriftStatus *string `type:"string" required:"true" enum:"StackResourceDriftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceDriftInformationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceDriftInformationSummary) GoString() string {
	return s.String()
}

// SetLastCheckTimestamp sets the LastCheckTimestamp field's value.
func (s *StackResourceDriftInformationSummary) SetLastCheckTimestamp(v time.Time) *StackResourceDriftInformationSummary {
	s.LastCheckTimestamp = &v
	return s
}

// SetStackResourceDriftStatus sets the StackResourceDriftStatus field's value.
func (s *StackResourceDriftInformationSummary) SetStackResourceDriftStatus(v string) *StackResourceDriftInformationSummary {
	s.StackResourceDriftStatus = &v
	return s
}

// Contains high-level information about the specified stack resource.
type StackResourceSummary struct {
	_ struct{} `type:"structure"`

	// Information about whether the resource's actual configuration differs, or
	// has drifted, from its expected configuration, as defined in the stack template
	// and any values specified as template parameters. For more information, see
	// Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackResourceDriftInformationSummary `type:"structure"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// Contains information about the module from which the resource was created,
	// if the resource was created from a module included in the stack template.
	ModuleInfo *ModuleInfo `type:"structure"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of the resource.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to Amazon Web Services Resource
	// Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackResourceSummary) GoString() string {
	return s.String()
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *StackResourceSummary) SetDriftInformation(v *StackResourceDriftInformationSummary) *StackResourceSummary {
	s.DriftInformation = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *StackResourceSummary) SetLastUpdatedTimestamp(v time.Time) *StackResourceSummary {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResourceSummary) SetLogicalResourceId(v string) *StackResourceSummary {
	s.LogicalResourceId = &v
	return s
}

// SetModuleInfo sets the ModuleInfo field's value.
func (s *StackResourceSummary) SetModuleInfo(v *ModuleInfo) *StackResourceSummary {
	s.ModuleInfo = v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResourceSummary) SetPhysicalResourceId(v string) *StackResourceSummary {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResourceSummary) SetResourceStatus(v string) *StackResourceSummary {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResourceSummary) SetResourceStatusReason(v string) *StackResourceSummary {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResourceSummary) SetResourceType(v string) *StackResourceSummary {
	s.ResourceType = &v
	return s
}

// A structure that contains information about a stack set. A stack set enables
// you to provision stacks into Amazon Web Services accounts and across Regions
// by using a single CloudFormation template. In the stack set, you specify
// the template to use, in addition to any parameters and capabilities that
// the template requires.
type StackSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role used to create or update the
	// stack set.
	//
	// Use customized administrator roles to control which users or groups can manage
	// specific stack sets within the same administrator account. For more information,
	// see Prerequisites: Granting Permissions for Stack Set Operations (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// [Service-managed permissions] Describes whether StackSets automatically deploys
	// to Organizations accounts that are added to a target organization or organizational
	// unit (OU).
	AutoDeployment *AutoDeployment `type:"structure"`

	// The capabilities that are allowed in the stack set. Some stack set templates
	// might include resources that can affect permissions in your Amazon Web Services
	// account—for example, by creating new Identity and Access Management (IAM)
	// users. For more information, see Acknowledging IAM Resources in CloudFormation
	// Templates. (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities)
	Capabilities []*string `type:"list" enum:"Capability"`

	// A description of the stack set that you specify when the stack set is created
	// or updated.
	Description *string `min:"1" type:"string"`

	// The name of the IAM execution role used to create or update the stack set.
	//
	// Use customized execution roles to control which stack resources users and
	// groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// Describes whether StackSets performs non-conflicting operations concurrently
	// and queues conflicting operations.
	ManagedExecution *ManagedExecution `type:"structure"`

	// [Service-managed permissions] The organization root ID or organizational
	// unit (OU) IDs that you specified for DeploymentTargets (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
	OrganizationalUnitIds []*string `type:"list"`

	// A list of input parameters for a stack set.
	Parameters []*Parameter `type:"list"`

	// Describes how the IAM roles required for stack set operations are created.
	//
	//    * With self-managed permissions, you must create the administrator and
	//    execution roles required to deploy to target accounts. For more information,
	//    see Grant Self-Managed Stack Set Permissions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
	//
	//    * With service-managed permissions, StackSets automatically creates the
	//    IAM roles required to deploy to accounts managed by Organizations. For
	//    more information, see Grant Service-Managed Stack Set Permissions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html).
	PermissionModel *string `type:"string" enum:"PermissionModels"`

	// Returns a list of all Amazon Web Services Regions the given StackSet has
	// stack instances deployed in. The Amazon Web Services Regions list output
	// is in no particular order.
	Regions []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the stack set.
	StackSetARN *string `type:"string"`

	// Detailed information about the drift status of the stack set.
	//
	// For stack sets, contains information about the last completed drift operation
	// performed on the stack set. Information about drift operations currently
	// in progress isn't included.
	StackSetDriftDetectionDetails *StackSetDriftDetectionDetails `type:"structure"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The name that's associated with the stack set.
	StackSetName *string `type:"string"`

	// The status of the stack set.
	Status *string `type:"string" enum:"StackSetStatus"`

	// A list of tags that specify information about the stack set. A maximum number
	// of 50 tags can be specified.
	Tags []*Tag `type:"list"`

	// The structure that contains the body of the template that was used to create
	// or update the stack set.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSet) GoString() string {
	return s.String()
}

// SetAdministrationRoleARN sets the AdministrationRoleARN field's value.
func (s *StackSet) SetAdministrationRoleARN(v string) *StackSet {
	s.AdministrationRoleARN = &v
	return s
}

// SetAutoDeployment sets the AutoDeployment field's value.
func (s *StackSet) SetAutoDeployment(v *AutoDeployment) *StackSet {
	s.AutoDeployment = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *StackSet) SetCapabilities(v []*string) *StackSet {
	s.Capabilities = v
	return s
}

// SetDescription sets the Description field's value.
func (s *StackSet) SetDescription(v string) *StackSet {
	s.Description = &v
	return s
}

// SetExecutionRoleName sets the ExecutionRoleName field's value.
func (s *StackSet) SetExecutionRoleName(v string) *StackSet {
	s.ExecutionRoleName = &v
	return s
}

// SetManagedExecution sets the ManagedExecution field's value.
func (s *StackSet) SetManagedExecution(v *ManagedExecution) *StackSet {
	s.ManagedExecution = v
	return s
}

// SetOrganizationalUnitIds sets the OrganizationalUnitIds field's value.
func (s *StackSet) SetOrganizationalUnitIds(v []*string) *StackSet {
	s.OrganizationalUnitIds = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *StackSet) SetParameters(v []*Parameter) *StackSet {
	s.Parameters = v
	return s
}

// SetPermissionModel sets the PermissionModel field's value.
func (s *StackSet) SetPermissionModel(v string) *StackSet {
	s.PermissionModel = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *StackSet) SetRegions(v []*string) *StackSet {
	s.Regions = v
	return s
}

// SetStackSetARN sets the StackSetARN field's value.
func (s *StackSet) SetStackSetARN(v string) *StackSet {
	s.StackSetARN = &v
	return s
}

// SetStackSetDriftDetectionDetails sets the StackSetDriftDetectionDetails field's value.
func (s *StackSet) SetStackSetDriftDetectionDetails(v *StackSetDriftDetectionDetails) *StackSet {
	s.StackSetDriftDetectionDetails = v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackSet) SetStackSetId(v string) *StackSet {
	s.StackSetId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *StackSet) SetStackSetName(v string) *StackSet {
	s.StackSetName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSet) SetStatus(v string) *StackSet {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StackSet) SetTags(v []*Tag) *StackSet {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *StackSet) SetTemplateBody(v string) *StackSet {
	s.TemplateBody = &v
	return s
}

// One of the targets for the stack set. Returned by the ListStackSetAutoDeploymentTargets
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetAutoDeploymentTargets.html)
// API operation.
type StackSetAutoDeploymentTargetSummary struct {
	_ struct{} `type:"structure"`

	// The organization root ID or organizational unit (OU) IDs where the stack
	// set is targeted.
	OrganizationalUnitId *string `type:"string"`

	// The list of Regions targeted for this organization or OU.
	Regions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetAutoDeploymentTargetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetAutoDeploymentTargetSummary) GoString() string {
	return s.String()
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *StackSetAutoDeploymentTargetSummary) SetOrganizationalUnitId(v string) *StackSetAutoDeploymentTargetSummary {
	s.OrganizationalUnitId = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *StackSetAutoDeploymentTargetSummary) SetRegions(v []*string) *StackSetAutoDeploymentTargetSummary {
	s.Regions = v
	return s
}

// Detailed information about the drift status of the stack set.
//
// For stack sets, contains information about the last completed drift operation
// performed on the stack set. Information about drift operations in-progress
// isn't included.
//
// For stack set operations, includes information about drift operations currently
// being performed on the stack set.
//
// For more information, see Detecting unmanaged changes in stack sets (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html)
// in the CloudFormation User Guide.
type StackSetDriftDetectionDetails struct {
	_ struct{} `type:"structure"`

	// The status of the stack set drift detection operation.
	//
	//    * COMPLETED: The drift detection operation completed without failing on
	//    any stack instances.
	//
	//    * FAILED: The drift detection operation exceeded the specified failure
	//    tolerance.
	//
	//    * PARTIAL_SUCCESS: The drift detection operation completed without exceeding
	//    the failure tolerance for the operation.
	//
	//    * IN_PROGRESS: The drift detection operation is currently being performed.
	//
	//    * STOPPED: The user has canceled the drift detection operation.
	DriftDetectionStatus *string `type:"string" enum:"StackSetDriftDetectionStatus"`

	// Status of the stack set's actual configuration compared to its expected template
	// and parameter configuration. A stack set is considered to have drifted if
	// one or more of its stack instances have drifted from their expected template
	// and parameter configuration.
	//
	//    * DRIFTED: One or more of the stack instances belonging to the stack set
	//    stack differs from the expected template and parameter configuration.
	//    A stack instance is considered to have drifted if one or more of the resources
	//    in the associated stack have drifted.
	//
	//    * NOT_CHECKED: CloudFormation hasn't checked the stack set for drift.
	//
	//    * IN_SYNC: All of the stack instances belonging to the stack set stack
	//    match from the expected template and parameter configuration.
	DriftStatus *string `type:"string" enum:"StackSetDriftStatus"`

	// The number of stack instances that have drifted from the expected template
	// and parameter configuration of the stack set. A stack instance is considered
	// to have drifted if one or more of the resources in the associated stack don't
	// match their expected configuration.
	DriftedStackInstancesCount *int64 `type:"integer"`

	// The number of stack instances for which the drift detection operation failed.
	FailedStackInstancesCount *int64 `type:"integer"`

	// The number of stack instances that are currently being checked for drift.
	InProgressStackInstancesCount *int64 `type:"integer"`

	// The number of stack instances which match the expected template and parameter
	// configuration of the stack set.
	InSyncStackInstancesCount *int64 `type:"integer"`

	// Most recent time when CloudFormation performed a drift detection operation
	// on the stack set. This value will be NULL for any stack set on which drift
	// detection hasn't yet been performed.
	LastDriftCheckTimestamp *time.Time `type:"timestamp"`

	// The total number of stack instances belonging to this stack set.
	//
	// The total number of stack instances is equal to the total of:
	//
	//    * Stack instances that match the stack set configuration.
	//
	//    * Stack instances that have drifted from the stack set configuration.
	//
	//    * Stack instances where the drift detection operation has failed.
	//
	//    * Stack instances currently being checked for drift.
	TotalStackInstancesCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetDriftDetectionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetDriftDetectionDetails) GoString() string {
	return s.String()
}

// SetDriftDetectionStatus sets the DriftDetectionStatus field's value.
func (s *StackSetDriftDetectionDetails) SetDriftDetectionStatus(v string) *StackSetDriftDetectionDetails {
	s.DriftDetectionStatus = &v
	return s
}

// SetDriftStatus sets the DriftStatus field's value.
func (s *StackSetDriftDetectionDetails) SetDriftStatus(v string) *StackSetDriftDetectionDetails {
	s.DriftStatus = &v
	return s
}

// SetDriftedStackInstancesCount sets the DriftedStackInstancesCount field's value.
func (s *StackSetDriftDetectionDetails) SetDriftedStackInstancesCount(v int64) *StackSetDriftDetectionDetails {
	s.DriftedStackInstancesCount = &v
	return s
}

// SetFailedStackInstancesCount sets the FailedStackInstancesCount field's value.
func (s *StackSetDriftDetectionDetails) SetFailedStackInstancesCount(v int64) *StackSetDriftDetectionDetails {
	s.FailedStackInstancesCount = &v
	return s
}

// SetInProgressStackInstancesCount sets the InProgressStackInstancesCount field's value.
func (s *StackSetDriftDetectionDetails) SetInProgressStackInstancesCount(v int64) *StackSetDriftDetectionDetails {
	s.InProgressStackInstancesCount = &v
	return s
}

// SetInSyncStackInstancesCount sets the InSyncStackInstancesCount field's value.
func (s *StackSetDriftDetectionDetails) SetInSyncStackInstancesCount(v int64) *StackSetDriftDetectionDetails {
	s.InSyncStackInstancesCount = &v
	return s
}

// SetLastDriftCheckTimestamp sets the LastDriftCheckTimestamp field's value.
func (s *StackSetDriftDetectionDetails) SetLastDriftCheckTimestamp(v time.Time) *StackSetDriftDetectionDetails {
	s.LastDriftCheckTimestamp = &v
	return s
}

// SetTotalStackInstancesCount sets the TotalStackInstancesCount field's value.
func (s *StackSetDriftDetectionDetails) SetTotalStackInstancesCount(v int64) *StackSetDriftDetectionDetails {
	s.TotalStackInstancesCount = &v
	return s
}

// The structure that contains information about a stack set operation.
type StackSetOperation struct {
	_ struct{} `type:"structure"`

	// The type of stack set operation: CREATE, UPDATE, or DELETE. Create and delete
	// operations affect only the specified stack set instances that are associated
	// with the specified stack set. Update operations affect both the stack set
	// itself, in addition to all associated stack set instances.
	Action *string `type:"string" enum:"StackSetOperationAction"`

	// The Amazon Resource Name (ARN) of the IAM role used to perform this stack
	// set operation.
	//
	// Use customized administrator roles to control which users or groups can manage
	// specific stack sets within the same administrator account. For more information,
	// see Define Permissions for Multiple Administrators (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
	// in the CloudFormation User Guide.
	AdministrationRoleARN *string `min:"20" type:"string"`

	// The time at which the operation was initiated. Note that the creation times
	// for the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested Regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time `type:"timestamp"`

	// [Service-managed permissions] The Organizations accounts affected by the
	// stack operation.
	DeploymentTargets *DeploymentTargets `type:"structure"`

	// The time at which the stack set operation ended, across all accounts and
	// Regions specified. Note that this doesn't necessarily mean that the stack
	// set operation was successful, or even attempted, in each account or Region.
	EndTimestamp *time.Time `type:"timestamp"`

	// The name of the IAM execution role used to create or update the stack set.
	//
	// Use customized execution roles to control which stack resources users and
	// groups can include in their stack sets.
	ExecutionRoleName *string `min:"1" type:"string"`

	// The unique ID of a stack set operation.
	OperationId *string `min:"1" type:"string"`

	// The preferences for how CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// For stack set operations of action type DELETE, specifies whether to remove
	// the stack instances from the specified stack set, but doesn't delete the
	// stacks. You can't re-associate a retained stack, or add an existing, saved
	// stack to a new stack set.
	RetainStacks *bool `type:"boolean"`

	// Detailed information about the drift status of the stack set. This includes
	// information about drift operations currently being performed on the stack
	// set.
	//
	// This information will only be present for stack set operations whose Action
	// type is DETECT_DRIFT.
	//
	// For more information, see Detecting Unmanaged Changes in Stack Sets (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html)
	// in the CloudFormation User Guide.
	StackSetDriftDetectionDetails *StackSetDriftDetectionDetails `type:"structure"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The status of the operation.
	//
	//    * FAILED: The operation exceeded the specified failure tolerance. The
	//    failure tolerance value that you've set for an operation is applied for
	//    each Region during stack create and update operations. If the number of
	//    failed stacks within a Region exceeds the failure tolerance, the status
	//    of the operation in the Region is set to FAILED. This in turn sets the
	//    status of the operation as a whole to FAILED, and CloudFormation cancels
	//    the operation in any remaining Regions.
	//
	//    * QUEUED: [Service-managed permissions] For automatic deployments that
	//    require a sequence of operations, the operation is queued to be performed.
	//    For more information, see the stack set operation status codes (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes)
	//    in the CloudFormation User Guide.
	//
	//    * RUNNING: The operation is currently being performed.
	//
	//    * STOPPED: The user has canceled the operation.
	//
	//    * STOPPING: The operation is in the process of stopping, at user request.
	//
	//    * SUCCEEDED: The operation completed creating or updating all the specified
	//    stacks without exceeding the failure tolerance for the operation.
	Status *string `type:"string" enum:"StackSetOperationStatus"`

	// Detailed information about the StackSet operation.
	StatusDetails *StackSetOperationStatusDetails `type:"structure"`

	// The status of the operation in details.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperation) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *StackSetOperation) SetAction(v string) *StackSetOperation {
	s.Action = &v
	return s
}

// SetAdministrationRoleARN sets the AdministrationRoleARN field's value.
func (s *StackSetOperation) SetAdministrationRoleARN(v string) *StackSetOperation {
	s.AdministrationRoleARN = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *StackSetOperation) SetCreationTimestamp(v time.Time) *StackSetOperation {
	s.CreationTimestamp = &v
	return s
}

// SetDeploymentTargets sets the DeploymentTargets field's value.
func (s *StackSetOperation) SetDeploymentTargets(v *DeploymentTargets) *StackSetOperation {
	s.DeploymentTargets = v
	return s
}

// SetEndTimestamp sets the EndTimestamp field's value.
func (s *StackSetOperation) SetEndTimestamp(v time.Time) *StackSetOperation {
	s.EndTimestamp = &v
	return s
}

// SetExecutionRoleName sets the ExecutionRoleName field's value.
func (s *StackSetOperation) SetExecutionRoleName(v string) *StackSetOperation {
	s.ExecutionRoleName = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *StackSetOperation) SetOperationId(v string) *StackSetOperation {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *StackSetOperation) SetOperationPreferences(v *StackSetOperationPreferences) *StackSetOperation {
	s.OperationPreferences = v
	return s
}

// SetRetainStacks sets the RetainStacks field's value.
func (s *StackSetOperation) SetRetainStacks(v bool) *StackSetOperation {
	s.RetainStacks = &v
	return s
}

// SetStackSetDriftDetectionDetails sets the StackSetDriftDetectionDetails field's value.
func (s *StackSetOperation) SetStackSetDriftDetectionDetails(v *StackSetDriftDetectionDetails) *StackSetOperation {
	s.StackSetDriftDetectionDetails = v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackSetOperation) SetStackSetId(v string) *StackSetOperation {
	s.StackSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSetOperation) SetStatus(v string) *StackSetOperation {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *StackSetOperation) SetStatusDetails(v *StackSetOperationStatusDetails) *StackSetOperation {
	s.StatusDetails = v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *StackSetOperation) SetStatusReason(v string) *StackSetOperation {
	s.StatusReason = &v
	return s
}

// The user-specified preferences for how CloudFormation performs a stack set
// operation.
//
// For more information about maximum concurrent accounts and failure tolerance,
// see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
type StackSetOperationPreferences struct {
	_ struct{} `type:"structure"`

	// Specifies how the concurrency level behaves during the operation execution.
	//
	//    * STRICT_FAILURE_TOLERANCE: This option dynamically lowers the concurrency
	//    level to ensure the number of failed accounts never exceeds the value
	//    of FailureToleranceCount +1. The initial actual concurrency is set to
	//    the lower of either the value of the MaxConcurrentCount, or the value
	//    of MaxConcurrentCount +1. The actual concurrency is then reduced proportionally
	//    by the number of failures. This is the default behavior. If failure tolerance
	//    or Maximum concurrent accounts are set to percentages, the behavior is
	//    similar.
	//
	//    * SOFT_FAILURE_TOLERANCE: This option decouples FailureToleranceCount
	//    from the actual concurrency. This allows stack set operations to run at
	//    the concurrency level set by the MaxConcurrentCount value, or MaxConcurrentPercentage,
	//    regardless of the number of failures.
	ConcurrencyMode *string `type:"string" enum:"ConcurrencyMode"`

	// The number of accounts, per Region, for which this operation can fail before
	// CloudFormation stops the operation in that Region. If the operation is stopped
	// in a Region, CloudFormation doesn't attempt the operation in any subsequent
	// Regions.
	//
	// Conditional: You must specify either FailureToleranceCount or FailureTolerancePercentage
	// (but not both).
	//
	// By default, 0 is specified.
	FailureToleranceCount *int64 `type:"integer"`

	// The percentage of accounts, per Region, for which this stack operation can
	// fail before CloudFormation stops the operation in that Region. If the operation
	// is stopped in a Region, CloudFormation doesn't attempt the operation in any
	// subsequent Regions.
	//
	// When calculating the number of accounts based on the specified percentage,
	// CloudFormation rounds down to the next whole number.
	//
	// Conditional: You must specify either FailureToleranceCount or FailureTolerancePercentage,
	// but not both.
	//
	// By default, 0 is specified.
	FailureTolerancePercentage *int64 `type:"integer"`

	// The maximum number of accounts in which to perform this operation at one
	// time. This can depend on the value of FailureToleranceCount depending on
	// your ConcurrencyMode. MaxConcurrentCount is at most one more than the FailureToleranceCount
	// if you're using STRICT_FAILURE_TOLERANCE.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Conditional: You must specify either MaxConcurrentCount or MaxConcurrentPercentage,
	// but not both.
	//
	// By default, 1 is specified.
	MaxConcurrentCount *int64 `min:"1" type:"integer"`

	// The maximum percentage of accounts in which to perform this operation at
	// one time.
	//
	// When calculating the number of accounts based on the specified percentage,
	// CloudFormation rounds down to the next whole number. This is true except
	// in cases where rounding down would result is zero. In this case, CloudFormation
	// sets the number as one instead.
	//
	// Note that this setting lets you specify the maximum for operations. For large
	// deployments, under certain circumstances the actual number of accounts acted
	// upon concurrently may be lower due to service throttling.
	//
	// Conditional: You must specify either MaxConcurrentCount or MaxConcurrentPercentage,
	// but not both.
	//
	// By default, 1 is specified.
	MaxConcurrentPercentage *int64 `min:"1" type:"integer"`

	// The concurrency type of deploying StackSets operations in Regions, could
	// be in parallel or one Region at a time.
	RegionConcurrencyType *string `type:"string" enum:"RegionConcurrencyType"`

	// The order of the Regions where you want to perform the stack operation.
	//
	// RegionOrder isn't followed if AutoDeployment is enabled.
	RegionOrder []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperationPreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperationPreferences) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StackSetOperationPreferences) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StackSetOperationPreferences"}
	if s.MaxConcurrentCount != nil && *s.MaxConcurrentCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConcurrentCount", 1))
	}
	if s.MaxConcurrentPercentage != nil && *s.MaxConcurrentPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConcurrentPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConcurrencyMode sets the ConcurrencyMode field's value.
func (s *StackSetOperationPreferences) SetConcurrencyMode(v string) *StackSetOperationPreferences {
	s.ConcurrencyMode = &v
	return s
}

// SetFailureToleranceCount sets the FailureToleranceCount field's value.
func (s *StackSetOperationPreferences) SetFailureToleranceCount(v int64) *StackSetOperationPreferences {
	s.FailureToleranceCount = &v
	return s
}

// SetFailureTolerancePercentage sets the FailureTolerancePercentage field's value.
func (s *StackSetOperationPreferences) SetFailureTolerancePercentage(v int64) *StackSetOperationPreferences {
	s.FailureTolerancePercentage = &v
	return s
}

// SetMaxConcurrentCount sets the MaxConcurrentCount field's value.
func (s *StackSetOperationPreferences) SetMaxConcurrentCount(v int64) *StackSetOperationPreferences {
	s.MaxConcurrentCount = &v
	return s
}

// SetMaxConcurrentPercentage sets the MaxConcurrentPercentage field's value.
func (s *StackSetOperationPreferences) SetMaxConcurrentPercentage(v int64) *StackSetOperationPreferences {
	s.MaxConcurrentPercentage = &v
	return s
}

// SetRegionConcurrencyType sets the RegionConcurrencyType field's value.
func (s *StackSetOperationPreferences) SetRegionConcurrencyType(v string) *StackSetOperationPreferences {
	s.RegionConcurrencyType = &v
	return s
}

// SetRegionOrder sets the RegionOrder field's value.
func (s *StackSetOperationPreferences) SetRegionOrder(v []*string) *StackSetOperationPreferences {
	s.RegionOrder = v
	return s
}

// The structure that contains information about a specified operation's results
// for a given account in a given Region.
type StackSetOperationResultSummary struct {
	_ struct{} `type:"structure"`

	// [Self-managed permissions] The name of the Amazon Web Services account for
	// this operation result.
	Account *string `type:"string"`

	// The results of the account gate function CloudFormation invokes, if present,
	// before proceeding with stack set operations in an account.
	AccountGateResult *AccountGateResult `type:"structure"`

	// [Service-managed permissions] The organization root ID or organizational
	// unit (OU) IDs that you specified for DeploymentTargets (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
	OrganizationalUnitId *string `type:"string"`

	// The name of the Amazon Web Services Region for this operation result.
	Region *string `type:"string"`

	// The result status of the stack set operation for the given account in the
	// given Region.
	//
	//    * CANCELLED: The operation in the specified account and Region has been
	//    canceled. This is either because a user has stopped the stack set operation,
	//    or because the failure tolerance of the stack set operation has been exceeded.
	//
	//    * FAILED: The operation in the specified account and Region failed. If
	//    the stack set operation fails in enough accounts within a Region, the
	//    failure tolerance for the stack set operation as a whole might be exceeded.
	//
	//    * RUNNING: The operation in the specified account and Region is currently
	//    in progress.
	//
	//    * PENDING: The operation in the specified account and Region has yet to
	//    start.
	//
	//    * SUCCEEDED: The operation in the specified account and Region completed
	//    successfully.
	Status *string `type:"string" enum:"StackSetOperationResultStatus"`

	// The reason for the assigned result status.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperationResultSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperationResultSummary) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *StackSetOperationResultSummary) SetAccount(v string) *StackSetOperationResultSummary {
	s.Account = &v
	return s
}

// SetAccountGateResult sets the AccountGateResult field's value.
func (s *StackSetOperationResultSummary) SetAccountGateResult(v *AccountGateResult) *StackSetOperationResultSummary {
	s.AccountGateResult = v
	return s
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *StackSetOperationResultSummary) SetOrganizationalUnitId(v string) *StackSetOperationResultSummary {
	s.OrganizationalUnitId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *StackSetOperationResultSummary) SetRegion(v string) *StackSetOperationResultSummary {
	s.Region = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSetOperationResultSummary) SetStatus(v string) *StackSetOperationResultSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *StackSetOperationResultSummary) SetStatusReason(v string) *StackSetOperationResultSummary {
	s.StatusReason = &v
	return s
}

// Detailed information about the StackSet operation.
type StackSetOperationStatusDetails struct {
	_ struct{} `type:"structure"`

	// The number of stack instances for which the StackSet operation failed.
	FailedStackInstancesCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperationStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperationStatusDetails) GoString() string {
	return s.String()
}

// SetFailedStackInstancesCount sets the FailedStackInstancesCount field's value.
func (s *StackSetOperationStatusDetails) SetFailedStackInstancesCount(v int64) *StackSetOperationStatusDetails {
	s.FailedStackInstancesCount = &v
	return s
}

// The structures that contain summary information about the specified operation.
type StackSetOperationSummary struct {
	_ struct{} `type:"structure"`

	// The type of operation: CREATE, UPDATE, or DELETE. Create and delete operations
	// affect only the specified stack instances that are associated with the specified
	// stack set. Update operations affect both the stack set itself and all associated
	// stack set instances.
	Action *string `type:"string" enum:"StackSetOperationAction"`

	// The time at which the operation was initiated. Note that the creation times
	// for the stack set operation might differ from the creation time of the individual
	// stacks themselves. This is because CloudFormation needs to perform preparatory
	// work for the operation, such as dispatching the work to the requested Regions,
	// before actually creating the first stacks.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The time at which the stack set operation ended, across all accounts and
	// Regions specified. Note that this doesn't necessarily mean that the stack
	// set operation was successful, or even attempted, in each account or Region.
	EndTimestamp *time.Time `type:"timestamp"`

	// The unique ID of the stack set operation.
	OperationId *string `min:"1" type:"string"`

	// The user-specified preferences for how CloudFormation performs a stack set
	// operation.
	//
	// For more information about maximum concurrent accounts and failure tolerance,
	// see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// The overall status of the operation.
	//
	//    * FAILED: The operation exceeded the specified failure tolerance. The
	//    failure tolerance value that you've set for an operation is applied for
	//    each Region during stack create and update operations. If the number of
	//    failed stacks within a Region exceeds the failure tolerance, the status
	//    of the operation in the Region is set to FAILED. This in turn sets the
	//    status of the operation as a whole to FAILED, and CloudFormation cancels
	//    the operation in any remaining Regions.
	//
	//    * QUEUED: [Service-managed permissions] For automatic deployments that
	//    require a sequence of operations, the operation is queued to be performed.
	//    For more information, see the stack set operation status codes (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes)
	//    in the CloudFormation User Guide.
	//
	//    * RUNNING: The operation is currently being performed.
	//
	//    * STOPPED: The user has canceled the operation.
	//
	//    * STOPPING: The operation is in the process of stopping, at user request.
	//
	//    * SUCCEEDED: The operation completed creating or updating all the specified
	//    stacks without exceeding the failure tolerance for the operation.
	Status *string `type:"string" enum:"StackSetOperationStatus"`

	// Detailed information about the stack set operation.
	StatusDetails *StackSetOperationStatusDetails `type:"structure"`

	// The status of the operation in details.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetOperationSummary) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *StackSetOperationSummary) SetAction(v string) *StackSetOperationSummary {
	s.Action = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *StackSetOperationSummary) SetCreationTimestamp(v time.Time) *StackSetOperationSummary {
	s.CreationTimestamp = &v
	return s
}

// SetEndTimestamp sets the EndTimestamp field's value.
func (s *StackSetOperationSummary) SetEndTimestamp(v time.Time) *StackSetOperationSummary {
	s.EndTimestamp = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *StackSetOperationSummary) SetOperationId(v string) *StackSetOperationSummary {
	s.OperationId = &v
	return s
}

// SetOperationPreferences sets the OperationPreferences field's value.
func (s *StackSetOperationSummary) SetOperationPreferences(v *StackSetOperationPreferences) *StackSetOperationSummary {
	s.OperationPreferences = v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSetOperationSummary) SetStatus(v string) *StackSetOperationSummary {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *StackSetOperationSummary) SetStatusDetails(v *StackSetOperationStatusDetails) *StackSetOperationSummary {
	s.StatusDetails = v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *StackSetOperationSummary) SetStatusReason(v string) *StackSetOperationSummary {
	s.StatusReason = &v
	return s
}

// The structures that contain summary information about the specified stack
// set.
type StackSetSummary struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Describes whether StackSets automatically deploys
	// to Organizations accounts that are added to a target organizational unit
	// (OU).
	AutoDeployment *AutoDeployment `type:"structure"`

	// A description of the stack set that you specify when the stack set is created
	// or updated.
	Description *string `min:"1" type:"string"`

	// Status of the stack set's actual configuration compared to its expected template
	// and parameter configuration. A stack set is considered to have drifted if
	// one or more of its stack instances have drifted from their expected template
	// and parameter configuration.
	//
	//    * DRIFTED: One or more of the stack instances belonging to the stack set
	//    stack differs from the expected template and parameter configuration.
	//    A stack instance is considered to have drifted if one or more of the resources
	//    in the associated stack have drifted.
	//
	//    * NOT_CHECKED: CloudFormation hasn't checked the stack set for drift.
	//
	//    * IN_SYNC: All the stack instances belonging to the stack set stack match
	//    from the expected template and parameter configuration.
	//
	//    * UNKNOWN: This value is reserved for future use.
	DriftStatus *string `type:"string" enum:"StackDriftStatus"`

	// Most recent time when CloudFormation performed a drift detection operation
	// on the stack set. This value will be NULL for any stack set on which drift
	// detection hasn't yet been performed.
	LastDriftCheckTimestamp *time.Time `type:"timestamp"`

	// Describes whether StackSets performs non-conflicting operations concurrently
	// and queues conflicting operations.
	ManagedExecution *ManagedExecution `type:"structure"`

	// Describes how the IAM roles required for stack set operations are created.
	//
	//    * With self-managed permissions, you must create the administrator and
	//    execution roles required to deploy to target accounts. For more information,
	//    see Grant Self-Managed Stack Set Permissions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
	//
	//    * With service-managed permissions, StackSets automatically creates the
	//    IAM roles required to deploy to accounts managed by Organizations. For
	//    more information, see Grant Service-Managed Stack Set Permissions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html).
	PermissionModel *string `type:"string" enum:"PermissionModels"`

	// The ID of the stack set.
	StackSetId *string `type:"string"`

	// The name of the stack set.
	StackSetName *string `type:"string"`

	// The status of the stack set.
	Status *string `type:"string" enum:"StackSetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSetSummary) GoString() string {
	return s.String()
}

// SetAutoDeployment sets the AutoDeployment field's value.
func (s *StackSetSummary) SetAutoDeployment(v *AutoDeployment) *StackSetSummary {
	s.AutoDeployment = v
	return s
}

// SetDescription sets the Description field's value.
func (s *StackSetSummary) SetDescription(v string) *StackSetSummary {
	s.Description = &v
	return s
}

// SetDriftStatus sets the DriftStatus field's value.
func (s *StackSetSummary) SetDriftStatus(v string) *StackSetSummary {
	s.DriftStatus = &v
	return s
}

// SetLastDriftCheckTimestamp sets the LastDriftCheckTimestamp field's value.
func (s *StackSetSummary) SetLastDriftCheckTimestamp(v time.Time) *StackSetSummary {
	s.LastDriftCheckTimestamp = &v
	return s
}

// SetManagedExecution sets the ManagedExecution field's value.
func (s *StackSetSummary) SetManagedExecution(v *ManagedExecution) *StackSetSummary {
	s.ManagedExecution = v
	return s
}

// SetPermissionModel sets the PermissionModel field's value.
func (s *StackSetSummary) SetPermissionModel(v string) *StackSetSummary {
	s.PermissionModel = &v
	return s
}

// SetStackSetId sets the StackSetId field's value.
func (s *StackSetSummary) SetStackSetId(v string) *StackSetSummary {
	s.StackSetId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *StackSetSummary) SetStackSetName(v string) *StackSetSummary {
	s.StackSetName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StackSetSummary) SetStatus(v string) *StackSetSummary {
	s.Status = &v
	return s
}

// The StackSummary Data Type
type StackSummary struct {
	_ struct{} `type:"structure"`

	// The time the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp"`

	// Summarizes information about whether a stack's actual configuration differs,
	// or has drifted, from its expected configuration, as defined in the stack
	// template and any values specified as template parameters. For more information,
	// see Detecting Unregulated Configuration Changes to Stacks and Resources (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
	DriftInformation *StackDriftInformationSummary `type:"structure"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the direct parent of this stack. For the first level of nested stacks,
	// the root stack is also the parent stack.
	//
	// For more information, see Working with Nested Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the CloudFormation User Guide.
	ParentId *string `type:"string"`

	// For nested stacks--stacks created as resources for another stack--the stack
	// ID of the top-level stack to which the nested stack ultimately belongs.
	//
	// For more information, see Working with Nested Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html)
	// in the CloudFormation User Guide.
	RootId *string `type:"string"`

	// Unique stack identifier.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// The current status of the stack.
	//
	// StackStatus is a required field
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/Failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// The template description of the template used to create the stack.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StackSummary) SetCreationTime(v time.Time) *StackSummary {
	s.CreationTime = &v
	return s
}

// SetDeletionTime sets the DeletionTime field's value.
func (s *StackSummary) SetDeletionTime(v time.Time) *StackSummary {
	s.DeletionTime = &v
	return s
}

// SetDriftInformation sets the DriftInformation field's value.
func (s *StackSummary) SetDriftInformation(v *StackDriftInformationSummary) *StackSummary {
	s.DriftInformation = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *StackSummary) SetLastUpdatedTime(v time.Time) *StackSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *StackSummary) SetParentId(v string) *StackSummary {
	s.ParentId = &v
	return s
}

// SetRootId sets the RootId field's value.
func (s *StackSummary) SetRootId(v string) *StackSummary {
	s.RootId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackSummary) SetStackId(v string) *StackSummary {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackSummary) SetStackName(v string) *StackSummary {
	s.StackName = &v
	return s
}

// SetStackStatus sets the StackStatus field's value.
func (s *StackSummary) SetStackStatus(v string) *StackSummary {
	s.StackStatus = &v
	return s
}

// SetStackStatusReason sets the StackStatusReason field's value.
func (s *StackSummary) SetStackStatusReason(v string) *StackSummary {
	s.StackStatusReason = &v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *StackSummary) SetTemplateDescription(v string) *StackSummary {
	s.TemplateDescription = &v
	return s
}

type StartResourceScanInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this StartResourceScan request. Specify this token
	// if you plan to retry requests so that CloudFormation knows that you're not
	// attempting to start a new resource scan.
	ClientRequestToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartResourceScanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartResourceScanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartResourceScanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartResourceScanInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartResourceScanInput) SetClientRequestToken(v string) *StartResourceScanInput {
	s.ClientRequestToken = &v
	return s
}

type StartResourceScanOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource scan. The format is arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}.
	// An example is arn:aws:cloudformation:us-east-1:123456789012:resourceScan/f5b490f7-7ed4-428a-aa06-31ff25db0772 .
	ResourceScanId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartResourceScanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartResourceScanOutput) GoString() string {
	return s.String()
}

// SetResourceScanId sets the ResourceScanId field's value.
func (s *StartResourceScanOutput) SetResourceScanId(v string) *StartResourceScanOutput {
	s.ResourceScanId = &v
	return s
}

type StopStackSetOperationInput struct {
	_ struct{} `type:"structure"`

	// [Service-managed permissions] Specifies whether you are acting as an account
	// administrator in the organization's management account or as a delegated
	// administrator in a member account.
	//
	// By default, SELF is specified. Use SELF for stack sets with self-managed
	// permissions.
	//
	//    * If you are signed in to the management account, specify SELF.
	//
	//    * If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN.
	//    Your Amazon Web Services account must be registered as a delegated administrator
	//    in the management account. For more information, see Register a delegated
	//    administrator (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html)
	//    in the CloudFormation User Guide.
	CallAs *string `type:"string" enum:"CallAs"`

	// The ID of the stack operation.
	//
	// OperationId is a required field
	OperationId *string `min:"1" type:"string" required:"true"`

	// The name or unique ID of the stack set that you want to stop the operation
	// for.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStackSetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStackSetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStackSetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopStackSetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationId", 1))
	}
	if s.StackSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAs sets the CallAs field's value.
func (s *StopStackSetOperationInput) SetCallAs(v string) *StopStackSetOperationInput {
	s.CallAs = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *StopStackSetOperationInput) SetOperationId(v string) *StopStackSetOperationInput {
	s.OperationId = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *StopStackSetOperationInput) SetStackSetName(v string) *StopStackSetOperationInput {
	s.StackSetName = &v
	return s
}

type StopStackSetOperationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStackSetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStackSetOperationOutput) GoString() string {
	return s.String()
}

// The Tag type enables you to specify a key-value pair that can be used to
// store information about an CloudFormation stack.
type Tag struct {
	_ struct{} `type:"structure"`

	// Required. A string used to identify this tag. You can specify a maximum of
	// 128 characters for a tag key. Tags owned by Amazon Web Services (Amazon Web
	// Services) have the reserved prefix: aws:.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Required. A string containing the value for this tag. You can specify a maximum
	// of 256 characters for a tag value.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The configuration details of a generated template.
type TemplateConfiguration struct {
	_ struct{} `type:"structure"`

	// The DeletionPolicy assigned to resources in the generated template. Supported
	// values are:
	//
	//    * DELETE - delete all resources when the stack is deleted.
	//
	//    * RETAIN - retain all resources when the stack is deleted.
	//
	// For more information, see DeletionPolicy attribute (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html)
	// in the CloudFormation User Guide.
	DeletionPolicy *string `type:"string" enum:"GeneratedTemplateDeletionPolicy"`

	// The UpdateReplacePolicy assigned to resources in the generated template.
	// Supported values are:
	//
	//    * DELETE - delete all resources when the resource is replaced during an
	//    update operation.
	//
	//    * RETAIN - retain all resources when the resource is replaced during an
	//    update operation.
	//
	// For more information, see UpdateReplacePolicy attribute (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html)
	// in the CloudFormation User Guide.
	UpdateReplacePolicy *string `type:"string" enum:"GeneratedTemplateUpdateReplacePolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateConfiguration) GoString() string {
	return s.String()
}

// SetDeletionPolicy sets the DeletionPolicy field's value.
func (s *TemplateConfiguration) SetDeletionPolicy(v string) *TemplateConfiguration {
	s.DeletionPolicy = &v
	return s
}

// SetUpdateReplacePolicy sets the UpdateReplacePolicy field's value.
func (s *TemplateConfiguration) SetUpdateReplacePolicy(v string) *TemplateConfiguration {
	s.UpdateReplacePolicy = &v
	return s
}

// The TemplateParameter data type.
type TemplateParameter struct {
	_ struct{} `type:"structure"`

	// The default value associated with the parameter.
	DefaultValue *string `type:"string"`

	// User defined description associated with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag indicating whether the parameter should be displayed as plain text in
	// logs and UIs.
	NoEcho *bool `type:"boolean"`

	// The name associated with the parameter.
	ParameterKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateParameter) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *TemplateParameter) SetDefaultValue(v string) *TemplateParameter {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TemplateParameter) SetDescription(v string) *TemplateParameter {
	s.Description = &v
	return s
}

// SetNoEcho sets the NoEcho field's value.
func (s *TemplateParameter) SetNoEcho(v bool) *TemplateParameter {
	s.NoEcho = &v
	return s
}

// SetParameterKey sets the ParameterKey field's value.
func (s *TemplateParameter) SetParameterKey(v string) *TemplateParameter {
	s.ParameterKey = &v
	return s
}

// A summary of the progress of the template generation.
type TemplateProgress struct {
	_ struct{} `type:"structure"`

	// The number of resources that failed the template generation.
	ResourcesFailed *int64 `type:"integer"`

	// The number of resources that are still pending the template generation.
	ResourcesPending *int64 `type:"integer"`

	// The number of resources that are in-process for the template generation.
	ResourcesProcessing *int64 `type:"integer"`

	// The number of resources that succeeded the template generation.
	ResourcesSucceeded *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateProgress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateProgress) GoString() string {
	return s.String()
}

// SetResourcesFailed sets the ResourcesFailed field's value.
func (s *TemplateProgress) SetResourcesFailed(v int64) *TemplateProgress {
	s.ResourcesFailed = &v
	return s
}

// SetResourcesPending sets the ResourcesPending field's value.
func (s *TemplateProgress) SetResourcesPending(v int64) *TemplateProgress {
	s.ResourcesPending = &v
	return s
}

// SetResourcesProcessing sets the ResourcesProcessing field's value.
func (s *TemplateProgress) SetResourcesProcessing(v int64) *TemplateProgress {
	s.ResourcesProcessing = &v
	return s
}

// SetResourcesSucceeded sets the ResourcesSucceeded field's value.
func (s *TemplateProgress) SetResourcesSucceeded(v int64) *TemplateProgress {
	s.ResourcesSucceeded = &v
	return s
}

// The summary of a generated template.
type TemplateSummary struct {
	_ struct{} `type:"structure"`

	// The time the generated template was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the generated template. The format is arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}.
	// For example, arn:aws:cloudformation:us-east-1:123456789012:generatedtemplate/2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc .
	GeneratedTemplateId *string `min:"1" type:"string"`

	// The name of the generated template.
	GeneratedTemplateName *string `min:"1" type:"string"`

	// The time the generated template was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The number of resources in the generated template. This is a total of resources
	// in pending, in-progress, completed, and failed states.
	NumberOfResources *int64 `type:"integer"`

	// The status of the template generation. Supported values are:
	//
	//    * CreatePending - the creation of the template is pending.
	//
	//    * CreateInProgress - the creation of the template is in progress.
	//
	//    * DeletePending - the deletion of the template is pending.
	//
	//    * DeleteInProgress - the deletion of the template is in progress.
	//
	//    * UpdatePending - the update of the template is pending.
	//
	//    * UpdateInProgress - the update of the template is in progress.
	//
	//    * Failed - the template operation failed.
	//
	//    * Complete - the template operation is complete.
	Status *string `type:"string" enum:"GeneratedTemplateStatus"`

	// The reason for the current template generation status. This will provide
	// more details if a failure happened.
	StatusReason *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *TemplateSummary) SetCreationTime(v time.Time) *TemplateSummary {
	s.CreationTime = &v
	return s
}

// SetGeneratedTemplateId sets the GeneratedTemplateId field's value.
func (s *TemplateSummary) SetGeneratedTemplateId(v string) *TemplateSummary {
	s.GeneratedTemplateId = &v
	return s
}

// SetGeneratedTemplateName sets the GeneratedTemplateName field's value.
func (s *TemplateSummary) SetGeneratedTemplateName(v string) *TemplateSummary {
	s.GeneratedTemplateName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *TemplateSummary) SetLastUpdatedTime(v time.Time) *TemplateSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetNumberOfResources sets the NumberOfResources field's value.
func (s *TemplateSummary) SetNumberOfResources(v int64) *TemplateSummary {
	s.NumberOfResources = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TemplateSummary) SetStatus(v string) *TemplateSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TemplateSummary) SetStatusReason(v string) *TemplateSummary {
	s.StatusReason = &v
	return s
}

// Options for the GetTemplateSummary API action.
type TemplateSummaryConfig struct {
	_ struct{} `type:"structure"`

	// If set to True, any unrecognized resource types generate warnings and not
	// an error. Any unrecognized resource types are returned in the Warnings output
	// parameter.
	TreatUnrecognizedResourceTypesAsWarnings *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummaryConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummaryConfig) GoString() string {
	return s.String()
}

// SetTreatUnrecognizedResourceTypesAsWarnings sets the TreatUnrecognizedResourceTypesAsWarnings field's value.
func (s *TemplateSummaryConfig) SetTreatUnrecognizedResourceTypesAsWarnings(v bool) *TemplateSummaryConfig {
	s.TreatUnrecognizedResourceTypesAsWarnings = &v
	return s
}

type TestTypeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension.
	//
	// Conditional: You must specify Arn, or TypeName and Type.
	Arn *string `type:"string"`

	// The S3 bucket to which CloudFormation delivers the contract test execution
	// logs.
	//
	// CloudFormation delivers the logs by the time contract testing has completed
	// and the extension has been assigned a test type status of PASSED or FAILED.
	//
	// The user calling TestType must be able to access items in the specified S3
	// bucket. Specifically, the user needs the following permissions:
	//
	//    * GetObject
	//
	//    * PutObject
	//
	// For more information, see Actions, Resources, and Condition Keys for Amazon
	// S3 (https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html)
	// in the Amazon Web Services Identity and Access Management User Guide.
	LogDeliveryBucket *string `min:"3" type:"string"`

	// The type of the extension to test.
	//
	// Conditional: You must specify Arn, or TypeName and Type.
	Type *string `type:"string" enum:"ThirdPartyType"`

	// The name of the extension to test.
	//
	// Conditional: You must specify Arn, or TypeName and Type.
	TypeName *string `min:"10" type:"string"`

	// The version of the extension to test.
	//
	// You can specify the version id with either Arn, or with TypeName and Type.
	//
	// If you don't specify a version, CloudFormation uses the default version of
	// the extension in this account and Region for testing.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestTypeInput"}
	if s.LogDeliveryBucket != nil && len(*s.LogDeliveryBucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("LogDeliveryBucket", 3))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TestTypeInput) SetArn(v string) *TestTypeInput {
	s.Arn = &v
	return s
}

// SetLogDeliveryBucket sets the LogDeliveryBucket field's value.
func (s *TestTypeInput) SetLogDeliveryBucket(v string) *TestTypeInput {
	s.LogDeliveryBucket = &v
	return s
}

// SetType sets the Type field's value.
func (s *TestTypeInput) SetType(v string) *TestTypeInput {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *TestTypeInput) SetTypeName(v string) *TestTypeInput {
	s.TypeName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *TestTypeInput) SetVersionId(v string) *TestTypeInput {
	s.VersionId = &v
	return s
}

type TestTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension.
	TypeVersionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestTypeOutput) GoString() string {
	return s.String()
}

// SetTypeVersionArn sets the TypeVersionArn field's value.
func (s *TestTypeOutput) SetTypeVersionArn(v string) *TestTypeOutput {
	s.TypeVersionArn = &v
	return s
}

// Detailed information concerning the specification of a CloudFormation extension
// in a given account and Region.
//
// For more information, see Configuring extensions at the account level (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private.html#registry-set-configuration)
// in the CloudFormation User Guide.
type TypeConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The alias specified for this configuration, if one was specified when the
	// configuration was set.
	Alias *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the configuration data, in this account
	// and Region.
	Arn *string `type:"string"`

	// A JSON string specifying the configuration data for the extension, in this
	// account and Region.
	//
	// If a configuration hasn't been set for a specified extension, CloudFormation
	// returns {}.
	Configuration *string `min:"1" type:"string"`

	// Whether this configuration data is the default configuration for the extension.
	IsDefaultConfiguration *bool `type:"boolean"`

	// When the configuration data was last updated for this extension.
	//
	// If a configuration hasn't been set for a specified extension, CloudFormation
	// returns null.
	LastUpdated *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) for the extension, in this account and Region.
	//
	// For public extensions, this will be the ARN assigned when you call the ActivateType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
	// API operation in this account and Region. For private extensions, this will
	// be the ARN assigned when you call the RegisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html)
	// API operation in this account and Region.
	TypeArn *string `type:"string"`

	// The name of the extension.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeConfigurationDetails) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *TypeConfigurationDetails) SetAlias(v string) *TypeConfigurationDetails {
	s.Alias = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *TypeConfigurationDetails) SetArn(v string) *TypeConfigurationDetails {
	s.Arn = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *TypeConfigurationDetails) SetConfiguration(v string) *TypeConfigurationDetails {
	s.Configuration = &v
	return s
}

// SetIsDefaultConfiguration sets the IsDefaultConfiguration field's value.
func (s *TypeConfigurationDetails) SetIsDefaultConfiguration(v bool) *TypeConfigurationDetails {
	s.IsDefaultConfiguration = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *TypeConfigurationDetails) SetLastUpdated(v time.Time) *TypeConfigurationDetails {
	s.LastUpdated = &v
	return s
}

// SetTypeArn sets the TypeArn field's value.
func (s *TypeConfigurationDetails) SetTypeArn(v string) *TypeConfigurationDetails {
	s.TypeArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *TypeConfigurationDetails) SetTypeName(v string) *TypeConfigurationDetails {
	s.TypeName = &v
	return s
}

// Identifying information for the configuration of a CloudFormation extension.
type TypeConfigurationIdentifier struct {
	_ struct{} `type:"structure"`

	// The type of extension.
	Type *string `type:"string" enum:"ThirdPartyType"`

	// The Amazon Resource Name (ARN) for the extension, in this account and Region.
	//
	// For public extensions, this will be the ARN assigned when you call the ActivateType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
	// API operation in this account and Region. For private extensions, this will
	// be the ARN assigned when you call the RegisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html)
	// API operation in this account and Region.
	TypeArn *string `type:"string"`

	// The alias specified for this configuration, if one was specified when the
	// configuration was set.
	TypeConfigurationAlias *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the configuration, in this account and
	// Region.
	TypeConfigurationArn *string `type:"string"`

	// The name of the extension type to which this configuration applies.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeConfigurationIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeConfigurationIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypeConfigurationIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypeConfigurationIdentifier"}
	if s.TypeConfigurationAlias != nil && len(*s.TypeConfigurationAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeConfigurationAlias", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *TypeConfigurationIdentifier) SetType(v string) *TypeConfigurationIdentifier {
	s.Type = &v
	return s
}

// SetTypeArn sets the TypeArn field's value.
func (s *TypeConfigurationIdentifier) SetTypeArn(v string) *TypeConfigurationIdentifier {
	s.TypeArn = &v
	return s
}

// SetTypeConfigurationAlias sets the TypeConfigurationAlias field's value.
func (s *TypeConfigurationIdentifier) SetTypeConfigurationAlias(v string) *TypeConfigurationIdentifier {
	s.TypeConfigurationAlias = &v
	return s
}

// SetTypeConfigurationArn sets the TypeConfigurationArn field's value.
func (s *TypeConfigurationIdentifier) SetTypeConfigurationArn(v string) *TypeConfigurationIdentifier {
	s.TypeConfigurationArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *TypeConfigurationIdentifier) SetTypeName(v string) *TypeConfigurationIdentifier {
	s.TypeName = &v
	return s
}

// Filter criteria to use in determining which extensions to return.
type TypeFilters struct {
	_ struct{} `type:"structure"`

	// The category of extensions to return.
	//
	//    * REGISTERED: Private extensions that have been registered for this account
	//    and Region.
	//
	//    * ACTIVATED: Public extensions that have been activated for this account
	//    and Region.
	//
	//    * THIRD_PARTY: Extensions available for use from publishers other than
	//    Amazon. This includes: Private extensions registered in the account. Public
	//    extensions from publishers other than Amazon, whether activated or not.
	//
	//    * AWS_TYPES: Extensions available for use from Amazon.
	Category *string `type:"string" enum:"Category"`

	// The id of the publisher of the extension.
	//
	// Extensions published by Amazon aren't assigned a publisher ID. Use the AWS_TYPES
	// category to specify a list of types published by Amazon.
	PublisherId *string `min:"1" type:"string"`

	// A prefix to use as a filter for results.
	TypeNamePrefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TypeFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TypeFilters"}
	if s.PublisherId != nil && len(*s.PublisherId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublisherId", 1))
	}
	if s.TypeNamePrefix != nil && len(*s.TypeNamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeNamePrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *TypeFilters) SetCategory(v string) *TypeFilters {
	s.Category = &v
	return s
}

// SetPublisherId sets the PublisherId field's value.
func (s *TypeFilters) SetPublisherId(v string) *TypeFilters {
	s.PublisherId = &v
	return s
}

// SetTypeNamePrefix sets the TypeNamePrefix field's value.
func (s *TypeFilters) SetTypeNamePrefix(v string) *TypeFilters {
	s.TypeNamePrefix = &v
	return s
}

// Contains summary information about the specified CloudFormation extension.
type TypeSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the default version of the extension. The default version is used
	// when the extension version isn't specified.
	//
	// This applies only to private extensions you have registered in your account.
	// For public extensions, both those provided by Amazon and published by third
	// parties, CloudFormation returns null. For more information, see RegisterType
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
	//
	// To set the default version of an extension, use SetTypeDefaultVersion.
	DefaultVersionId *string `min:"1" type:"string"`

	// The description of the extension.
	Description *string `min:"1" type:"string"`

	// Whether the extension is activated for this account and Region.
	//
	// This applies only to third-party public extensions. Extensions published
	// by Amazon are activated by default.
	IsActivated *bool `type:"boolean"`

	// When the specified extension version was registered. This applies only to:
	//
	//    * Private extensions you have registered in your account. For more information,
	//    see RegisterType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
	//
	//    * Public extensions you have activated in your account with auto-update
	//    specified. For more information, see ActivateType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html).
	//
	// For all other extension types, CloudFormation returns null.
	LastUpdated *time.Time `type:"timestamp"`

	// For public extensions that have been activated for this account and Region,
	// the latest version of the public extension that is available. For any extensions
	// other than activated third-arty extensions, CloudFormation returns null.
	//
	// How you specified AutoUpdate when enabling the extension affects whether
	// CloudFormation automatically updates the extension in this account and Region
	// when a new version is released. For more information, see Setting CloudFormation
	// to automatically use new versions of extensions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto)
	// in the CloudFormation User Guide.
	LatestPublicVersion *string `min:"5" type:"string"`

	// For public extensions that have been activated for this account and Region,
	// the type name of the public extension.
	//
	// If you specified a TypeNameAlias when enabling the extension in this account
	// and Region, CloudFormation treats that alias as the extension's type name
	// within the account and Region, not the type name of the public extension.
	// For more information, see Specifying aliases to refer to extensions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias)
	// in the CloudFormation User Guide.
	OriginalTypeName *string `min:"10" type:"string"`

	// For public extensions that have been activated for this account and Region,
	// the version of the public extension to be used for CloudFormation operations
	// in this account and Region.
	//
	// How you specified AutoUpdate when enabling the extension affects whether
	// CloudFormation automatically updates the extension in this account and Region
	// when a new version is released. For more information, see Setting CloudFormation
	// to automatically use new versions of extensions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto)
	// in the CloudFormation User Guide.
	PublicVersionNumber *string `min:"5" type:"string"`

	// The ID of the extension publisher, if the extension is published by a third
	// party. Extensions published by Amazon don't return a publisher ID.
	PublisherId *string `min:"1" type:"string"`

	// The service used to verify the publisher identity.
	//
	// For more information, see Registering your account to publish CloudFormation
	// extensions (https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html)
	// in the CFN-CLI User Guide for Extension Development.
	PublisherIdentity *string `type:"string" enum:"IdentityProvider"`

	// The publisher name, as defined in the public profile for that publisher in
	// the service used to verify the publisher identity.
	PublisherName *string `min:"1" type:"string"`

	// The kind of extension.
	Type *string `type:"string" enum:"RegistryType"`

	// The Amazon Resource Name (ARN) of the extension.
	TypeArn *string `type:"string"`

	// The name of the extension.
	//
	// If you specified a TypeNameAlias when you call the ActivateType (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
	// API operation in your account and Region, CloudFormation considers that alias
	// as the type name.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeSummary) GoString() string {
	return s.String()
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *TypeSummary) SetDefaultVersionId(v string) *TypeSummary {
	s.DefaultVersionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TypeSummary) SetDescription(v string) *TypeSummary {
	s.Description = &v
	return s
}

// SetIsActivated sets the IsActivated field's value.
func (s *TypeSummary) SetIsActivated(v bool) *TypeSummary {
	s.IsActivated = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *TypeSummary) SetLastUpdated(v time.Time) *TypeSummary {
	s.LastUpdated = &v
	return s
}

// SetLatestPublicVersion sets the LatestPublicVersion field's value.
func (s *TypeSummary) SetLatestPublicVersion(v string) *TypeSummary {
	s.LatestPublicVersion = &v
	return s
}

// SetOriginalTypeName sets the OriginalTypeName field's value.
func (s *TypeSummary) SetOriginalTypeName(v string) *TypeSummary {
	s.OriginalTypeName = &v
	return s
}

// SetPublicVersionNumber sets the PublicVersionNumber field's value.
func (s *TypeSummary) SetPublicVersionNumber(v string) *TypeSummary {
	s.PublicVersionNumber = &v
	return s
}

// SetPublisherId sets the PublisherId field's value.
func (s *TypeSummary) SetPublisherId(v string) *TypeSummary {
	s.PublisherId = &v
	return s
}

// SetPublisherIdentity sets the PublisherIdentity field's value.
func (s *TypeSummary) SetPublisherIdentity(v string) *TypeSummary {
	s.PublisherIdentity = &v
	return s
}

// SetPublisherName sets the PublisherName field's value.
func (s *TypeSummary) SetPublisherName(v string) *TypeSummary {
	s.PublisherName = &v
	return s
}

// SetType sets the Type field's value.
func (s *TypeSummary) SetType(v string) *TypeSummary {
	s.Type = &v
	return s
}

// SetTypeArn sets the TypeArn field's value.
func (s *TypeSummary) SetTypeArn(v string) *TypeSummary {
	s.TypeArn = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *TypeSummary) SetTypeName(v string) *TypeSummary {
	s.TypeName = &v
	return s
}

// Contains summary information about a specific version of a CloudFormation
// extension.
type TypeVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the extension version.
	Arn *string `type:"string"`

	// The description of the extension version.
	Description *string `min:"1" type:"string"`

	// Whether the specified extension version is set as the default version.
	//
	// This applies only to private extensions you have registered in your account,
	// and extensions published by Amazon. For public third-party extensions, CloudFormation
	// returns null.
	IsDefaultVersion *bool `type:"boolean"`

	// For public extensions that have been activated for this account and Region,
	// the version of the public extension to be used for CloudFormation operations
	// in this account and Region. For any extensions other than activated third-arty
	// extensions, CloudFormation returns null.
	//
	// How you specified AutoUpdate when enabling the extension affects whether
	// CloudFormation automatically updates the extension in this account and Region
	// when a new version is released. For more information, see Setting CloudFormation
	// to automatically use new versions of extensions (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto)
	// in the CloudFormation User Guide.
	PublicVersionNumber *string `min:"5" type:"string"`

	// When the version was registered.
	TimeCreated *time.Time `type:"timestamp"`

	// The kind of extension.
	Type *string `type:"string" enum:"RegistryType"`

	// The name of the extension.
	TypeName *string `min:"10" type:"string"`

	// The ID of a specific version of the extension. The version ID is the value
	// at the end of the Amazon Resource Name (ARN) assigned to the extension version
	// when it's registered.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TypeVersionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TypeVersionSummary) SetArn(v string) *TypeVersionSummary {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TypeVersionSummary) SetDescription(v string) *TypeVersionSummary {
	s.Description = &v
	return s
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *TypeVersionSummary) SetIsDefaultVersion(v bool) *TypeVersionSummary {
	s.IsDefaultVersion = &v
	return s
}

// SetPublicVersionNumber sets the PublicVersionNumber field's value.
func (s *TypeVersionSummary) SetPublicVersionNumber(v string) *TypeVersionSummary {
	s.PublicVersionNumber = &v
	return s
}

// SetTimeCreated sets the TimeCreated field's value.
func (s *TypeVersionSummary) SetTimeCreated(v time.Time) *TypeVersionSummary {
	s.TimeCreated = &v
	return s
}

// SetType sets the Type field's value.
func (s *TypeVersionSummary) SetType(v string) *TypeVersionSummary {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *TypeVersionSummary) SetTypeName(v string) *TypeVersionSummary {
	s.TypeName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *TypeVersionSummary) SetVersionId(v string) *TypeVersionSummary {
	s.VersionId = &v
	return s
}

type UpdateGeneratedTemplateInput struct {
	_ struct{} `type:"structure"`

	// An optional list of resources to be added to the generated template.
	AddResources []*ResourceDefinition `min:"1" type:"list"`

	// The name or Amazon Resource Name (ARN) of a generated template.
	//
	// GeneratedTemplateName is a required field
	GeneratedTemplateName *string `min:"1" type:"string" required:"true"`

	// An optional new name to assign to the generated template.
	NewGeneratedTemplateName *string `min:"1" type:"string"`

	// If true, update the resource properties in the generated template with their
	// current live state. This feature is useful when the resource properties in
	// your generated a template does not reflect the live state of the resource
	// properties. This happens when a user update the resource properties after
	// generating a template.
	RefreshAllResources *bool `type:"boolean"`

	// A list of logical ids for resources to remove from the generated template.
	RemoveResources []*string `min:"1" type:"list"`

	// The configuration details of the generated template, including the DeletionPolicy
	// and UpdateReplacePolicy.
	TemplateConfiguration *TemplateConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGeneratedTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGeneratedTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateG