// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Package arch provides architecture specific Linux constants like the audit
// arch constant and syscall tables.
package arch

//go:generate sh -c "head -n 17 doc.go >  zarches.go"
//go:generate sh -c "go tool cgo -godefs defs_arches_linux.go >> zarches.go"
//go:generate sh -c "perl -p -i -e 's/DO NOT EDIT$/DO NOT EDIT./' zarches.go"
//go:generate sh -c "perl -p -i -e 's|// Created by |// Code generated by |' zarches.go"
//go:generate sh -c "perl -p -i -e 's|(// cgo -godefs).*go-seccomp-bpf/arch/(.*)$|\\1 \\2|' zarches.go"
//go:generate go run mk_syscalls_linux.go
//go:generate go fmt .
