// Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
// or more contributor license agreements. Licensed under the Elastic License;
// you may not use this file except in compliance with the Elastic License.

// This file defines unimplemented gRPC services that are likely to be implemented in the future.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.20.1
// source: elastic-agent-client-future.proto

package proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of transaction to start.
type StoreTxType int32

const (
	StoreTxType_READ_ONLY  StoreTxType = 0
	StoreTxType_READ_WRITE StoreTxType = 1
)

// Enum value maps for StoreTxType.
var (
	StoreTxType_name = map[int32]string{
		0: "READ_ONLY",
		1: "READ_WRITE",
	}
	StoreTxType_value = map[string]int32{
		"READ_ONLY":  0,
		"READ_WRITE": 1,
	}
)

func (x StoreTxType) Enum() *StoreTxType {
	p := new(StoreTxType)
	*p = x
	return p
}

func (x StoreTxType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StoreTxType) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_future_proto_enumTypes[0].Descriptor()
}

func (StoreTxType) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_future_proto_enumTypes[0]
}

func (x StoreTxType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StoreTxType.Descriptor instead.
func (StoreTxType) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{0}
}

// Status result of the get.
type StoreGetKeyResponse_Status int32

const (
	// Action was successful.
	StoreGetKeyResponse_FOUND StoreGetKeyResponse_Status = 0
	// Action has failed.
	StoreGetKeyResponse_NOT_FOUND StoreGetKeyResponse_Status = 1
)

// Enum value maps for StoreGetKeyResponse_Status.
var (
	StoreGetKeyResponse_Status_name = map[int32]string{
		0: "FOUND",
		1: "NOT_FOUND",
	}
	StoreGetKeyResponse_Status_value = map[string]int32{
		"FOUND":     0,
		"NOT_FOUND": 1,
	}
)

func (x StoreGetKeyResponse_Status) Enum() *StoreGetKeyResponse_Status {
	p := new(StoreGetKeyResponse_Status)
	*p = x
	return p
}

func (x StoreGetKeyResponse_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StoreGetKeyResponse_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_future_proto_enumTypes[1].Descriptor()
}

func (StoreGetKeyResponse_Status) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_future_proto_enumTypes[1]
}

func (x StoreGetKeyResponse_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StoreGetKeyResponse_Status.Descriptor instead.
func (StoreGetKeyResponse_Status) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{3, 0}
}

// Begins a new transaction.
//
// A started transaction must either have commit or discard called.
type StoreBeginTxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the connection to the Elastic Agent.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// ID of the unit.
	UnitId string `protobuf:"bytes,2,opt,name=unit_id,json=unitId,proto3" json:"unit_id,omitempty"`
	// Type of the unit.
	UnitType UnitType `protobuf:"varint,3,opt,name=unit_type,json=unitType,proto3,enum=proto.UnitType" json:"unit_type,omitempty"`
	// Type of transaction to start.
	Type StoreTxType `protobuf:"varint,4,opt,name=type,proto3,enum=proto.StoreTxType" json:"type,omitempty"`
}

func (x *StoreBeginTxRequest) Reset() {
	*x = StoreBeginTxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreBeginTxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreBeginTxRequest) ProtoMessage() {}

func (x *StoreBeginTxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreBeginTxRequest.ProtoReflect.Descriptor instead.
func (*StoreBeginTxRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{0}
}

func (x *StoreBeginTxRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *StoreBeginTxRequest) GetUnitId() string {
	if x != nil {
		return x.UnitId
	}
	return ""
}

func (x *StoreBeginTxRequest) GetUnitType() UnitType {
	if x != nil {
		return x.UnitType
	}
	return UnitType_INPUT
}

func (x *StoreBeginTxRequest) GetType() StoreTxType {
	if x != nil {
		return x.Type
	}
	return StoreTxType_READ_ONLY
}

// Response for a started transaction.
type StoreBeginTxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transaction ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *StoreBeginTxResponse) Reset() {
	*x = StoreBeginTxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreBeginTxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreBeginTxResponse) ProtoMessage() {}

func (x *StoreBeginTxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreBeginTxResponse.ProtoReflect.Descriptor instead.
func (*StoreBeginTxResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{1}
}

func (x *StoreBeginTxResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Gets a key from the store.
type StoreGetKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the connection to the Elastic Agent.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Transaction ID.
	TxId string `protobuf:"bytes,2,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
	// Name of the key.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StoreGetKeyRequest) Reset() {
	*x = StoreGetKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreGetKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreGetKeyRequest) ProtoMessage() {}

func (x *StoreGetKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreGetKeyRequest.ProtoReflect.Descriptor instead.
func (*StoreGetKeyRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{2}
}

func (x *StoreGetKeyRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *StoreGetKeyRequest) GetTxId() string {
	if x != nil {
		return x.TxId
	}
	return ""
}

func (x *StoreGetKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response of the retrieved key.
type StoreGetKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status StoreGetKeyResponse_Status `protobuf:"varint,1,opt,name=status,proto3,enum=proto.StoreGetKeyResponse_Status" json:"status,omitempty"`
	// Value when `FOUND`.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *StoreGetKeyResponse) Reset() {
	*x = StoreGetKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreGetKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreGetKeyResponse) ProtoMessage() {}

func (x *StoreGetKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreGetKeyResponse.ProtoReflect.Descriptor instead.
func (*StoreGetKeyResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{3}
}

func (x *StoreGetKeyResponse) GetStatus() StoreGetKeyResponse_Status {
	if x != nil {
		return x.Status
	}
	return StoreGetKeyResponse_FOUND
}

func (x *StoreGetKeyResponse) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// Sets a key into the store.
//
// `tx_id` must be an ID of a transaction that was started with `READ_WRITE`.
type StoreSetKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the connection to the Elastic Agent.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Transaction ID.
	TxId string `protobuf:"bytes,2,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
	// Name of the key.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Value of the key.
	Value []byte `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	// TTL of the key (in milliseconds)
	Ttl uint64 `protobuf:"varint,5,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (x *StoreSetKeyRequest) Reset() {
	*x = StoreSetKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreSetKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreSetKeyRequest) ProtoMessage() {}

func (x *StoreSetKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreSetKeyRequest.ProtoReflect.Descriptor instead.
func (*StoreSetKeyRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{4}
}

func (x *StoreSetKeyRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *StoreSetKeyRequest) GetTxId() string {
	if x != nil {
		return x.TxId
	}
	return ""
}

func (x *StoreSetKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StoreSetKeyRequest) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *StoreSetKeyRequest) GetTtl() uint64 {
	if x != nil {
		return x.Ttl
	}
	return 0
}

// Response from `SetKey`.
type StoreSetKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StoreSetKeyResponse) Reset() {
	*x = StoreSetKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreSetKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreSetKeyResponse) ProtoMessage() {}

func (x *StoreSetKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreSetKeyResponse.ProtoReflect.Descriptor instead.
func (*StoreSetKeyResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{5}
}

// Deletes a key in the store.
//
// `tx_id` must be an ID of a transaction that was started with `READ_WRITE`.
//
// Does not error in the case that a key does not exist.
type StoreDeleteKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the connection to the Elastic Agent.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Transaction ID.
	TxId string `protobuf:"bytes,2,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
	// Name of the key.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StoreDeleteKeyRequest) Reset() {
	*x = StoreDeleteKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreDeleteKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreDeleteKeyRequest) ProtoMessage() {}

func (x *StoreDeleteKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreDeleteKeyRequest.ProtoReflect.Descriptor instead.
func (*StoreDeleteKeyRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{6}
}

func (x *StoreDeleteKeyRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *StoreDeleteKeyRequest) GetTxId() string {
	if x != nil {
		return x.TxId
	}
	return ""
}

func (x *StoreDeleteKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response from `DeleteKey`.
type StoreDeleteKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StoreDeleteKeyResponse) Reset() {
	*x = StoreDeleteKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreDeleteKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreDeleteKeyResponse) ProtoMessage() {}

func (x *StoreDeleteKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreDeleteKeyResponse.ProtoReflect.Descriptor instead.
func (*StoreDeleteKeyResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{7}
}

// Commits the transaction in the store.
//
// Upon error the whole transaction is discarded so no need to call discard after error.
type StoreCommitTxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the connection to the Elastic Agent.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Transaction ID.
	TxId string `protobuf:"bytes,2,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
}

func (x *StoreCommitTxRequest) Reset() {
	*x = StoreCommitTxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreCommitTxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreCommitTxRequest) ProtoMessage() {}

func (x *StoreCommitTxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreCommitTxRequest.ProtoReflect.Descriptor instead.
func (*StoreCommitTxRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{8}
}

func (x *StoreCommitTxRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *StoreCommitTxRequest) GetTxId() string {
	if x != nil {
		return x.TxId
	}
	return ""
}

// Response from `CommitTx`.
type StoreCommitTxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StoreCommitTxResponse) Reset() {
	*x = StoreCommitTxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreCommitTxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreCommitTxResponse) ProtoMessage() {}

func (x *StoreCommitTxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreCommitTxResponse.ProtoReflect.Descriptor instead.
func (*StoreCommitTxResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{9}
}

// Discards the transaction in the store.
type StoreDiscardTxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the connection to the Elastic Agent.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Transaction ID.
	TxId string `protobuf:"bytes,2,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
}

func (x *StoreDiscardTxRequest) Reset() {
	*x = StoreDiscardTxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreDiscardTxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreDiscardTxRequest) ProtoMessage() {}

func (x *StoreDiscardTxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreDiscardTxRequest.ProtoReflect.Descriptor instead.
func (*StoreDiscardTxRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{10}
}

func (x *StoreDiscardTxRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *StoreDiscardTxRequest) GetTxId() string {
	if x != nil {
		return x.TxId
	}
	return ""
}

// Response from `DiscardTx`.
type StoreDiscardTxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StoreDiscardTxResponse) Reset() {
	*x = StoreDiscardTxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreDiscardTxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreDiscardTxResponse) ProtoMessage() {}

func (x *StoreDiscardTxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreDiscardTxResponse.ProtoReflect.Descriptor instead.
func (*StoreDiscardTxResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{11}
}

// Requests an artifact from the Elastic Agent.
type ArtifactFetchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the collection of inputs to the agent. When started this is provided
	// in the `ConnInfo`.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// ID of the artifact.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// SHA256 of the artifact.
	Sha256 string `protobuf:"bytes,3,opt,name=sha256,proto3" json:"sha256,omitempty"`
}

func (x *ArtifactFetchRequest) Reset() {
	*x = ArtifactFetchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactFetchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactFetchRequest) ProtoMessage() {}

func (x *ArtifactFetchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactFetchRequest.ProtoReflect.Descriptor instead.
func (*ArtifactFetchRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{12}
}

func (x *ArtifactFetchRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ArtifactFetchRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ArtifactFetchRequest) GetSha256() string {
	if x != nil {
		return x.Sha256
	}
	return ""
}

// Content of the artifact.
type ArtifactFetchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ContentEof:
	//
	//	*ArtifactFetchResponse_Content
	//	*ArtifactFetchResponse_Eof
	ContentEof isArtifactFetchResponse_ContentEof `protobuf_oneof:"content_eof"`
}

func (x *ArtifactFetchResponse) Reset() {
	*x = ArtifactFetchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactFetchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactFetchResponse) ProtoMessage() {}

func (x *ArtifactFetchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactFetchResponse.ProtoReflect.Descriptor instead.
func (*ArtifactFetchResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{13}
}

func (m *ArtifactFetchResponse) GetContentEof() isArtifactFetchResponse_ContentEof {
	if m != nil {
		return m.ContentEof
	}
	return nil
}

func (x *ArtifactFetchResponse) GetContent() []byte {
	if x, ok := x.GetContentEof().(*ArtifactFetchResponse_Content); ok {
		return x.Content
	}
	return nil
}

func (x *ArtifactFetchResponse) GetEof() *emptypb.Empty {
	if x, ok := x.GetContentEof().(*ArtifactFetchResponse_Eof); ok {
		return x.Eof
	}
	return nil
}

type isArtifactFetchResponse_ContentEof interface {
	isArtifactFetchResponse_ContentEof()
}

type ArtifactFetchResponse_Content struct {
	// Artifact content.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

type ArtifactFetchResponse_Eof struct {
	// End-of-file.
	Eof *emptypb.Empty `protobuf:"bytes,2,opt,name=eof,proto3,oneof"`
}

func (*ArtifactFetchResponse_Content) isArtifactFetchResponse_ContentEof() {}

func (*ArtifactFetchResponse_Eof) isArtifactFetchResponse_ContentEof() {}

type LogMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the unit.
	UnitId string `protobuf:"bytes,1,opt,name=unit_id,json=unitId,proto3" json:"unit_id,omitempty"`
	// Type of the unit.
	UnitType UnitType `protobuf:"varint,2,opt,name=unit_type,json=unitType,proto3,enum=proto.UnitType" json:"unit_type,omitempty"`
	// ECS log message body JSON encoded.
	Message []byte `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *LogMessage) Reset() {
	*x = LogMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMessage) ProtoMessage() {}

func (x *LogMessage) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMessage.ProtoReflect.Descriptor instead.
func (*LogMessage) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{14}
}

func (x *LogMessage) GetUnitId() string {
	if x != nil {
		return x.UnitId
	}
	return ""
}

func (x *LogMessage) GetUnitType() UnitType {
	if x != nil {
		return x.UnitType
	}
	return UnitType_INPUT
}

func (x *LogMessage) GetMessage() []byte {
	if x != nil {
		return x.Message
	}
	return nil
}

type LogMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the connection to the Elastic Agent.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Multiple message to report at the same time.
	Messages []*LogMessage `protobuf:"bytes,2,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (x *LogMessageRequest) Reset() {
	*x = LogMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMessageRequest) ProtoMessage() {}

func (x *LogMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMessageRequest.ProtoReflect.Descriptor instead.
func (*LogMessageRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{15}
}

func (x *LogMessageRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *LogMessageRequest) GetMessages() []*LogMessage {
	if x != nil {
		return x.Messages
	}
	return nil
}

type LogMessageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LogMessageResponse) Reset() {
	*x = LogMessageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_future_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMessageResponse) ProtoMessage() {}

func (x *LogMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_future_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMessageResponse.ProtoReflect.Descriptor instead.
func (*LogMessageResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_future_proto_rawDescGZIP(), []int{16}
}

var File_elastic_agent_client_future_proto protoreflect.FileDescriptor

var file_elastic_agent_client_future_proto_rawDesc = []byte{
	0x0a, 0x21, 0x65, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x2d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2d,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2d, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x05, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x65, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63,
	0x2d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x9a, 0x01, 0x0a, 0x13, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x65, 0x67,
	0x69, 0x6e, 0x54, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x75, 0x6e, 0x69, 0x74, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x09, 0x75, 0x6e,
	0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08,
	0x75, 0x6e, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x54, 0x78, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0x26, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x78,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x53, 0x0a, 0x12, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x13, 0x0a, 0x05, 0x74, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x78, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x01,
	0x0a, 0x13, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x22, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x09, 0x0a, 0x05, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e,
	0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x01, 0x22, 0x7b, 0x0a, 0x12, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x53, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x13, 0x0a, 0x05, 0x74, 0x78, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x78, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x22, 0x15, 0x0a, 0x13, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x53, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56,
	0x0a, 0x15, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x13, 0x0a,
	0x05, 0x74, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x78,
	0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x18, 0x0a, 0x16, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x41, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54,
	0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x13,
	0x0a, 0x05, 0x74, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x78, 0x49, 0x64, 0x22, 0x17, 0x0a, 0x15, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x54, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x0a, 0x15,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x54, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x13, 0x0a, 0x05, 0x74,
	0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x78, 0x49, 0x64,
	0x22, 0x18, 0x0a, 0x16, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64,
	0x54, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x0a, 0x14, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x32,
	0x35, 0x36, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36,
	0x22, 0x6e, 0x0a, 0x15, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x03, 0x65, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x03, 0x65, 0x6f,
	0x66, 0x42, 0x0d, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6f, 0x66,
	0x22, 0x6d, 0x0a, 0x0a, 0x4c, 0x6f, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17,
	0x0a, 0x07, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x75, 0x6e, 0x69, 0x74, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x09, 0x75, 0x6e, 0x69, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x75, 0x6e, 0x69,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x58, 0x0a, 0x11, 0x4c, 0x6f, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x08, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x6f, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0x14, 0x0a, 0x12, 0x4c, 0x6f, 0x67,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a,
	0x2c, 0x0a, 0x0b, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x78, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0d,
	0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x00, 0x12, 0x0e, 0x0a,
	0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x01, 0x32, 0xb4, 0x03,
	0x0a, 0x11, 0x45, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x78, 0x12, 0x1a,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x65, 0x67, 0x69,
	0x6e, 0x54, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x78, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4b, 0x65,
	0x79, 0x12, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x47,
	0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x53, 0x65, 0x74, 0x4b,
	0x65, 0x79, 0x12, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x53, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x74, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x09, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x78, 0x12,
	0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x54, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x54, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x09, 0x44, 0x69,
	0x73, 0x63, 0x61, 0x72, 0x64, 0x54, 0x78, 0x12, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x54, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x54, 0x78, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x32, 0x5c, 0x0a, 0x14, 0x45, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x44, 0x0a, 0x05,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x12, 0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x30, 0x01, 0x32, 0x4d, 0x0a, 0x0f, 0x45, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x12, 0x3a, 0x0a, 0x03, 0x4c, 0x6f, 0x67, 0x12, 0x18, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x6f, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4c,
	0x6f, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x42, 0x14, 0x5a, 0x0f, 0x70, 0x6b, 0x67, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x3b, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_elastic_agent_client_future_proto_rawDescOnce sync.Once
	file_elastic_agent_client_future_proto_rawDescData = file_elastic_agent_client_future_proto_rawDesc
)

func file_elastic_agent_client_future_proto_rawDescGZIP() []byte {
	file_elastic_agent_client_future_proto_rawDescOnce.Do(func() {
		file_elastic_agent_client_future_proto_rawDescData = protoimpl.X.CompressGZIP(file_elastic_agent_client_future_proto_rawDescData)
	})
	return file_elastic_agent_client_future_proto_rawDescData
}

var file_elastic_agent_client_future_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_elastic_agent_client_future_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_elastic_agent_client_future_proto_goTypes = []interface{}{
	(StoreTxType)(0),                // 0: proto.StoreTxType
	(StoreGetKeyResponse_Status)(0), // 1: proto.StoreGetKeyResponse.Status
	(*StoreBeginTxRequest)(nil),     // 2: proto.StoreBeginTxRequest
	(*StoreBeginTxResponse)(nil),    // 3: proto.StoreBeginTxResponse
	(*StoreGetKeyRequest)(nil),      // 4: proto.StoreGetKeyRequest
	(*StoreGetKeyResponse)(nil),     // 5: proto.StoreGetKeyResponse
	(*StoreSetKeyRequest)(nil),      // 6: proto.StoreSetKeyRequest
	(*StoreSetKeyResponse)(nil),     // 7: proto.StoreSetKeyResponse
	(*StoreDeleteKeyRequest)(nil),   // 8: proto.StoreDeleteKeyRequest
	(*StoreDeleteKeyResponse)(nil),  // 9: proto.StoreDeleteKeyResponse
	(*StoreCommitTxRequest)(nil),    // 10: proto.StoreCommitTxRequest
	(*StoreCommitTxResponse)(nil),   // 11: proto.StoreCommitTxResponse
	(*StoreDiscardTxRequest)(nil),   // 12: proto.StoreDiscardTxRequest
	(*StoreDiscardTxResponse)(nil),  // 13: proto.StoreDiscardTxResponse
	(*ArtifactFetchRequest)(nil),    // 14: proto.ArtifactFetchRequest
	(*ArtifactFetchResponse)(nil),   // 15: proto.ArtifactFetchResponse
	(*LogMessage)(nil),              // 16: proto.LogMessage
	(*LogMessageRequest)(nil),       // 17: proto.LogMessageRequest
	(*LogMessageResponse)(nil),      // 18: proto.LogMessageResponse
	(UnitType)(0),                   // 19: proto.UnitType
	(*emptypb.Empty)(nil),           // 20: google.protobuf.Empty
}
var file_elastic_agent_client_future_proto_depIdxs = []int32{
	19, // 0: proto.StoreBeginTxRequest.unit_type:type_name -> proto.UnitType
	0,  // 1: proto.StoreBeginTxRequest.type:type_name -> proto.StoreTxType
	1,  // 2: proto.StoreGetKeyResponse.status:type_name -> proto.StoreGetKeyResponse.Status
	20, // 3: proto.ArtifactFetchResponse.eof:type_name -> google.protobuf.Empty
	19, // 4: proto.LogMessage.unit_type:type_name -> proto.UnitType
	16, // 5: proto.LogMessageRequest.messages:type_name -> proto.LogMessage
	2,  // 6: proto.ElasticAgentStore.BeginTx:input_type -> proto.StoreBeginTxRequest
	4,  // 7: proto.ElasticAgentStore.GetKey:input_type -> proto.StoreGetKeyRequest
	6,  // 8: proto.ElasticAgentStore.SetKey:input_type -> proto.StoreSetKeyRequest
	8,  // 9: proto.ElasticAgentStore.DeleteKey:input_type -> proto.StoreDeleteKeyRequest
	10, // 10: proto.ElasticAgentStore.CommitTx:input_type -> proto.StoreCommitTxRequest
	12, // 11: proto.ElasticAgentStore.DiscardTx:input_type -> proto.StoreDiscardTxRequest
	14, // 12: proto.ElasticAgentArtifact.Fetch:input_type -> proto.ArtifactFetchRequest
	17, // 13: proto.ElasticAgentLog.Log:input_type -> proto.LogMessageRequest
	3,  // 14: proto.ElasticAgentStore.BeginTx:output_type -> proto.StoreBeginTxResponse
	5,  // 15: proto.ElasticAgentStore.GetKey:output_type -> proto.StoreGetKeyResponse
	7,  // 16: proto.ElasticAgentStore.SetKey:output_type -> proto.StoreSetKeyResponse
	9,  // 17: proto.ElasticAgentStore.DeleteKey:output_type -> proto.StoreDeleteKeyResponse
	11, // 18: proto.ElasticAgentStore.CommitTx:output_type -> proto.StoreCommitTxResponse
	13, // 19: proto.ElasticAgentStore.DiscardTx:output_type -> proto.StoreDiscardTxResponse
	15, // 20: proto.ElasticAgentArtifact.Fetch:output_type -> proto.ArtifactFetchResponse
	18, // 21: proto.ElasticAgentLog.Log:output_type -> proto.LogMessageResponse
	14, // [14:22] is the sub-list for method output_type
	6,  // [6:14] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_elastic_agent_client_future_proto_init() }
func file_elastic_agent_client_future_proto_init() {
	if File_elastic_agent_client_future_proto != nil {
		return
	}
	file_elastic_agent_client_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_elastic_agent_client_future_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreBeginTxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreBeginTxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreGetKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreGetKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreSetKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreSetKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreDeleteKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreDeleteKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreCommitTxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreCommitTxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreDiscardTxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreDiscardTxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactFetchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactFetchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_future_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogMessageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_elastic_agent_client_future_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*ArtifactFetchResponse_Content)(nil),
		(*ArtifactFetchResponse_Eof)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_elastic_agent_client_future_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   3,
		},
		GoTypes:           file_elastic_agent_client_future_proto_goTypes,
		DependencyIndexes: file_elastic_agent_client_future_proto_depIdxs,
		EnumInfos:         file_elastic_agent_client_future_proto_enumTypes,
		MessageInfos:      file_elastic_agent_client_future_proto_msgTypes,
	}.Build()
	File_elastic_agent_client_future_proto = out.File
	file_elastic_agent_client_future_proto_rawDesc = nil
	file_elastic_agent_client_future_proto_goTypes = nil
	file_elastic_agent_client_future_proto_depIdxs = nil
}
