// Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
// or more contributor license agreements. Licensed under the Elastic License;
// you may not use this file except in compliance with the Elastic License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.20.1
// source: elastic-agent-client-future.proto

package proto

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// ElasticAgentStoreClient is the client API for ElasticAgentStore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ElasticAgentStoreClient interface {
	// Key-Value state storage is provided for each unit.
	//
	// Transactional store is provided to allow multiple key operations to occur before a commit to ensure consistent
	// state when multiple keys make up the state of an units persistent state.
	BeginTx(ctx context.Context, in *StoreBeginTxRequest, opts ...grpc.CallOption) (*StoreBeginTxResponse, error)
	GetKey(ctx context.Context, in *StoreGetKeyRequest, opts ...grpc.CallOption) (*StoreGetKeyResponse, error)
	SetKey(ctx context.Context, in *StoreSetKeyRequest, opts ...grpc.CallOption) (*StoreSetKeyResponse, error)
	DeleteKey(ctx context.Context, in *StoreDeleteKeyRequest, opts ...grpc.CallOption) (*StoreDeleteKeyResponse, error)
	CommitTx(ctx context.Context, in *StoreCommitTxRequest, opts ...grpc.CallOption) (*StoreCommitTxResponse, error)
	DiscardTx(ctx context.Context, in *StoreDiscardTxRequest, opts ...grpc.CallOption) (*StoreDiscardTxResponse, error)
}

type elasticAgentStoreClient struct {
	cc grpc.ClientConnInterface
}

func NewElasticAgentStoreClient(cc grpc.ClientConnInterface) ElasticAgentStoreClient {
	return &elasticAgentStoreClient{cc}
}

func (c *elasticAgentStoreClient) BeginTx(ctx context.Context, in *StoreBeginTxRequest, opts ...grpc.CallOption) (*StoreBeginTxResponse, error) {
	out := new(StoreBeginTxResponse)
	err := c.cc.Invoke(ctx, "/proto.ElasticAgentStore/BeginTx", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *elasticAgentStoreClient) GetKey(ctx context.Context, in *StoreGetKeyRequest, opts ...grpc.CallOption) (*StoreGetKeyResponse, error) {
	out := new(StoreGetKeyResponse)
	err := c.cc.Invoke(ctx, "/proto.ElasticAgentStore/GetKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *elasticAgentStoreClient) SetKey(ctx context.Context, in *StoreSetKeyRequest, opts ...grpc.CallOption) (*StoreSetKeyResponse, error) {
	out := new(StoreSetKeyResponse)
	err := c.cc.Invoke(ctx, "/proto.ElasticAgentStore/SetKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *elasticAgentStoreClient) DeleteKey(ctx context.Context, in *StoreDeleteKeyRequest, opts ...grpc.CallOption) (*StoreDeleteKeyResponse, error) {
	out := new(StoreDeleteKeyResponse)
	err := c.cc.Invoke(ctx, "/proto.ElasticAgentStore/DeleteKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *elasticAgentStoreClient) CommitTx(ctx context.Context, in *StoreCommitTxRequest, opts ...grpc.CallOption) (*StoreCommitTxResponse, error) {
	out := new(StoreCommitTxResponse)
	err := c.cc.Invoke(ctx, "/proto.ElasticAgentStore/CommitTx", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *elasticAgentStoreClient) DiscardTx(ctx context.Context, in *StoreDiscardTxRequest, opts ...grpc.CallOption) (*StoreDiscardTxResponse, error) {
	out := new(StoreDiscardTxResponse)
	err := c.cc.Invoke(ctx, "/proto.ElasticAgentStore/DiscardTx", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ElasticAgentStoreServer is the server API for ElasticAgentStore service.
// All implementations must embed UnimplementedElasticAgentStoreServer
// for forward compatibility
type ElasticAgentStoreServer interface {
	// Key-Value state storage is provided for each unit.
	//
	// Transactional store is provided to allow multiple key operations to occur before a commit to ensure consistent
	// state when multiple keys make up the state of an units persistent state.
	BeginTx(context.Context, *StoreBeginTxRequest) (*StoreBeginTxResponse, error)
	GetKey(context.Context, *StoreGetKeyRequest) (*StoreGetKeyResponse, error)
	SetKey(context.Context, *StoreSetKeyRequest) (*StoreSetKeyResponse, error)
	DeleteKey(context.Context, *StoreDeleteKeyRequest) (*StoreDeleteKeyResponse, error)
	CommitTx(context.Context, *StoreCommitTxRequest) (*StoreCommitTxResponse, error)
	DiscardTx(context.Context, *StoreDiscardTxRequest) (*StoreDiscardTxResponse, error)
	mustEmbedUnimplementedElasticAgentStoreServer()
}

// UnimplementedElasticAgentStoreServer must be embedded to have forward compatible implementations.
type UnimplementedElasticAgentStoreServer struct {
}

func (UnimplementedElasticAgentStoreServer) BeginTx(context.Context, *StoreBeginTxRequest) (*StoreBeginTxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BeginTx not implemented")
}
func (UnimplementedElasticAgentStoreServer) GetKey(context.Context, *StoreGetKeyRequest) (*StoreGetKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKey not implemented")
}
func (UnimplementedElasticAgentStoreServer) SetKey(context.Context, *StoreSetKeyRequest) (*StoreSetKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetKey not implemented")
}
func (UnimplementedElasticAgentStoreServer) DeleteKey(context.Context, *StoreDeleteKeyRequest) (*StoreDeleteKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKey not implemented")
}
func (UnimplementedElasticAgentStoreServer) CommitTx(context.Context, *StoreCommitTxRequest) (*StoreCommitTxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitTx not implemented")
}
func (UnimplementedElasticAgentStoreServer) DiscardTx(context.Context, *StoreDiscardTxRequest) (*StoreDiscardTxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiscardTx not implemented")
}
func (UnimplementedElasticAgentStoreServer) mustEmbedUnimplementedElasticAgentStoreServer() {}

// UnsafeElasticAgentStoreServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ElasticAgentStoreServer will
// result in compilation errors.
type UnsafeElasticAgentStoreServer interface {
	mustEmbedUnimplementedElasticAgentStoreServer()
}

func RegisterElasticAgentStoreServer(s grpc.ServiceRegistrar, srv ElasticAgentStoreServer) {
	s.RegisterService(&ElasticAgentStore_ServiceDesc, srv)
}

func _ElasticAgentStore_BeginTx_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoreBeginTxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ElasticAgentStoreServer).BeginTx(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ElasticAgentStore/BeginTx",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ElasticAgentStoreServer).BeginTx(ctx, req.(*StoreBeginTxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ElasticAgentStore_GetKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoreGetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ElasticAgentStoreServer).GetKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ElasticAgentStore/GetKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ElasticAgentStoreServer).GetKey(ctx, req.(*StoreGetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ElasticAgentStore_SetKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoreSetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ElasticAgentStoreServer).SetKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ElasticAgentStore/SetKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ElasticAgentStoreServer).SetKey(ctx, req.(*StoreSetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ElasticAgentStore_DeleteKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoreDeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ElasticAgentStoreServer).DeleteKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ElasticAgentStore/DeleteKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ElasticAgentStoreServer).DeleteKey(ctx, req.(*StoreDeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ElasticAgentStore_CommitTx_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoreCommitTxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ElasticAgentStoreServer).CommitTx(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ElasticAgentStore/CommitTx",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ElasticAgentStoreServer).CommitTx(ctx, req.(*StoreCommitTxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ElasticAgentStore_DiscardTx_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoreDiscardTxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ElasticAgentStoreServer).DiscardTx(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ElasticAgentStore/DiscardTx",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ElasticAgentStoreServer).DiscardTx(ctx, req.(*StoreDiscardTxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ElasticAgentStore_ServiceDesc is the grpc.ServiceDesc for ElasticAgentStore service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ElasticAgentStore_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "proto.ElasticAgentStore",
	HandlerType: (*ElasticAgentStoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BeginTx",
			Handler:    _ElasticAgentStore_BeginTx_Handler,
		},
		{
			MethodName: "GetKey",
			Handler:    _ElasticAgentStore_GetKey_Handler,
		},
		{
			MethodName: "SetKey",
			Handler:    _ElasticAgentStore_SetKey_Handler,
		},
		{
			MethodName: "DeleteKey",
			Handler:    _ElasticAgentStore_DeleteKey_Handler,
		},
		{
			MethodName: "CommitTx",
			Handler:    _ElasticAgentStore_CommitTx_Handler,
		},
		{
			MethodName: "DiscardTx",
			Handler:    _ElasticAgentStore_DiscardTx_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "elastic-agent-client-future.proto",
}

// ElasticAgentArtifactClient is the client API for ElasticAgentArtifact service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ElasticAgentArtifactClient interface {
	// Fetches an artifact from the artifact store.
	//
	// Response from this call can be chunked over multiple `ArtifactFetchResponse` for very large responses. A minimum
	// of two responses will always be returned. The last response has eof set.
	Fetch(ctx context.Context, in *ArtifactFetchRequest, opts ...grpc.CallOption) (ElasticAgentArtifact_FetchClient, error)
}

type elasticAgentArtifactClient struct {
	cc grpc.ClientConnInterface
}

func NewElasticAgentArtifactClient(cc grpc.ClientConnInterface) ElasticAgentArtifactClient {
	return &elasticAgentArtifactClient{cc}
}

func (c *elasticAgentArtifactClient) Fetch(ctx context.Context, in *ArtifactFetchRequest, opts ...grpc.CallOption) (ElasticAgentArtifact_FetchClient, error) {
	stream, err := c.cc.NewStream(ctx, &ElasticAgentArtifact_ServiceDesc.Streams[0], "/proto.ElasticAgentArtifact/Fetch", opts...)
	if err != nil {
		return nil, err
	}
	x := &elasticAgentArtifactFetchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ElasticAgentArtifact_FetchClient interface {
	Recv() (*ArtifactFetchResponse, error)
	grpc.ClientStream
}

type elasticAgentArtifactFetchClient struct {
	grpc.ClientStream
}

func (x *elasticAgentArtifactFetchClient) Recv() (*ArtifactFetchResponse, error) {
	m := new(ArtifactFetchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ElasticAgentArtifactServer is the server API for ElasticAgentArtifact service.
// All implementations must embed UnimplementedElasticAgentArtifactServer
// for forward compatibility
type ElasticAgentArtifactServer interface {
	// Fetches an artifact from the artifact store.
	//
	// Response from this call can be chunked over multiple `ArtifactFetchResponse` for very large responses. A minimum
	// of two responses will always be returned. The last response has eof set.
	Fetch(*ArtifactFetchRequest, ElasticAgentArtifact_FetchServer) error
	mustEmbedUnimplementedElasticAgentArtifactServer()
}

// UnimplementedElasticAgentArtifactServer must be embedded to have forward compatible implementations.
type UnimplementedElasticAgentArtifactServer struct {
}

func (UnimplementedElasticAgentArtifactServer) Fetch(*ArtifactFetchRequest, ElasticAgentArtifact_FetchServer) error {
	return status.Errorf(codes.Unimplemented, "method Fetch not implemented")
}
func (UnimplementedElasticAgentArtifactServer) mustEmbedUnimplementedElasticAgentArtifactServer() {}

// UnsafeElasticAgentArtifactServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ElasticAgentArtifactServer will
// result in compilation errors.
type UnsafeElasticAgentArtifactServer interface {
	mustEmbedUnimplementedElasticAgentArtifactServer()
}

func RegisterElasticAgentArtifactServer(s grpc.ServiceRegistrar, srv ElasticAgentArtifactServer) {
	s.RegisterService(&ElasticAgentArtifact_ServiceDesc, srv)
}

func _ElasticAgentArtifact_Fetch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ArtifactFetchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ElasticAgentArtifactServer).Fetch(m, &elasticAgentArtifactFetchServer{stream})
}

type ElasticAgentArtifact_FetchServer interface {
	Send(*ArtifactFetchResponse) error
	grpc.ServerStream
}

type elasticAgentArtifactFetchServer struct {
	grpc.ServerStream
}

func (x *elasticAgentArtifactFetchServer) Send(m *ArtifactFetchResponse) error {
	return x.ServerStream.SendMsg(m)
}

// ElasticAgentArtifact_ServiceDesc is the grpc.ServiceDesc for ElasticAgentArtifact service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ElasticAgentArtifact_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "proto.ElasticAgentArtifact",
	HandlerType: (*ElasticAgentArtifactServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Fetch",
			Handler:       _ElasticAgentArtifact_Fetch_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "elastic-agent-client-future.proto",
}

// ElasticAgentLogClient is the client API for ElasticAgentLog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ElasticAgentLogClient interface {
	// Log messages to the Elastic Agent.
	Log(ctx context.Context, in *LogMessageRequest, opts ...grpc.CallOption) (*LogMessageResponse, error)
}

type elasticAgentLogClient struct {
	cc grpc.ClientConnInterface
}

func NewElasticAgentLogClient(cc grpc.ClientConnInterface) ElasticAgentLogClient {
	return &elasticAgentLogClient{cc}
}

func (c *elasticAgentLogClient) Log(ctx context.Context, in *LogMessageRequest, opts ...grpc.CallOption) (*LogMessageResponse, error) {
	out := new(LogMessageResponse)
	err := c.cc.Invoke(ctx, "/proto.ElasticAgentLog/Log", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ElasticAgentLogServer is the server API for ElasticAgentLog service.
// All implementations must embed UnimplementedElasticAgentLogServer
// for forward compatibility
type ElasticAgentLogServer interface {
	// Log messages to the Elastic Agent.
	Log(context.Context, *LogMessageRequest) (*LogMessageResponse, error)
	mustEmbedUnimplementedElasticAgentLogServer()
}

// UnimplementedElasticAgentLogServer must be embedded to have forward compatible implementations.
type UnimplementedElasticAgentLogServer struct {
}

func (UnimplementedElasticAgentLogServer) Log(context.Context, *LogMessageRequest) (*LogMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Log not implemented")
}
func (UnimplementedElasticAgentLogServer) mustEmbedUnimplementedElasticAgentLogServer() {}

// UnsafeElasticAgentLogServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ElasticAgentLogServer will
// result in compilation errors.
type UnsafeElasticAgentLogServer interface {
	mustEmbedUnimplementedElasticAgentLogServer()
}

func RegisterElasticAgentLogServer(s grpc.ServiceRegistrar, srv ElasticAgentLogServer) {
	s.RegisterService(&ElasticAgentLog_ServiceDesc, srv)
}

func _ElasticAgentLog_Log_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ElasticAgentLogServer).Log(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ElasticAgentLog/Log",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ElasticAgentLogServer).Log(ctx, req.(*LogMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ElasticAgentLog_ServiceDesc is the grpc.ServiceDesc for ElasticAgentLog service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ElasticAgentLog_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "proto.ElasticAgentLog",
	HandlerType: (*ElasticAgentLogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Log",
			Handler:    _ElasticAgentLog_Log_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "elastic-agent-client-future.proto",
}
