// Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
// or more contributor license agreements. Licensed under the Elastic License;
// you may not use this file except in compliance with the Elastic License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.20.1
// source: elastic-agent-client.proto

package proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Features that the connection between the client and the server supports.
type ConnectionSupports int32

const (
	// Checkin chunking support.
	ConnectionSupports_CheckinChunking ConnectionSupports = 0
)

// Enum value maps for ConnectionSupports.
var (
	ConnectionSupports_name = map[int32]string{
		0: "CheckinChunking",
	}
	ConnectionSupports_value = map[string]int32{
		"CheckinChunking": 0,
	}
)

func (x ConnectionSupports) Enum() *ConnectionSupports {
	p := new(ConnectionSupports)
	*p = x
	return p
}

func (x ConnectionSupports) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionSupports) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_proto_enumTypes[0].Descriptor()
}

func (ConnectionSupports) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_proto_enumTypes[0]
}

func (x ConnectionSupports) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionSupports.Descriptor instead.
func (ConnectionSupports) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{0}
}

// State codes for the current state.
type State int32

const (
	// STARTING is an optional observed state indicating the unit is doing work to start before
	// transitioning to HEALTHY.
	State_STARTING State = 0
	// CONFIGURING is an optional observed state indicating the unit is started and being configured
	// prior to transitioning to HEALTHY. Typically reported when a units current configuration does
	// not match its expected configuration.
	State_CONFIGURING State = 1
	// HEALTHY is a required observed and expected state. The agent sends an expected state of
	// HEALTHY when a unit should be started and running.
	State_HEALTHY State = 2
	// DEGRADED is an optional observed state indicating the unit experienced a non-fatal error.
	State_DEGRADED State = 3
	// FAILED is an optional observed state indicating the unit experienced a fatal error.
	State_FAILED State = 4
	// STOPPING is an optional observed state indicating the unit is doing the work required to STOP
	// before transitioning to STOPPED.
	State_STOPPING State = 5
	// STOPPED is a required observed and expected state. The agent sends an expected state of
	// STOPPED when a unit should stop running.
	State_STOPPED State = 6
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0: "STARTING",
		1: "CONFIGURING",
		2: "HEALTHY",
		3: "DEGRADED",
		4: "FAILED",
		5: "STOPPING",
		6: "STOPPED",
	}
	State_value = map[string]int32{
		"STARTING":    0,
		"CONFIGURING": 1,
		"HEALTHY":     2,
		"DEGRADED":    3,
		"FAILED":      4,
		"STOPPING":    5,
		"STOPPED":     6,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_proto_enumTypes[1].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_proto_enumTypes[1]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{1}
}

// Type of unit.
type UnitType int32

const (
	UnitType_INPUT  UnitType = 0
	UnitType_OUTPUT UnitType = 1
)

// Enum value maps for UnitType.
var (
	UnitType_name = map[int32]string{
		0: "INPUT",
		1: "OUTPUT",
	}
	UnitType_value = map[string]int32{
		"INPUT":  0,
		"OUTPUT": 1,
	}
)

func (x UnitType) Enum() *UnitType {
	p := new(UnitType)
	*p = x
	return p
}

func (x UnitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UnitType) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_proto_enumTypes[2].Descriptor()
}

func (UnitType) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_proto_enumTypes[2]
}

func (x UnitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UnitType.Descriptor instead.
func (UnitType) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{2}
}

// Log level for the unit.
type UnitLogLevel int32

const (
	UnitLogLevel_ERROR UnitLogLevel = 0
	UnitLogLevel_WARN  UnitLogLevel = 1
	UnitLogLevel_INFO  UnitLogLevel = 2
	UnitLogLevel_DEBUG UnitLogLevel = 3
	UnitLogLevel_TRACE UnitLogLevel = 4
)

// Enum value maps for UnitLogLevel.
var (
	UnitLogLevel_name = map[int32]string{
		0: "ERROR",
		1: "WARN",
		2: "INFO",
		3: "DEBUG",
		4: "TRACE",
	}
	UnitLogLevel_value = map[string]int32{
		"ERROR": 0,
		"WARN":  1,
		"INFO":  2,
		"DEBUG": 3,
		"TRACE": 4,
	}
)

func (x UnitLogLevel) Enum() *UnitLogLevel {
	p := new(UnitLogLevel)
	*p = x
	return p
}

func (x UnitLogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UnitLogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_proto_enumTypes[3].Descriptor()
}

func (UnitLogLevel) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_proto_enumTypes[3]
}

func (x UnitLogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UnitLogLevel.Descriptor instead.
func (UnitLogLevel) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{3}
}

// Services that the client is allowed to use over the connection.
type ConnInfoServices int32

const (
	// V1 checkin service.
	ConnInfoServices_Checkin ConnInfoServices = 0
	// V2 checkin service.
	ConnInfoServices_CheckinV2 ConnInfoServices = 1
	// Key-value store service.
	ConnInfoServices_Store ConnInfoServices = 2
	// Artifact store service.
	ConnInfoServices_Artifact ConnInfoServices = 3
	// Log service.
	ConnInfoServices_Log ConnInfoServices = 4
)

// Enum value maps for ConnInfoServices.
var (
	ConnInfoServices_name = map[int32]string{
		0: "Checkin",
		1: "CheckinV2",
		2: "Store",
		3: "Artifact",
		4: "Log",
	}
	ConnInfoServices_value = map[string]int32{
		"Checkin":   0,
		"CheckinV2": 1,
		"Store":     2,
		"Artifact":  3,
		"Log":       4,
	}
)

func (x ConnInfoServices) Enum() *ConnInfoServices {
	p := new(ConnInfoServices)
	*p = x
	return p
}

func (x ConnInfoServices) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnInfoServices) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_proto_enumTypes[4].Descriptor()
}

func (ConnInfoServices) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_proto_enumTypes[4]
}

func (x ConnInfoServices) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnInfoServices.Descriptor instead.
func (ConnInfoServices) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{4}
}

// Type of action being performed.
type ActionRequest_Type int32

const (
	// Custom action (registered by the unit). Examples include endpoint response actions and OSQuery results.
	ActionRequest_CUSTOM ActionRequest_Type = 0
	// Diagnostics collection action. Implemented by components and units when they wish to
	// include custom information in diagnostics archives. If unimplemented, an ActionResponse
	// with the FAILED status is required.
	ActionRequest_DIAGNOSTICS ActionRequest_Type = 1
)

// Enum value maps for ActionRequest_Type.
var (
	ActionRequest_Type_name = map[int32]string{
		0: "CUSTOM",
		1: "DIAGNOSTICS",
	}
	ActionRequest_Type_value = map[string]int32{
		"CUSTOM":      0,
		"DIAGNOSTICS": 1,
	}
)

func (x ActionRequest_Type) Enum() *ActionRequest_Type {
	p := new(ActionRequest_Type)
	*p = x
	return p
}

func (x ActionRequest_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionRequest_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_proto_enumTypes[5].Descriptor()
}

func (ActionRequest_Type) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_proto_enumTypes[5]
}

func (x ActionRequest_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionRequest_Type.Descriptor instead.
func (ActionRequest_Type) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{18, 0}
}

// The level that the action is operating on.
// Currently only used for diagnostics.
type ActionRequest_Level int32

const (
	// All diagnostics
	ActionRequest_ALL ActionRequest_Level = 0
	// Component level action
	ActionRequest_COMPONENT ActionRequest_Level = 1
	// Unit level action
	ActionRequest_UNIT ActionRequest_Level = 2
)

// Enum value maps for ActionRequest_Level.
var (
	ActionRequest_Level_name = map[int32]string{
		0: "ALL",
		1: "COMPONENT",
		2: "UNIT",
	}
	ActionRequest_Level_value = map[string]int32{
		"ALL":       0,
		"COMPONENT": 1,
		"UNIT":      2,
	}
)

func (x ActionRequest_Level) Enum() *ActionRequest_Level {
	p := new(ActionRequest_Level)
	*p = x
	return p
}

func (x ActionRequest_Level) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionRequest_Level) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_proto_enumTypes[6].Descriptor()
}

func (ActionRequest_Level) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_proto_enumTypes[6]
}

func (x ActionRequest_Level) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionRequest_Level.Descriptor instead.
func (ActionRequest_Level) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{18, 1}
}

// Status result of the action.
type ActionResponse_Status int32

const (
	// Action was successful.
	ActionResponse_SUCCESS ActionResponse_Status = 0
	// Action has failed or is unimplemented.
	ActionResponse_FAILED ActionResponse_Status = 1
)

// Enum value maps for ActionResponse_Status.
var (
	ActionResponse_Status_name = map[int32]string{
		0: "SUCCESS",
		1: "FAILED",
	}
	ActionResponse_Status_value = map[string]int32{
		"SUCCESS": 0,
		"FAILED":  1,
	}
)

func (x ActionResponse_Status) Enum() *ActionResponse_Status {
	p := new(ActionResponse_Status)
	*p = x
	return p
}

func (x ActionResponse_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionResponse_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_elastic_agent_client_proto_enumTypes[7].Descriptor()
}

func (ActionResponse_Status) Type() protoreflect.EnumType {
	return &file_elastic_agent_client_proto_enumTypes[7]
}

func (x ActionResponse_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionResponse_Status.Descriptor instead.
func (ActionResponse_Status) EnumDescriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{20, 0}
}

// Package metadata provided in the meta field of a unit.
type Package struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source is the original configuration of this Package in the agent policy. Only standard
	// fields are defined as explicit types, additional fields can be parsed from source.
	Source *structpb.Struct `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Name of the package.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Version of the package.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Package) Reset() {
	*x = Package{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package) ProtoMessage() {}

func (x *Package) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package.ProtoReflect.Descriptor instead.
func (*Package) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{0}
}

func (x *Package) GetSource() *structpb.Struct {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *Package) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Package) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Metadata provided in the meta field of a unit.
type Meta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source is the original configuration of this Meta object in the agent policy. Only standard
	// fields are defined as explicit types, additional fields can be parsed from source.
	Source *structpb.Struct `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Package metadata.
	Package *Package `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
}

func (x *Meta) Reset() {
	*x = Meta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Meta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Meta) ProtoMessage() {}

func (x *Meta) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Meta.ProtoReflect.Descriptor instead.
func (*Meta) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{1}
}

func (x *Meta) GetSource() *structpb.Struct {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *Meta) GetPackage() *Package {
	if x != nil {
		return x.Package
	}
	return nil
}

// Data stream defined in either top-level unit or in multiple streams in the unit.
type DataStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source is the original configuration of this DataStream object in the agent policy. Only
	// standard fields are defined as explicit types, additional fields can be parsed from source.
	Source *structpb.Struct `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Dataset for the stream.
	Dataset string `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Type for the stream.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Namespace for the stream.
	Namespace string `protobuf:"bytes,4,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (x *DataStream) Reset() {
	*x = DataStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStream) ProtoMessage() {}

func (x *DataStream) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStream.ProtoReflect.Descriptor instead.
func (*DataStream) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{2}
}

func (x *DataStream) GetSource() *structpb.Struct {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *DataStream) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *DataStream) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *DataStream) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

// Stream defined in a configuration.
type Stream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source is the original configuration of this Stream object in the agent policy. Only standard
	// fields are defined as explicit types, additional fields can be parsed from source.
	//
	// This source field will almost always contain arbitrary unit configuration fields beyond those
	// explicitly defined in this message type.
	Source     *structpb.Struct `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	Id         string           `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	DataStream *DataStream      `protobuf:"bytes,3,opt,name=data_stream,json=dataStream,proto3" json:"data_stream,omitempty"`
}

func (x *Stream) Reset() {
	*x = Stream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream) ProtoMessage() {}

func (x *Stream) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream.ProtoReflect.Descriptor instead.
func (*Stream) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{3}
}

func (x *Stream) GetSource() *structpb.Struct {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *Stream) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Stream) GetDataStream() *DataStream {
	if x != nil {
		return x.DataStream
	}
	return nil
}

// A units expected configuration.
type UnitExpectedConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source is the original configuration of this unit configuration object in the agent policy.
	// Only standard fields are defined as explicit types, additional fields can be parsed from source.
	//
	// This source field will almost always contain arbitrary unit configuration fields beyond those
	// explicitly defined in this message type.
	Source *structpb.Struct `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Unique ID for the Unit.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Type of the unit.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Name of the unit.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Revision of the unit.
	Revision uint64 `protobuf:"varint,5,opt,name=revision,proto3" json:"revision,omitempty"`
	// Metadata information of the unit.
	Meta *Meta `protobuf:"bytes,6,opt,name=meta,proto3" json:"meta,omitempty"`
	// Unit-level data stream.
	DataStream *DataStream `protobuf:"bytes,7,opt,name=data_stream,json=dataStream,proto3" json:"data_stream,omitempty"`
	// Multiple streams per unit.
	Streams []*Stream `protobuf:"bytes,8,rep,name=streams,proto3" json:"streams,omitempty"`
}

func (x *UnitExpectedConfig) Reset() {
	*x = UnitExpectedConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnitExpectedConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnitExpectedConfig) ProtoMessage() {}

func (x *UnitExpectedConfig) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnitExpectedConfig.ProtoReflect.Descriptor instead.
func (*UnitExpectedConfig) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{4}
}

func (x *UnitExpectedConfig) GetSource() *structpb.Struct {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *UnitExpectedConfig) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UnitExpectedConfig) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *UnitExpectedConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UnitExpectedConfig) GetRevision() uint64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *UnitExpectedConfig) GetMeta() *Meta {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *UnitExpectedConfig) GetDataStream() *DataStream {
	if x != nil {
		return x.DataStream
	}
	return nil
}

func (x *UnitExpectedConfig) GetStreams() []*Stream {
	if x != nil {
		return x.Streams
	}
	return nil
}

// A unit that is part of a collector/shipper.
type UnitExpected struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID of the unit.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Unit type.
	Type UnitType `protobuf:"varint,2,opt,name=type,proto3,enum=proto.UnitType" json:"type,omitempty"`
	// Expected state of the unit. Will always be one of HEALTHY or STOPPED.
	State State `protobuf:"varint,3,opt,name=state,proto3,enum=proto.State" json:"state,omitempty"`
	// Index or revision of the expected configuration. When the expected configuration changes the
	// agent will increment this number and the UnitExpectedConfig field will be populated.
	ConfigStateIdx uint64 `protobuf:"varint,4,opt,name=config_state_idx,json=configStateIdx,proto3" json:"config_state_idx,omitempty"`
	// Current expected configuration. Omitted if the client reports it has applied the current
	// configuration.
	Config *UnitExpectedConfig `protobuf:"bytes,5,opt,name=config,proto3" json:"config,omitempty"`
	// Log level of the unit.
	LogLevel UnitLogLevel `protobuf:"varint,6,opt,name=log_level,json=logLevel,proto3,enum=proto.UnitLogLevel" json:"log_level,omitempty"`
}

func (x *UnitExpected) Reset() {
	*x = UnitExpected{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnitExpected) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnitExpected) ProtoMessage() {}

func (x *UnitExpected) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnitExpected.ProtoReflect.Descriptor instead.
func (*UnitExpected) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{5}
}

func (x *UnitExpected) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UnitExpected) GetType() UnitType {
	if x != nil {
		return x.Type
	}
	return UnitType_INPUT
}

func (x *UnitExpected) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STARTING
}

func (x *UnitExpected) GetConfigStateIdx() uint64 {
	if x != nil {
		return x.ConfigStateIdx
	}
	return 0
}

func (x *UnitExpected) GetConfig() *UnitExpectedConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *UnitExpected) GetLogLevel() UnitLogLevel {
	if x != nil {
		return x.LogLevel
	}
	return UnitLogLevel_ERROR
}

// Agent information that the component might want to use for its events,
// including the package version, which components should report instead
// of their own version.
//
// Sent on component start up as part of StartUpInfo and on the first checkin
// expected response to the component.
type AgentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID is the Elastic Agent's unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version is the package version of the running Elastic Agent.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Snapshot is true when the running Elastic Agent is a snapshot version.
	Snapshot bool `protobuf:"varint,3,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (x *AgentInfo) Reset() {
	*x = AgentInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentInfo) ProtoMessage() {}

func (x *AgentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentInfo.ProtoReflect.Descriptor instead.
func (*AgentInfo) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{6}
}

func (x *AgentInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AgentInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AgentInfo) GetSnapshot() bool {
	if x != nil {
		return x.Snapshot
	}
	return false
}

// Feature flags configurations.
type Features struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source is the original source of the features. All values from the features
	// are included here even if other concrete fields are defined for this message.
	Source *structpb.Struct `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	Fqdn   *FQDNFeature     `protobuf:"bytes,2,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Features) Reset() {
	*x = Features{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Features) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Features) ProtoMessage() {}

func (x *Features) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Features.ProtoReflect.Descriptor instead.
func (*Features) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{7}
}

func (x *Features) GetSource() *structpb.Struct {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *Features) GetFqdn() *FQDNFeature {
	if x != nil {
		return x.Fqdn
	}
	return nil
}

// FQDN feature flag indicates to use FQDN for host.name instead of hostname.
type FQDNFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *FQDNFeature) Reset() {
	*x = FQDNFeature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FQDNFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FQDNFeature) ProtoMessage() {}

func (x *FQDNFeature) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FQDNFeature.ProtoReflect.Descriptor instead.
func (*FQDNFeature) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{8}
}

func (x *FQDNFeature) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Elastic APM TLS config
type ElasticAPMTLS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SkipVerify bool   `protobuf:"varint,1,opt,name=skip_verify,json=skipVerify,proto3" json:"skip_verify,omitempty"`
	ServerCert string `protobuf:"bytes,2,opt,name=server_cert,json=serverCert,proto3" json:"server_cert,omitempty"`
	ServerCa   string `protobuf:"bytes,3,opt,name=server_ca,json=serverCa,proto3" json:"server_ca,omitempty"`
}

func (x *ElasticAPMTLS) Reset() {
	*x = ElasticAPMTLS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ElasticAPMTLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ElasticAPMTLS) ProtoMessage() {}

func (x *ElasticAPMTLS) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ElasticAPMTLS.ProtoReflect.Descriptor instead.
func (*ElasticAPMTLS) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{9}
}

func (x *ElasticAPMTLS) GetSkipVerify() bool {
	if x != nil {
		return x.SkipVerify
	}
	return false
}

func (x *ElasticAPMTLS) GetServerCert() string {
	if x != nil {
		return x.ServerCert
	}
	return ""
}

func (x *ElasticAPMTLS) GetServerCa() string {
	if x != nil {
		return x.ServerCa
	}
	return ""
}

// Elastic APM configuration
type ElasticAPM struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Tls          *ElasticAPMTLS `protobuf:"bytes,1,opt,name=tls,proto3" json:"tls,omitempty"`
	Environment  string         `protobuf:"bytes,2,opt,name=environment,proto3" json:"environment,omitempty"`
	ApiKey       string         `protobuf:"bytes,3,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	SecretToken  string         `protobuf:"bytes,4,opt,name=secret_token,json=secretToken,proto3" json:"secret_token,omitempty"`
	Hosts        []string       `protobuf:"bytes,5,rep,name=hosts,proto3" json:"hosts,omitempty"`
	GlobalLabels string         `protobuf:"bytes,6,opt,name=global_labels,json=globalLabels,proto3" json:"global_labels,omitempty"`
}

func (x *ElasticAPM) Reset() {
	*x = ElasticAPM{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ElasticAPM) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ElasticAPM) ProtoMessage() {}

func (x *ElasticAPM) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ElasticAPM.ProtoReflect.Descriptor instead.
func (*ElasticAPM) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{10}
}

func (x *ElasticAPM) GetTls() *ElasticAPMTLS {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *ElasticAPM) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *ElasticAPM) GetApiKey() string {
	if x != nil {
		return x.ApiKey
	}
	return ""
}

func (x *ElasticAPM) GetSecretToken() string {
	if x != nil {
		return x.SecretToken
	}
	return ""
}

func (x *ElasticAPM) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *ElasticAPM) GetGlobalLabels() string {
	if x != nil {
		return x.GlobalLabels
	}
	return ""
}

// APM configuration
type APMConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Elastic *ElasticAPM `protobuf:"bytes,1,opt,name=elastic,proto3" json:"elastic,omitempty"`
}

func (x *APMConfig) Reset() {
	*x = APMConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APMConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APMConfig) ProtoMessage() {}

func (x *APMConfig) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APMConfig.ProtoReflect.Descriptor instead.
func (*APMConfig) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{11}
}

func (x *APMConfig) GetElastic() *ElasticAPM {
	if x != nil {
		return x.Elastic
	}
	return nil
}

// Component-level configuration.
type Component struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Limits    *ComponentLimits `protobuf:"bytes,1,opt,name=limits,proto3" json:"limits,omitempty"`
	ApmConfig *APMConfig       `protobuf:"bytes,2,opt,name=apm_config,json=apmConfig,proto3,oneof" json:"apm_config,omitempty"`
}

func (x *Component) Reset() {
	*x = Component{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Component) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Component) ProtoMessage() {}

func (x *Component) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Component.ProtoReflect.Descriptor instead.
func (*Component) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{12}
}

func (x *Component) GetLimits() *ComponentLimits {
	if x != nil {
		return x.Limits
	}
	return nil
}

func (x *Component) GetApmConfig() *APMConfig {
	if x != nil {
		return x.ApmConfig
	}
	return nil
}

// Limits to configure for the currently running component.
type ComponentLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source is the original source of the limits. All values from the limits
	// are included here even if other concrete fields are defined for this message.
	Source *structpb.Struct `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// GoMaxProcs limits the number of operating system threads that can execute user-level Go code simultaneously.
	// Translates into GOMAXPROCS Go runtime setting for the component implemented in Go.
	// Should be ignored by non-Go components.
	// If set to `0` the client should use all the available CPUs.
	GoMaxProcs uint64 `protobuf:"varint,2,opt,name=go_max_procs,json=goMaxProcs,proto3" json:"go_max_procs,omitempty"`
}

func (x *ComponentLimits) Reset() {
	*x = ComponentLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComponentLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComponentLimits) ProtoMessage() {}

func (x *ComponentLimits) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComponentLimits.ProtoReflect.Descriptor instead.
func (*ComponentLimits) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{13}
}

func (x *ComponentLimits) GetSource() *structpb.Struct {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *ComponentLimits) GetGoMaxProcs() uint64 {
	if x != nil {
		return x.GoMaxProcs
	}
	return 0
}

// A set of units and their expected states and configuration.
type CheckinExpected struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Units is the expected units the component should be running. Note that units can be added or
	// removed from this list any time as the agent policy is edited. Units that should be removed
	// will first have their expected state set to STOPPED, and then will be removed from this list
	// once their observed state has also been repoted as STOPPED to allow for graceful shutdown.
	Units []*UnitExpected `protobuf:"bytes,1,rep,name=units,proto3" json:"units,omitempty"`
	// Agent info is provided only on first CheckinExpected response to the component.
	AgentInfo *AgentInfo `protobuf:"bytes,2,opt,name=agent_info,json=agentInfo,proto3" json:"agent_info,omitempty"`
	// Features are the expected feature flags configurations. Can apply to either components or
	// individual units depending on the flag and its implementation. Omitted if the client reports
	// it has applied the current configuration. Added in Elastic Agent v8.7.1.
	Features *Features `protobuf:"bytes,3,opt,name=features,proto3" json:"features,omitempty"`
	// Index or revision of the expected feature flags configuration. When the expected
	// configuration changes the agent will increment this number and the Features field will be
	// populated.
	FeaturesIdx uint64 `protobuf:"varint,4,opt,name=features_idx,json=featuresIdx,proto3" json:"features_idx,omitempty"`
	// Component is the expected component configuration. Contains configuration expected to apply
	// globally to the entire component process. Omitted if the client reports it has applied the
	// current configuration. Added in Elastic Agent v8.10.0.
	Component *Component `protobuf:"bytes,5,opt,name=component,proto3" json:"component,omitempty"`
	// Index or revision of the expected component configuration. When the expected configuration
	// changes the agent will increment this number and the Component field will be populated.
	ComponentIdx uint64 `protobuf:"varint,6,opt,name=component_idx,json=componentIdx,proto3" json:"component_idx,omitempty"`
	// When a units timestamp is provided then the set of units could not all fit inside this single message
	// and it was split across multiple messages. Each message chunk must have the same units timestamp, in
	// the case that the client gets a new message with a different timestamp and its newer than the other
	// timestamp then it should take that new message chunk as a start of a new message set. To finish the a
	// set of messages with the same timestamp, the last chunk should be an empty set of units.
	UnitsTimestamp *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=units_timestamp,json=unitsTimestamp,proto3" json:"units_timestamp,omitempty"`
}

func (x *CheckinExpected) Reset() {
	*x = CheckinExpected{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckinExpected) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckinExpected) ProtoMessage() {}

func (x *CheckinExpected) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckinExpected.ProtoReflect.Descriptor instead.
func (*CheckinExpected) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{14}
}

func (x *CheckinExpected) GetUnits() []*UnitExpected {
	if x != nil {
		return x.Units
	}
	return nil
}

func (x *CheckinExpected) GetAgentInfo() *AgentInfo {
	if x != nil {
		return x.AgentInfo
	}
	return nil
}

func (x *CheckinExpected) GetFeatures() *Features {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *CheckinExpected) GetFeaturesIdx() uint64 {
	if x != nil {
		return x.FeaturesIdx
	}
	return 0
}

func (x *CheckinExpected) GetComponent() *Component {
	if x != nil {
		return x.Component
	}
	return nil
}

func (x *CheckinExpected) GetComponentIdx() uint64 {
	if x != nil {
		return x.ComponentIdx
	}
	return 0
}

func (x *CheckinExpected) GetUnitsTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.UnitsTimestamp
	}
	return nil
}

// Observed status for a unit.
//
// Contains the currently applied `config_state_idx` (0 in the case of initial start, 1 is the first
// applied config index) along with the status of the application. In the case that the sent `config_state_idx`
// doesn't match the expected `config_state_idx` that Elastic Agent expects, the unit is always marked as
// `CONFIGURING` and a new `UnitExpected` will be sent to so it can have the latest configuration.
type UnitObserved struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID of the unit.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Unit type.
	Type UnitType `protobuf:"varint,2,opt,name=type,proto3,enum=proto.UnitType" json:"type,omitempty"`
	// Index or revision of the currently applied configuration.
	ConfigStateIdx uint64 `protobuf:"varint,3,opt,name=config_state_idx,json=configStateIdx,proto3" json:"config_state_idx,omitempty"`
	// Current state of the unit.
	State State `protobuf:"varint,4,opt,name=state,proto3,enum=proto.State" json:"state,omitempty"`
	// Human readable message for the state of the unit.
	// Exposed to users to provide more detail about the state for this single unit.
	Message string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// Payload for the current state.
	Payload *structpb.Struct `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *UnitObserved) Reset() {
	*x = UnitObserved{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnitObserved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnitObserved) ProtoMessage() {}

func (x *UnitObserved) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnitObserved.ProtoReflect.Descriptor instead.
func (*UnitObserved) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{15}
}

func (x *UnitObserved) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UnitObserved) GetType() UnitType {
	if x != nil {
		return x.Type
	}
	return UnitType_INPUT
}

func (x *UnitObserved) GetConfigStateIdx() uint64 {
	if x != nil {
		return x.ConfigStateIdx
	}
	return 0
}

func (x *UnitObserved) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STARTING
}

func (x *UnitObserved) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *UnitObserved) GetPayload() *structpb.Struct {
	if x != nil {
		return x.Payload
	}
	return nil
}

// Observed version information for the running program.
type CheckinObservedVersionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the binary.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Additional metadata about the binary.
	Meta map[string]string `protobuf:"bytes,3,rep,name=meta,proto3" json:"meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// VCS commit hash of the binary.
	BuildHash string `protobuf:"bytes,4,opt,name=build_hash,json=buildHash,proto3" json:"build_hash,omitempty"`
}

func (x *CheckinObservedVersionInfo) Reset() {
	*x = CheckinObservedVersionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckinObservedVersionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckinObservedVersionInfo) ProtoMessage() {}

func (x *CheckinObservedVersionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckinObservedVersionInfo.ProtoReflect.Descriptor instead.
func (*CheckinObservedVersionInfo) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{16}
}

func (x *CheckinObservedVersionInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CheckinObservedVersionInfo) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *CheckinObservedVersionInfo) GetBuildHash() string {
	if x != nil {
		return x.BuildHash
	}
	return ""
}

// Observed statuses and configuration for defined units.
//
// In the case that a unit is missing from the observation then the Elastic Agent will mark that missing unit
// as `STARTING` and send a new `UnitExpected` for the missing unit.
type CheckinObserved struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the connection to the Elastic Agent.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Units observed state.
	Units []*UnitObserved `protobuf:"bytes,2,rep,name=units,proto3" json:"units,omitempty"`
	// Version information about the running program. Should always be included on first checkin, and not again unless
	// one of the values have changed.
	VersionInfo *CheckinObservedVersionInfo `protobuf:"bytes,3,opt,name=version_info,json=versionInfo,proto3,oneof" json:"version_info,omitempty"`
	// Index or revision of the currently feature flags configuration.
	FeaturesIdx uint64 `protobuf:"varint,5,opt,name=features_idx,json=featuresIdx,proto3" json:"features_idx,omitempty"`
	// Index or revision of the currently component configuration.
	ComponentIdx uint64 `protobuf:"varint,6,opt,name=component_idx,json=componentIdx,proto3" json:"component_idx,omitempty"`
	// When a units timestamp is provided then the set of units could not all fit inside this single message
	// and it was split across multiple messages. Each message chunk must have the same units timestamp, in
	// the case that the client gets a new message with a different timestamp and its newer than the other
	// timestamp then it should take that new message chunk as a start of a new message set. To finish the a
	// set of messages with the same timestamp, the last chunk should be an empty set of units.
	UnitsTimestamp *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=units_timestamp,json=unitsTimestamp,proto3" json:"units_timestamp,omitempty"`
	// Supports provides information to the agent about extra features this client supports. Should always be included
	// on first checkin, and not again unless upon reconnect.
	Supports []ConnectionSupports `protobuf:"varint,8,rep,packed,name=supports,proto3,enum=proto.ConnectionSupports" json:"supports,omitempty"`
}

func (x *CheckinObserved) Reset() {
	*x = CheckinObserved{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckinObserved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckinObserved) ProtoMessage() {}

func (x *CheckinObserved) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckinObserved.ProtoReflect.Descriptor instead.
func (*CheckinObserved) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{17}
}

func (x *CheckinObserved) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *CheckinObserved) GetUnits() []*UnitObserved {
	if x != nil {
		return x.Units
	}
	return nil
}

func (x *CheckinObserved) GetVersionInfo() *CheckinObservedVersionInfo {
	if x != nil {
		return x.VersionInfo
	}
	return nil
}

func (x *CheckinObserved) GetFeaturesIdx() uint64 {
	if x != nil {
		return x.FeaturesIdx
	}
	return 0
}

func (x *CheckinObserved) GetComponentIdx() uint64 {
	if x != nil {
		return x.ComponentIdx
	}
	return 0
}

func (x *CheckinObserved) GetUnitsTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.UnitsTimestamp
	}
	return nil
}

func (x *CheckinObserved) GetSupports() []ConnectionSupports {
	if x != nil {
		return x.Supports
	}
	return nil
}

// A action request is streamed from the Elastic Agent to the application so an action can be performed
// by the connected application.
type ActionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID of the action.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the action (name is ignored for DIAGNOSTICS).
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// JSON encoded parameters for the action.
	Params []byte `protobuf:"bytes,3,opt,name=params,proto3" json:"params,omitempty"`
	// Unique ID of the unit (only used with V2).
	UnitId string `protobuf:"bytes,4,opt,name=unit_id,json=unitId,proto3" json:"unit_id,omitempty"`
	// Type of the unit (only used with V2).
	UnitType UnitType `protobuf:"varint,5,opt,name=unit_type,json=unitType,proto3,enum=proto.UnitType" json:"unit_type,omitempty"`
	// Type of action to be performed (only used with V2).
	Type ActionRequest_Type `protobuf:"varint,6,opt,name=type,proto3,enum=proto.ActionRequest_Type" json:"type,omitempty"`
	// Level marks the action as either operating on a component, or a unit.
	// If level=component, then the consumer should ignore the unit_id and unit_type fields.
	Level ActionRequest_Level `protobuf:"varint,7,opt,name=level,proto3,enum=proto.ActionRequest_Level" json:"level,omitempty"`
}

func (x *ActionRequest) Reset() {
	*x = ActionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionRequest) ProtoMessage() {}

func (x *ActionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionRequest.ProtoReflect.Descriptor instead.
func (*ActionRequest) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{18}
}

func (x *ActionRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ActionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ActionRequest) GetParams() []byte {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ActionRequest) GetUnitId() string {
	if x != nil {
		return x.UnitId
	}
	return ""
}

func (x *ActionRequest) GetUnitType() UnitType {
	if x != nil {
		return x.UnitType
	}
	return UnitType_INPUT
}

func (x *ActionRequest) GetType() ActionRequest_Type {
	if x != nil {
		return x.Type
	}
	return ActionRequest_CUSTOM
}

func (x *ActionRequest) GetLevel() ActionRequest_Level {
	if x != nil {
		return x.Level
	}
	return ActionRequest_ALL
}

type ActionDiagnosticUnitResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human readable name of the diagnostic result content.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filename to use to store the diagnostic to the disk.
	Filename string `protobuf:"bytes,2,opt,name=filename,proto3" json:"filename,omitempty"`
	// Human readable description of the information this diagnostic provides.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Content-Type of the resulting content.
	ContentType string `protobuf:"bytes,4,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Actual file content.
	Content []byte `protobuf:"bytes,5,opt,name=content,proto3" json:"content,omitempty"`
	// Timestamp the content was generated at.
	Generated *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=generated,proto3" json:"generated,omitempty"`
}

func (x *ActionDiagnosticUnitResult) Reset() {
	*x = ActionDiagnosticUnitResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionDiagnosticUnitResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionDiagnosticUnitResult) ProtoMessage() {}

func (x *ActionDiagnosticUnitResult) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionDiagnosticUnitResult.ProtoReflect.Descriptor instead.
func (*ActionDiagnosticUnitResult) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{19}
}

func (x *ActionDiagnosticUnitResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ActionDiagnosticUnitResult) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

func (x *ActionDiagnosticUnitResult) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ActionDiagnosticUnitResult) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *ActionDiagnosticUnitResult) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *ActionDiagnosticUnitResult) GetGenerated() *timestamppb.Timestamp {
	if x != nil {
		return x.Generated
	}
	return nil
}

// An action response is streamed from the application back to the Elastic Agent to provide a result to
// an action request.
type ActionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token that is used to uniquely identify the application to agent. When agent started this
	// application it would have provided it this token.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Unique ID of the action.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Status of the action.
	Status ActionResponse_Status `protobuf:"varint,3,opt,name=status,proto3,enum=proto.ActionResponse_Status" json:"status,omitempty"`
	// JSON encoded result for the action (empty when diagnostic action response).
	Result []byte `protobuf:"bytes,4,opt,name=result,proto3" json:"result,omitempty"`
	// Specific result for the diagnostics action.
	Diagnostic []*ActionDiagnosticUnitResult `protobuf:"bytes,5,rep,name=diagnostic,proto3" json:"diagnostic,omitempty"`
}

func (x *ActionResponse) Reset() {
	*x = ActionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionResponse) ProtoMessage() {}

func (x *ActionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionResponse.ProtoReflect.Descriptor instead.
func (*ActionResponse) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{20}
}

func (x *ActionResponse) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ActionResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ActionResponse) GetStatus() ActionResponse_Status {
	if x != nil {
		return x.Status
	}
	return ActionResponse_SUCCESS
}

func (x *ActionResponse) GetResult() []byte {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *ActionResponse) GetDiagnostic() []*ActionDiagnosticUnitResult {
	if x != nil {
		return x.Diagnostic
	}
	return nil
}

// Information sent to component on startup containing the necessary information
// for the component to connect back to the Elastic Agent and the agent details.
//
// This is normally sent through stdin and should never be sent across a network
// un-encrypted.
type StartUpInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// GRPC connection address.
	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	// Server name to use when connecting over TLS.
	ServerName string `protobuf:"bytes,2,opt,name=server_name,json=serverName,proto3" json:"server_name,omitempty"`
	// Token that the application should send as the unique identifier when connecting over the GRPC.
	Token string `protobuf:"bytes,3,opt,name=token,proto3" json:"token,omitempty"`
	// CA certificate.
	CaCert []byte `protobuf:"bytes,4,opt,name=ca_cert,json=caCert,proto3" json:"ca_cert,omitempty"`
	// Peer certificate.
	PeerCert []byte `protobuf:"bytes,5,opt,name=peer_cert,json=peerCert,proto3" json:"peer_cert,omitempty"`
	// Peer private key.
	PeerKey []byte `protobuf:"bytes,6,opt,name=peer_key,json=peerKey,proto3" json:"peer_key,omitempty"`
	// Allowed services that spawned process can use. (only used in V2)
	Services []ConnInfoServices `protobuf:"varint,7,rep,packed,name=services,proto3,enum=proto.ConnInfoServices" json:"services,omitempty"`
	// Supports provides information to the client about extra features this server supports.
	Supports []ConnectionSupports `protobuf:"varint,8,rep,packed,name=supports,proto3,enum=proto.ConnectionSupports" json:"supports,omitempty"`
	// Maximum message size that the client can use (in bytes).
	MaxMessageSize uint32 `protobuf:"varint,9,opt,name=max_message_size,json=maxMessageSize,proto3" json:"max_message_size,omitempty"`
	// Agent information, including the agent package version, which should be
	// presented in user-visible fields and messages instead of the build
	// version of the running component.
	AgentInfo *AgentInfo `protobuf:"bytes,10,opt,name=agent_info,json=agentInfo,proto3" json:"agent_info,omitempty"`
}

func (x *StartUpInfo) Reset() {
	*x = StartUpInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_elastic_agent_client_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartUpInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartUpInfo) ProtoMessage() {}

func (x *StartUpInfo) ProtoReflect() protoreflect.Message {
	mi := &file_elastic_agent_client_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartUpInfo.ProtoReflect.Descriptor instead.
func (*StartUpInfo) Descriptor() ([]byte, []int) {
	return file_elastic_agent_client_proto_rawDescGZIP(), []int{21}
}

func (x *StartUpInfo) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

func (x *StartUpInfo) GetServerName() string {
	if x != nil {
		return x.ServerName
	}
	return ""
}

func (x *StartUpInfo) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *StartUpInfo) GetCaCert() []byte {
	if x != nil {
		return x.CaCert
	}
	return nil
}

func (x *StartUpInfo) GetPeerCert() []byte {
	if x != nil {
		return x.PeerCert
	}
	return nil
}

func (x *StartUpInfo) GetPeerKey() []byte {
	if x != nil {
		return x.PeerKey
	}
	return nil
}

func (x *StartUpInfo) GetServices() []ConnInfoServices {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *StartUpInfo) GetSupports() []ConnectionSupports {
	if x != nil {
		return x.Supports
	}
	return nil
}

func (x *StartUpInfo) GetMaxMessageSize() uint32 {
	if x != nil {
		return x.MaxMessageSize
	}
	return 0
}

func (x *StartUpInfo) GetAgentInfo() *AgentInfo {
	if x != nil {
		return x.AgentInfo
	}
	return nil
}

var File_elastic_agent_client_proto protoreflect.FileDescriptor

var file_elastic_agent_client_proto_rawDesc = []byte{
	0x0a, 0x1a, 0x65, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x2d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2d,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x25, 0x65, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x2d, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2d, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x68, 0x0a, 0x07, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x61, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x07,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x07, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x22, 0x89, 0x01, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x22, 0x7d, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x2f, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x32, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x22, 0x97, 0x02, 0x0a, 0x12, 0x55, 0x6e, 0x69, 0x74, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a,
	0x04, 0x6d, 0x65, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x04, 0x6d, 0x65, 0x74, 0x61, 0x12, 0x32,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x27, 0x0a, 0x07, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x07, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x22, 0xf6, 0x01, 0x0a, 0x0c,
	0x55, 0x6e, 0x69, 0x74, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x22, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x0c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x64, 0x78, 0x12,
	0x31, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x45, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x30, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x55, 0x6e,
	0x69, 0x74, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x22, 0x51, 0x0a, 0x09, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x63, 0x0a, 0x08, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x51, 0x44, 0x4e, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22, 0x27, 0x0a, 0x0b,
	0x46, 0x51, 0x44, 0x4e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x6e, 0x0a, 0x0d, 0x45, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63,
	0x41, 0x50, 0x4d, 0x54, 0x4c, 0x53, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x6b, 0x69,
	0x70, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x63, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x61, 0x22, 0xcd, 0x01, 0x0a, 0x0a, 0x45, 0x6c, 0x61, 0x73, 0x74, 0x69,
	0x63, 0x41, 0x50, 0x4d, 0x12, 0x26, 0x0a, 0x03, 0x74, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x6c, 0x61, 0x73, 0x74, 0x69,
	0x63, 0x41, 0x50, 0x4d, 0x54, 0x4c, 0x53, 0x52, 0x03, 0x74, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17,
	0x0a, 0x07, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x68, 0x6f,
	0x73, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x68, 0x6f, 0x73, 0x74, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0x38, 0x0a, 0x09, 0x41, 0x50, 0x4d, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x2b, 0x0a, 0x07, 0x65, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x6c, 0x61, 0x73,
	0x74, 0x69, 0x63, 0x41, 0x50, 0x4d, 0x52, 0x07, 0x65, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x22,
	0x80, 0x01, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a,
	0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x34, 0x0a,
	0x0a, 0x61, 0x70, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x50, 0x4d, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x09, 0x61, 0x70, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x61, 0x70, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x64, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x67, 0x6f, 0x5f, 0x6d, 0x61, 0x78,
	0x5f, 0x70, 0x72, 0x6f, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x67, 0x6f,
	0x4d, 0x61, 0x78, 0x50, 0x72, 0x6f, 0x63, 0x73, 0x22, 0xd7, 0x02, 0x0a, 0x0f, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x69, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x05,
	0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x52, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x08, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x5f, 0x69, 0x64, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x49, 0x64, 0x78, 0x12, 0x2e, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x78, 0x12, 0x43, 0x0a,
	0x0f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0e, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x22, 0xde, 0x01, 0x0a, 0x0c, 0x55, 0x6e, 0x69, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x78, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49,
	0x64, 0x78, 0x12, 0x22, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x31, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x22, 0xc9, 0x01, 0x0a, 0x1a, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x4f,
	0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x04, 0x6d, 0x65, 0x74, 0x61, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x69, 0x6e, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x04, 0x6d, 0x65, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x82, 0x03, 0x0a, 0x0f, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x4f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x29, 0x0a, 0x05, 0x75, 0x6e, 0x69,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x55, 0x6e, 0x69, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x52, 0x05, 0x75,
	0x6e, 0x69, 0x74, 0x73, 0x12, 0x49, 0x0a, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52,
	0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x88, 0x01, 0x01, 0x12,
	0x21, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x78, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x49,
	0x64, 0x78, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x78, 0x12, 0x43, 0x0a, 0x0f, 0x75, 0x6e, 0x69, 0x74, 0x73,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x75, 0x6e,
	0x69, 0x74, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x35, 0x0a, 0x08,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x19,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x08, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x22, 0xc3, 0x02, 0x0a, 0x0d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x6e, 0x69, 0x74, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x09, 0x75,
	0x6e, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0f,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x08, 0x75, 0x6e, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x23, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x44, 0x49, 0x41, 0x47, 0x4e, 0x4f, 0x53, 0x54, 0x49, 0x43, 0x53, 0x10, 0x01, 0x22,
	0x29, 0x0a, 0x05, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x55, 0x4e, 0x49, 0x54, 0x10, 0x02, 0x22, 0xe5, 0x01, 0x0a, 0x1a, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x55,
	0x6e, 0x69, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x09, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x22, 0xea, 0x01, 0x0a, 0x0e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x34, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x41, 0x0a, 0x0a, 0x64, 0x69, 0x61,
	0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x55, 0x6e, 0x69, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x0a, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x22, 0x21, 0x0a, 0x06,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x22,
	0xf0, 0x02, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x72, 0x74, 0x55, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x12, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61,
	0x64, 0x64, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x61,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x63, 0x61, 0x43,
	0x65, 0x72, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x70, 0x65, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74,
	0x12, 0x19, 0x0a, 0x08, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x07, 0x70, 0x65, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x12, 0x33, 0x0a, 0x08, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x17, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x35, 0x0a, 0x08, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x08, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x2f, 0x0a, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x2a, 0x29, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x69, 0x6e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x10, 0x00, 0x2a, 0x68, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54,
	0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x2a, 0x21, 0x0a, 0x08, 0x55, 0x6e, 0x69, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x10, 0x01, 0x2a, 0x43, 0x0a, 0x0c, 0x55, 0x6e,
	0x69, 0x74, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x57, 0x41, 0x52, 0x4e, 0x10, 0x01, 0x12,
	0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42,
	0x55, 0x47, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x52, 0x41, 0x43, 0x45, 0x10, 0x04, 0x2a,
	0x50, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x56, 0x32, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x6f, 0x67, 0x10,
	0x04, 0x32, 0xc6, 0x01, 0x0a, 0x0c, 0x45, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x09, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x56, 0x32, 0x12,
	0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x4f,
	0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x1a, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x28,
	0x01, 0x30, 0x01, 0x12, 0x3a, 0x0a, 0x07, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x15,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x28, 0x01, 0x30, 0x01, 0x12,
	0x39, 0x0a, 0x07, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x69, 0x6e, 0x12, 0x14, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64,
	0x1a, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x28, 0x01, 0x30, 0x01, 0x42, 0x14, 0x5a, 0x0f, 0x70, 0x6b,
	0x67, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x3b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0xf8, 0x01, 0x01,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_elastic_agent_client_proto_rawDescOnce sync.Once
	file_elastic_agent_client_proto_rawDescData = file_elastic_agent_client_proto_rawDesc
)

func file_elastic_agent_client_proto_rawDescGZIP() []byte {
	file_elastic_agent_client_proto_rawDescOnce.Do(func() {
		file_elastic_agent_client_proto_rawDescData = protoimpl.X.CompressGZIP(file_elastic_agent_client_proto_rawDescData)
	})
	return file_elastic_agent_client_proto_rawDescData
}

var file_elastic_agent_client_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_elastic_agent_client_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_elastic_agent_client_proto_goTypes = []interface{}{
	(ConnectionSupports)(0),            // 0: proto.ConnectionSupports
	(State)(0),                         // 1: proto.State
	(UnitType)(0),                      // 2: proto.UnitType
	(UnitLogLevel)(0),                  // 3: proto.UnitLogLevel
	(ConnInfoServices)(0),              // 4: proto.ConnInfoServices
	(ActionRequest_Type)(0),            // 5: proto.ActionRequest.Type
	(ActionRequest_Level)(0),           // 6: proto.ActionRequest.Level
	(ActionResponse_Status)(0),         // 7: proto.ActionResponse.Status
	(*Package)(nil),                    // 8: proto.Package
	(*Meta)(nil),                       // 9: proto.Meta
	(*DataStream)(nil),                 // 10: proto.DataStream
	(*Stream)(nil),                     // 11: proto.Stream
	(*UnitExpectedConfig)(nil),         // 12: proto.UnitExpectedConfig
	(*UnitExpected)(nil),               // 13: proto.UnitExpected
	(*AgentInfo)(nil),                  // 14: proto.AgentInfo
	(*Features)(nil),                   // 15: proto.Features
	(*FQDNFeature)(nil),                // 16: proto.FQDNFeature
	(*ElasticAPMTLS)(nil),              // 17: proto.ElasticAPMTLS
	(*ElasticAPM)(nil),                 // 18: proto.ElasticAPM
	(*APMConfig)(nil),                  // 19: proto.APMConfig
	(*Component)(nil),                  // 20: proto.Component
	(*ComponentLimits)(nil),            // 21: proto.ComponentLimits
	(*CheckinExpected)(nil),            // 22: proto.CheckinExpected
	(*UnitObserved)(nil),               // 23: proto.UnitObserved
	(*CheckinObservedVersionInfo)(nil), // 24: proto.CheckinObservedVersionInfo
	(*CheckinObserved)(nil),            // 25: proto.CheckinObserved
	(*ActionRequest)(nil),              // 26: proto.ActionRequest
	(*ActionDiagnosticUnitResult)(nil), // 27: proto.ActionDiagnosticUnitResult
	(*ActionResponse)(nil),             // 28: proto.ActionResponse
	(*StartUpInfo)(nil),                // 29: proto.StartUpInfo
	nil,                                // 30: proto.CheckinObservedVersionInfo.MetaEntry
	(*structpb.Struct)(nil),            // 31: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil),      // 32: google.protobuf.Timestamp
	(*StateObserved)(nil),              // 33: proto.StateObserved
	(*StateExpected)(nil),              // 34: proto.StateExpected
}
var file_elastic_agent_client_proto_depIdxs = []int32{
	31, // 0: proto.Package.source:type_name -> google.protobuf.Struct
	31, // 1: proto.Meta.source:type_name -> google.protobuf.Struct
	8,  // 2: proto.Meta.package:type_name -> proto.Package
	31, // 3: proto.DataStream.source:type_name -> google.protobuf.Struct
	31, // 4: proto.Stream.source:type_name -> google.protobuf.Struct
	10, // 5: proto.Stream.data_stream:type_name -> proto.DataStream
	31, // 6: proto.UnitExpectedConfig.source:type_name -> google.protobuf.Struct
	9,  // 7: proto.UnitExpectedConfig.meta:type_name -> proto.Meta
	10, // 8: proto.UnitExpectedConfig.data_stream:type_name -> proto.DataStream
	11, // 9: proto.UnitExpectedConfig.streams:type_name -> proto.Stream
	2,  // 10: proto.UnitExpected.type:type_name -> proto.UnitType
	1,  // 11: proto.UnitExpected.state:type_name -> proto.State
	12, // 12: proto.UnitExpected.config:type_name -> proto.UnitExpectedConfig
	3,  // 13: proto.UnitExpected.log_level:type_name -> proto.UnitLogLevel
	31, // 14: proto.Features.source:type_name -> google.protobuf.Struct
	16, // 15: proto.Features.fqdn:type_name -> proto.FQDNFeature
	17, // 16: proto.ElasticAPM.tls:type_name -> proto.ElasticAPMTLS
	18, // 17: proto.APMConfig.elastic:type_name -> proto.ElasticAPM
	21, // 18: proto.Component.limits:type_name -> proto.ComponentLimits
	19, // 19: proto.Component.apm_config:type_name -> proto.APMConfig
	31, // 20: proto.ComponentLimits.source:type_name -> google.protobuf.Struct
	13, // 21: proto.CheckinExpected.units:type_name -> proto.UnitExpected
	14, // 22: proto.CheckinExpected.agent_info:type_name -> proto.AgentInfo
	15, // 23: proto.CheckinExpected.features:type_name -> proto.Features
	20, // 24: proto.CheckinExpected.component:type_name -> proto.Component
	32, // 25: proto.CheckinExpected.units_timestamp:type_name -> google.protobuf.Timestamp
	2,  // 26: proto.UnitObserved.type:type_name -> proto.UnitType
	1,  // 27: proto.UnitObserved.state:type_name -> proto.State
	31, // 28: proto.UnitObserved.payload:type_name -> google.protobuf.Struct
	30, // 29: proto.CheckinObservedVersionInfo.meta:type_name -> proto.CheckinObservedVersionInfo.MetaEntry
	23, // 30: proto.CheckinObserved.units:type_name -> proto.UnitObserved
	24, // 31: proto.CheckinObserved.version_info:type_name -> proto.CheckinObservedVersionInfo
	32, // 32: proto.CheckinObserved.units_timestamp:type_name -> google.protobuf.Timestamp
	0,  // 33: proto.CheckinObserved.supports:type_name -> proto.ConnectionSupports
	2,  // 34: proto.ActionRequest.unit_type:type_name -> proto.UnitType
	5,  // 35: proto.ActionRequest.type:type_name -> proto.ActionRequest.Type
	6,  // 36: proto.ActionRequest.level:type_name -> proto.ActionRequest.Level
	32, // 37: proto.ActionDiagnosticUnitResult.generated:type_name -> google.protobuf.Timestamp
	7,  // 38: proto.ActionResponse.status:type_name -> proto.ActionResponse.Status
	27, // 39: proto.ActionResponse.diagnostic:type_name -> proto.ActionDiagnosticUnitResult
	4,  // 40: proto.StartUpInfo.services:type_name -> proto.ConnInfoServices
	0,  // 41: proto.StartUpInfo.supports:type_name -> proto.ConnectionSupports
	14, // 42: proto.StartUpInfo.agent_info:type_name -> proto.AgentInfo
	25, // 43: proto.ElasticAgent.CheckinV2:input_type -> proto.CheckinObserved
	28, // 44: proto.ElasticAgent.Actions:input_type -> proto.ActionResponse
	33, // 45: proto.ElasticAgent.Checkin:input_type -> proto.StateObserved
	22, // 46: proto.ElasticAgent.CheckinV2:output_type -> proto.CheckinExpected
	26, // 47: proto.ElasticAgent.Actions:output_type -> proto.ActionRequest
	34, // 48: proto.ElasticAgent.Checkin:output_type -> proto.StateExpected
	46, // [46:49] is the sub-list for method output_type
	43, // [43:46] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_elastic_agent_client_proto_init() }
func file_elastic_agent_client_proto_init() {
	if File_elastic_agent_client_proto != nil {
		return
	}
	file_elastic_agent_client_deprecated_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_elastic_agent_client_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Package); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Meta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnitExpectedConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnitExpected); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Features); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FQDNFeature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ElasticAPMTLS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ElasticAPM); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APMConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Component); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComponentLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckinExpected); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnitObserved); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckinObservedVersionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckinObserved); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionDiagnosticUnitResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_elastic_agent_client_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartUpInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_elastic_agent_client_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_elastic_agent_client_proto_msgTypes[17].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_elastic_agent_client_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_elastic_agent_client_proto_goTypes,
		DependencyIndexes: file_elastic_agent_client_proto_depIdxs,
		EnumInfos:         file_elastic_agent_client_proto_enumTypes,
		MessageInfos:      file_elastic_agent_client_proto_msgTypes,
	}.Build()
	File_elastic_agent_client_proto = out.File
	file_elastic_agent_client_proto_rawDesc = nil
	file_elastic_agent_client_proto_goTypes = nil
	file_elastic_agent_client_proto_depIdxs = nil
}
