// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Updates the specified archive rule.
type UpdateArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to update the archive rules for.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// A filter to match for the rules to update. Only rules that match the filter
	// are updated.
	//
	// Filter is a required field
	Filter map[string]Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule to update.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateArchiveRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateArchiveRuleInput"}

	if s.AnalyzerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AnalyzerName", 1))
	}

	if s.Filter == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filter"))
	}

	if s.RuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateArchiveRuleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "filter", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.AnalyzerName != nil {
		v := *s.AnalyzerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "analyzerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ruleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateArchiveRuleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateArchiveRule = "UpdateArchiveRule"

// UpdateArchiveRuleRequest returns a request value for making API operation for
// Access Analyzer.
//
// Updates the criteria and values for the specified archive rule.
//
//    // Example sending a request using UpdateArchiveRuleRequest.
//    req := client.UpdateArchiveRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateArchiveRule
func (c *Client) UpdateArchiveRuleRequest(input *UpdateArchiveRuleInput) UpdateArchiveRuleRequest {
	op := &aws.Operation{
		Name:       opUpdateArchiveRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule/{ruleName}",
	}

	if input == nil {
		input = &UpdateArchiveRuleInput{}
	}

	req := c.newRequest(op, input, &UpdateArchiveRuleOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return UpdateArchiveRuleRequest{Request: req, Input: input, Copy: c.UpdateArchiveRuleRequest}
}

// UpdateArchiveRuleRequest is the request type for the
// UpdateArchiveRule API operation.
type UpdateArchiveRuleRequest struct {
	*aws.Request
	Input *UpdateArchiveRuleInput
	Copy  func(*UpdateArchiveRuleInput) UpdateArchiveRuleRequest
}

// Send marshals and sends the UpdateArchiveRule API request.
func (r UpdateArchiveRuleRequest) Send(ctx context.Context) (*UpdateArchiveRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateArchiveRuleResponse{
		UpdateArchiveRuleOutput: r.Request.Data.(*UpdateArchiveRuleOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateArchiveRuleResponse is the response type for the
// UpdateArchiveRule API operation.
type UpdateArchiveRuleResponse struct {
	*UpdateArchiveRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateArchiveRule request.
func (r *UpdateArchiveRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
