// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCertificateAuthorityCsrInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called the CreateCertificateAuthority
	// action. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCertificateAuthorityCsrInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateAuthorityCsrInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCertificateAuthorityCsrInput"}

	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCertificateAuthorityCsrOutput struct {
	_ struct{} `type:"structure"`

	// The base64 PEM-encoded certificate signing request (CSR) for your private
	// CA certificate.
	Csr *string `type:"string"`
}

// String returns the string representation
func (s GetCertificateAuthorityCsrOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCertificateAuthorityCsr = "GetCertificateAuthorityCsr"

// GetCertificateAuthorityCsrRequest returns a request value for making API operation for
// AWS Certificate Manager Private Certificate Authority.
//
// Retrieves the certificate signing request (CSR) for your private certificate
// authority (CA). The CSR is created when you call the CreateCertificateAuthority
// action. Sign the CSR with your ACM Private CA-hosted or on-premises root
// or subordinate CA. Then import the signed certificate back into ACM Private
// CA by calling the ImportCertificateAuthorityCertificate action. The CSR is
// returned as a base64 PEM-encoded string.
//
//    // Example sending a request using GetCertificateAuthorityCsrRequest.
//    req := client.GetCertificateAuthorityCsrRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCsr
func (c *Client) GetCertificateAuthorityCsrRequest(input *GetCertificateAuthorityCsrInput) GetCertificateAuthorityCsrRequest {
	op := &aws.Operation{
		Name:       opGetCertificateAuthorityCsr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateAuthorityCsrInput{}
	}

	req := c.newRequest(op, input, &GetCertificateAuthorityCsrOutput{})

	return GetCertificateAuthorityCsrRequest{Request: req, Input: input, Copy: c.GetCertificateAuthorityCsrRequest}
}

// GetCertificateAuthorityCsrRequest is the request type for the
// GetCertificateAuthorityCsr API operation.
type GetCertificateAuthorityCsrRequest struct {
	*aws.Request
	Input *GetCertificateAuthorityCsrInput
	Copy  func(*GetCertificateAuthorityCsrInput) GetCertificateAuthorityCsrRequest
}

// Send marshals and sends the GetCertificateAuthorityCsr API request.
func (r GetCertificateAuthorityCsrRequest) Send(ctx context.Context) (*GetCertificateAuthorityCsrResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCertificateAuthorityCsrResponse{
		GetCertificateAuthorityCsrOutput: r.Request.Data.(*GetCertificateAuthorityCsrOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCertificateAuthorityCsrResponse is the response type for the
// GetCertificateAuthorityCsr API operation.
type GetCertificateAuthorityCsrResponse struct {
	*GetCertificateAuthorityCsrOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCertificateAuthorityCsr request.
func (r *GetCertificateAuthorityCsrResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
