// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListSkillsStoreCategoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of categories returned, per paginated calls.
	MaxResults *int64 `min:"1" type:"integer"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSkillsStoreCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSkillsStoreCategoriesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSkillsStoreCategoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListSkillsStoreCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of categories.
	CategoryList []Category `type:"list"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSkillsStoreCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSkillsStoreCategories = "ListSkillsStoreCategories"

// ListSkillsStoreCategoriesRequest returns a request value for making API operation for
// Alexa For Business.
//
// Lists all categories in the Alexa skill store.
//
//    // Example sending a request using ListSkillsStoreCategoriesRequest.
//    req := client.ListSkillsStoreCategoriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories
func (c *Client) ListSkillsStoreCategoriesRequest(input *ListSkillsStoreCategoriesInput) ListSkillsStoreCategoriesRequest {
	op := &aws.Operation{
		Name:       opListSkillsStoreCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSkillsStoreCategoriesInput{}
	}

	req := c.newRequest(op, input, &ListSkillsStoreCategoriesOutput{})

	return ListSkillsStoreCategoriesRequest{Request: req, Input: input, Copy: c.ListSkillsStoreCategoriesRequest}
}

// ListSkillsStoreCategoriesRequest is the request type for the
// ListSkillsStoreCategories API operation.
type ListSkillsStoreCategoriesRequest struct {
	*aws.Request
	Input *ListSkillsStoreCategoriesInput
	Copy  func(*ListSkillsStoreCategoriesInput) ListSkillsStoreCategoriesRequest
}

// Send marshals and sends the ListSkillsStoreCategories API request.
func (r ListSkillsStoreCategoriesRequest) Send(ctx context.Context) (*ListSkillsStoreCategoriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSkillsStoreCategoriesResponse{
		ListSkillsStoreCategoriesOutput: r.Request.Data.(*ListSkillsStoreCategoriesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSkillsStoreCategoriesRequestPaginator returns a paginator for ListSkillsStoreCategories.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSkillsStoreCategoriesRequest(input)
//   p := alexaforbusiness.NewListSkillsStoreCategoriesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSkillsStoreCategoriesPaginator(req ListSkillsStoreCategoriesRequest) ListSkillsStoreCategoriesPaginator {
	return ListSkillsStoreCategoriesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSkillsStoreCategoriesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSkillsStoreCategoriesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSkillsStoreCategoriesPaginator struct {
	aws.Pager
}

func (p *ListSkillsStoreCategoriesPaginator) CurrentPage() *ListSkillsStoreCategoriesOutput {
	return p.Pager.CurrentPage().(*ListSkillsStoreCategoriesOutput)
}

// ListSkillsStoreCategoriesResponse is the response type for the
// ListSkillsStoreCategories API operation.
type ListSkillsStoreCategoriesResponse struct {
	*ListSkillsStoreCategoriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSkillsStoreCategories request.
func (r *ListSkillsStoreCategoriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
