// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutInvitationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The email ID of the organization or individual contact that the enrolled
	// user can use.
	ContactEmail *string `min:"1" type:"string"`

	// The name of the organization sending the enrollment invite to a user.
	//
	// OrganizationName is a required field
	OrganizationName *string `min:"1" type:"string" required:"true"`

	// The list of private skill IDs that you want to recommend to the user to enable
	// in the invitation.
	PrivateSkillIds []string `type:"list"`
}

// String returns the string representation
func (s PutInvitationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInvitationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutInvitationConfigurationInput"}
	if s.ContactEmail != nil && len(*s.ContactEmail) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContactEmail", 1))
	}

	if s.OrganizationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationName"))
	}
	if s.OrganizationName != nil && len(*s.OrganizationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutInvitationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutInvitationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutInvitationConfiguration = "PutInvitationConfiguration"

// PutInvitationConfigurationRequest returns a request value for making API operation for
// Alexa For Business.
//
// Configures the email template for the user enrollment invitation with the
// specified attributes.
//
//    // Example sending a request using PutInvitationConfigurationRequest.
//    req := client.PutInvitationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration
func (c *Client) PutInvitationConfigurationRequest(input *PutInvitationConfigurationInput) PutInvitationConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutInvitationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInvitationConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutInvitationConfigurationOutput{})

	return PutInvitationConfigurationRequest{Request: req, Input: input, Copy: c.PutInvitationConfigurationRequest}
}

// PutInvitationConfigurationRequest is the request type for the
// PutInvitationConfiguration API operation.
type PutInvitationConfigurationRequest struct {
	*aws.Request
	Input *PutInvitationConfigurationInput
	Copy  func(*PutInvitationConfigurationInput) PutInvitationConfigurationRequest
}

// Send marshals and sends the PutInvitationConfiguration API request.
func (r PutInvitationConfigurationRequest) Send(ctx context.Context) (*PutInvitationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutInvitationConfigurationResponse{
		PutInvitationConfigurationOutput: r.Request.Data.(*PutInvitationConfigurationOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutInvitationConfigurationResponse is the response type for the
// PutInvitationConfiguration API operation.
type PutInvitationConfigurationResponse struct {
	*PutInvitationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutInvitationConfiguration request.
func (r *PutInvitationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
