// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteAccessLogSettingsInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// StageName is a required field
	StageName *string `location:"uri" locationName:"stageName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccessLogSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessLogSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAccessLogSettingsInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.StageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAccessLogSettingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteAccessLogSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessLogSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAccessLogSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteAccessLogSettings = "DeleteAccessLogSettings"

// DeleteAccessLogSettingsRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Deletes the AccessLogSettings for a Stage. To disable access logging for
// a Stage, delete its AccessLogSettings.
//
//    // Example sending a request using DeleteAccessLogSettingsRequest.
//    req := client.DeleteAccessLogSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteAccessLogSettings
func (c *Client) DeleteAccessLogSettingsRequest(input *DeleteAccessLogSettingsInput) DeleteAccessLogSettingsRequest {
	op := &aws.Operation{
		Name:       opDeleteAccessLogSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/stages/{stageName}/accesslogsettings",
	}

	if input == nil {
		input = &DeleteAccessLogSettingsInput{}
	}

	req := c.newRequest(op, input, &DeleteAccessLogSettingsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteAccessLogSettingsRequest{Request: req, Input: input, Copy: c.DeleteAccessLogSettingsRequest}
}

// DeleteAccessLogSettingsRequest is the request type for the
// DeleteAccessLogSettings API operation.
type DeleteAccessLogSettingsRequest struct {
	*aws.Request
	Input *DeleteAccessLogSettingsInput
	Copy  func(*DeleteAccessLogSettingsInput) DeleteAccessLogSettingsRequest
}

// Send marshals and sends the DeleteAccessLogSettings API request.
func (r DeleteAccessLogSettingsRequest) Send(ctx context.Context) (*DeleteAccessLogSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAccessLogSettingsResponse{
		DeleteAccessLogSettingsOutput: r.Request.Data.(*DeleteAccessLogSettingsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAccessLogSettingsResponse is the response type for the
// DeleteAccessLogSettings API operation.
type DeleteAccessLogSettingsResponse struct {
	*DeleteAccessLogSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAccessLogSettings request.
func (r *DeleteAccessLogSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
