// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartContinuousExportInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartContinuousExportInput) String() string {
	return awsutil.Prettify(s)
}

type StartContinuousExportOutput struct {
	_ struct{} `type:"structure"`

	// The type of data collector used to gather this data (currently only offered
	// for AGENT).
	DataSource DataSource `locationName:"dataSource" type:"string" enum:"true"`

	// The unique ID assigned to this export.
	ExportId *string `locationName:"exportId" type:"string"`

	// The name of the s3 bucket where the export data parquet files are stored.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// A dictionary which describes how the data is stored.
	//
	//    * databaseName - the name of the Glue database used to store the schema.
	SchemaStorageConfig map[string]string `locationName:"schemaStorageConfig" type:"map"`

	// The timestamp representing when the continuous export was started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s StartContinuousExportOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartContinuousExport = "StartContinuousExport"

// StartContinuousExportRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Start the continuous flow of agent's discovered data into Amazon Athena.
//
//    // Example sending a request using StartContinuousExportRequest.
//    req := client.StartContinuousExportRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartContinuousExport
func (c *Client) StartContinuousExportRequest(input *StartContinuousExportInput) StartContinuousExportRequest {
	op := &aws.Operation{
		Name:       opStartContinuousExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartContinuousExportInput{}
	}

	req := c.newRequest(op, input, &StartContinuousExportOutput{})

	return StartContinuousExportRequest{Request: req, Input: input, Copy: c.StartContinuousExportRequest}
}

// StartContinuousExportRequest is the request type for the
// StartContinuousExport API operation.
type StartContinuousExportRequest struct {
	*aws.Request
	Input *StartContinuousExportInput
	Copy  func(*StartContinuousExportInput) StartContinuousExportRequest
}

// Send marshals and sends the StartContinuousExport API request.
func (r StartContinuousExportRequest) Send(ctx context.Context) (*StartContinuousExportResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartContinuousExportResponse{
		StartContinuousExportOutput: r.Request.Data.(*StartContinuousExportOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartContinuousExportResponse is the response type for the
// StartContinuousExport API operation.
type StartContinuousExportResponse struct {
	*StartContinuousExportOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartContinuousExport request.
func (r *StartContinuousExportResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
