// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDirectoryConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the Directory Config object.
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`

	// The distinguished names of the organizational units for computer accounts.
	OrganizationalUnitDistinguishedNames []string `type:"list"`

	// The credentials for the service account used by the fleet or image builder
	// to connect to the directory.
	ServiceAccountCredentials *ServiceAccountCredentials `type:"structure"`
}

// String returns the string representation
func (s UpdateDirectoryConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDirectoryConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDirectoryConfigInput"}

	if s.DirectoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryName"))
	}
	if s.ServiceAccountCredentials != nil {
		if err := s.ServiceAccountCredentials.Validate(); err != nil {
			invalidParams.AddNested("ServiceAccountCredentials", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDirectoryConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Directory Config object.
	DirectoryConfig *DirectoryConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateDirectoryConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDirectoryConfig = "UpdateDirectoryConfig"

// UpdateDirectoryConfigRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Updates the specified Directory Config object in AppStream 2.0. This object
// includes the configuration information required to join fleets and image
// builders to Microsoft Active Directory domains.
//
//    // Example sending a request using UpdateDirectoryConfigRequest.
//    req := client.UpdateDirectoryConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig
func (c *Client) UpdateDirectoryConfigRequest(input *UpdateDirectoryConfigInput) UpdateDirectoryConfigRequest {
	op := &aws.Operation{
		Name:       opUpdateDirectoryConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDirectoryConfigInput{}
	}

	req := c.newRequest(op, input, &UpdateDirectoryConfigOutput{})

	return UpdateDirectoryConfigRequest{Request: req, Input: input, Copy: c.UpdateDirectoryConfigRequest}
}

// UpdateDirectoryConfigRequest is the request type for the
// UpdateDirectoryConfig API operation.
type UpdateDirectoryConfigRequest struct {
	*aws.Request
	Input *UpdateDirectoryConfigInput
	Copy  func(*UpdateDirectoryConfigInput) UpdateDirectoryConfigRequest
}

// Send marshals and sends the UpdateDirectoryConfig API request.
func (r UpdateDirectoryConfigRequest) Send(ctx context.Context) (*UpdateDirectoryConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDirectoryConfigResponse{
		UpdateDirectoryConfigOutput: r.Request.Data.(*UpdateDirectoryConfigOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDirectoryConfigResponse is the response type for the
// UpdateDirectoryConfig API operation.
type UpdateDirectoryConfigResponse struct {
	*UpdateDirectoryConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDirectoryConfig request.
func (r *UpdateDirectoryConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
