// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Represents the input of a FlushApiCache operation.
type FlushApiCacheInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s FlushApiCacheInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlushApiCacheInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FlushApiCacheInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FlushApiCacheInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a FlushApiCache operation.
type FlushApiCacheOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s FlushApiCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FlushApiCacheOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opFlushApiCache = "FlushApiCache"

// FlushApiCacheRequest returns a request value for making API operation for
// AWS AppSync.
//
// Flushes an ApiCache object.
//
//    // Example sending a request using FlushApiCacheRequest.
//    req := client.FlushApiCacheRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/FlushApiCache
func (c *Client) FlushApiCacheRequest(input *FlushApiCacheInput) FlushApiCacheRequest {
	op := &aws.Operation{
		Name:       opFlushApiCache,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/FlushCache",
	}

	if input == nil {
		input = &FlushApiCacheInput{}
	}

	req := c.newRequest(op, input, &FlushApiCacheOutput{})

	return FlushApiCacheRequest{Request: req, Input: input, Copy: c.FlushApiCacheRequest}
}

// FlushApiCacheRequest is the request type for the
// FlushApiCache API operation.
type FlushApiCacheRequest struct {
	*aws.Request
	Input *FlushApiCacheInput
	Copy  func(*FlushApiCacheInput) FlushApiCacheRequest
}

// Send marshals and sends the FlushApiCache API request.
func (r FlushApiCacheRequest) Send(ctx context.Context) (*FlushApiCacheResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &FlushApiCacheResponse{
		FlushApiCacheOutput: r.Request.Data.(*FlushApiCacheOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// FlushApiCacheResponse is the response type for the
// FlushApiCache API operation.
type FlushApiCacheResponse struct {
	*FlushApiCacheOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// FlushApiCache request.
func (r *FlushApiCacheResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
