// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDataSourceInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDataSourceInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The DataSource object.
	DataSource *DataSource `locationName:"dataSource" type:"structure"`
}

// String returns the string representation
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDataSourceOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSource != nil {
		v := s.DataSource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dataSource", v, metadata)
	}
	return nil
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest returns a request value for making API operation for
// AWS AppSync.
//
// Retrieves a DataSource object.
//
//    // Example sending a request using GetDataSourceRequest.
//    req := client.GetDataSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource
func (c *Client) GetDataSourceRequest(input *GetDataSourceInput) GetDataSourceRequest {
	op := &aws.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/datasources/{name}",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	req := c.newRequest(op, input, &GetDataSourceOutput{})

	return GetDataSourceRequest{Request: req, Input: input, Copy: c.GetDataSourceRequest}
}

// GetDataSourceRequest is the request type for the
// GetDataSource API operation.
type GetDataSourceRequest struct {
	*aws.Request
	Input *GetDataSourceInput
	Copy  func(*GetDataSourceInput) GetDataSourceRequest
}

// Send marshals and sends the GetDataSource API request.
func (r GetDataSourceRequest) Send(ctx context.Context) (*GetDataSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDataSourceResponse{
		GetDataSourceOutput: r.Request.Data.(*GetDataSourceOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDataSourceResponse is the response type for the
// GetDataSource API operation.
type GetDataSourceResponse struct {
	*GetDataSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDataSource request.
func (r *GetDataSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
