// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDataCatalogInput struct {
	_ struct{} `type:"structure"`

	// A description of the data catalog to be created.
	Description *string `min:"1" type:"string"`

	// The name of the data catalog to create. The catalog name must be unique for
	// the AWS account and can use a maximum of 128 alphanumeric, underscore, at
	// sign, or hyphen characters.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies the Lambda function or functions to use for creating the data catalog.
	// This is a mapping whose values depend on the catalog type.
	//
	//    * For the HIVE data catalog type, use the following syntax. The metadata-function
	//    parameter is required. The sdk-version parameter is optional and defaults
	//    to the currently supported version. metadata-function=lambda_arn, sdk-version=version_number
	//
	//    * For the LAMBDA data catalog type, use one of the following sets of required
	//    parameters, but not both. If you have one Lambda function that processes
	//    metadata and another for reading the actual data, use the following syntax.
	//    Both parameters are required. metadata-function=lambda_arn, record-function=lambda_arn
	//    If you have a composite Lambda function that processes both metadata and
	//    data, use the following syntax to specify your Lambda function. function=lambda_arn
	//
	//    * The GLUE type has no parameters.
	Parameters map[string]string `type:"map"`

	// A list of comma separated tags to add to the data catalog that is created.
	Tags []Tag `type:"list"`

	// The type of data catalog to create: LAMBDA for a federated catalog, GLUE
	// for AWS Glue Catalog, or HIVE for an external hive metastore.
	//
	// Type is a required field
	Type DataCatalogType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateDataCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataCatalogInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDataCatalogInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDataCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateDataCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDataCatalog = "CreateDataCatalog"

// CreateDataCatalogRequest returns a request value for making API operation for
// Amazon Athena.
//
// Creates (registers) a data catalog with the specified name and properties.
// Catalogs created are visible to all users of the same AWS account.
//
//    // Example sending a request using CreateDataCatalogRequest.
//    req := client.CreateDataCatalogRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateDataCatalog
func (c *Client) CreateDataCatalogRequest(input *CreateDataCatalogInput) CreateDataCatalogRequest {
	op := &aws.Operation{
		Name:       opCreateDataCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataCatalogInput{}
	}

	req := c.newRequest(op, input, &CreateDataCatalogOutput{})

	return CreateDataCatalogRequest{Request: req, Input: input, Copy: c.CreateDataCatalogRequest}
}

// CreateDataCatalogRequest is the request type for the
// CreateDataCatalog API operation.
type CreateDataCatalogRequest struct {
	*aws.Request
	Input *CreateDataCatalogInput
	Copy  func(*CreateDataCatalogInput) CreateDataCatalogRequest
}

// Send marshals and sends the CreateDataCatalog API request.
func (r CreateDataCatalogRequest) Send(ctx context.Context) (*CreateDataCatalogResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDataCatalogResponse{
		CreateDataCatalogOutput: r.Request.Data.(*CreateDataCatalogOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDataCatalogResponse is the response type for the
// CreateDataCatalog API operation.
type CreateDataCatalogResponse struct {
	*CreateDataCatalogOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDataCatalog request.
func (r *CreateDataCatalogResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
