// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDataCatalogInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog to return.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDataCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataCatalogInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDataCatalogInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDataCatalogOutput struct {
	_ struct{} `type:"structure"`

	// The data catalog returned.
	DataCatalog *DataCatalog `type:"structure"`
}

// String returns the string representation
func (s GetDataCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDataCatalog = "GetDataCatalog"

// GetDataCatalogRequest returns a request value for making API operation for
// Amazon Athena.
//
// Returns the specified data catalog.
//
//    // Example sending a request using GetDataCatalogRequest.
//    req := client.GetDataCatalogRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDataCatalog
func (c *Client) GetDataCatalogRequest(input *GetDataCatalogInput) GetDataCatalogRequest {
	op := &aws.Operation{
		Name:       opGetDataCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataCatalogInput{}
	}

	req := c.newRequest(op, input, &GetDataCatalogOutput{})

	return GetDataCatalogRequest{Request: req, Input: input, Copy: c.GetDataCatalogRequest}
}

// GetDataCatalogRequest is the request type for the
// GetDataCatalog API operation.
type GetDataCatalogRequest struct {
	*aws.Request
	Input *GetDataCatalogInput
	Copy  func(*GetDataCatalogInput) GetDataCatalogRequest
}

// Send marshals and sends the GetDataCatalog API request.
func (r GetDataCatalogRequest) Send(ctx context.Context) (*GetDataCatalogResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDataCatalogResponse{
		GetDataCatalogOutput: r.Request.Data.(*GetDataCatalogOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDataCatalogResponse is the response type for the
// GetDataCatalog API operation.
type GetDataCatalogResponse struct {
	*GetDataCatalogOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDataCatalog request.
func (r *GetDataCatalogResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
