// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The maximum number of items to return with this call. The default value is
	// 100 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoadBalancersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLoadBalancersInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// The load balancers.
	LoadBalancers []LoadBalancerState `type:"list"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLoadBalancers = "DescribeLoadBalancers"

// DescribeLoadBalancersRequest returns a request value for making API operation for
// Auto Scaling.
//
// Describes the load balancers for the specified Auto Scaling group.
//
// This operation describes only Classic Load Balancers. If you have Application
// Load Balancers or Network Load Balancers, use the DescribeLoadBalancerTargetGroups
// API instead.
//
//    // Example sending a request using DescribeLoadBalancersRequest.
//    req := client.DescribeLoadBalancersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers
func (c *Client) DescribeLoadBalancersRequest(input *DescribeLoadBalancersInput) DescribeLoadBalancersRequest {
	op := &aws.Operation{
		Name:       opDescribeLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancersInput{}
	}

	req := c.newRequest(op, input, &DescribeLoadBalancersOutput{})

	return DescribeLoadBalancersRequest{Request: req, Input: input, Copy: c.DescribeLoadBalancersRequest}
}

// DescribeLoadBalancersRequest is the request type for the
// DescribeLoadBalancers API operation.
type DescribeLoadBalancersRequest struct {
	*aws.Request
	Input *DescribeLoadBalancersInput
	Copy  func(*DescribeLoadBalancersInput) DescribeLoadBalancersRequest
}

// Send marshals and sends the DescribeLoadBalancers API request.
func (r DescribeLoadBalancersRequest) Send(ctx context.Context) (*DescribeLoadBalancersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLoadBalancersResponse{
		DescribeLoadBalancersOutput: r.Request.Data.(*DescribeLoadBalancersOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLoadBalancersResponse is the response type for the
// DescribeLoadBalancers API operation.
type DescribeLoadBalancersResponse struct {
	*DescribeLoadBalancersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLoadBalancers request.
func (r *DescribeLoadBalancersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
