// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeRegionSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeRegionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRegionSettingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

type DescribeRegionSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of all services along with the opt-in preferences in the region.
	ResourceTypeOptInPreference map[string]bool `type:"map"`
}

// String returns the string representation
func (s DescribeRegionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRegionSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ResourceTypeOptInPreference != nil {
		v := s.ResourceTypeOptInPreference

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "ResourceTypeOptInPreference", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.BoolValue(v1))
		}
		ms0.End()

	}
	return nil
}

const opDescribeRegionSettings = "DescribeRegionSettings"

// DescribeRegionSettingsRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns the current service opt-in settings for the Region. If the service
// has a value set to true, AWS Backup attempts to protect that service's resources
// in this Region, when included in an on-demand backup or scheduled backup
// plan. If the value is set to false for a service, AWS Backup does not attempt
// to protect that service's resources in this Region.
//
//    // Example sending a request using DescribeRegionSettingsRequest.
//    req := client.DescribeRegionSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings
func (c *Client) DescribeRegionSettingsRequest(input *DescribeRegionSettingsInput) DescribeRegionSettingsRequest {
	op := &aws.Operation{
		Name:       opDescribeRegionSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/account-settings",
	}

	if input == nil {
		input = &DescribeRegionSettingsInput{}
	}

	req := c.newRequest(op, input, &DescribeRegionSettingsOutput{})

	return DescribeRegionSettingsRequest{Request: req, Input: input, Copy: c.DescribeRegionSettingsRequest}
}

// DescribeRegionSettingsRequest is the request type for the
// DescribeRegionSettings API operation.
type DescribeRegionSettingsRequest struct {
	*aws.Request
	Input *DescribeRegionSettingsInput
	Copy  func(*DescribeRegionSettingsInput) DescribeRegionSettingsRequest
}

// Send marshals and sends the DescribeRegionSettings API request.
func (r DescribeRegionSettingsRequest) Send(ctx context.Context) (*DescribeRegionSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRegionSettingsResponse{
		DescribeRegionSettingsOutput: r.Request.Data.(*DescribeRegionSettingsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRegionSettingsResponse is the response type for the
// DescribeRegionSettings API operation.
type DescribeRegionSettingsResponse struct {
	*DescribeRegionSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRegionSettings request.
func (r *DescribeRegionSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
