// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package batch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name for your compute environment. Up to 128 letters (uppercase and lowercase),
	// numbers, hyphens, and underscores are allowed.
	//
	// ComputeEnvironmentName is a required field
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string" required:"true"`

	// Details of the compute resources managed by the compute environment. This
	// parameter is required for managed compute environments. For more information,
	// see Compute Environments (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the AWS Batch User Guide.
	ComputeResources *ComputeResource `locationName:"computeResources" type:"structure"`

	// The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch
	// to make calls to other AWS services on your behalf.
	//
	// If your specified role has a path other than /, then you must either specify
	// the full role ARN (this is recommended) or prefix the role name with the
	// path.
	//
	// Depending on how you created your AWS Batch service role, its ARN may contain
	// the service-role path prefix. When you only specify the name of the service
	// role, AWS Batch assumes that your ARN does not use the service-role path
	// prefix. Because of this, we recommend that you specify the full ARN of your
	// service role when you create compute environments.
	//
	// ServiceRole is a required field
	ServiceRole *string `locationName:"serviceRole" type:"string" required:"true"`

	// The state of the compute environment. If the state is ENABLED, then the compute
	// environment accepts jobs from a queue and can scale out automatically based
	// on queues.
	State CEState `locationName:"state" type:"string" enum:"true"`

	// The type of the compute environment. For more information, see Compute Environments
	// (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the AWS Batch User Guide.
	//
	// Type is a required field
	Type CEType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComputeEnvironmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateComputeEnvironmentInput"}

	if s.ComputeEnvironmentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComputeEnvironmentName"))
	}

	if s.ServiceRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceRole"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.ComputeResources != nil {
		if err := s.ComputeResources.Validate(); err != nil {
			invalidParams.AddNested("ComputeResources", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateComputeEnvironmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ComputeEnvironmentName != nil {
		v := *s.ComputeEnvironmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ComputeResources != nil {
		v := s.ComputeResources

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "computeResources", v, metadata)
	}
	if s.ServiceRole != nil {
		v := *s.ServiceRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type CreateComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string"`

	// The name of the compute environment.
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string"`
}

// String returns the string representation
func (s CreateComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateComputeEnvironmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComputeEnvironmentArn != nil {
		v := *s.ComputeEnvironmentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironmentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ComputeEnvironmentName != nil {
		v := *s.ComputeEnvironmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateComputeEnvironment = "CreateComputeEnvironment"

// CreateComputeEnvironmentRequest returns a request value for making API operation for
// AWS Batch.
//
// Creates an AWS Batch compute environment. You can create MANAGED or UNMANAGED
// compute environments.
//
// In a managed compute environment, AWS Batch manages the capacity and instance
// types of the compute resources within the environment. This is based on the
// compute resource specification that you define or the launch template (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html)
// that you specify when you create the compute environment. You can choose
// to use Amazon EC2 On-Demand Instances or Spot Instances in your managed compute
// environment. You can optionally set a maximum price so that Spot Instances
// only launch when the Spot Instance price is below a specified percentage
// of the On-Demand price.
//
// Multi-node parallel jobs are not supported on Spot Instances.
//
// In an unmanaged compute environment, you can manage your own compute resources.
// This provides more compute resource configuration options, such as using
// a custom AMI, but you must ensure that your AMI meets the Amazon ECS container
// instance AMI specification. For more information, see Container Instance
// AMIs (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html)
// in the Amazon Elastic Container Service Developer Guide. After you have created
// your unmanaged compute environment, you can use the DescribeComputeEnvironments
// operation to find the Amazon ECS cluster that is associated with it. Then,
// manually launch your container instances into that Amazon ECS cluster. For
// more information, see Launching an Amazon ECS Container Instance (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// AWS Batch does not upgrade the AMIs in a compute environment after it is
// created (for example, when a newer version of the Amazon ECS-optimized AMI
// is available). You are responsible for the management of the guest operating
// system (including updates and security patches) and any additional application
// software or utilities that you install on the compute resources. To use a
// new AMI for your AWS Batch jobs:
//
// Create a new compute environment with the new AMI.
//
// Add the compute environment to an existing job queue.
//
// Remove the old compute environment from your job queue.
//
// Delete the old compute environment.
//
//    // Example sending a request using CreateComputeEnvironmentRequest.
//    req := client.CreateComputeEnvironmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironment
func (c *Client) CreateComputeEnvironmentRequest(input *CreateComputeEnvironmentInput) CreateComputeEnvironmentRequest {
	op := &aws.Operation{
		Name:       opCreateComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/createcomputeenvironment",
	}

	if input == nil {
		input = &CreateComputeEnvironmentInput{}
	}

	req := c.newRequest(op, input, &CreateComputeEnvironmentOutput{})

	return CreateComputeEnvironmentRequest{Request: req, Input: input, Copy: c.CreateComputeEnvironmentRequest}
}

// CreateComputeEnvironmentRequest is the request type for the
// CreateComputeEnvironment API operation.
type CreateComputeEnvironmentRequest struct {
	*aws.Request
	Input *CreateComputeEnvironmentInput
	Copy  func(*CreateComputeEnvironmentInput) CreateComputeEnvironmentRequest
}

// Send marshals and sends the CreateComputeEnvironment API request.
func (r CreateComputeEnvironmentRequest) Send(ctx context.Context) (*CreateComputeEnvironmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateComputeEnvironmentResponse{
		CreateComputeEnvironmentOutput: r.Request.Data.(*CreateComputeEnvironmentOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateComputeEnvironmentResponse is the response type for the
// CreateComputeEnvironment API operation.
type CreateComputeEnvironmentResponse struct {
	*CreateComputeEnvironmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateComputeEnvironment request.
func (r *CreateComputeEnvironmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
