// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateMeetingWithAttendeesInput struct {
	_ struct{} `type:"structure"`

	// The request containing the attendees to create.
	Attendees []CreateAttendeeRequestItem `min:"1" type:"list"`

	// The unique identifier for the client request. Use a different token for different
	// meetings.
	//
	// ClientRequestToken is a required field
	ClientRequestToken *string `min:"2" type:"string" required:"true" idempotencyToken:"true" sensitive:"true"`

	// The external meeting ID.
	ExternalMeetingId *string `min:"2" type:"string" sensitive:"true"`

	// The Region in which to create the meeting. Default: us-east-1.
	//
	// Available values: ap-northeast-1, ap-southeast-1, ap-southeast-2, ca-central-1,
	// eu-central-1, eu-north-1, eu-west-1, eu-west-2, eu-west-3, sa-east-1, us-east-1,
	// us-east-2, us-west-1, us-west-2.
	MediaRegion *string `type:"string"`

	// Reserved.
	MeetingHostId *string `min:"2" type:"string" sensitive:"true"`

	// The configuration for resource targets to receive notifications when Amazon
	// Chime SDK meeting and attendee events occur. The Amazon Chime SDK supports
	// resource targets located in the US East (N. Virginia) AWS Region (us-east-1).
	NotificationsConfiguration *MeetingNotificationConfiguration `type:"structure"`

	// The tag key-value pairs.
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateMeetingWithAttendeesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeetingWithAttendeesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateMeetingWithAttendeesInput"}
	if s.Attendees != nil && len(s.Attendees) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attendees", 1))
	}

	if s.ClientRequestToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientRequestToken"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.ExternalMeetingId != nil && len(*s.ExternalMeetingId) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ExternalMeetingId", 2))
	}
	if s.MeetingHostId != nil && len(*s.MeetingHostId) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("MeetingHostId", 2))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Attendees != nil {
		for i, v := range s.Attendees {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attendees", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.NotificationsConfiguration != nil {
		if err := s.NotificationsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationsConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateMeetingWithAttendeesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Attendees != nil {
		v := s.Attendees

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attendees", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExternalMeetingId != nil {
		v := *s.ExternalMeetingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalMeetingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MediaRegion != nil {
		v := *s.MediaRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MediaRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeetingHostId != nil {
		v := *s.MeetingHostId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MeetingHostId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NotificationsConfiguration != nil {
		v := s.NotificationsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NotificationsConfiguration", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

type CreateMeetingWithAttendeesOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees IDs and join tokens.
	Attendees []Attendee `type:"list"`

	// If the action fails for one or more of the attendees in the request, a list
	// of the attendees is returned, along with error codes and error messages.
	Errors []CreateAttendeeError `type:"list"`

	// A meeting created using the Amazon Chime SDK.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation
func (s CreateMeetingWithAttendeesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateMeetingWithAttendeesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attendees != nil {
		v := s.Attendees

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attendees", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Meeting != nil {
		v := s.Meeting

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Meeting", v, metadata)
	}
	return nil
}

const opCreateMeetingWithAttendees = "CreateMeetingWithAttendees"

// CreateMeetingWithAttendeesRequest returns a request value for making API operation for
// Amazon Chime.
//
// Creates a new Amazon Chime SDK meeting in the specified media Region, with
// attendees. For more information about specifying media Regions, see Amazon
// Chime SDK Media Regions (https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html)
// in the Amazon Chime Developer Guide. For more information about the Amazon
// Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
//    // Example sending a request using CreateMeetingWithAttendeesRequest.
//    req := client.CreateMeetingWithAttendeesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeetingWithAttendees
func (c *Client) CreateMeetingWithAttendeesRequest(input *CreateMeetingWithAttendeesInput) CreateMeetingWithAttendeesRequest {
	op := &aws.Operation{
		Name:       opCreateMeetingWithAttendees,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings?operation=create-attendees",
	}

	if input == nil {
		input = &CreateMeetingWithAttendeesInput{}
	}

	req := c.newRequest(op, input, &CreateMeetingWithAttendeesOutput{})

	return CreateMeetingWithAttendeesRequest{Request: req, Input: input, Copy: c.CreateMeetingWithAttendeesRequest}
}

// CreateMeetingWithAttendeesRequest is the request type for the
// CreateMeetingWithAttendees API operation.
type CreateMeetingWithAttendeesRequest struct {
	*aws.Request
	Input *CreateMeetingWithAttendeesInput
	Copy  func(*CreateMeetingWithAttendeesInput) CreateMeetingWithAttendeesRequest
}

// Send marshals and sends the CreateMeetingWithAttendees API request.
func (r CreateMeetingWithAttendeesRequest) Send(ctx context.Context) (*CreateMeetingWithAttendeesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateMeetingWithAttendeesResponse{
		CreateMeetingWithAttendeesOutput: r.Request.Data.(*CreateMeetingWithAttendeesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateMeetingWithAttendeesResponse is the response type for the
// CreateMeetingWithAttendees API operation.
type CreateMeetingWithAttendeesResponse struct {
	*CreateMeetingWithAttendeesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateMeetingWithAttendees request.
func (r *CreateMeetingWithAttendeesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
