// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetProxySessionInput struct {
	_ struct{} `type:"structure"`

	// The proxy session ID.
	//
	// ProxySessionId is a required field
	ProxySessionId *string `location:"uri" locationName:"proxySessionId" min:"1" type:"string" required:"true"`

	// The Amazon Chime voice connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetProxySessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProxySessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetProxySessionInput"}

	if s.ProxySessionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProxySessionId"))
	}
	if s.ProxySessionId != nil && len(*s.ProxySessionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProxySessionId", 1))
	}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetProxySessionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ProxySessionId != nil {
		v := *s.ProxySessionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "proxySessionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetProxySessionOutput struct {
	_ struct{} `type:"structure"`

	// The proxy session details.
	ProxySession *ProxySession `type:"structure"`
}

// String returns the string representation
func (s GetProxySessionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetProxySessionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProxySession != nil {
		v := s.ProxySession

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ProxySession", v, metadata)
	}
	return nil
}

const opGetProxySession = "GetProxySession"

// GetProxySessionRequest returns a request value for making API operation for
// Amazon Chime.
//
// Gets the specified proxy session details for the specified Amazon Chime Voice
// Connector.
//
//    // Example sending a request using GetProxySessionRequest.
//    req := client.GetProxySessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetProxySession
func (c *Client) GetProxySessionRequest(input *GetProxySessionInput) GetProxySessionRequest {
	op := &aws.Operation{
		Name:       opGetProxySession,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions/{proxySessionId}",
	}

	if input == nil {
		input = &GetProxySessionInput{}
	}

	req := c.newRequest(op, input, &GetProxySessionOutput{})

	return GetProxySessionRequest{Request: req, Input: input, Copy: c.GetProxySessionRequest}
}

// GetProxySessionRequest is the request type for the
// GetProxySession API operation.
type GetProxySessionRequest struct {
	*aws.Request
	Input *GetProxySessionInput
	Copy  func(*GetProxySessionInput) GetProxySessionRequest
}

// Send marshals and sends the GetProxySession API request.
func (r GetProxySessionRequest) Send(ctx context.Context) (*GetProxySessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetProxySessionResponse{
		GetProxySessionOutput: r.Request.Data.(*GetProxySessionOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetProxySessionResponse is the response type for the
// GetProxySession API operation.
type GetProxySessionResponse struct {
	*GetProxySessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetProxySession request.
func (r *GetProxySessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
