// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateRoomInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The room name.
	Name *string `type:"string" sensitive:"true"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoomInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRoomInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.RoomId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoomId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRoomInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoomId != nil {
		v := *s.RoomId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "roomId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateRoomOutput struct {
	_ struct{} `type:"structure"`

	// The room details.
	Room *Room `type:"structure"`
}

// String returns the string representation
func (s UpdateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRoomOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Room != nil {
		v := s.Room

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Room", v, metadata)
	}
	return nil
}

const opUpdateRoom = "UpdateRoom"

// UpdateRoomRequest returns a request value for making API operation for
// Amazon Chime.
//
// Updates room details, such as the room name, for a room in an Amazon Chime
// Enterprise account.
//
//    // Example sending a request using UpdateRoomRequest.
//    req := client.UpdateRoomRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoom
func (c *Client) UpdateRoomRequest(input *UpdateRoomInput) UpdateRoomRequest {
	op := &aws.Operation{
		Name:       opUpdateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}",
	}

	if input == nil {
		input = &UpdateRoomInput{}
	}

	req := c.newRequest(op, input, &UpdateRoomOutput{})

	return UpdateRoomRequest{Request: req, Input: input, Copy: c.UpdateRoomRequest}
}

// UpdateRoomRequest is the request type for the
// UpdateRoom API operation.
type UpdateRoomRequest struct {
	*aws.Request
	Input *UpdateRoomInput
	Copy  func(*UpdateRoomInput) UpdateRoomRequest
}

// Send marshals and sends the UpdateRoom API request.
func (r UpdateRoomRequest) Send(ctx context.Context) (*UpdateRoomResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRoomResponse{
		UpdateRoomOutput: r.Request.Data.(*UpdateRoomOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRoomResponse is the response type for the
// UpdateRoom API operation.
type UpdateRoomResponse struct {
	*UpdateRoomOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRoom request.
func (r *UpdateRoomResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
