// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetSchemaAsJsonInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the schema to retrieve.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSchemaAsJsonInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSchemaAsJsonInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSchemaAsJsonInput"}

	if s.SchemaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSchemaAsJsonInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetSchemaAsJsonOutput struct {
	_ struct{} `type:"structure"`

	// The JSON representation of the schema document.
	Document *string `type:"string"`

	// The name of the retrieved schema.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetSchemaAsJsonOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSchemaAsJsonOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Document != nil {
		v := *s.Document

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Document", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetSchemaAsJson = "GetSchemaAsJson"

// GetSchemaAsJsonRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Retrieves a JSON representation of the schema. See JSON Schema Format (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json)
// for more information.
//
//    // Example sending a request using GetSchemaAsJsonRequest.
//    req := client.GetSchemaAsJsonRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetSchemaAsJson
func (c *Client) GetSchemaAsJsonRequest(input *GetSchemaAsJsonInput) GetSchemaAsJsonRequest {
	op := &aws.Operation{
		Name:       opGetSchemaAsJson,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/json",
	}

	if input == nil {
		input = &GetSchemaAsJsonInput{}
	}

	req := c.newRequest(op, input, &GetSchemaAsJsonOutput{})

	return GetSchemaAsJsonRequest{Request: req, Input: input, Copy: c.GetSchemaAsJsonRequest}
}

// GetSchemaAsJsonRequest is the request type for the
// GetSchemaAsJson API operation.
type GetSchemaAsJsonRequest struct {
	*aws.Request
	Input *GetSchemaAsJsonInput
	Copy  func(*GetSchemaAsJsonInput) GetSchemaAsJsonRequest
}

// Send marshals and sends the GetSchemaAsJson API request.
func (r GetSchemaAsJsonRequest) Send(ctx context.Context) (*GetSchemaAsJsonResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSchemaAsJsonResponse{
		GetSchemaAsJsonOutput: r.Request.Data.(*GetSchemaAsJsonOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSchemaAsJsonResponse is the response type for the
// GetSchemaAsJson API operation.
type GetSchemaAsJsonResponse struct {
	*GetSchemaAsJsonOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSchemaAsJson request.
func (r *GetSchemaAsJsonResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
