// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateStackInstancesInput struct {
	_ struct{} `type:"structure"`

	// [Self-managed permissions] The names of one or more AWS accounts that you
	// want to create stack instances in the specified Region(s) for.
	//
	// You can specify Accounts or DeploymentTargets, but not both.
	Accounts []string `type:"list"`

	// [Service-managed permissions] The AWS Organizations accounts for which to
	// create stack instances in the specified Regions.
	//
	// You can specify Accounts or DeploymentTargets, but not both.
	DeploymentTargets *DeploymentTargets `type:"structure"`

	// The unique identifier for this stack set operation.
	//
	// The operation ID also functions as an idempotency token, to ensure that AWS
	// CloudFormation performs the stack set operation only once, even if you retry
	// the request multiple times. You might retry stack set operation requests
	// to ensure that AWS CloudFormation successfully received them.
	//
	// If you don't specify an operation ID, the SDK generates one automatically.
	//
	// Repeating this stack set operation with a new operation ID retries all stack
	// instances whose status is OUTDATED.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// Preferences for how AWS CloudFormation performs this stack set operation.
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// A list of stack set parameters whose values you want to override in the selected
	// stack instances.
	//
	// Any overridden parameter values will be applied to all stack instances in
	// the specified accounts and Regions. When specifying parameters and their
	// values, be aware of how AWS CloudFormation sets parameter values during stack
	// instance operations:
	//
	//    * To override the current value for a parameter, include the parameter
	//    and specify its value.
	//
	//    * To leave a parameter set to its present value, you can do one of the
	//    following: Do not include the parameter in the list. Include the parameter
	//    and specify UsePreviousValue as true. (You cannot specify both a value
	//    and set UsePreviousValue to true.)
	//
	//    * To set all overridden parameter back to the values specified in the
	//    stack set, specify a parameter list but do not include any parameters.
	//
	//    * To leave all parameters set to their present values, do not specify
	//    this property at all.
	//
	// During stack set updates, any parameter values overridden for a stack instance
	// are not updated, but retain their overridden value.
	//
	// You can only override the parameter values that are specified in the stack
	// set; to add or delete a parameter itself, use UpdateStackSet (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
	// to update the stack set template.
	ParameterOverrides []Parameter `type:"list"`

	// The names of one or more Regions where you want to create stack instances
	// using the specified AWS account(s).
	//
	// Regions is a required field
	Regions []string `type:"list" required:"true"`

	// The name or unique ID of the stack set that you want to create stack instances
	// from.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStackInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateStackInstancesInput"}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.Regions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Regions"))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateStackInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for this stack set operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStackInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateStackInstances = "CreateStackInstances"

// CreateStackInstancesRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Creates stack instances for the specified accounts, within the specified
// Regions. A stack instance refers to a stack in a specific account and Region.
// You must specify at least one value for either Accounts or DeploymentTargets,
// and you must specify at least one value for Regions.
//
//    // Example sending a request using CreateStackInstancesRequest.
//    req := client.CreateStackInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances
func (c *Client) CreateStackInstancesRequest(input *CreateStackInstancesInput) CreateStackInstancesRequest {
	op := &aws.Operation{
		Name:       opCreateStackInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInstancesInput{}
	}

	req := c.newRequest(op, input, &CreateStackInstancesOutput{})

	return CreateStackInstancesRequest{Request: req, Input: input, Copy: c.CreateStackInstancesRequest}
}

// CreateStackInstancesRequest is the request type for the
// CreateStackInstances API operation.
type CreateStackInstancesRequest struct {
	*aws.Request
	Input *CreateStackInstancesInput
	Copy  func(*CreateStackInstancesInput) CreateStackInstancesRequest
}

// Send marshals and sends the CreateStackInstances API request.
func (r CreateStackInstancesRequest) Send(ctx context.Context) (*CreateStackInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateStackInstancesResponse{
		CreateStackInstancesOutput: r.Request.Data.(*CreateStackInstancesOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateStackInstancesResponse is the response type for the
// CreateStackInstances API operation.
type CreateStackInstancesResponse struct {
	*CreateStackInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateStackInstances request.
func (r *CreateStackInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
