// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The input for ListStacks action.
type ListStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Stack status to use as a filter. Specify one or more stack status codes to
	// list only stacks with the specified status codes. For a complete list of
	// stack status codes, see the StackStatus parameter of the Stack data type.
	StackStatusFilter []StackStatus `type:"list"`
}

// String returns the string representation
func (s ListStacksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStacksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for ListStacks action.
type ListStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSummary structures containing information about the specified
	// stacks.
	StackSummaries []StackSummary `type:"list"`
}

// String returns the string representation
func (s ListStacksOutput) String() string {
	return awsutil.Prettify(s)
}

const opListStacks = "ListStacks"

// ListStacksRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the summary information for stacks whose status matches the specified
// StackStatusFilter. Summary information for stacks that have been deleted
// is kept for 90 days after the stack is deleted. If no StackStatusFilter is
// specified, summary information for all stacks is returned (including existing
// stacks and stacks that have been deleted).
//
//    // Example sending a request using ListStacksRequest.
//    req := client.ListStacksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks
func (c *Client) ListStacksRequest(input *ListStacksInput) ListStacksRequest {
	op := &aws.Operation{
		Name:       opListStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStacksInput{}
	}

	req := c.newRequest(op, input, &ListStacksOutput{})

	return ListStacksRequest{Request: req, Input: input, Copy: c.ListStacksRequest}
}

// ListStacksRequest is the request type for the
// ListStacks API operation.
type ListStacksRequest struct {
	*aws.Request
	Input *ListStacksInput
	Copy  func(*ListStacksInput) ListStacksRequest
}

// Send marshals and sends the ListStacks API request.
func (r ListStacksRequest) Send(ctx context.Context) (*ListStacksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListStacksResponse{
		ListStacksOutput: r.Request.Data.(*ListStacksOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListStacksRequestPaginator returns a paginator for ListStacks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListStacksRequest(input)
//   p := cloudformation.NewListStacksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListStacksPaginator(req ListStacksRequest) ListStacksPaginator {
	return ListStacksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListStacksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListStacksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListStacksPaginator struct {
	aws.Pager
}

func (p *ListStacksPaginator) CurrentPage() *ListStacksOutput {
	return p.Pager.CurrentPage().(*ListStacksOutput)
}

// ListStacksResponse is the response type for the
// ListStacks API operation.
type ListStacksResponse struct {
	*ListStacksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListStacks request.
func (r *ListStacksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
