// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateCachePolicyInput struct {
	_ struct{} `type:"structure" payload:"CachePolicyConfig"`

	// A cache policy configuration.
	//
	// CachePolicyConfig is a required field
	CachePolicyConfig *CachePolicyConfig `locationName:"CachePolicyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateCachePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCachePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCachePolicyInput"}

	if s.CachePolicyConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("CachePolicyConfig"))
	}
	if s.CachePolicyConfig != nil {
		if err := s.CachePolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("CachePolicyConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCachePolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.CachePolicyConfig != nil {
		v := s.CachePolicyConfig

		metadata := protocol.Metadata{XMLNamespaceURI: "http://cloudfront.amazonaws.com/doc/2020-05-31/"}
		e.SetFields(protocol.PayloadTarget, "CachePolicyConfig", v, metadata)
	}
	return nil
}

type CreateCachePolicyOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicy"`

	// A cache policy.
	CachePolicy *CachePolicy `type:"structure"`

	// The current version of the cache policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the cache policy just created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateCachePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCachePolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Location", protocol.StringValue(v), metadata)
	}
	if s.CachePolicy != nil {
		v := s.CachePolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CachePolicy", v, metadata)
	}
	return nil
}

const opCreateCachePolicy = "CreateCachePolicy2020_05_31"

// CreateCachePolicyRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Creates a cache policy.
//
// After you create a cache policy, you can attach it to one or more cache behaviors.
// When it’s attached to a cache behavior, the cache policy determines the
// following:
//
//    * The values that CloudFront includes in the cache key. These values can
//    include HTTP headers, cookies, and URL query strings. CloudFront uses
//    the cache key to find an object in its cache that it can return to the
//    viewer.
//
//    * The default, minimum, and maximum time to live (TTL) values that you
//    want objects to stay in the CloudFront cache.
//
// The headers, cookies, and query strings that are included in the cache key
// are automatically included in requests that CloudFront sends to the origin.
// CloudFront sends a request when it can’t find an object in its cache that
// matches the request’s cache key. If you want to send values to the origin
// but not include them in the cache key, use CreateOriginRequestPolicy.
//
// For more information about cache policies, see Controlling the cache key
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html)
// in the Amazon CloudFront Developer Guide.
//
//    // Example sending a request using CreateCachePolicyRequest.
//    req := client.CreateCachePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy
func (c *Client) CreateCachePolicyRequest(input *CreateCachePolicyInput) CreateCachePolicyRequest {
	op := &aws.Operation{
		Name:       opCreateCachePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/cache-policy",
	}

	if input == nil {
		input = &CreateCachePolicyInput{}
	}

	req := c.newRequest(op, input, &CreateCachePolicyOutput{})

	return CreateCachePolicyRequest{Request: req, Input: input, Copy: c.CreateCachePolicyRequest}
}

// CreateCachePolicyRequest is the request type for the
// CreateCachePolicy API operation.
type CreateCachePolicyRequest struct {
	*aws.Request
	Input *CreateCachePolicyInput
	Copy  func(*CreateCachePolicyInput) CreateCachePolicyRequest
}

// Send marshals and sends the CreateCachePolicy API request.
func (r CreateCachePolicyRequest) Send(ctx context.Context) (*CreateCachePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCachePolicyResponse{
		CreateCachePolicyOutput: r.Request.Data.(*CreateCachePolicyOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCachePolicyResponse is the response type for the
// CreateCachePolicy API operation.
type CreateCachePolicyResponse struct {
	*CreateCachePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCachePolicy request.
func (r *CreateCachePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
