// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type DeleteOriginRequestPolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the origin request policy that you are deleting.
	// To get the identifier, you can use ListOriginRequestPolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the origin request policy that you are deleting. The version
	// is the origin request policy’s ETag value, which you can get using ListOriginRequestPolicies,
	// GetOriginRequestPolicy, or GetOriginRequestPolicyConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteOriginRequestPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOriginRequestPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteOriginRequestPolicyInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteOriginRequestPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type DeleteOriginRequestPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOriginRequestPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteOriginRequestPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteOriginRequestPolicy = "DeleteOriginRequestPolicy2020_05_31"

// DeleteOriginRequestPolicyRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Deletes an origin request policy.
//
// You cannot delete an origin request policy if it’s attached to any cache
// behaviors. First update your distributions to remove the origin request policy
// from all cache behaviors, then delete the origin request policy.
//
// To delete an origin request policy, you must provide the policy’s identifier
// and version. To get the identifier, you can use ListOriginRequestPolicies
// or GetOriginRequestPolicy.
//
//    // Example sending a request using DeleteOriginRequestPolicyRequest.
//    req := client.DeleteOriginRequestPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy
func (c *Client) DeleteOriginRequestPolicyRequest(input *DeleteOriginRequestPolicyInput) DeleteOriginRequestPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteOriginRequestPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/origin-request-policy/{Id}",
	}

	if input == nil {
		input = &DeleteOriginRequestPolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteOriginRequestPolicyOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteOriginRequestPolicyRequest{Request: req, Input: input, Copy: c.DeleteOriginRequestPolicyRequest}
}

// DeleteOriginRequestPolicyRequest is the request type for the
// DeleteOriginRequestPolicy API operation.
type DeleteOriginRequestPolicyRequest struct {
	*aws.Request
	Input *DeleteOriginRequestPolicyInput
	Copy  func(*DeleteOriginRequestPolicyInput) DeleteOriginRequestPolicyRequest
}

// Send marshals and sends the DeleteOriginRequestPolicy API request.
func (r DeleteOriginRequestPolicyRequest) Send(ctx context.Context) (*DeleteOriginRequestPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteOriginRequestPolicyResponse{
		DeleteOriginRequestPolicyOutput: r.Request.Data.(*DeleteOriginRequestPolicyOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteOriginRequestPolicyResponse is the response type for the
// DeleteOriginRequestPolicy API operation.
type DeleteOriginRequestPolicyResponse struct {
	*DeleteOriginRequestPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteOriginRequestPolicy request.
func (r *DeleteOriginRequestPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
