// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The certificate fingerprint.
	CertificateFingerprint *string `type:"string"`

	// The ARN of the client.
	ClientArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The certificate installed on the HSMs used by this client.
	Certificate *string `min:"600" type:"string"`

	// The certificate fingerprint.
	CertificateFingerprint *string `type:"string"`

	// The ARN of the client.
	ClientArn *string `type:"string"`

	// The label of the client.
	Label *string `type:"string"`

	// The date and time the client was last modified.
	LastModifiedTimestamp *string `type:"string"`
}

// String returns the string representation
func (s DescribeLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLunaClient = "DescribeLunaClient"

// DescribeLunaClientRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Retrieves information about an HSM client.
//
//    // Example sending a request using DescribeLunaClientRequest.
//    req := client.DescribeLunaClientRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeLunaClient
func (c *Client) DescribeLunaClientRequest(input *DescribeLunaClientInput) DescribeLunaClientRequest {
	op := &aws.Operation{
		Name:       opDescribeLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLunaClientInput{}
	}

	req := c.newRequest(op, input, &DescribeLunaClientOutput{})

	return DescribeLunaClientRequest{Request: req, Input: input, Copy: c.DescribeLunaClientRequest}
}

// DescribeLunaClientRequest is the request type for the
// DescribeLunaClient API operation.
type DescribeLunaClientRequest struct {
	*aws.Request
	Input *DescribeLunaClientInput
	Copy  func(*DescribeLunaClientInput) DescribeLunaClientRequest
}

// Send marshals and sends the DescribeLunaClient API request.
func (r DescribeLunaClientRequest) Send(ctx context.Context) (*DescribeLunaClientResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLunaClientResponse{
		DescribeLunaClientOutput: r.Request.Data.(*DescribeLunaClientOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLunaClientResponse is the response type for the
// DescribeLunaClient API operation.
type DescribeLunaClientResponse struct {
	*DescribeLunaClientOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLunaClient request.
func (r *DescribeLunaClientResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
