// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to create. All domain names in an AWS Region that
	// are in the same AWS account must be unique. The domain name is used as the
	// prefix in DNS hostnames. Do not use sensitive information in a domain name
	// because it is publicly discoverable.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The encryption key for the domain. This is used to encrypt content stored
	// in a domain. An encryption key can be a key ID, a key Amazon Resource Name
	// (ARN), a key alias, or a key alias ARN. To specify an encryptionKey, your
	// IAM role must have kms:DescribeKey and kms:CreateGrant permissions on the
	// encryption key that is used. For more information, see DescribeKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax)
	// in the AWS Key Management Service API Reference and AWS KMS API Permissions
	// Reference (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
	// in the AWS Key Management Service Developer Guide.
	//
	// CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric
	// CMK with your domain. For more information, see Using symmetric and asymmetric
	// keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	// in the AWS Key Management Service Developer Guide.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDomainInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EncryptionKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDomainInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.EncryptionKey != nil {
		v := *s.EncryptionKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "encryptionKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the created domain after processing the request.
	Domain *DomainDescription `locationName:"domain" type:"structure"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDomainOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Domain != nil {
		v := s.Domain

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "domain", v, metadata)
	}
	return nil
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest returns a request value for making API operation for
// CodeArtifact.
//
// Creates a domain. CodeArtifact domains make it easier to manage multiple
// repositories across an organization. You can use a domain to apply permissions
// across many repositories owned by different AWS accounts. An asset is stored
// only once in a domain, even if it's in multiple repositories.
//
// Although you can have multiple domains, we recommend a single production
// domain that contains all published artifacts so that your development teams
// can find and share packages. You can use a second pre-production domain to
// test changes to the production domain configuration.
//
//    // Example sending a request using CreateDomainRequest.
//    req := client.CreateDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateDomain
func (c *Client) CreateDomainRequest(input *CreateDomainInput) CreateDomainRequest {
	op := &aws.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/domain",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	req := c.newRequest(op, input, &CreateDomainOutput{})

	return CreateDomainRequest{Request: req, Input: input, Copy: c.CreateDomainRequest}
}

// CreateDomainRequest is the request type for the
// CreateDomain API operation.
type CreateDomainRequest struct {
	*aws.Request
	Input *CreateDomainInput
	Copy  func(*CreateDomainInput) CreateDomainRequest
}

// Send marshals and sends the CreateDomain API request.
func (r CreateDomainRequest) Send(ctx context.Context) (*CreateDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDomainResponse{
		CreateDomainOutput: r.Request.Data.(*CreateDomainOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDomainResponse is the response type for the
// CreateDomain API operation.
type CreateDomainResponse struct {
	*CreateDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDomain request.
func (r *CreateDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
