// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutDomainPermissionsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain on which to set the resource policy.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `locationName:"domainOwner" min:"12" type:"string"`

	// A valid displayable JSON Aspen policy string to be set as the access control
	// resource policy on the provided domain.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" min:"1" type:"string" required:"true"`

	// The current revision of the resource policy to be set. This revision is used
	// for optimistic locking, which prevents others from overwriting your changes
	// to the domain's resource policy.
	PolicyRevision *string `locationName:"policyRevision" min:"1" type:"string"`
}

// String returns the string representation
func (s PutDomainPermissionsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDomainPermissionsPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutDomainPermissionsPolicyInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}

	if s.PolicyDocument == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.PolicyRevision != nil && len(*s.PolicyRevision) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyRevision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutDomainPermissionsPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyDocument != nil {
		v := *s.PolicyDocument

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyDocument", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyRevision != nil {
		v := *s.PolicyRevision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyRevision", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutDomainPermissionsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The resource policy that was set after processing the request.
	Policy *ResourcePolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation
func (s PutDomainPermissionsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutDomainPermissionsPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := s.Policy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "policy", v, metadata)
	}
	return nil
}

const opPutDomainPermissionsPolicy = "PutDomainPermissionsPolicy"

// PutDomainPermissionsPolicyRequest returns a request value for making API operation for
// CodeArtifact.
//
// Sets a resource policy on a domain that specifies permissions to access it.
//
//    // Example sending a request using PutDomainPermissionsPolicyRequest.
//    req := client.PutDomainPermissionsPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutDomainPermissionsPolicy
func (c *Client) PutDomainPermissionsPolicyRequest(input *PutDomainPermissionsPolicyInput) PutDomainPermissionsPolicyRequest {
	op := &aws.Operation{
		Name:       opPutDomainPermissionsPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/domain/permissions/policy",
	}

	if input == nil {
		input = &PutDomainPermissionsPolicyInput{}
	}

	req := c.newRequest(op, input, &PutDomainPermissionsPolicyOutput{})

	return PutDomainPermissionsPolicyRequest{Request: req, Input: input, Copy: c.PutDomainPermissionsPolicyRequest}
}

// PutDomainPermissionsPolicyRequest is the request type for the
// PutDomainPermissionsPolicy API operation.
type PutDomainPermissionsPolicyRequest struct {
	*aws.Request
	Input *PutDomainPermissionsPolicyInput
	Copy  func(*PutDomainPermissionsPolicyInput) PutDomainPermissionsPolicyRequest
}

// Send marshals and sends the PutDomainPermissionsPolicy API request.
func (r PutDomainPermissionsPolicyRequest) Send(ctx context.Context) (*PutDomainPermissionsPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutDomainPermissionsPolicyResponse{
		PutDomainPermissionsPolicyOutput: r.Request.Data.(*PutDomainPermissionsPolicyOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutDomainPermissionsPolicyResponse is the response type for the
// PutDomainPermissionsPolicy API operation.
type PutDomainPermissionsPolicyResponse struct {
	*PutDomainPermissionsPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutDomainPermissionsPolicy request.
func (r *PutDomainPermissionsPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
