// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type PutCommentReactionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the comment to which you want to add or update a reaction.
	//
	// CommentId is a required field
	CommentId *string `locationName:"commentId" type:"string" required:"true"`

	// The emoji reaction you want to add or update. To remove a reaction, provide
	// a value of blank or null. You can also provide the value of none. For information
	// about emoji reaction values supported in AWS CodeCommit, see the AWS CodeCommit
	// User Guide (https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table).
	//
	// ReactionValue is a required field
	ReactionValue *string `locationName:"reactionValue" type:"string" required:"true"`
}

// String returns the string representation
func (s PutCommentReactionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutCommentReactionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutCommentReactionInput"}

	if s.CommentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CommentId"))
	}

	if s.ReactionValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReactionValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutCommentReactionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutCommentReactionOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutCommentReaction = "PutCommentReaction"

// PutCommentReactionRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Adds or updates a reaction to a specified comment for the user whose identity
// is used to make the request. You can only add or update a reaction for yourself.
// You cannot add, modify, or delete a reaction for another user.
//
//    // Example sending a request using PutCommentReactionRequest.
//    req := client.PutCommentReactionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutCommentReaction
func (c *Client) PutCommentReactionRequest(input *PutCommentReactionInput) PutCommentReactionRequest {
	op := &aws.Operation{
		Name:       opPutCommentReaction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutCommentReactionInput{}
	}

	req := c.newRequest(op, input, &PutCommentReactionOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return PutCommentReactionRequest{Request: req, Input: input, Copy: c.PutCommentReactionRequest}
}

// PutCommentReactionRequest is the request type for the
// PutCommentReaction API operation.
type PutCommentReactionRequest struct {
	*aws.Request
	Input *PutCommentReactionInput
	Copy  func(*PutCommentReactionInput) PutCommentReactionRequest
}

// Send marshals and sends the PutCommentReaction API request.
func (r PutCommentReactionRequest) Send(ctx context.Context) (*PutCommentReactionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutCommentReactionResponse{
		PutCommentReactionOutput: r.Request.Data.(*PutCommentReactionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutCommentReactionResponse is the response type for the
// PutCommentReaction API operation.
type PutCommentReactionResponse struct {
	*PutCommentReactionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutCommentReaction request.
func (r *PutCommentReactionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
