// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input of an EnableStageTransition action.
type EnableStageTransitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline in which you want to enable the flow of artifacts
	// from one stage to another.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The name of the stage where you want to enable the transition of artifacts,
	// either into the stage (inbound) or from that stage to the next stage (outbound).
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// Specifies whether artifacts are allowed to enter the stage and be processed
	// by the actions in that stage (inbound) or whether already processed artifacts
	// are allowed to transition to the next stage (outbound).
	//
	// TransitionType is a required field
	TransitionType StageTransitionType `locationName:"transitionType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s EnableStageTransitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableStageTransitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableStageTransitionInput"}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}

	if s.StageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StageName", 1))
	}
	if len(s.TransitionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TransitionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableStageTransitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableStageTransitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableStageTransition = "EnableStageTransition"

// EnableStageTransitionRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Enables artifacts in a pipeline to transition to a stage in a pipeline.
//
//    // Example sending a request using EnableStageTransitionRequest.
//    req := client.EnableStageTransitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransition
func (c *Client) EnableStageTransitionRequest(input *EnableStageTransitionInput) EnableStageTransitionRequest {
	op := &aws.Operation{
		Name:       opEnableStageTransition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableStageTransitionInput{}
	}

	req := c.newRequest(op, input, &EnableStageTransitionOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return EnableStageTransitionRequest{Request: req, Input: input, Copy: c.EnableStageTransitionRequest}
}

// EnableStageTransitionRequest is the request type for the
// EnableStageTransition API operation.
type EnableStageTransitionRequest struct {
	*aws.Request
	Input *EnableStageTransitionInput
	Copy  func(*EnableStageTransitionInput) EnableStageTransitionRequest
}

// Send marshals and sends the EnableStageTransition API request.
func (r EnableStageTransitionRequest) Send(ctx context.Context) (*EnableStageTransitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableStageTransitionResponse{
		EnableStageTransitionOutput: r.Request.Data.(*EnableStageTransitionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableStageTransitionResponse is the response type for the
// EnableStageTransition API operation.
type EnableStageTransitionResponse struct {
	*EnableStageTransitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableStageTransition request.
func (r *EnableStageTransitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
