// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The name that is displayed as the friendly name for the user in AWS CodeStar.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The email address that is displayed as part of the user's profile in AWS
	// CodeStar.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" sensitive:"true"`

	// The SSH public key associated with the user in AWS CodeStar. If a project
	// owner allows the user remote access to project resources, this public key
	// will be used along with the user's private key for SSH access.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The name that will be displayed as the friendly name for the user in AWS
	// CodeStar.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateUserProfileInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DisplayName", 1))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("EmailAddress", 3))
	}

	if s.UserArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The date the user profile was created, in timestamp format.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name that is displayed as the friendly name for the user in AWS CodeStar.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The email address that is displayed as part of the user's profile in AWS
	// CodeStar.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" sensitive:"true"`

	// The date the user profile was last modified, in timestamp format.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The SSH public key associated with the user in AWS CodeStar. This is the
	// public portion of the public/private keypair the user can use to access project
	// resources if a project owner allows the user remote access to those resources.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest returns a request value for making API operation for
// AWS CodeStar.
//
// Updates a user's profile in AWS CodeStar. The user profile is not project-specific.
// Information in the user profile is displayed wherever the user's information
// appears to other users in AWS CodeStar.
//
//    // Example sending a request using UpdateUserProfileRequest.
//    req := client.UpdateUserProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateUserProfile
func (c *Client) UpdateUserProfileRequest(input *UpdateUserProfileInput) UpdateUserProfileRequest {
	op := &aws.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	req := c.newRequest(op, input, &UpdateUserProfileOutput{})

	return UpdateUserProfileRequest{Request: req, Input: input, Copy: c.UpdateUserProfileRequest}
}

// UpdateUserProfileRequest is the request type for the
// UpdateUserProfile API operation.
type UpdateUserProfileRequest struct {
	*aws.Request
	Input *UpdateUserProfileInput
	Copy  func(*UpdateUserProfileInput) UpdateUserProfileRequest
}

// Send marshals and sends the UpdateUserProfile API request.
func (r UpdateUserProfileRequest) Send(ctx context.Context) (*UpdateUserProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateUserProfileResponse{
		UpdateUserProfileOutput: r.Request.Data.(*UpdateUserProfileOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateUserProfileResponse is the response type for the
// UpdateUserProfile API operation.
type UpdateUserProfileResponse struct {
	*UpdateUserProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateUserProfile request.
func (r *UpdateUserProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
