// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to reset a user's password as an administrator.
type AdminResetUserPasswordInput struct {
	_ struct{} `type:"structure"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning AWS Lambda functions to user pool
	// triggers. When you use the AdminResetUserPassword API action, Amazon Cognito
	// invokes the function that is assigned to the custom message trigger. When
	// Amazon Cognito invokes this function, it passes a JSON payload, which the
	// function receives as input. This payload contains a clientMetadata attribute,
	// which provides the data that you assigned to the ClientMetadata parameter
	// in your AdminResetUserPassword request. In your function code in AWS Lambda,
	// you can process the clientMetadata value to enhance your workflow for your
	// specific needs.
	//
	// For more information, see Customizing User Pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// Take the following limitations into consideration when you use the ClientMetadata
	// parameter:
	//
	//    * Amazon Cognito does not store the ClientMetadata value. This data is
	//    available only to AWS Lambda triggers that are assigned to a user pool
	//    to support custom workflows. If your user pool configuration does not
	//    include triggers, the ClientMetadata parameter serves no purpose.
	//
	//    * Amazon Cognito does not validate the ClientMetadata value.
	//
	//    * Amazon Cognito does not encrypt the the ClientMetadata value, so don't
	//    use it to provide sensitive information.
	ClientMetadata map[string]string `type:"map"`

	// The user pool ID for the user pool where you want to reset the user's password.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user whose password you wish to reset.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s AdminResetUserPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminResetUserPasswordInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminResetUserPasswordInput"}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to reset a user password as an administrator.
type AdminResetUserPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminResetUserPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminResetUserPassword = "AdminResetUserPassword"

// AdminResetUserPasswordRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Resets the specified user's password in a user pool as an administrator.
// Works on any user.
//
// When a developer calls this API, the current password is invalidated, so
// it must be changed. If a user tries to sign in after the API is called, the
// app will get a PasswordResetRequiredException exception back and should direct
// the user down the flow to reset the password, which is the same as the forgot
// password flow. In addition, if the user pool has phone verification selected
// and a verified phone number exists for the user, or if email verification
// is selected and a verified email exists for the user, calling this API will
// also result in sending a message to the end user with the code to change
// their password.
//
// Calling this action requires developer credentials.
//
//    // Example sending a request using AdminResetUserPasswordRequest.
//    req := client.AdminResetUserPasswordRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword
func (c *Client) AdminResetUserPasswordRequest(input *AdminResetUserPasswordInput) AdminResetUserPasswordRequest {
	op := &aws.Operation{
		Name:       opAdminResetUserPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminResetUserPasswordInput{}
	}

	req := c.newRequest(op, input, &AdminResetUserPasswordOutput{})

	return AdminResetUserPasswordRequest{Request: req, Input: input, Copy: c.AdminResetUserPasswordRequest}
}

// AdminResetUserPasswordRequest is the request type for the
// AdminResetUserPassword API operation.
type AdminResetUserPasswordRequest struct {
	*aws.Request
	Input *AdminResetUserPasswordInput
	Copy  func(*AdminResetUserPasswordInput) AdminResetUserPasswordRequest
}

// Send marshals and sends the AdminResetUserPassword API request.
func (r AdminResetUserPasswordRequest) Send(ctx context.Context) (*AdminResetUserPasswordResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminResetUserPasswordResponse{
		AdminResetUserPasswordOutput: r.Request.Data.(*AdminResetUserPasswordOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminResetUserPasswordResponse is the response type for the
// AdminResetUserPassword API operation.
type AdminResetUserPasswordResponse struct {
	*AdminResetUserPasswordOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminResetUserPassword request.
func (r *AdminResetUserPasswordResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
