// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request to update the device status, as an administrator.
type AdminUpdateDeviceStatusInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The status indicating whether a device has been remembered or not.
	DeviceRememberedStatus DeviceRememberedStatusType `type:"string" enum:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s AdminUpdateDeviceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateDeviceStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminUpdateDeviceStatusInput"}

	if s.DeviceKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceKey", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status response from the request to update the device, as an administrator.
type AdminUpdateDeviceStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminUpdateDeviceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminUpdateDeviceStatus = "AdminUpdateDeviceStatus"

// AdminUpdateDeviceStatusRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Updates the device status as an administrator.
//
// Calling this action requires developer credentials.
//
//    // Example sending a request using AdminUpdateDeviceStatusRequest.
//    req := client.AdminUpdateDeviceStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus
func (c *Client) AdminUpdateDeviceStatusRequest(input *AdminUpdateDeviceStatusInput) AdminUpdateDeviceStatusRequest {
	op := &aws.Operation{
		Name:       opAdminUpdateDeviceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateDeviceStatusInput{}
	}

	req := c.newRequest(op, input, &AdminUpdateDeviceStatusOutput{})

	return AdminUpdateDeviceStatusRequest{Request: req, Input: input, Copy: c.AdminUpdateDeviceStatusRequest}
}

// AdminUpdateDeviceStatusRequest is the request type for the
// AdminUpdateDeviceStatus API operation.
type AdminUpdateDeviceStatusRequest struct {
	*aws.Request
	Input *AdminUpdateDeviceStatusInput
	Copy  func(*AdminUpdateDeviceStatusInput) AdminUpdateDeviceStatusRequest
}

// Send marshals and sends the AdminUpdateDeviceStatus API request.
func (r AdminUpdateDeviceStatusRequest) Send(ctx context.Context) (*AdminUpdateDeviceStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminUpdateDeviceStatusResponse{
		AdminUpdateDeviceStatusOutput: r.Request.Data.(*AdminUpdateDeviceStatusOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminUpdateDeviceStatusResponse is the response type for the
// AdminUpdateDeviceStatus API operation.
type AdminUpdateDeviceStatusResponse struct {
	*AdminUpdateDeviceStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminUpdateDeviceStatus request.
func (r *AdminUpdateDeviceStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
