// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to describe the user pool.
type DescribeUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool you want to describe.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeUserPoolInput"}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response to describe the user pool.
type DescribeUserPoolOutput struct {
	_ struct{} `type:"structure"`

	// The container of metadata returned by the server to describe the pool.
	UserPool *UserPoolType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeUserPool = "DescribeUserPool"

// DescribeUserPoolRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Returns the configuration information and metadata of the specified user
// pool.
//
//    // Example sending a request using DescribeUserPoolRequest.
//    req := client.DescribeUserPoolRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool
func (c *Client) DescribeUserPoolRequest(input *DescribeUserPoolInput) DescribeUserPoolRequest {
	op := &aws.Operation{
		Name:       opDescribeUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolInput{}
	}

	req := c.newRequest(op, input, &DescribeUserPoolOutput{})

	return DescribeUserPoolRequest{Request: req, Input: input, Copy: c.DescribeUserPoolRequest}
}

// DescribeUserPoolRequest is the request type for the
// DescribeUserPool API operation.
type DescribeUserPoolRequest struct {
	*aws.Request
	Input *DescribeUserPoolInput
	Copy  func(*DescribeUserPoolInput) DescribeUserPoolRequest
}

// Send marshals and sends the DescribeUserPool API request.
func (r DescribeUserPoolRequest) Send(ctx context.Context) (*DescribeUserPoolResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeUserPoolResponse{
		DescribeUserPoolOutput: r.Request.Data.(*DescribeUserPoolOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeUserPoolResponse is the response type for the
// DescribeUserPool API operation.
type DescribeUserPoolResponse struct {
	*DescribeUserPoolOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeUserPool request.
func (r *DescribeUserPoolResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
